/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;

public class TokenUtil {
    private static final char[] SPACE = new char[]{' '};
    private static final char[] IMAGE_POUND_POUND = "##".toCharArray();
    private static final char[] IMAGE_POUND = "#".toCharArray();
    private static final char[] DIGRAPH_LBRACE = "<%".toCharArray();
    private static final char[] DIGRAPH_RBRACE = "%>".toCharArray();
    private static final char[] DIGRAPH_LBRACKET = "<:".toCharArray();
    private static final char[] DIGRAPH_RBRACKET = ":>".toCharArray();
    private static final char[] DIGRAPH_POUND = "%:".toCharArray();
    private static final char[] DIGRAPH_POUNDPOUND = "%:%:".toCharArray();

    public static boolean isOperator(int kind) {
        switch (kind) {
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 72: 
            case 92: 
            case 152: 
            case 153: 
            case 8001: {
                return true;
            }
        }
        return false;
    }

    public static char[] getImage(int type) {
        switch (type) {
            case 138: {
                return IMAGE_POUND;
            }
            case 139: {
                return IMAGE_POUND_POUND;
            }
            case 3: {
                return Keywords.cpCOLONCOLON;
            }
            case 4: {
                return Keywords.cpCOLON;
            }
            case 5: {
                return Keywords.cpSEMI;
            }
            case 6: {
                return Keywords.cpCOMMA;
            }
            case 7: {
                return Keywords.cpQUESTION;
            }
            case 8: {
                return Keywords.cpLPAREN;
            }
            case 9: {
                return Keywords.cpRPAREN;
            }
            case 10: {
                return Keywords.cpLBRACKET;
            }
            case 11: {
                return Keywords.cpRBRACKET;
            }
            case 12: {
                return Keywords.cpLBRACE;
            }
            case 13: {
                return Keywords.cpRBRACE;
            }
            case 14: {
                return Keywords.cpPLUSASSIGN;
            }
            case 15: {
                return Keywords.cpINCR;
            }
            case 16: {
                return Keywords.cpPLUS;
            }
            case 17: {
                return Keywords.cpMINUSASSIGN;
            }
            case 18: {
                return Keywords.cpDECR;
            }
            case 19: {
                return Keywords.cpARROWSTAR;
            }
            case 20: {
                return Keywords.cpARROW;
            }
            case 21: {
                return Keywords.cpMINUS;
            }
            case 22: {
                return Keywords.cpSTARASSIGN;
            }
            case 23: {
                return Keywords.cpSTAR;
            }
            case 24: {
                return Keywords.cpMODASSIGN;
            }
            case 25: {
                return Keywords.cpMOD;
            }
            case 26: {
                return Keywords.cpXORASSIGN;
            }
            case 27: {
                return Keywords.cpXOR;
            }
            case 28: {
                return Keywords.cpAMPERASSIGN;
            }
            case 29: {
                return Keywords.cpAND;
            }
            case 30: {
                return Keywords.cpAMPER;
            }
            case 31: {
                return Keywords.cpBITORASSIGN;
            }
            case 32: {
                return Keywords.cpOR;
            }
            case 33: {
                return Keywords.cpBITOR;
            }
            case 34: {
                return Keywords.cpCOMPL;
            }
            case 35: {
                return Keywords.cpNOTEQUAL;
            }
            case 36: {
                return Keywords.cpNOT;
            }
            case 37: {
                return Keywords.cpEQUAL;
            }
            case 8001: {
                return Keywords.cpTHREEWAYCOMPARISON;
            }
            case 38: {
                return Keywords.cpASSIGN;
            }
            case 40: {
                return Keywords.cpSHIFTL;
            }
            case 41: {
                return Keywords.cpLTEQUAL;
            }
            case 42: {
                return Keywords.cpLT;
            }
            case 43: {
                return Keywords.cpSHIFTRASSIGN;
            }
            case 44: {
                return Keywords.cpSHIFTR;
            }
            case 45: {
                return Keywords.cpGTEQUAL;
            }
            case 46: 
            case 5201: {
                return Keywords.cpGT;
            }
            case 47: {
                return Keywords.cpSHIFTLASSIGN;
            }
            case 48: {
                return Keywords.cpELLIPSIS;
            }
            case 49: {
                return Keywords.cpDOTSTAR;
            }
            case 50: {
                return Keywords.cpDOT;
            }
            case 51: {
                return Keywords.cpDIVASSIGN;
            }
            case 52: {
                return Keywords.cpDIV;
            }
            case 153: {
                return Keywords.cpMIN;
            }
            case 152: {
                return Keywords.cpMAX;
            }
            case -197: {
                return SPACE;
            }
            case -196: {
                return CharArrayUtils.EMPTY;
            }
        }
        return CharArrayUtils.EMPTY;
    }

    public static char[] getDigraphImage(int type) {
        switch (type) {
            case 138: {
                return DIGRAPH_POUND;
            }
            case 139: {
                return DIGRAPH_POUNDPOUND;
            }
            case 10: {
                return DIGRAPH_LBRACKET;
            }
            case 11: {
                return DIGRAPH_RBRACKET;
            }
            case 12: {
                return DIGRAPH_LBRACE;
            }
            case 13: {
                return DIGRAPH_RBRACE;
            }
        }
        assert (false) : type;
        return CharArrayUtils.EMPTY;
    }

    public static IToken getLast(IToken tokenList) {
        IToken last;
        do {
            last = tokenList;
        } while ((tokenList = tokenList.getNext()) != null);
        return last;
    }
}

