/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IReplEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptExecutionException;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.completion.CodeCompletionAggregator;
import org.eclipse.ease.ui.completion.CompletionLabelProvider;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.ScriptCompletionProposal;
import org.eclipse.ease.ui.completion.provider.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.provider.ICompletionProvider;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.ease.ui.dnd.ShellDropTarget;
import org.eclipse.ease.ui.help.hovers.ContentProposalModifier;
import org.eclipse.ease.ui.view.DropinsSelectionProvider;
import org.eclipse.ease.ui.view.ScriptHistoryText;
import org.eclipse.ease.ui.view.TextSelectionProvider;
import org.eclipse.ease.ui.views.shell.dropins.DropinTools;
import org.eclipse.ease.ui.views.shell.dropins.IShellDropin;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.osgi.service.prefs.Preferences;

public class ScriptShell
extends ViewPart
implements IPropertyChangeListener,
IScriptEngineProvider,
IExecutionListener,
ITabbedPropertySheetPageContributor {
    public static final String VIEW_ID = "org.eclipse.ease.ui.views.scriptShell";
    private static final String XML_HISTORY_NODE = "history";
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{70, 30};
    private SashForm fSashForm;
    private Combo fInputCombo;
    private ScriptHistoryText fOutputText;
    private int[] fSashWeights = DEFAULT_SASH_WEIGHTS;
    private IReplEngine fScriptEngine;
    private IMemento fInitMemento;
    private int fHistoryLength;
    private boolean fKeepCommand;
    private AutoFocus fAutoFocusListener = null;
    private CodeCompletionAggregator fCompletionDispatcher = null;
    private Collection<IShellDropin> fDropins = null;
    private String[] fHistory;

    public ScriptShell() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public final void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fInitMemento = memento;
    }

    public final void saveState(IMemento memento) {
        String[] stringArray = this.fInputCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            memento.createChild(XML_HISTORY_NODE).putTextData(item);
            ++n2;
        }
        super.saveState(memento);
    }

    public final void createPartControl(Composite parent) {
        Collection engines;
        parent.setLayout((Layout)new GridLayout());
        this.fSashForm = new SashForm(parent, 0);
        this.fSashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fOutputText = new ScriptHistoryText((Composite)this.fSashForm, 2824);
        this.fOutputText.setAlwaysShowScrollBars(false);
        this.fOutputText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String selected = ScriptShell.this.fOutputText.getLine(ScriptShell.this.fOutputText.getLineIndex(e.y));
                if (!selected.isEmpty()) {
                    ScriptShell.this.fInputCombo.setText(selected);
                    ScriptShell.this.fInputCombo.setFocus();
                    ScriptShell.this.fInputCombo.setSelection(new Point(0, selected.length()));
                }
            }
        });
        TabFolder tabFolder = new TabFolder((Composite)this.fSashForm, 1024);
        this.fDropins = this.getAvailableDropins();
        for (IShellDropin dropin : this.fDropins) {
            TabItem tab = new TabItem(tabFolder, 0);
            tab.setText(dropin.getTitle());
            tab.setControl((Control)dropin.getPartControl(this.getSite(), (Composite)tabFolder));
        }
        this.showDropinsPane(this.shallDisplayDropins());
        this.fInputCombo = new Combo(parent, 0);
        this.fInputCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                String input = ScriptShell.this.fInputCombo.getText();
                ScriptShell.this.fInputCombo.setText("");
                ScriptShell.this.fScriptEngine.execute((Object)new Script("User input", (Object)input, true));
            }
        });
        this.fInputCombo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.count == 3) {
                    ScriptShell.this.fInputCombo.setSelection(new Point(0, ScriptShell.this.fInputCombo.getText().length()));
                }
            }
        });
        this.fInputCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.fInitMemento != null) {
            IMemento[] iMementoArray = this.fInitMemento.getChildren(XML_HISTORY_NODE);
            int tab = iMementoArray.length;
            int n = 0;
            while (n < tab) {
                IMemento node = iMementoArray[n];
                if (node.getTextData() != null) {
                    this.fInputCombo.add(node.getTextData());
                }
                ++n;
            }
        }
        this.fHistory = (String[])this.fInputCombo.getItems().clone();
        this.fInitMemento = null;
        ShellDropTarget.addDropSupport((Control)this.fOutputText, this);
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        this.fHistoryLength = prefs.getInt("shellHistoryLength", 20);
        this.fKeepCommand = prefs.getBoolean("shellKeepCommand", false);
        boolean autoFocus = prefs.getBoolean("shellAutoFocus", true);
        if (autoFocus) {
            if (this.fAutoFocusListener == null) {
                this.fAutoFocusListener = new AutoFocus();
            }
            this.fOutputText.addKeyListener(this.fAutoFocusListener);
        }
        TextSelectionProvider selectionProvider = new TextSelectionProvider();
        this.fOutputText.addSelectionListener(selectionProvider);
        this.getSite().setSelectionProvider((ISelectionProvider)selectionProvider);
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        String engineID = prefs.get("shellDefaultEngine", "org.eclipse.ease.javascript.rhino");
        EngineDescription engineDescription = scriptService.getEngineByID(engineID);
        if (engineDescription == null && (engineDescription = scriptService.getEngine("JavaScript")) == null && !(engines = scriptService.getEngines()).isEmpty()) {
            engineDescription = (EngineDescription)engines.iterator().next();
        }
        if (engineDescription != null) {
            this.setEngine(engineDescription.getID());
        } else {
            ScriptResult invalidEngine = new ScriptResult();
            invalidEngine.setException(new ScriptExecutionException("No script engines available"));
            this.fOutputText.printResult(invalidEngine);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)new DropinsSelectionProvider(tabFolder, this.getAvailableDropins()));
    }

    private Collection<IShellDropin> getAvailableDropins() {
        if (this.fDropins == null) {
            this.fDropins = DropinTools.getAvailableDropins();
        }
        return this.fDropins;
    }

    private boolean shallDisplayDropins() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.eclipse.ease.commands.script.toggleDropinsSection");
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        if (state == null) {
            return true;
        }
        if (!(state.getValue() instanceof Boolean)) {
            return true;
        }
        return (Boolean)state.getValue();
    }

    private void addAutoCompletion() {
        this.fCompletionDispatcher.addCompletionProvider(new ICompletionProvider(){
            private final IImageResolver fImageResolver = new AbstractCompletionProvider.DescriptorImageResolver(Activator.getImageDescriptor("org.eclipse.ease.ui", "/icons/eobj16/history.png"));

            @Override
            public boolean isActive(ICompletionContext context) {
                return true;
            }

            @Override
            public Collection<ScriptCompletionProposal> getProposals(ICompletionContext context) {
                return Arrays.asList(ScriptShell.this.fHistory).stream().filter(t -> t.startsWith(context.getText())).map(t -> new ScriptCompletionProposal(context, (String)t, (String)t, this.fImageResolver, 0, null)).collect(Collectors.toList());
            }
        });
        ContentProposalModifier contentAssistAdapter = new ContentProposalModifier((Control)this.fInputCombo, (IControlContentAdapter)new ComboContentAdapter(), this.fCompletionDispatcher, KeyStroke.getInstance((int)262144, (int)32), new char[]{'.'});
        contentAssistAdapter.setProposalAcceptanceStyle(2);
        contentAssistAdapter.setLabelProvider(new CompletionLabelProvider());
        contentAssistAdapter.setAutoActivationDelay(500);
    }

    public void runStartupCommands() {
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        for (ScriptType scriptType : this.fScriptEngine.getDescription().getSupportedScriptTypes()) {
            String initCommands = prefs.get("shellStartup" + scriptType.getName(), "").trim();
            if (!initCommands.isEmpty()) {
                this.fScriptEngine.execute((Object)initCommands);
                continue;
            }
            ICodeFactory codeFactory = ScriptService.getCodeFactory((IScriptEngine)this.fScriptEngine);
            if (codeFactory == null) continue;
            String helpComment = codeFactory.createCommentedString("use help(\"<topic>\") to get more information", false);
            this.fScriptEngine.execute((Object)helpComment);
        }
    }

    private void addToHistory(String input) {
        Display.getDefault().asyncExec(() -> {
            if (this.fInputCombo.getSelectionIndex() != -1) {
                this.fInputCombo.remove(this.fInputCombo.getSelectionIndex());
            } else {
                int index = 0;
                while (index < this.fInputCombo.getItemCount()) {
                    if (this.fInputCombo.getItem(index).equals(input)) {
                        this.fInputCombo.remove(index);
                        break;
                    }
                    ++index;
                }
            }
            while (this.fInputCombo.getItemCount() >= this.fHistoryLength) {
                this.fInputCombo.remove(this.fInputCombo.getItemCount() - 1);
            }
            this.fInputCombo.add(input, 0);
            this.fHistory = (String[])this.fInputCombo.getItems().clone();
        });
    }

    public final void dispose() {
        if (this.fScriptEngine != null) {
            this.fScriptEngine.removeExecutionListener((IExecutionListener)this);
            this.fScriptEngine.terminate();
        }
        super.dispose();
    }

    public final void setFocus() {
        this.fInputCombo.setFocus();
    }

    public final void clearOutput() {
        this.fOutputText.clear();
    }

    public final void showDropinsPane(boolean show) {
        if (show) {
            this.fSashForm.setWeights(this.fSashWeights);
            if (this.fSashWeights[1] == 0) {
                this.fSashForm.setWeights(DEFAULT_SASH_WEIGHTS);
            }
        } else {
            this.fSashWeights = this.fSashForm.getWeights();
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.fSashForm.setWeights(nArray);
        }
        this.fDropins.stream().forEach(d -> d.setHidden(!show));
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if ("shellAutoFocus".equals(event.getProperty())) {
            if (Boolean.parseBoolean(event.getNewValue().toString())) {
                if (this.fAutoFocusListener == null) {
                    this.fAutoFocusListener = new AutoFocus();
                }
                this.fOutputText.addKeyListener(this.fAutoFocusListener);
            } else {
                this.fOutputText.removeKeyListener(this.fAutoFocusListener);
            }
        } else if ("shellKeepCommand".equals(event.getProperty())) {
            this.fKeepCommand = Boolean.parseBoolean(event.getNewValue().toString());
        } else if ("shellHistoryLength".equals(event.getProperty())) {
            this.fHistoryLength = Integer.parseInt(event.getNewValue().toString());
        }
    }

    public void stopScriptEngine() {
        this.getScriptEngine().terminateCurrent();
    }

    public IScriptEngine getScriptEngine() {
        return this.fScriptEngine;
    }

    public void changePartName(String newPartName) {
        this.setPartName(newPartName);
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        if (status == 3) {
            try {
                this.addToHistory(script.getCode());
                if (this.fKeepCommand) {
                    String code = script.getCode();
                    Display.getDefault().asyncExec(() -> {
                        if (!this.fInputCombo.isDisposed()) {
                            this.fInputCombo.setText(code);
                            this.fInputCombo.setSelection(new Point(0, code.length()));
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void setEngine(String id) {
        IScriptService scriptService;
        IScriptEngine candidate;
        if (this.fScriptEngine != null) {
            this.fOutputText.removeScriptEngine(this.fScriptEngine);
            this.fScriptEngine.removeExecutionListener((IExecutionListener)this);
            this.fScriptEngine.terminate();
        }
        if ((candidate = (scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class)).getEngineByID(id).createEngine()) instanceof IReplEngine) {
            this.fScriptEngine = (IReplEngine)candidate;
        } else {
            ScriptResult invalidEngine = new ScriptResult();
            invalidEngine.setException(new ScriptExecutionException("Invalid engine selected for shell: " + id));
            this.fOutputText.printResult(invalidEngine);
        }
        this.fInputCombo.setEnabled(this.fScriptEngine != null);
        if (this.fScriptEngine != null) {
            this.fScriptEngine.setTerminateOnIdle(false);
            String partName = String.valueOf(scriptService.getEngineByID(id).getName()) + " Script Shell";
            this.setPartName(partName);
            ScriptConsole console = ScriptConsole.create(partName, (IScriptEngine)this.fScriptEngine);
            this.fScriptEngine.setOutputStream((OutputStream)console.getOutputStream());
            this.fScriptEngine.setErrorStream((OutputStream)console.getErrorStream());
            this.fScriptEngine.setInputStream((InputStream)console.getInputStream());
            this.fScriptEngine.addExecutionListener((IExecutionListener)this);
            this.fScriptEngine.schedule();
            this.fOutputText.addScriptEngine(this.fScriptEngine);
            if (this.fInputCombo != null) {
                this.runStartupCommands();
            }
            for (IShellDropin dropin : this.fDropins) {
                dropin.setScriptEngine(this.fScriptEngine);
            }
            this.fCompletionDispatcher = new CodeCompletionAggregator((IScriptEngine)this.fScriptEngine);
            this.addAutoCompletion();
        }
    }

    public String getContributorId() {
        return VIEW_ID;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        return (T)super.getAdapter(adapter);
    }

    private class AutoFocus
    implements KeyListener {
        private AutoFocus() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 118 && (e.stateMask & 0x40000) != 0) {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                Object content = clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (content != null) {
                    ScriptShell.this.fInputCombo.setText(String.valueOf(ScriptShell.this.fInputCombo.getText()) + content.toString());
                }
                ScriptShell.this.fInputCombo.setFocus();
                ScriptShell.this.fInputCombo.setSelection(new Point(ScriptShell.this.fInputCombo.getText().length(), ScriptShell.this.fInputCombo.getText().length()));
            }
        }

        public void keyPressed(KeyEvent e) {
            if ((e.keyCode != 99 || (e.stateMask & 0x40000) == 0) && e.keyCode != 262144) {
                ScriptShell.this.fInputCombo.setText(String.valueOf(ScriptShell.this.fInputCombo.getText()) + e.character);
                ScriptShell.this.fInputCombo.setFocus();
                ScriptShell.this.fInputCombo.setSelection(new Point(ScriptShell.this.fInputCombo.getText().length(), ScriptShell.this.fInputCombo.getText().length()));
            }
        }
    }
}

