/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.core.trace;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.collect.BufferedBlockingQueue;
import org.eclipse.tracecompass.incubator.scripting.core.trace.ScriptEventsIterator;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;

public class ScriptEventRequest
extends TmfEventRequest {
    public static final EndEvent END_EVENT = new EndEvent();
    private static final int DEFAULT_EVENTS_QUEUE_SIZE = 127;
    private static final int DEFAULT_EVENTS_CHUNK_SIZE = 127;
    private final BufferedBlockingQueue<ITmfEvent> fEventsQueue = new BufferedBlockingQueue(127, 127);
    private final ScriptEventsIterator fEventIterator = new ScriptEventsIterator(this.fEventsQueue);

    public ScriptEventRequest() {
        super(ITmfEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, 100);
    }

    public void handleData(@NonNull ITmfEvent event) {
        super.handleData(event);
        this.fEventsQueue.put((Object)event);
    }

    public synchronized void done() {
        super.done();
        if (!this.isCancelled()) {
            this.fEventsQueue.put((Object)END_EVENT);
            this.fEventsQueue.flushInputBuffer();
        }
    }

    public synchronized void cancel() {
        super.cancel();
        while (!this.fEventsQueue.isEmpty()) {
            this.fEventIterator.next();
        }
        this.fEventsQueue.put((Object)END_EVENT);
        this.fEventsQueue.flushInputBuffer();
    }

    public ScriptEventsIterator getEventIterator() {
        return this.fEventIterator;
    }

    private static class EndEvent
    extends TmfEvent {
        public EndEvent() {
            super(null, -1L, null, null, null);
        }
    }
}

