/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class StringTools {
    public static final String LINE_DELIMITER = System.getProperty("line.separator");

    public static final String toString(InputStream stream) throws IOException {
        return StringTools.toString(new InputStreamReader(stream));
    }

    public static String toString(Reader reader) throws IOException {
        int read;
        if (!(reader instanceof BufferedReader)) {
            return StringTools.toString(new BufferedReader(reader));
        }
        char[] buffer = new char[1024];
        StringBuilder result = new StringBuilder();
        do {
            if ((read = reader.read(buffer)) <= 0) continue;
            result.append(new String(buffer, 0, read));
        } while (read != -1);
        return result.toString();
    }

    public static String[] parseArguments(String argument) {
        if (argument != null && !argument.isEmpty()) {
            return argument.replaceAll("^\"", "").split("\"?(\\s+|$)(?=(([^\"]*\"){2})*[^\"]*$)\"?");
        }
        return new String[0];
    }
}

