/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.base;

import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;

public abstract class JavaStatusContext
extends RefactoringStatusContext {
    public static RefactoringStatusContext create(IMember member) {
        if (member == null || !member.exists()) {
            return null;
        }
        return new MemberSourceContext(member);
    }

    public static RefactoringStatusContext create(IImportDeclaration declaration) {
        if (declaration == null || !declaration.exists()) {
            return null;
        }
        return new ImportDeclarationSourceContext(declaration);
    }

    public static RefactoringStatusContext create(IFunctionBinding method) {
        return JavaStatusContext.create((IMember)((IFunction)method.getJavaElement()));
    }

    public static RefactoringStatusContext create(ITypeRoot typeRoot) {
        return JavaStatusContext.create(typeRoot, null);
    }

    public static RefactoringStatusContext create(ITypeRoot typeRoot, ISourceRange range) {
        if (typeRoot instanceof IJavaScriptUnit) {
            return new CompilationUnitSourceContext((IJavaScriptUnit)typeRoot, range);
        }
        if (typeRoot instanceof IClassFile) {
            return new ClassFileSourceContext((IClassFile)typeRoot, range);
        }
        return null;
    }

    public static RefactoringStatusContext create(ITypeRoot typeRoot, ASTNode node) {
        SourceRange range = null;
        if (node != null) {
            range = new SourceRange(node.getStartPosition(), node.getLength());
        }
        return JavaStatusContext.create(typeRoot, range);
    }

    public static RefactoringStatusContext create(ITypeRoot typeRoot, Selection selection) {
        SourceRange range = null;
        if (selection != null) {
            range = new SourceRange(selection.getOffset(), selection.getLength());
        }
        return JavaStatusContext.create(typeRoot, range);
    }

    public abstract boolean isBinary();

    public abstract IJavaScriptUnit getCompilationUnit();

    public abstract IClassFile getClassFile();

    public abstract ISourceRange getSourceRange();

    public Object getCorrespondingElement() {
        if (this.isBinary()) {
            return this.getClassFile();
        }
        return this.getCompilationUnit();
    }

    private static class ClassFileSourceContext
    extends JavaStatusContext {
        private IClassFile fClassFile;
        private ISourceRange fSourceRange;

        private ClassFileSourceContext(IClassFile classFile, ISourceRange range) {
            this.fClassFile = classFile;
            this.fSourceRange = range;
            if (this.fSourceRange == null) {
                this.fSourceRange = new SourceRange(0, 0);
            }
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public IJavaScriptUnit getCompilationUnit() {
            return null;
        }

        @Override
        public IClassFile getClassFile() {
            return this.fClassFile;
        }

        @Override
        public ISourceRange getSourceRange() {
            return this.fSourceRange;
        }

        public String toString() {
            return this.getSourceRange() + " in " + super.toString();
        }
    }

    private static class CompilationUnitSourceContext
    extends JavaStatusContext {
        private IJavaScriptUnit fCUnit;
        private ISourceRange fSourceRange;

        private CompilationUnitSourceContext(IJavaScriptUnit cunit, ISourceRange range) {
            this.fCUnit = cunit;
            this.fSourceRange = range;
            if (this.fSourceRange == null) {
                this.fSourceRange = new SourceRange(0, 0);
            }
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public IJavaScriptUnit getCompilationUnit() {
            return this.fCUnit;
        }

        @Override
        public IClassFile getClassFile() {
            return null;
        }

        @Override
        public ISourceRange getSourceRange() {
            return this.fSourceRange;
        }

        public String toString() {
            return this.getSourceRange() + " in " + super.toString();
        }
    }

    private static class ImportDeclarationSourceContext
    extends JavaStatusContext {
        private IImportDeclaration fImportDeclartion;

        private ImportDeclarationSourceContext(IImportDeclaration declaration) {
            this.fImportDeclartion = declaration;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public IJavaScriptUnit getCompilationUnit() {
            return (IJavaScriptUnit)this.fImportDeclartion.getParent().getParent();
        }

        @Override
        public IClassFile getClassFile() {
            return null;
        }

        @Override
        public ISourceRange getSourceRange() {
            try {
                return this.fImportDeclartion.getSourceRange();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return new SourceRange(0, 0);
            }
        }
    }

    private static class MemberSourceContext
    extends JavaStatusContext {
        private IMember fMember;

        private MemberSourceContext(IMember member) {
            this.fMember = member;
        }

        @Override
        public boolean isBinary() {
            return this.fMember.isBinary();
        }

        @Override
        public IJavaScriptUnit getCompilationUnit() {
            return this.fMember.getJavaScriptUnit();
        }

        @Override
        public IClassFile getClassFile() {
            return this.fMember.getClassFile();
        }

        @Override
        public ISourceRange getSourceRange() {
            try {
                return this.fMember.getSourceRange();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return new SourceRange(0, 0);
            }
        }
    }
}

