/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.jsontrace.core.trace;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.jsontrace.core.Activator;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceKnownSize;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public abstract class JsonTrace
extends TmfTrace
implements ITmfPersistentlyIndexable,
ITmfPropertiesProvider,
ITmfTraceKnownSize {
    private static final int MAX_SIZE = 50000000;
    private static final int CHECKPOINT_SIZE = 10000;
    private static final int ESTIMATED_EVENT_SIZE = 50;
    protected static final TmfLongLocation NULL_LOCATION = new TmfLongLocation(-1L);
    private static final TmfContext INVALID_CONTEXT = new TmfContext((ITmfLocation)NULL_LOCATION, -1L);
    protected static final int MAX_LINES = 100;
    protected static final int MAX_CONFIDENCE = 100;
    protected final @NonNull Map<@NonNull String, @NonNull String> fProperties = new LinkedHashMap<String, String>();
    protected File fFile;
    protected RandomAccessFile fFileInput;

    public synchronized void dispose() {
        if (this.fFileInput != null) {
            try {
                this.fFileInput.close();
            }
            catch (IOException e) {
                Activator.getInstance().logError("Error disposing trace. File: " + this.getPath(), (Throwable)e);
            }
        }
        super.dispose();
    }

    public double getLocationRatio(ITmfLocation location) {
        return ((Long)this.getCurrentLocation().getLocationInfo()).doubleValue() / (double)this.fFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITmfContext seekEvent(ITmfLocation location) {
        if (this.fFile == null) {
            return INVALID_CONTEXT;
        }
        TmfContext context = new TmfContext((ITmfLocation)NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals((Object)location)) {
            return context;
        }
        JsonTrace jsonTrace = this;
        synchronized (jsonTrace) {
            try {
                if (location == null) {
                    this.fFileInput.seek(1L);
                } else if (location.getLocationInfo() instanceof Long) {
                    this.fFileInput.seek((Long)location.getLocationInfo());
                }
                context.setLocation((ITmfLocation)new TmfLongLocation(this.fFileInput.getFilePointer()));
                context.setRank(0L);
                return context;
            }
            catch (FileNotFoundException e) {
                Activator.getInstance().logError("Error seeking event. File not found: " + this.getPath(), (Throwable)e);
                return context;
            }
            catch (IOException e) {
                Activator.getInstance().logError("Error seeking event. File: " + this.getPath(), (Throwable)e);
                return context;
            }
        }
    }

    public ITmfContext seekEvent(double ratio) {
        File file = this.fFile;
        if (file == null) {
            return INVALID_CONTEXT;
        }
        long filePos = (long)((double)file.length() * ratio);
        long estimatedRank = filePos / 50L;
        return this.seekEvent((ITmfLocation)new TmfLongLocation(estimatedRank));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITmfLocation getCurrentLocation() {
        long temp = -1L;
        try {
            JsonTrace jsonTrace = this;
            synchronized (jsonTrace) {
                temp = this.fFileInput.getFilePointer();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new TmfLongLocation(temp);
    }

    public @NonNull Map<@NonNull String, @NonNull String> getProperties() {
        return this.fProperties;
    }

    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        return new TmfLongLocation(bufferIn);
    }

    public int getCheckpointSize() {
        return 10000;
    }

    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfBTreeTraceIndexer((ITmfTrace)this, interval);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static @Nullable String readNextEventString(IReaderWrapper parser) throws IOException {
        StringBuilder sb = new StringBuilder();
        int scope = -1;
        int arrScope = 0;
        boolean inQuotes = false;
        int elem = parser.read();
        while (elem != -1) {
            if (elem == 34) {
                inQuotes = !inQuotes;
            } else if (!inQuotes) {
                if (elem == 91) {
                    ++arrScope;
                } else if (elem == 93) {
                    if (arrScope <= 0) return null;
                    --arrScope;
                } else if (elem == 123) {
                    ++scope;
                } else if (elem == 125) {
                    if (scope > 0) {
                        --scope;
                    } else if (scope == 0) {
                        sb.append((char)elem);
                        return sb.toString();
                    }
                }
            }
            if (scope >= 0) {
                sb.append((char)elem);
            }
            elem = parser.read();
            if (sb.length() <= 50000000) continue;
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        long length = 0L;
        JsonTrace jsonTrace = this;
        synchronized (jsonTrace) {
            RandomAccessFile fileInput;
            block6: {
                fileInput = this.fFileInput;
                if (fileInput != null) break block6;
                return 0;
            }
            try {
                length = fileInput.length();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int progress() {
        long length = 0L;
        JsonTrace jsonTrace = this;
        synchronized (jsonTrace) {
            RandomAccessFile fileInput;
            block6: {
                fileInput = this.fFileInput;
                if (fileInput != null) break block6;
                return 0;
            }
            try {
                length = fileInput.getFilePointer();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
    }

    public static interface IReaderWrapper {
        public int read() throws IOException;
    }
}

