/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer2;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;

public class TreeViewer
extends AbstractSelectTreeViewer2 {
    private static final int COL_INDEX_COLOR_LEGEND = 2;

    public TreeViewer(Composite parent, String id) {
        super(parent, 2, id);
        this.setLabelProvider((IBaseLabelProvider)new TreeXyLabelProvider());
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        TmfTreeColumnData legendColumn = new TmfTreeColumnData("Legend");
        legendColumn.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (TreeViewer.this.isChecked(o1) && !TreeViewer.this.isChecked(o2)) {
                    return -1;
                }
                if (!TreeViewer.this.isChecked(o1) && TreeViewer.this.isChecked(o2)) {
                    return 1;
                }
                if (o1 instanceof ITmfTreeViewerEntry & o2 instanceof ITmfTreeViewerEntry) {
                    ITmfTreeViewerEntry e1 = (ITmfTreeViewerEntry)o1;
                    ITmfTreeViewerEntry e2 = (ITmfTreeViewerEntry)o2;
                    return e1.getName().compareTo(e2.getName());
                }
                return 0;
            }
        });
        return () -> Arrays.asList(TreeViewer.createColumn((String)"Name", Comparator.comparing(ITmfTreeViewerEntry::getName)), new TmfTreeColumnData("Unit"), legendColumn);
    }

    protected void updateContent(long start, long end, boolean isSelection) {
        super.updateContent(start, end, isSelection);
    }

    private final class TreeXyLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        private TreeXyLabelProvider() {
        }

        private Optional<ITmfTreeDataModel> tryGetModel(Object element) {
            if (element instanceof TmfGenericTreeEntry) {
                ITmfTreeDataModel model = ((TmfGenericTreeEntry)element).getModel();
                return Optional.ofNullable(model);
            }
            return Optional.empty();
        }

        public String getColumnText(Object element, int columnIndex) {
            return super.getColumnText(element, columnIndex);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ITmfTreeDataModel treeModel;
            Optional<ITmfTreeDataModel> model;
            if (columnIndex == 2 && element instanceof ITmfTreeViewerEntry && TreeViewer.this.isChecked(element) && (model = this.tryGetModel(element)).isPresent() && (treeModel = model.get()).hasRowModel()) {
                return TreeViewer.this.getLegendImage(treeModel.getId());
            }
            return null;
        }
    }
}

