/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public interface IContentAssistProcessorExtension
extends IContentAssistProcessor {
    @Override
    @Deprecated
    default public char[] getCompletionProposalAutoActivationCharacters() {
        throw new UnsupportedOperationException("use isCompletionProposalAutoActivation instead");
    }

    @Override
    @Deprecated
    default public char[] getContextInformationAutoActivationCharacters() {
        throw new UnsupportedOperationException("use isContextInformationAutoActivation instead");
    }

    public boolean isCompletionProposalAutoActivation(char var1, ITextViewer var2, int var3);

    public boolean isContextInformationAutoActivation(char var1, ITextViewer var2, int var3);

    public static IContentAssistProcessorExtension adapt(final IContentAssistProcessor processor) {
        if (processor == null) {
            return null;
        }
        if (processor instanceof IContentAssistProcessorExtension) {
            return (IContentAssistProcessorExtension)processor;
        }
        return new IContentAssistProcessorExtension(){

            @Override
            public String getErrorMessage() {
                return processor.getErrorMessage();
            }

            @Override
            public IContextInformationValidator getContextInformationValidator() {
                return processor.getContextInformationValidator();
            }

            @Override
            public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
                return processor.computeContextInformation(viewer, offset);
            }

            @Override
            public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
                return processor.computeCompletionProposals(viewer, offset);
            }

            @Override
            @Deprecated
            public char[] getCompletionProposalAutoActivationCharacters() {
                return processor.getCompletionProposalAutoActivationCharacters();
            }

            @Override
            @Deprecated
            public char[] getContextInformationAutoActivationCharacters() {
                return processor.getContextInformationAutoActivationCharacters();
            }

            @Override
            public boolean isCompletionProposalAutoActivation(char c, ITextViewer viewer, int offset) {
                char[] triggers = processor.getCompletionProposalAutoActivationCharacters();
                if (triggers != null) {
                    char[] cArray = triggers;
                    int n = triggers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char trigger = cArray[n2];
                        if (c == trigger) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }

            @Override
            public boolean isContextInformationAutoActivation(char c, ITextViewer viewer, int offset) {
                char[] triggers = processor.getContextInformationAutoActivationCharacters();
                if (triggers != null) {
                    char[] cArray = triggers;
                    int n = triggers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char trigger = cArray[n2];
                        if (c == trigger) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        };
    }
}

