/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.core.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.tracecompass.tmf.filter.parser.FilterParserLexer;

public class SyntaxHighlighting {
    public static final Color OPERATION_COLOR = new Color(0.3, 0.3, 1.0, 1.0);
    public static final Color TEXT_COLOR = new Color(0.0, 0.0, 0.0, 1.0);
    public static final Color SEPARATOR_COLOR = new Color(0.9, 0.5, 0.1, 1.0);

    public static List<ColorInformation> getColorInformationList(String str) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        ANTLRInputStream antlrStream = new ANTLRInputStream((InputStream)input);
        FilterParserLexer lexer = new FilterParserLexer((CharStream)antlrStream);
        lexer.setErrorListener(e -> {});
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        List commonTokenList = tokenStream.getTokens();
        LinkedList<ColorInformation> colorInformations = new LinkedList<ColorInformation>();
        commonTokenList.forEach(commonToken -> {
            Position start = new Position(commonToken.getLine(), commonToken.getStartIndex());
            Position end = new Position(commonToken.getLine(), commonToken.getStopIndex());
            Range range = new Range(start, end);
            Color color = SyntaxHighlighting.getColor(commonToken.getType());
            ColorInformation colorInformation = new ColorInformation(range, color);
            colorInformations.add(colorInformation);
        });
        return colorInformations;
    }

    private static Color getColor(int type) {
        switch (type) {
            case 6: {
                return OPERATION_COLOR;
            }
            case 19: {
                return TEXT_COLOR;
            }
            case 18: {
                return SEPARATOR_COLOR;
            }
        }
        return TEXT_COLOR;
    }
}

