/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;

public abstract class CompoundDeclaration
extends Declaration {
    private static final long BIT_MASK = 3L;
    private static final boolean[] ALIGNED_BYTES_ALIGNMENT;
    private static final int BITS_PER_BYTE = 8;

    static {
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        ALIGNED_BYTES_ALIGNMENT = blArray;
    }

    public abstract IDeclaration getElementType();

    @Override
    public long getAlignment() {
        return this.getElementType().getAlignment();
    }

    public boolean isString() {
        IDeclaration elementType = this.getElementType();
        if (elementType instanceof IntegerDeclaration) {
            IntegerDeclaration elemInt = (IntegerDeclaration)elementType;
            return elemInt.isCharacter();
        }
        return false;
    }

    public boolean isAlignedBytes() {
        IDeclaration elementType = this.getElementType();
        if (elementType instanceof IntegerDeclaration) {
            IntegerDeclaration elemInt = (IntegerDeclaration)elementType;
            long alignment = this.getAlignment();
            int lowBits = (int)(alignment & 3L);
            return elemInt.getLength() == 8 && alignment <= 8L && ALIGNED_BYTES_ALIGNMENT[lowBits];
        }
        return false;
    }
}

