/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;

public class ModuleSpecifier
extends ASTNode {
    public static final ChildPropertyDescriptor LOCAL_PROPERTY = new ChildPropertyDescriptor(ModuleSpecifier.class, "local", SimpleName.class, true, false);
    public static final ChildPropertyDescriptor DISCOVERABLE_NAME_PROPERTY = new ChildPropertyDescriptor(ModuleSpecifier.class, "discoverableName", SimpleName.class, false, false);
    public static final SimplePropertyDescriptor DEFAULT_PROPERTY = new SimplePropertyDescriptor(ModuleSpecifier.class, "isDefault", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor NAMESPACE_PROPERTY = new SimplePropertyDescriptor(ModuleSpecifier.class, "namespace", Boolean.TYPE, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;
    private SimpleName local;
    private SimpleName discoverableName;
    private boolean isDefault;
    private boolean namespace;

    static {
        ArrayList propertyList = new ArrayList(5);
        ModuleSpecifier.createPropertyList(ModuleSpecifier.class, propertyList);
        ModuleSpecifier.addProperty(LOCAL_PROPERTY, propertyList);
        ModuleSpecifier.addProperty(DISCOVERABLE_NAME_PROPERTY, propertyList);
        ModuleSpecifier.addProperty(DEFAULT_PROPERTY, propertyList);
        ModuleSpecifier.addProperty(NAMESPACE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = ModuleSpecifier.reapPropertyList(propertyList);
    }

    public static List<StructuralPropertyDescriptor> propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    ModuleSpecifier(AST ast) {
        super(ast);
    }

    @Override
    List internalStructuralPropertiesForType(int apiLevel) {
        return ModuleSpecifier.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == LOCAL_PROPERTY) {
            if (get) {
                return this.getLocal();
            }
            this.setLocal((SimpleName)child);
            return null;
        }
        if (property == DISCOVERABLE_NAME_PROPERTY) {
            if (get) {
                return this.getDiscoverableName();
            }
            this.setDiscoverableName((SimpleName)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == DEFAULT_PROPERTY) {
            if (get) {
                return this.isDefault();
            }
            this.setDefault(value);
            return false;
        }
        if (property == NAMESPACE_PROPERTY) {
            if (get) {
                return this.isNamespace();
            }
            this.setNamespace(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    int getNodeType0() {
        return 106;
    }

    public SimpleName getLocal() {
        return this.local;
    }

    public void setLocal(SimpleName local) {
        if (local == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this.local;
        this.preReplaceChild(oldChild, local, LOCAL_PROPERTY);
        this.local = local;
        this.postReplaceChild(oldChild, local, LOCAL_PROPERTY);
    }

    public SimpleName getDiscoverableName() {
        return this.discoverableName;
    }

    public void setDiscoverableName(SimpleName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this.discoverableName;
        this.preReplaceChild(oldChild, name, DISCOVERABLE_NAME_PROPERTY);
        this.discoverableName = name;
        this.postReplaceChild(oldChild, name, DISCOVERABLE_NAME_PROPERTY);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.preValueChange(DEFAULT_PROPERTY);
        this.isDefault = isDefault;
        this.postValueChange(DEFAULT_PROPERTY);
    }

    public boolean isNamespace() {
        return this.namespace;
    }

    public void setNamespace(boolean namespace) {
        this.preValueChange(NAMESPACE_PROPERTY);
        this.namespace = namespace;
        this.postValueChange(NAMESPACE_PROPERTY);
    }

    @Override
    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        ModuleSpecifier result = new ModuleSpecifier(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setDiscoverableName((SimpleName)this.getDiscoverableName().clone(target));
        result.setLocal((SimpleName)this.getLocal().clone(target));
        result.setDefault(this.isDefault());
        result.setNamespace(this.isNamespace());
        return result;
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getLocal());
            this.acceptChild(visitor, this.getDiscoverableName());
        }
        visitor.endVisit(this);
    }

    @Override
    int treeSize() {
        return 56;
    }

    @Override
    int memSize() {
        return this.memSize() + (this.local == null ? 0 : this.getLocal().treeSize()) + (this.discoverableName == null ? 0 : this.getDiscoverableName().treeSize());
    }
}

