/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumerationSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTypeSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;

public final class InstantiationContext {
    private CPPTemplateParameterMap parameterMap;
    private boolean forDeduction = false;
    private int packOffset;
    private final ICPPSpecialization contextSpecialization;
    private boolean expandPack;
    private boolean packExpanded;
    private Map<IBinding, IBinding> fInstantiatedLocals = null;

    public InstantiationContext(ICPPTemplateParameterMap parameterMap, int packOffset, ICPPSpecialization contextSpecialization) {
        this.parameterMap = (CPPTemplateParameterMap)parameterMap;
        this.packOffset = packOffset;
        this.contextSpecialization = contextSpecialization;
    }

    public InstantiationContext(ICPPTemplateParameterMap parameterMap, ICPPSpecialization contextSpecialization) {
        this(parameterMap, -1, contextSpecialization);
    }

    public InstantiationContext(ICPPTemplateParameterMap parameterMap, int packOffset) {
        this(parameterMap, packOffset, null);
    }

    public InstantiationContext(ICPPTemplateParameterMap parameterMap) {
        this(parameterMap, -1, null);
    }

    public static InstantiationContext forDeduction(ICPPTemplateParameterMap parameterMap) {
        InstantiationContext result = new InstantiationContext(parameterMap);
        result.forDeduction = true;
        return result;
    }

    public ICPPTemplateParameterMap getParameterMap() {
        return this.parameterMap;
    }

    public boolean isForDeduction() {
        return this.forDeduction;
    }

    public void addToParameterMap(ICPPTemplateParameter par, ICPPTemplateArgument arg) {
        if (this.parameterMap == null) {
            this.parameterMap = new CPPTemplateParameterMap(1);
        }
        this.parameterMap.put(par, arg);
    }

    public void addToParameterMap(ICPPTemplateParameter par, ICPPTemplateArgument[] args) {
        if (this.parameterMap == null) {
            this.parameterMap = new CPPTemplateParameterMap(1);
        }
        this.parameterMap.put(par, args);
    }

    public void addToParameterMap(ICPPTemplateParameterMap toAdd) {
        if (this.parameterMap == null) {
            this.parameterMap = new CPPTemplateParameterMap((CPPTemplateParameterMap)toAdd);
        } else {
            this.parameterMap.putAll(toAdd);
        }
    }

    public final ICPPSpecialization getContextSpecialization() {
        return this.contextSpecialization;
    }

    public final ICPPTypeSpecialization getContextTypeSpecialization() {
        return this.contextSpecialization instanceof ICPPTypeSpecialization ? (ICPPTypeSpecialization)this.contextSpecialization : null;
    }

    public ICPPClassSpecialization getContextClassSpecialization() {
        return InstantiationContext.getContextClassSpecialization(this.contextSpecialization);
    }

    public boolean hasPackOffset() {
        return this.packOffset != -1;
    }

    public int getPackOffset() {
        return this.packOffset;
    }

    public void setPackOffset(int packOffset) {
        this.packOffset = packOffset;
    }

    public boolean shouldExpandPack() {
        return this.expandPack;
    }

    public void setExpandPack(boolean expand) {
        this.expandPack = expand;
    }

    public boolean isPackExpanded() {
        return this.packExpanded;
    }

    public void setPackExpanded(boolean expanded) {
        this.packExpanded = expanded;
    }

    public ICPPTemplateArgument getArgument(ICPPTemplateParameter param) {
        return this.parameterMap == null ? null : this.parameterMap.getArgument(param, this.packOffset);
    }

    public ICPPTemplateArgument[] getPackExpansion(ICPPTemplateParameter param) {
        return this.parameterMap == null ? null : this.parameterMap.getPackExpansion(param);
    }

    public static ICPPClassSpecialization getContextClassSpecialization(IBinding owner) {
        if (owner instanceof ICPPEnumerationSpecialization) {
            owner = owner.getOwner();
        }
        if (owner instanceof ICPPClassSpecialization) {
            return (ICPPClassSpecialization)owner;
        }
        return null;
    }

    public void putInstantiatedLocal(IBinding local, IBinding instantiatedLocal) {
        if (this.fInstantiatedLocals == null) {
            this.fInstantiatedLocals = new HashMap<IBinding, IBinding>();
        }
        this.fInstantiatedLocals.put(local, instantiatedLocal);
    }

    public IBinding getInstantiatedLocal(IBinding local) {
        return this.fInstantiatedLocals == null ? null : this.fInstantiatedLocals.get(local);
    }
}

