/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom.flatten;

public abstract class JsCodeOutputStream {
    protected char lastChar = (char)65535;
    protected boolean optionalSemicolon;
    protected int rawMode;

    public void write(String token) {
        if (token.isEmpty()) {
            return;
        }
        if (this.optionalSemicolon) {
            this.optionalSemicolon = false;
            if (!token.equals("}")) {
                this.put(";");
                this.lastChar = (char)59;
            }
        }
        if (this.rawMode == 0) {
            char firstChar = token.charAt(0);
            if ((this.lastChar == '+' || this.lastChar == '-') && this.lastChar == firstChar || JsCodeOutputStream.isIdentifierChar(this.lastChar) && JsCodeOutputStream.isIdentifierChar(firstChar) || this.lastChar == '/' && (firstChar == 'i' || firstChar == '/')) {
                this.put(" ");
            }
        }
        this.put(token);
        this.lastChar = token.charAt(token.length() - 1);
    }

    public void writeSemicolon() {
        this.write(";");
    }

    public void writeOptionalSemicolon() {
        this.optionalSemicolon = true;
    }

    private static boolean isIdentifierChar(int ch) {
        if (ch < 128) {
            return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57 || ch == 36 || ch == 95;
        }
        switch (Character.getType(ch)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                return true;
            }
        }
        return ch == 8204 || ch == 8205;
    }

    protected abstract void put(String var1);

    public void setRawMode() {
        ++this.rawMode;
    }

    public void unsetRawMode() {
        --this.rawMode;
    }
}

