/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.gnu.IGCCASTAttributeList;
import org.eclipse.cdt.core.dom.parser.cpp.ICPPASTAttributeSpecifier;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class NodeWriter {
    protected Scribe scribe;
    protected ASTWriterVisitor visitor;
    protected NodeCommentMap commentMap;
    protected static final String COMMA_SPACE = ", ";
    protected static final String EQUALS = " = ";
    protected static final String SPACE_COLON_SPACE = " : ";
    protected static final String VAR_ARGS = "...";
    protected static final String COLON_COLON = "::";
    protected static final String COLON_SPACE = ": ";
    protected static final String OPENING_SQUARE_BRACKET = "[";
    protected static final String CLOSING_SQUARE_BRACKET = "]";
    protected static final String OPENING_PARENTHESIS = "(";
    protected static final String CLOSING_PARENTHESIS = ")";

    public NodeWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        this.scribe = scribe;
        this.visitor = visitor;
        this.commentMap = commentMap;
    }

    protected void writeNodeList(IASTNode[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            nodes[i].accept(this.visitor);
            if (i + 1 < nodes.length) {
                this.scribe.print(COMMA_SPACE);
            }
            ++i;
        }
    }

    protected void visitNodeIfNotNull(IASTNode node) {
        if (node != null) {
            node.accept(this.visitor);
        }
    }

    protected void writeTrailingComments(IASTNode node) {
        this.writeTrailingComments(node, true);
    }

    protected void writeTrailingComments(IASTNode node, boolean newLine) {
        boolean first = true;
        for (IASTComment comment : this.getTrailingComments(node)) {
            if (!first) {
                this.scribe.newLine();
            }
            this.scribe.printSpace();
            this.scribe.print(comment.getComment());
            first = false;
        }
        if (newLine) {
            this.scribe.newLine();
        }
    }

    protected boolean hasTrailingComments(IASTNode node) {
        return !this.getTrailingComments(node).isEmpty();
    }

    private List<IASTComment> getTrailingComments(IASTNode node) {
        List<IASTComment> trailingComments = this.commentMap.getTrailingCommentsForNode(node);
        IASTNode originalNode = node.getOriginalNode();
        if (originalNode != node) {
            trailingComments.addAll(this.commentMap.getTrailingCommentsForNode(originalNode));
        }
        return trailingComments;
    }

    protected boolean hasFreestandingComments(IASTNode node) {
        return !this.getFreestandingComments(node).isEmpty();
    }

    private List<IASTComment> getFreestandingComments(IASTNode node) {
        List<IASTComment> freestandingComments = this.commentMap.getFreestandingCommentsForNode(node);
        IASTNode originalNode = node.getOriginalNode();
        if (originalNode != node) {
            freestandingComments.addAll(this.commentMap.getFreestandingCommentsForNode(originalNode));
        }
        return freestandingComments;
    }

    protected void writeFreestandingComments(IASTNode node) {
        for (IASTComment comment : this.getFreestandingComments(node)) {
            this.scribe.print(comment.getComment());
            this.scribe.newLine();
        }
    }

    protected void writeAttributes(IASTAttributeOwner attributeOwner, EnumSet<SpaceLocation> spaceLocations) {
        IASTAttributeSpecifier[] specifiers = attributeOwner.getAttributeSpecifiers();
        this.writeAttributes(specifiers, spaceLocations);
    }

    protected void writeGCCAttributes(IASTAttributeOwner attributeOwner, EnumSet<SpaceLocation> spaceLocations) {
        IASTAttributeSpecifier[] specifiers = attributeOwner.getAttributeSpecifiers();
        IASTAttributeSpecifier[] gnuSpecifiers = ArrayUtil.filter(specifiers, IGCCASTAttributeList.TYPE_FILTER);
        this.writeAttributes(gnuSpecifiers, spaceLocations);
    }

    protected void writeCPPAttributes(IASTAttributeOwner attributeOwner, EnumSet<SpaceLocation> spaceLocations) {
        IASTAttributeSpecifier[] specifiers = attributeOwner.getAttributeSpecifiers();
        IASTAttributeSpecifier[] cppSpecifiers = ArrayUtil.filter(specifiers, ICPPASTAttributeSpecifier.TYPE_FILTER);
        this.writeAttributes(cppSpecifiers, spaceLocations);
    }

    private void writeAttributes(IASTAttributeSpecifier[] specifiers, EnumSet<SpaceLocation> spaceLocations) {
        if (specifiers.length == 0) {
            return;
        }
        if (spaceLocations.contains((Object)SpaceLocation.BEFORE)) {
            this.scribe.printSpace();
        }
        IASTAttributeSpecifier[] iASTAttributeSpecifierArray = specifiers;
        int n = specifiers.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAttributeSpecifier specifier = iASTAttributeSpecifierArray[n2];
            specifier.accept(this.visitor);
            ++n2;
        }
        if (spaceLocations.contains((Object)SpaceLocation.AFTER)) {
            this.scribe.printSpace();
        }
    }

    protected static enum SpaceLocation {
        BEFORE,
        AFTER;

    }
}

