/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.internal.core.dom.parser.AbstractGNUSourceCodeParser;

public class NameOrTemplateIDVariants {
    private BranchPoint fFirst;

    public boolean isEmpty() {
        return this.fFirst == null;
    }

    public void addBranchPoint(Variant variants, AbstractGNUSourceCodeParser.BinaryOperator left, boolean allowAssignment, int conditionCount) {
        this.fFirst = new BranchPoint(this.fFirst, variants, left, allowAssignment, conditionCount);
    }

    public void closeVariants(int offset, AbstractGNUSourceCodeParser.BinaryOperator lastOperator) {
        BranchPoint p = this.fFirst;
        while (p != null) {
            Variant v = p.getFirstVariant();
            while (v != null) {
                if (v.getTargetOperator() == null && offset == v.getRightOffset()) {
                    v.setTargetOperator(lastOperator);
                }
                v = v.getNext();
            }
            p = p.getNext();
        }
    }

    public Variant selectFallback() {
        BranchPoint p = this.fFirst;
        while (p != null) {
            Variant best = null;
            Variant v = p.getFirstVariant();
            while (v != null) {
                if (v.getTargetOperator() == null && (best == null || v.fRightOffset < best.fRightOffset)) {
                    best = v;
                }
                v = v.getNext();
            }
            if (best != null) {
                this.remove(best);
                return best;
            }
            p = p.getNext();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void remove(Variant remove) {
        block5: {
            owner = Variant.access$3(remove);
            next = remove.getNext();
            prev = owner.getFirstVariant();
            if (remove != prev) ** GOTO lbl14
            BranchPoint.access$0(owner, next);
            if (next != null) break block5;
            this.remove(owner);
            break block5;
lbl-1000:
            // 1 sources

            {
                n = prev.getNext();
                if (n == remove) {
                    Variant.access$1(prev, next);
                    break;
                }
                prev = n;
lbl14:
                // 2 sources

                ** while (prev != null)
            }
        }
    }

    private void remove(BranchPoint remove) {
        BranchPoint next = remove.getNext();
        if (remove == this.fFirst) {
            this.fFirst = next;
        } else {
            BranchPoint prev = this.fFirst;
            while (prev != null) {
                BranchPoint n = prev.getNext();
                if (n == remove) {
                    prev.fNext = next;
                    break;
                }
                prev = n;
            }
        }
    }

    public BranchPoint getOrderedBranchPoints() {
        BranchPoint prev = null;
        BranchPoint curr = this.fFirst;
        while (curr != null) {
            curr.reverseVariants();
            BranchPoint next = curr.getNext();
            curr.fNext = prev;
            prev = curr;
            curr = next;
        }
        this.fFirst = null;
        return prev;
    }

    public boolean hasRightBound(int opOffset) {
        BranchPoint p = this.fFirst;
        while (p != null) {
            Variant v = p.getFirstVariant();
            while (v != null) {
                if (v.fRightOffset > opOffset) {
                    return false;
                }
                v = v.getNext();
            }
            p = p.getNext();
        }
        return true;
    }

    public void removeInvalid(AbstractGNUSourceCodeParser.BinaryOperator lastOperator) {
        BranchPoint p = this.fFirst;
        while (p != null) {
            if (!this.isReachable(p, lastOperator)) {
                this.remove(p);
            } else {
                Variant v = p.getFirstVariant();
                while (v != null) {
                    if (v.getTargetOperator() == null) {
                        this.remove(v);
                    }
                    v = v.getNext();
                }
            }
            p = p.getNext();
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isReachable(BranchPoint bp, AbstractGNUSourceCodeParser.BinaryOperator endOperator) {
        op = bp.getLeftOperator();
        if (op != null) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            if (endOperator == op) {
                return true;
            }
            endOperator = endOperator.getNext();
lbl7:
            // 2 sources

            ** while (endOperator != null)
        }
lbl8:
        // 1 sources

        return false;
    }

    static class BranchPoint {
        private BranchPoint fNext;
        private Variant fFirstVariant;
        private final boolean fAllowAssignment;
        private final int fConditionCount;
        private final AbstractGNUSourceCodeParser.BinaryOperator fLeftOperator;

        BranchPoint(BranchPoint next, Variant variant, AbstractGNUSourceCodeParser.BinaryOperator left, boolean allowAssignment, int conditionCount) {
            this.fNext = next;
            this.fFirstVariant = variant;
            this.fAllowAssignment = allowAssignment;
            this.fConditionCount = conditionCount;
            this.fLeftOperator = left;
            while (variant != null) {
                variant.fOwner = this;
                variant = variant.getNext();
            }
        }

        public boolean isAllowAssignment() {
            return this.fAllowAssignment;
        }

        public int getConditionCount() {
            return this.fConditionCount;
        }

        public AbstractGNUSourceCodeParser.BinaryOperator getLeftOperator() {
            return this.fLeftOperator;
        }

        public Variant getFirstVariant() {
            return this.fFirstVariant;
        }

        public BranchPoint getNext() {
            return this.fNext;
        }

        public void reverseVariants() {
            Variant prev = null;
            Variant curr = this.fFirstVariant;
            while (curr != null) {
                Variant next = curr.getNext();
                curr.fNext = prev;
                prev = curr;
                curr = next;
            }
            this.fFirstVariant = prev;
        }

        static /* synthetic */ void access$0(BranchPoint branchPoint, Variant variant) {
            branchPoint.fFirstVariant = variant;
        }
    }

    static class Variant {
        private BranchPoint fOwner;
        private Variant fNext;
        private final IASTExpression fExpression;
        private AbstractGNUSourceCodeParser.BinaryOperator fTargetOperator;
        private final int fRightOffset;
        private final IASTName[] fTemplateNames;

        public Variant(Variant next, IASTExpression expr, IASTName[] templateNames, int rightOffset) {
            this.fNext = next;
            this.fExpression = expr;
            this.fRightOffset = rightOffset;
            this.fTemplateNames = templateNames;
        }

        public BranchPoint getOwner() {
            return this.fOwner;
        }

        public int getRightOffset() {
            return this.fRightOffset;
        }

        public IASTName[] getTemplateNames() {
            return this.fTemplateNames;
        }

        public Variant getNext() {
            return this.fNext;
        }

        public IASTExpression getExpression() {
            return this.fExpression;
        }

        public AbstractGNUSourceCodeParser.BinaryOperator getTargetOperator() {
            return this.fTargetOperator;
        }

        public void setTargetOperator(AbstractGNUSourceCodeParser.BinaryOperator lastOperator) {
            this.fTargetOperator = lastOperator;
        }

        static /* synthetic */ BranchPoint access$3(Variant variant) {
            return variant.fOwner;
        }
    }
}

