/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.locale.LSR;
import com.ibm.icu.impl.locale.LikelySubtagsBuilder;
import com.ibm.icu.util.BytesTrie;
import com.ibm.icu.util.ULocale;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public final class XLikelySubtags {
    private static final String PSEUDO_ACCENTS_PREFIX = "'";
    private static final String PSEUDO_BIDI_PREFIX = "+";
    private static final String PSEUDO_CRACKED_PREFIX = ",";
    private static final boolean DEBUG_OUTPUT = false;
    static final XLikelySubtags INSTANCE = new XLikelySubtags(LikelySubtagsBuilder.build());
    private final Map<String, String> languageAliases;
    private final Map<String, String> regionAliases;
    private final BytesTrie trie;
    private final long trieUndState;
    private final long trieUndZzzzState;
    private final int defaultLsrIndex;
    private final LSR[] lsrs;

    private XLikelySubtags(Data data) {
        this.languageAliases = data.languageAliases;
        this.regionAliases = data.regionAliases;
        this.trie = data.trie;
        this.lsrs = data.lsrs;
        BytesTrie.Result result = this.trie.next(42);
        assert (result == BytesTrie.Result.INTERMEDIATE_VALUE);
        int value = this.trie.getValue();
        assert (value == 0);
        this.trieUndState = this.trie.getState64();
        result = this.trie.next(42);
        assert (result == BytesTrie.Result.INTERMEDIATE_VALUE);
        value = this.trie.getValue();
        assert (value == 0);
        this.trieUndZzzzState = this.trie.getState64();
        result = this.trie.next(42);
        assert (result.hasValue());
        this.defaultLsrIndex = this.trie.getValue();
        this.trie.reset();
    }

    private static String getCanonical(Map<String, String> aliases, String alias) {
        String canonical = aliases.get(alias);
        return canonical == null ? alias : canonical;
    }

    LSR makeMaximizedLsrFrom(ULocale locale) {
        String variant;
        String name = locale.getName();
        if (name.startsWith("@x=")) {
            return new LSR(name, "", "");
        }
        String language = locale.getLanguage();
        String script = locale.getScript();
        String region = locale.getCountry();
        if (region.length() == 2 && region.charAt(0) == 'X') {
            switch (region.charAt(1)) {
                case 'A': {
                    return new LSR(PSEUDO_ACCENTS_PREFIX + language, PSEUDO_ACCENTS_PREFIX + script, region);
                }
                case 'B': {
                    return new LSR(PSEUDO_BIDI_PREFIX + language, PSEUDO_BIDI_PREFIX + script, region);
                }
                case 'C': {
                    return new LSR(PSEUDO_CRACKED_PREFIX + language, PSEUDO_CRACKED_PREFIX + script, region);
                }
            }
        }
        if ((variant = locale.getVariant()).startsWith("PS")) {
            switch (variant) {
                case "PSACCENT": {
                    return new LSR(PSEUDO_ACCENTS_PREFIX + language, PSEUDO_ACCENTS_PREFIX + script, region.isEmpty() ? "XA" : region);
                }
                case "PSBIDI": {
                    return new LSR(PSEUDO_BIDI_PREFIX + language, PSEUDO_BIDI_PREFIX + script, region.isEmpty() ? "XB" : region);
                }
                case "PSCRACK": {
                    return new LSR(PSEUDO_CRACKED_PREFIX + language, PSEUDO_CRACKED_PREFIX + script, region.isEmpty() ? "XC" : region);
                }
            }
        }
        language = XLikelySubtags.getCanonical(this.languageAliases, language);
        region = XLikelySubtags.getCanonical(this.regionAliases, region);
        return INSTANCE.maximize(language, script, region);
    }

    private LSR maximize(String language, String script, String region) {
        long state;
        int value;
        int retainOldMask = 0;
        BytesTrie iter = new BytesTrie(this.trie);
        if (language.equals("und")) {
            language = "";
        }
        if ((value = XLikelySubtags.trieNext(iter, language, false)) >= 0) {
            if (!language.isEmpty()) {
                retainOldMask |= 4;
            }
            state = iter.getState64();
        } else {
            retainOldMask |= 4;
            iter.resetToState64(this.trieUndState);
            state = 0L;
        }
        if (script.equals("Zzzz")) {
            script = "";
        }
        if ((value = XLikelySubtags.trieNext(iter, script, false)) >= 0) {
            if (!script.isEmpty()) {
                retainOldMask |= 2;
            }
            state = iter.getState64();
        } else {
            retainOldMask |= 2;
            if (state == 0L) {
                iter.resetToState64(this.trieUndZzzzState);
            } else {
                iter.resetToState64(state);
                value = XLikelySubtags.trieNext(iter, "", false);
                assert (value == 0);
                state = iter.getState64();
            }
        }
        if (region.equals("ZZ")) {
            region = "";
        }
        if ((value = XLikelySubtags.trieNext(iter, region, true)) >= 0) {
            if (!region.isEmpty()) {
                retainOldMask |= 1;
            }
        } else {
            retainOldMask |= 1;
            if (state == 0L) {
                value = this.defaultLsrIndex;
            } else {
                iter.resetToState64(state);
                value = XLikelySubtags.trieNext(iter, "", true);
                if (value < 0) {
                    return null;
                }
            }
        }
        LSR result = this.lsrs[value];
        if (language.isEmpty()) {
            language = "und";
        }
        if (retainOldMask == 0) {
            return result;
        }
        if ((retainOldMask & 4) == 0) {
            language = result.language;
        }
        if ((retainOldMask & 2) == 0) {
            script = result.script;
        }
        if ((retainOldMask & 1) == 0) {
            region = result.region;
        }
        return new LSR(language, script, region);
    }

    private static final int trieNext(BytesTrie iter, String s, boolean finalSubtag) {
        BytesTrie.Result result;
        if (s.isEmpty()) {
            result = iter.next(42);
        } else {
            int end = s.length() - 1;
            int i = 0;
            while (true) {
                result = iter.next(s.charAt(i));
                if (i >= end) break;
                if (!result.hasNext()) {
                    return -1;
                }
                ++i;
            }
        }
        if (!finalSubtag) {
            if (result == BytesTrie.Result.INTERMEDIATE_VALUE) {
                return 0;
            }
        } else if (result.hasValue()) {
            return iter.getValue();
        }
        return -1;
    }

    LSR minimizeSubtags(String languageIn, String scriptIn, String regionIn, ULocale.Minimize fieldToFavor) {
        LSR result2;
        LSR result = this.maximize(languageIn, scriptIn, regionIn);
        BytesTrie iter = new BytesTrie(this.trie);
        int value = XLikelySubtags.trieNext(iter, result.language, false);
        assert (value >= 0);
        value = XLikelySubtags.trieNext(iter, "", false);
        assert (value >= 0);
        value = XLikelySubtags.trieNext(iter, "", true);
        LSR value00 = this.lsrs[value];
        boolean favorRegionOk = false;
        if (result.script.equals(value00.script)) {
            if (result.region.equals(value00.region)) {
                return new LSR(result.language, "", "");
            }
            if (fieldToFavor == ULocale.Minimize.FAVOR_REGION) {
                return new LSR(result.language, "", result.region);
            }
            favorRegionOk = true;
        }
        if ((result2 = this.maximize(languageIn, scriptIn, "")).equals(result)) {
            return new LSR(result.language, result.script, "");
        }
        if (favorRegionOk) {
            return new LSR(result.language, "", result.region);
        }
        return result;
    }

    private Map<String, LSR> getTable() {
        LinkedHashMap<String, LSR> map = new LinkedHashMap<String, LSR>();
        HashSet<String> prefixes = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        for (BytesTrie.Entry entry : this.trie) {
            sb.setLength(0);
            int length = entry.bytesLength();
            int i = 0;
            while (i < length) {
                byte b = entry.byteAt(i++);
                sb.append((char)b);
                if (i >= length || !prefixes.contains(sb.toString())) continue;
                sb.append('-');
            }
            String s = sb.toString();
            if (entry.value == 0) {
                prefixes.add(s);
                continue;
            }
            map.put(s, this.lsrs[entry.value]);
        }
        return map;
    }

    public String toString() {
        return this.getTable().toString();
    }

    static final class Data {
        private final Map<String, String> languageAliases;
        private final Map<String, String> regionAliases;
        private final BytesTrie trie;
        private final LSR[] lsrs;

        Data(Map<String, String> languageAliases, Map<String, String> regionAliases, BytesTrie trie, LSR[] lsrs) {
            this.languageAliases = languageAliases;
            this.regionAliases = regionAliases;
            this.trie = trie;
            this.lsrs = lsrs;
        }
    }
}

