/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat;

import com.ibm.icu.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.MessagesForNumberFormat;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public class FormattedValueVMUtil {
    private static Map<String, Map<String, String>> fFormatProperties = Collections.synchronizedMap(new TreeMap());
    private static Map<String, String> fFormatLabels = new HashMap<String, String>(8);

    static {
        FormattedValueVMUtil.setFormatLabel("NATURAL.Format", MessagesForNumberFormat.FormattedValueVMUtil_Natural_format__label);
        FormattedValueVMUtil.setFormatLabel("HEX.Format", MessagesForNumberFormat.FormattedValueVMUtil_Hex_format__label);
        FormattedValueVMUtil.setFormatLabel("DECIMAL.Format", MessagesForNumberFormat.FormattedValueVMUtil_Decimal_format__label);
        FormattedValueVMUtil.setFormatLabel("OCTAL.Format", MessagesForNumberFormat.FormattedValueVMUtil_Octal_format__label);
        FormattedValueVMUtil.setFormatLabel("BINARY.Format", MessagesForNumberFormat.FormattedValueVMUtil_Binary_format__label);
        FormattedValueVMUtil.setFormatLabel("STRING.Format", MessagesForNumberFormat.FormattedValueVMUtil_String_format__label);
    }

    public static void setFormatLabel(String formatId, String label) {
        fFormatLabels.put(formatId, label);
    }

    public static String getFormatLabel(String formatId) {
        String label = fFormatLabels.get(formatId);
        if (label != null) {
            return label;
        }
        return MessageFormat.format((String)MessagesForNumberFormat.FormattedValueVMUtil_Other_format__format_text, (Object[])new Object[]{formatId});
    }

    @Deprecated
    public static String getPropertyForFormatId(String formatId) {
        return FormattedValueVMUtil.getPropertyForFormatId(formatId, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPropertyForFormatId(String formatId, String prefix) {
        if (formatId == null) {
            return null;
        }
        if (prefix == null) {
            prefix = "";
        }
        Map<String, Map<String, String>> map = fFormatProperties;
        synchronized (map) {
            Map<String, String> formatsMap = FormattedValueVMUtil.getFormatsMap(prefix);
            String property = formatsMap.get(formatId);
            if (property == null) {
                property = (String.valueOf(prefix) + "formatted_value_base" + "." + formatId).intern();
                formatsMap.put(formatId, property);
            }
            return property;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getFormatsMap(String prefix) {
        Map<String, Map<String, String>> map = fFormatProperties;
        synchronized (map) {
            Map<String, String> prefixMap = fFormatProperties.get(prefix);
            if (prefixMap == null) {
                prefixMap = new TreeMap<String, String>();
                fFormatProperties.put(prefix, prefixMap);
            }
            return prefixMap;
        }
    }

    @Deprecated
    public static String getFormatFromProperty(String property) {
        return FormattedValueVMUtil.getFormatFromProperty(property, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFormatFromProperty(String property, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        Map<String, Map<String, String>> map = fFormatProperties;
        synchronized (map) {
            Map<String, String> formatsMap = FormattedValueVMUtil.getFormatsMap(prefix);
            for (Map.Entry<String, String> entry : formatsMap.entrySet()) {
                if (!entry.getValue().equals(property)) continue;
                return entry.getKey();
            }
            if (!property.startsWith(prefix) || !property.startsWith("formatted_value_base", prefix.length())) {
                throw new IllegalArgumentException("Property " + property + " is not a valid formatted value format property.");
            }
            String formatId = property.substring(prefix.length() + "formatted_value_base".length() + 1).intern();
            formatsMap.put(formatId, property);
            return formatId;
        }
    }

    public static String getPreferredFormat(IPresentationContext context) {
        Object prop = context.getProperty("CurrentNumericStyle");
        if (prop != null) {
            return (String)prop;
        }
        return "NATURAL.Format";
    }

    @Deprecated
    @ConfinedToDsfExecutor(value="service.getExecutor()")
    public static void updateFormattedValues(final IPropertiesUpdate[] updates, final IFormattedValues service, final Class<? extends IFormattedValues.IFormattedDataDMContext> dmcType, final RequestMonitor monitor) {
        final Map availableFormats = Collections.synchronizedMap(new HashMap(updates.length * 4 / 3));
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)service.getExecutor(), monitor){

            protected void handleCompleted() {
                FormattedValueVMUtil.updateFormattedValuesWithAvailableFormats(updates, service, dmcType, availableFormats, monitor);
            }
        };
        int count = 0;
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            if (update.getProperties().contains("formatted_value_available_formats") || update.getProperties().contains("formatted_value_active_format") || update.getProperties().contains("formatted_value_active_format_value")) {
                IFormattedValues.IFormattedDataDMContext dmc = null;
                if (update.getElement() instanceof IDMVMContext) {
                    dmc = (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)update.getElement()).getDMContext(), dmcType);
                }
                if (dmc == null) {
                    update.setStatus(DsfUIPlugin.newErrorStatus(10002, "Update element did not contain a valid context: " + dmcType, null));
                } else {
                    service.getAvailableFormats(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<String[]>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                if (update.getProperties().contains("formatted_value_available_formats")) {
                                    update.setProperty("formatted_value_available_formats", this.getData());
                                }
                                availableFormats.put(update, (String[])this.getData());
                            } else {
                                update.setStatus(this.getStatus());
                            }
                            countingRm.done();
                        }
                    });
                    ++count;
                }
            }
            ++n2;
        }
        countingRm.setDoneCount(count);
    }

    @ConfinedToDsfExecutor(value="service.getExecutor()")
    private static void updateFormattedValuesWithAvailableFormats(IPropertiesUpdate[] updates, IFormattedValues service, Class<? extends IFormattedValues.IFormattedDataDMContext> dmcType, Map<IPropertiesUpdate, String[]> availableFormatsMap, RequestMonitor monitor) {
        final CountingRequestMonitor countingRm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), monitor);
        int count = 0;
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            IFormattedValues.IFormattedDataDMContext dmc = null;
            if (update.getElement() instanceof IDMVMContext) {
                dmc = (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)update.getElement()).getDMContext(), dmcType);
            }
            if (dmc != null) {
                String[] availableFormats = availableFormatsMap.get(update);
                String _activeFormat = null;
                if (availableFormats != null && availableFormats.length != 0) {
                    _activeFormat = FormattedValueVMUtil.getPreferredFormat(update.getPresentationContext());
                    update.setProperty("CurrentNumericStyle", _activeFormat);
                    if (!FormattedValueVMUtil.isFormatAvailable(_activeFormat, availableFormats)) {
                        _activeFormat = availableFormats[0];
                    }
                }
                final String activeFormat = _activeFormat;
                if (update.getProperties().contains("formatted_value_active_format")) {
                    assert (activeFormat != null) : "Our caller should have provided the available formats if this property was specified; given available formats, an 'active' nomination is guaranteed.";
                    update.setProperty("formatted_value_active_format", activeFormat);
                }
                boolean activeFormatValueRequested = false;
                boolean activeFormatValueHandled = false;
                if (update.getProperties().contains("formatted_value_active_format_value")) {
                    assert (activeFormat != null) : "Our caller should have provided the available formats if this property was specified; given available formats, an 'active' nomination is guaranteed.";
                    activeFormatValueRequested = true;
                }
                Iterator<String> itr = update.getProperties().iterator();
                while (itr.hasNext() || activeFormatValueRequested && !activeFormatValueHandled) {
                    String nextFormat;
                    if (itr.hasNext()) {
                        String propertyName = itr.next();
                        if (!propertyName.startsWith("formatted_value_base")) continue;
                        nextFormat = FormattedValueVMUtil.getFormatFromProperty(propertyName);
                        if (nextFormat.equals(activeFormat)) {
                            activeFormatValueHandled = true;
                        }
                        if (availableFormats != null && !FormattedValueVMUtil.isFormatAvailable(nextFormat, availableFormats)) {
                            continue;
                        }
                    } else {
                        nextFormat = activeFormat;
                        activeFormatValueHandled = true;
                    }
                    final boolean _activeFormatValueRequested = activeFormatValueRequested;
                    final IFormattedValues.FormattedValueDMContext formattedValueDmc = service.getFormattedValueContext(dmc, nextFormat);
                    service.getFormattedExpressionValue(formattedValueDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IFormattedValues.FormattedValueDMData>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                String format = formattedValueDmc.getFormatID();
                                update.setProperty(FormattedValueVMUtil.getPropertyForFormatId(format), ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                if (_activeFormatValueRequested && format.equals(activeFormat)) {
                                    update.setProperty("formatted_value_active_format_value", ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                }
                            } else {
                                update.setStatus(this.getStatus());
                            }
                            countingRm.done();
                        }
                    });
                    ++count;
                }
            }
            ++n2;
        }
        countingRm.setDoneCount(count);
    }

    private static boolean isFormatAvailable(String format, String[] availableFormats) {
        String[] stringArray = availableFormats;
        int n = availableFormats.length;
        int n2 = 0;
        while (n2 < n) {
            String availableFormat = stringArray[n2];
            if (availableFormat.equals(format)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

