/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui;

import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EvaluationContextManager
implements IWindowListener,
IDebugContextListener {
    private static final String CDT_DEBUG_UI_PLUGIN_ID = "org.eclipse.cdt.debug.ui";
    private static final String DEBUGGER_ACTIVE = "org.eclipse.cdt.debug.ui.debuggerActive";
    protected static EvaluationContextManager fgManager;

    protected EvaluationContextManager() {
    }

    public static void startup() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (fgManager == null) {
                    EvaluationContextManager manager = new EvaluationContextManager();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        manager.windowOpened(windows[i]);
                        ++i;
                    }
                    workbench.addWindowListener((IWindowListener)manager);
                    fgManager = manager;
                }
            }
        };
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        display.asyncExec(r);
    }

    public void windowActivated(IWorkbenchWindow window) {
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(window);
        service.addDebugContextListener((IDebugContextListener)this);
        this.selectionChanged(service.getActiveContext());
    }

    public void windowDeactivated(IWorkbenchWindow window) {
        DebugUITools.getDebugContextManager().getContextService(window).removeDebugContextListener((IDebugContextListener)this);
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.selectionChanged(event.getContext());
    }

    private void selectionChanged(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IDMVMContext) {
            this.setContext((IDMVMContext)element);
            return;
        }
        this.removeContext();
    }

    private void setContext(IDMVMContext target) {
        System.setProperty(DEBUGGER_ACTIVE, Boolean.TRUE.toString());
    }

    private void removeContext() {
        System.setProperty(DEBUGGER_ACTIVE, Boolean.FALSE.toString());
    }
}

