/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

public final class CharOperation {
    public static final char[] NO_CHAR = new char[0];
    public static final char[][] NO_CHAR_CHAR = new char[0][];

    public static final char[] append(char[] array, char suffix) {
        if (array == null) {
            return new char[]{suffix};
        }
        int length = array.length;
        char[] cArray = array;
        array = new char[length + 1];
        System.arraycopy(cArray, 0, array, 0, length);
        array[length] = suffix;
        return array;
    }

    public static final char[] append(char[] target, int index, char[] array, int start, int end) {
        int subLength = end - start;
        int newTargetLength = subLength + index;
        int targetLength = target.length;
        if (newTargetLength > targetLength) {
            char[] cArray = target;
            target = new char[newTargetLength * 2];
            System.arraycopy(cArray, 0, target, 0, index);
        }
        System.arraycopy(array, start, target, index, subLength);
        return target;
    }

    public static final char[][] arrayConcat(char[][] first, char[][] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        int length2 = second.length;
        char[][] result = new char[length1 + length2][];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        return result;
    }

    public static final char[][] arrayConcat(char[][] first, char[] second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            return new char[][]{second};
        }
        int length = first.length;
        char[][] result = new char[length + 1][];
        System.arraycopy(first, 0, result, 0, length);
        result[length] = second;
        return result;
    }

    public static final int compareWith(char[] array, char[] prefix) {
        int arrayLength = array.length;
        int prefixLength = prefix.length;
        int min = Math.min(arrayLength, prefixLength);
        int i = 0;
        while (min-- != 0) {
            char c2;
            char c1 = array[i];
            if (c1 == (c2 = prefix[i++])) continue;
            return c1 - c2;
        }
        if (prefixLength == i) {
            return 0;
        }
        return 1;
    }

    public static final char[] concat(char[] first, char[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        int length2 = second.length;
        char[] result = new char[length1 + length2];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        return result;
    }

    public static final char[] concat(char[] first, char[] second, char[] third) {
        if (first == null) {
            return CharOperation.concat(second, third);
        }
        if (second == null) {
            return CharOperation.concat(first, third);
        }
        if (third == null) {
            return CharOperation.concat(first, second);
        }
        int length1 = first.length;
        int length2 = second.length;
        int length3 = third.length;
        char[] result = new char[length1 + length2 + length3];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        System.arraycopy(third, 0, result, length1 + length2, length3);
        return result;
    }

    public static final char[] concat(char[] first, char[] second, char separator) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        if (length1 == 0) {
            return second;
        }
        int length2 = second.length;
        if (length2 == 0) {
            return first;
        }
        char[] result = new char[length1 + length2 + 1];
        System.arraycopy(first, 0, result, 0, length1);
        result[length1] = separator;
        System.arraycopy(second, 0, result, length1 + 1, length2);
        return result;
    }

    public static final char[] concat(char[] first, char sep1, char[] second, char sep2, char[] third) {
        if (first == null) {
            return CharOperation.concat(second, third, sep2);
        }
        if (second == null) {
            return CharOperation.concat(first, third, sep1);
        }
        if (third == null) {
            return CharOperation.concat(first, second, sep1);
        }
        int length1 = first.length;
        int length2 = second.length;
        int length3 = third.length;
        char[] result = new char[length1 + length2 + length3 + 2];
        System.arraycopy(first, 0, result, 0, length1);
        result[length1] = sep1;
        System.arraycopy(second, 0, result, length1 + 1, length2);
        result[length1 + length2 + 1] = sep2;
        System.arraycopy(third, 0, result, length1 + length2 + 2, length3);
        return result;
    }

    public static final char[] concat(char prefix, char[] array, char suffix) {
        if (array == null) {
            return new char[]{prefix, suffix};
        }
        int length = array.length;
        char[] result = new char[length + 2];
        result[0] = prefix;
        System.arraycopy(array, 0, result, 1, length);
        result[length + 1] = suffix;
        return result;
    }

    public static final char[] concatWith(char[] name, char[][] array, char separator) {
        int nameLength;
        int n = nameLength = name == null ? 0 : name.length;
        if (nameLength == 0) {
            return CharOperation.concatWith(array, separator);
        }
        if (array == null) {
            return name;
        }
        int length = array.length;
        if (length == 0) {
            return name;
        }
        int size = nameLength;
        int index = length;
        while (--index >= 0) {
            if (array[index].length <= 0) continue;
            size += array[index].length + 1;
        }
        char[] result = new char[size];
        index = size;
        int i = length - 1;
        while (i >= 0) {
            int subLength = array[i].length;
            if (subLength > 0) {
                System.arraycopy(array[i], 0, result, index -= subLength, subLength);
                result[--index] = separator;
            }
            --i;
        }
        System.arraycopy(name, 0, result, 0, nameLength);
        return result;
    }

    public static final char[] concatWith(char[][] array, char[] name, char separator) {
        int nameLength;
        int n = nameLength = name == null ? 0 : name.length;
        if (nameLength == 0) {
            return CharOperation.concatWith(array, separator);
        }
        if (array == null) {
            return name;
        }
        int length = array.length;
        if (length == 0) {
            return name;
        }
        int size = nameLength;
        int index = length;
        while (--index >= 0) {
            if (array[index].length <= 0) continue;
            size += array[index].length + 1;
        }
        char[] result = new char[size];
        index = 0;
        int i = 0;
        while (i < length) {
            int subLength = array[i].length;
            if (subLength > 0) {
                System.arraycopy(array[i], 0, result, index, subLength);
                index += subLength;
                result[index++] = separator;
            }
            ++i;
        }
        System.arraycopy(name, 0, result, index, nameLength);
        return result;
    }

    public static final char[] concatWith(char[][] array, char separator) {
        if (array == null) {
            return NO_CHAR;
        }
        int length = array.length;
        if (length == 0) {
            return NO_CHAR;
        }
        int size = length - 1;
        int index = length;
        while (--index >= 0) {
            if (array[index].length == 0) {
                --size;
                continue;
            }
            size += array[index].length;
        }
        if (size <= 0) {
            return NO_CHAR;
        }
        char[] result = new char[size];
        index = length;
        while (--index >= 0) {
            length = array[index].length;
            if (length <= 0) continue;
            System.arraycopy(array[index], 0, result, size -= length, length);
            if (--size < 0) continue;
            result[size] = separator;
        }
        return result;
    }

    public static final boolean contains(char character, char[][] array) {
        int i = array.length;
        while (--i >= 0) {
            char[] subarray = array[i];
            int j = subarray.length;
            while (--j >= 0) {
                if (subarray[j] != character) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean contains(char character, char[] array) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i] != character) continue;
            return true;
        }
        return false;
    }

    public static final char[][] deepCopy(char[][] toCopy) {
        int toCopyLength = toCopy.length;
        char[][] result = new char[toCopyLength][];
        int i = 0;
        while (i < toCopyLength) {
            char[] toElement = toCopy[i];
            int toElementLength = toElement.length;
            char[] resultElement = new char[toElementLength];
            System.arraycopy(toElement, 0, resultElement, 0, toElementLength);
            result[i] = resultElement;
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean endsWith(char[] array, char[] toBeFound) {
        i = toBeFound.length;
        j = array.length - i;
        if (j >= 0) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            if (toBeFound[i] == array[i + j]) continue;
            return false;
lbl7:
            // 2 sources

            ** while (--i >= 0)
        }
lbl8:
        // 1 sources

        return true;
    }

    public static final boolean equals(char[][] first, char[][] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (CharOperation.equals(first[i], second[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(char[][] first, char[][] second, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return CharOperation.equals(first, second);
        }
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (CharOperation.equals(first[i], second[i], false)) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(char[] first, char[] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(char[] first, char[] second, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return CharOperation.equals(first, second);
        }
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (Character.toLowerCase(first[i]) == Character.toLowerCase(second[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean fragmentEquals(char[] fragment, char[] name, int startIndex, boolean isCaseSensitive) {
        int max = fragment.length;
        if (name.length < max + startIndex) {
            return false;
        }
        if (isCaseSensitive) {
            int i = max;
            while (--i >= 0) {
                if (fragment[i] == name[i + startIndex]) continue;
                return false;
            }
            return true;
        }
        int i = max;
        while (--i >= 0) {
            if (Character.toLowerCase(fragment[i]) == Character.toLowerCase(name[i + startIndex])) continue;
            return false;
        }
        return true;
    }

    public static final int hashCode(char[] array) {
        int hash = 0;
        int offset = 0;
        int length = array.length;
        if (length < 16) {
            int i = length;
            while (i > 0) {
                hash = hash * 37 + array[offset++];
                --i;
            }
        } else {
            int skip = length / 8;
            int i = length;
            while (i > 0) {
                hash = hash * 39 + array[offset];
                i -= skip;
                offset += skip;
            }
        }
        return hash & Integer.MAX_VALUE;
    }

    public static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static final int indexOf(char toBeFound, char[] array) {
        int i = 0;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(char toBeFound, char[] array, int start) {
        int i = start;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int lastIndexOf(char toBeFound, char[] array) {
        int i = array.length;
        while (--i >= 0) {
            if (toBeFound != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static final int lastIndexOf(char toBeFound, char[] array, int startIndex) {
        int i = array.length;
        while (--i >= startIndex) {
            if (toBeFound != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static final int lastIndexOf(char toBeFound, char[] array, int startIndex, int endIndex) {
        int i = endIndex;
        while (--i >= startIndex) {
            if (toBeFound != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static final char[] lastSegment(char[] array, char separator) {
        int pos = CharOperation.lastIndexOf(separator, array);
        if (pos < 0) {
            return array;
        }
        return CharOperation.subarray(array, pos + 1, array.length);
    }

    public static final boolean match(char[] pattern, char[] name, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        return CharOperation.match(pattern, 0, pattern.length, name, 0, name.length, isCaseSensitive, true);
    }

    public static final boolean match(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd, boolean isCaseSensitive) {
        return CharOperation.match(pattern, patternStart, patternEnd, name, nameStart, nameEnd, isCaseSensitive, false);
    }

    public static final boolean match(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd, boolean isCaseSensitive, boolean allowEscaping) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        if (patternEnd < 0) {
            patternEnd = pattern.length;
        }
        if (nameEnd < 0) {
            nameEnd = name.length;
        }
        char patternChar = '\u0000';
        boolean isEscaped = false;
        while (iPattern < patternEnd && ((patternChar = pattern[iPattern]) != '*' || patternChar == '*' && isEscaped)) {
            if (allowEscaping && pattern[iPattern] == '\\' && !isEscaped) {
                ++iPattern;
                isEscaped = true;
                continue;
            }
            isEscaped = false;
            if (iName == nameEnd) {
                return false;
            }
            if (patternChar != (isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) && patternChar != '?') {
                return false;
            }
            ++iName;
            ++iPattern;
            patternChar = '\u0000';
        }
        int segmentStart = patternChar == '*' ? ++iPattern : 0;
        int prefixStart = iName;
        while (iName < nameEnd) {
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            patternChar = pattern[iPattern];
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    return true;
                }
                prefixStart = iName;
                continue;
            }
            if ((isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) != patternChar && patternChar != '?') {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            ++iName;
            ++iPattern;
        }
        return segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern[iPattern] == '*';
    }

    public static final boolean pathMatch(char[] pattern, char[] filepath, boolean isCaseSensitive, char pathSeparator) {
        int pSegmentRestart;
        if (filepath == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int pLength = pattern.length;
        boolean freeLeadingDoubleStar = pattern[0] != pathSeparator;
        int pSegmentStart = freeLeadingDoubleStar ? 0 : 1;
        int pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart + 1);
        if (pSegmentEnd < 0) {
            pSegmentEnd = pLength;
        }
        boolean freeTrailingDoubleStar = pattern[pLength - 1] == pathSeparator;
        int fLength = filepath.length;
        int fSegmentStart = filepath[0] != pathSeparator ? 0 : 1;
        if (fSegmentStart != pSegmentStart) {
            return false;
        }
        int fSegmentEnd = CharOperation.indexOf(pathSeparator, filepath, fSegmentStart + 1);
        if (fSegmentEnd < 0) {
            fSegmentEnd = fLength;
        }
        while (!(pSegmentStart >= pLength || freeLeadingDoubleStar || pSegmentEnd == pLength && freeTrailingDoubleStar || pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*')) {
            if (fSegmentStart >= fLength) {
                return false;
            }
            if (!CharOperation.match(pattern, pSegmentStart, pSegmentEnd, filepath, fSegmentStart, fSegmentEnd, isCaseSensitive)) {
                return false;
            }
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            if ((fSegmentEnd = CharOperation.indexOf(pathSeparator, filepath, fSegmentStart = fSegmentEnd + 1)) >= 0) continue;
            fSegmentEnd = fLength;
        }
        if (pSegmentStart >= pLength && freeTrailingDoubleStar || pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*') {
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            pSegmentRestart = pSegmentStart;
        } else {
            if (pSegmentStart >= pLength) {
                return fSegmentStart >= fLength;
            }
            pSegmentRestart = 0;
        }
        int fSegmentRestart = fSegmentStart;
        while (fSegmentStart < fLength) {
            if (pSegmentStart >= pLength) {
                if (freeTrailingDoubleStar) {
                    return true;
                }
                pSegmentStart = pSegmentRestart;
                pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart);
                if (pSegmentEnd < 0) {
                    pSegmentEnd = pLength;
                }
                if ((fSegmentRestart = CharOperation.indexOf(pathSeparator, filepath, fSegmentRestart + 1)) < 0) {
                    fSegmentRestart = fLength;
                }
                fSegmentStart = ++fSegmentRestart;
                fSegmentEnd = CharOperation.indexOf(pathSeparator, filepath, fSegmentStart);
                if (fSegmentEnd >= 0) continue;
                fSegmentEnd = fLength;
                continue;
            }
            if (pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*') {
                pSegmentStart = pSegmentEnd + 1;
                if ((pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                    pSegmentEnd = pLength;
                }
                pSegmentRestart = pSegmentStart;
                fSegmentRestart = fSegmentStart;
                if (pSegmentStart < pLength) continue;
                return true;
            }
            if (!CharOperation.match(pattern, pSegmentStart, pSegmentEnd, filepath, fSegmentStart, fSegmentEnd, isCaseSensitive)) {
                pSegmentStart = pSegmentRestart;
                pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart);
                if (pSegmentEnd < 0) {
                    pSegmentEnd = pLength;
                }
                if ((fSegmentRestart = CharOperation.indexOf(pathSeparator, filepath, fSegmentRestart + 1)) < 0) {
                    fSegmentRestart = fLength;
                }
                fSegmentStart = ++fSegmentRestart;
                fSegmentEnd = CharOperation.indexOf(pathSeparator, filepath, fSegmentStart);
                if (fSegmentEnd >= 0) continue;
                fSegmentEnd = fLength;
                continue;
            }
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            if ((fSegmentEnd = CharOperation.indexOf(pathSeparator, filepath, fSegmentStart = fSegmentEnd + 1)) >= 0) continue;
            fSegmentEnd = fLength;
        }
        return pSegmentRestart >= pSegmentEnd || fSegmentStart >= fLength && pSegmentStart >= pLength || pSegmentStart == pLength - 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*' || pSegmentStart == pLength && freeTrailingDoubleStar;
    }

    public static final int occurencesOf(char toBeFound, char[] array) {
        int count = 0;
        char[] cArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (toBeFound == element) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static final int occurencesOf(char toBeFound, char[] array, int start) {
        int count = 0;
        int i = start;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static final boolean prefixEquals(char[] prefix, char[] name) {
        int max = prefix.length;
        if (name.length < max) {
            return false;
        }
        int i = max;
        while (--i >= 0) {
            if (prefix[i] == name[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean prefixEquals(char[] prefix, char[] name, boolean isCaseSensitive) {
        int max = prefix.length;
        if (name.length < max) {
            return false;
        }
        if (isCaseSensitive) {
            int i = max;
            while (--i >= 0) {
                if (prefix[i] == name[i]) continue;
                return false;
            }
            return true;
        }
        int i = max;
        while (--i >= 0) {
            if (Character.toLowerCase(prefix[i]) == Character.toLowerCase(name[i])) continue;
            return false;
        }
        return true;
    }

    public static final void replace(char[] array, char toBeReplaced, char replacementChar) {
        if (toBeReplaced != replacementChar) {
            int i = 0;
            int max = array.length;
            while (i < max) {
                if (array[i] == toBeReplaced) {
                    array[i] = replacementChar;
                }
                ++i;
            }
        }
    }

    public static final char[] replace(char[] array, char[] toBeReplaced, char[] replacementChars) {
        int max = array.length;
        int replacedLength = toBeReplaced.length;
        int replacementLength = replacementChars.length;
        int[] starts = new int[5];
        int occurrenceCount = 0;
        if (!CharOperation.equals(toBeReplaced, replacementChars)) {
            int i = 0;
            while (i < max) {
                block7: {
                    int j = 0;
                    while (j < replacedLength) {
                        if (i + j != max && array[i + j] == toBeReplaced[j++]) {
                            continue;
                        }
                        break block7;
                    }
                    if (occurrenceCount == starts.length) {
                        int[] nArray = starts;
                        starts = new int[occurrenceCount * 2];
                        System.arraycopy(nArray, 0, starts, 0, occurrenceCount);
                    }
                    starts[occurrenceCount++] = i;
                }
                ++i;
            }
        }
        if (occurrenceCount == 0) {
            return array;
        }
        char[] result = new char[max + occurrenceCount * (replacementLength - replacedLength)];
        int inStart = 0;
        int outStart = 0;
        int i = 0;
        while (i < occurrenceCount) {
            int offset = starts[i] - inStart;
            System.arraycopy(array, inStart, result, outStart, offset);
            inStart += offset;
            System.arraycopy(replacementChars, 0, result, outStart += offset, replacementLength);
            inStart += replacedLength;
            outStart += replacementLength;
            ++i;
        }
        System.arraycopy(array, inStart, result, outStart, max - inStart);
        return result;
    }

    public static final char[][] splitAndTrimOn(char divider, char[] array) {
        if (array == null) {
            return NO_CHAR_CHAR;
        }
        int length = array.length;
        if (length == 0) {
            return NO_CHAR_CHAR;
        }
        int wordCount = 1;
        int i = 0;
        while (i < length) {
            if (array[i] == divider) {
                ++wordCount;
            }
            ++i;
        }
        char[][] split = new char[wordCount][];
        int last = 0;
        int currentWord = 0;
        int i2 = 0;
        while (i2 < length) {
            if (array[i2] == divider) {
                int start = last;
                int end = i2 - 1;
                while (start < i2 && array[start] == ' ') {
                    ++start;
                }
                while (end > start && array[end] == ' ') {
                    --end;
                }
                split[currentWord] = new char[end - start + 1];
                System.arraycopy(array, start, split[currentWord++], 0, end - start + 1);
                last = i2 + 1;
            }
            ++i2;
        }
        int start = last;
        int end = length - 1;
        while (start < length && array[start] == ' ') {
            ++start;
        }
        while (end > start && array[end] == ' ') {
            --end;
        }
        split[currentWord] = new char[end - start + 1];
        System.arraycopy(array, start, split[currentWord++], 0, end - start + 1);
        return split;
    }

    public static final char[][] splitOn(char divider, char[] array) {
        if (array == null) {
            return NO_CHAR_CHAR;
        }
        int length = array.length;
        if (length == 0) {
            return NO_CHAR_CHAR;
        }
        int wordCount = 1;
        int i = 0;
        while (i < length) {
            if (array[i] == divider) {
                ++wordCount;
            }
            ++i;
        }
        char[][] split = new char[wordCount][];
        int last = 0;
        int currentWord = 0;
        int i2 = 0;
        while (i2 < length) {
            if (array[i2] == divider) {
                split[currentWord] = new char[i2 - last];
                System.arraycopy(array, last, split[currentWord++], 0, i2 - last);
                last = i2 + 1;
            }
            ++i2;
        }
        split[currentWord] = new char[length - last];
        System.arraycopy(array, last, split[currentWord], 0, length - last);
        return split;
    }

    public static final char[][] splitOn(char divider, char[] array, int start, int end) {
        if (array == null) {
            return NO_CHAR_CHAR;
        }
        int length = array.length;
        if (length == 0 || start > end) {
            return NO_CHAR_CHAR;
        }
        int wordCount = 1;
        int i = start;
        while (i < end) {
            if (array[i] == divider) {
                ++wordCount;
            }
            ++i;
        }
        char[][] split = new char[wordCount][];
        int last = start;
        int currentWord = 0;
        int i2 = start;
        while (i2 < end) {
            if (array[i2] == divider) {
                split[currentWord] = new char[i2 - last];
                System.arraycopy(array, last, split[currentWord++], 0, i2 - last);
                last = i2 + 1;
            }
            ++i2;
        }
        split[currentWord] = new char[end - last];
        System.arraycopy(array, last, split[currentWord], 0, end - last);
        return split;
    }

    public static final char[][] subarray(char[][] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[][] result = new char[end - start][];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final char[] subarray(char[] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[] result = new char[end - start];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final char[] toLowerCase(char[] chars) {
        if (chars == null) {
            return null;
        }
        int length = chars.length;
        char[] lowerChars = null;
        int i = 0;
        while (i < length) {
            char c = chars[i];
            char lc = Character.toLowerCase(c);
            if (c != lc || lowerChars != null) {
                if (lowerChars == null) {
                    lowerChars = new char[length];
                    System.arraycopy(chars, 0, lowerChars, 0, i);
                }
                lowerChars[i] = lc;
            }
            ++i;
        }
        return lowerChars == null ? chars : lowerChars;
    }

    public static final char[] trim(char[] chars) {
        if (chars == null) {
            return null;
        }
        int start = 0;
        int length = chars.length;
        int end = length - 1;
        while (start < length && chars[start] == ' ') {
            ++start;
        }
        while (end > start && chars[end] == ' ') {
            --end;
        }
        if (start != 0 || end != length - 1) {
            return CharOperation.subarray(chars, start, end + 1);
        }
        return chars;
    }

    public static final String toString(char[][] array) {
        char[] result = CharOperation.concatWith(array, '.');
        return new String(result);
    }
}

