/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.wizards.UpdateMakeProjectWizard;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class UpdateMakeProjectAction
implements IWorkbenchWindowActionDelegate {
    private ISelection fSelection;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            ArrayList<IProject> projects = new ArrayList<IProject>(elems.length);
            int i = 0;
            while (i < elems.length) {
                Object elem = elems[i];
                IProject project = null;
                if (elem instanceof IFile) {
                    IFile file = (IFile)elem;
                    project = file.getProject();
                } else if (elem instanceof IProject) {
                    project = (IProject)elem;
                } else if (elem instanceof ICProject) {
                    project = ((ICProject)elem).getProject();
                }
                if (project != null) {
                    projects.add(project);
                }
                ++i;
            }
            IProject[] projectArray = projects.toArray(new IProject[projects.size()]);
            UpdateMakeProjectWizard wizard = new UpdateMakeProjectWizard(projectArray);
            WizardDialog dialog = new WizardDialog(MakeUIPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public static IProject[] getOldProjects() {
        IProject[] project = MakeUIPlugin.getWorkspace().getRoot().getProjects();
        Vector<IProject> result = new Vector<IProject>();
        try {
            int i = 0;
            while (i < project.length) {
                if (UpdateMakeProjectAction.isOldProject(project[i])) {
                    result.add(project[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.logException(e);
        }
        return result.toArray(new IProject[result.size()]);
    }

    protected static boolean isOldProject(IProject project) throws CoreException {
        if (project.isAccessible()) {
            IProjectDescription desc = project.getDescription();
            ICommand[] builder = desc.getBuildSpec();
            int j = 0;
            while (j < builder.length) {
                if (builder[j].getBuilderName().equals("org.eclipse.cdt.core.cbuilder")) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public static void run(boolean fork, IRunnableContext context, final IProject[] projects) {
        try {
            context.run(fork, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                UpdateMakeProjectAction.doProjectUpdate(monitor, projects);
                            }
                        };
                        MakeUIPlugin.getWorkspace().run(runnable, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            MakeUIPlugin.logException(e, MakeUIPlugin.getResourceString("UpdateMakeProjectAction.exception.error"), MakeUIPlugin.getResourceString("UpdateMakeProjectAction.eception.message"));
        }
    }

    protected static void doProjectUpdate(IProgressMonitor monitor, IProject[] project) throws CoreException {
        monitor.beginTask(MakeUIPlugin.getResourceString("UpdateMakeProjectAction.monitor.update"), project.length * 4);
        try {
            int i = 0;
            while (i < project.length) {
                project[i].refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                MakeProjectNature.removeFromBuildSpec((IProject)project[i], (String)"org.eclipse.cdt.core.cbuilder", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                CCorePlugin.getDefault().mapCProjectOwner(project[i], MakeCorePlugin.MAKE_PROJECT_ID, true);
                MakeProjectNature.addNature((IProject)project[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IMakeBuilderInfo newInfo = MakeCorePlugin.createBuildInfo((IProject)project[i], (String)MakeBuilder.BUILDER_ID);
                QualifiedName[] qName = new QualifiedName[]{new QualifiedName("org.eclipse.cdt.core", "buildLocation"), new QualifiedName("org.eclipse.cdt.core", "buildFullArguments"), new QualifiedName("org.eclipse.cdt.core", "buildIncrementalArguments"), new QualifiedName("org.eclipse.cdt.core", "stopOnError"), new QualifiedName("org.eclipse.cdt.core", "useDefaultBuildCmd")};
                String property = project[i].getPersistentProperty(qName[0]);
                if (property != null) {
                    newInfo.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, property);
                }
                if ((property = project[i].getPersistentProperty(qName[1])) != null) {
                    newInfo.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, property);
                }
                if ((property = project[i].getPersistentProperty(qName[3])) != null) {
                    newInfo.setStopOnError(Boolean.valueOf(property).booleanValue());
                }
                if ((property = project[i].getPersistentProperty(qName[4])) != null) {
                    newInfo.setUseDefaultBuildCmd(Boolean.valueOf(property).booleanValue());
                }
                int j = 0;
                while (j < qName.length) {
                    project[i].setPersistentProperty(qName[j], null);
                    ++j;
                }
                SubProgressMonitor subMon = new SubProgressMonitor(monitor, 1, 4);
                project[i].accept((IResourceProxyVisitor)new TargetConvertVisitor((IProgressMonitor)subMon), 0);
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object sel;
        boolean enabled = false;
        this.fSelection = selection;
        if (this.fSelection instanceof IStructuredSelection && (sel = ((IStructuredSelection)this.fSelection).getFirstElement()) instanceof IAdaptable) {
            IResource res = (IResource)((IAdaptable)sel).getAdapter(IResource.class);
            try {
                if (res instanceof IProject && UpdateMakeProjectAction.isOldProject((IProject)res)) {
                    enabled = true;
                }
            }
            catch (CoreException coreException) {}
        }
        action.setEnabled(enabled);
    }

    public static class TargetConvertVisitor
    implements IResourceProxyVisitor {
        private final int TOTAL_WORK = 100;
        private int halfWay = 50;
        private int currentIncrement;
        private int nextProgress = this.currentIncrement = 4;
        private int worked = 0;
        IProgressMonitor monitor;

        public TargetConvertVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
            monitor.beginTask(MakeUIPlugin.getResourceString("UpdateMakeProjectAction.monitor.convert"), 100);
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            try {
                if (proxy.getType() != 2 && proxy.getType() != 4) {
                    return false;
                }
                IContainer container = (IContainer)proxy.requestResource();
                this.monitor.subTask(container.getProjectRelativePath().toString());
                QualifiedName qName = new QualifiedName("org.eclipse.cdt.make", "goals");
                String goal = container.getPersistentProperty(qName);
                if (goal != null) {
                    goal = goal.trim();
                    IMakeTargetManager manager = MakeCorePlugin.getDefault().getTargetManager();
                    String[] builder = manager.getTargetBuilders(container.getProject());
                    IMakeTarget target = manager.createTarget(container.getProject(), goal, builder[0]);
                    target.setBuildAttribute(IMakeTarget.BUILD_TARGET, goal);
                    manager.addTarget(container, target);
                    container.setPersistentProperty(qName, null);
                }
                return true;
            }
            finally {
                if (--this.nextProgress <= 0) {
                    this.monitor.worked(1);
                    ++this.worked;
                    if (this.worked >= this.halfWay) {
                        this.currentIncrement *= 2;
                        this.halfWay += (100 - this.halfWay) / 2;
                    }
                    this.nextProgress = this.currentIncrement;
                }
            }
        }
    }
}

