/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.cdt.internal.autotools.ui.wizards.AutotoolsBuildWizardHandler;
import org.eclipse.cdt.internal.autotools.ui.wizards.AutotoolsWizardMessages;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyManager;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildListComparator;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.AbstractCWizard;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.jface.wizard.IWizard;

public class AutotoolsBuildWizard
extends AbstractCWizard {
    public static final String OTHERS_LABEL = AutotoolsWizardMessages.getResourceString("AutotoolsBuildWizard.1");
    public static final String AUTOTOOLS_PROJECTTYPE_ID = "org.eclipse.linuxtools.cdt.autotools.core.projectType";
    public static final String EMPTY_PROJECT = AutotoolsWizardMessages.getResourceString("AutotoolsBuildWizard.2");
    public static final String AUTOTOOLS_TOOLCHAIN_ID = "org.eclipse.linuxtools.cdt.autotools.core.toolChain";

    public EntryDescriptor[] createItems(boolean supportedOnly, IWizard wizard) {
        IBuildPropertyManager bpm = ManagedBuildManager.getBuildPropertyManager();
        IBuildPropertyType bpt = bpm.getPropertyType("org.eclipse.cdt.build.core.buildArtefactType");
        IBuildPropertyValue[] vs = bpt.getSupportedValues();
        Arrays.sort(vs, BuildListComparator.getInstance());
        ArrayList<EntryDescriptor> items = new ArrayList<EntryDescriptor>();
        EntryDescriptor oldsRoot = null;
        SortedMap sm = ManagedBuildManager.getExtensionProjectTypeMap();
        for (Map.Entry e : sm.entrySet()) {
            IProjectType pt = (IProjectType)e.getValue();
            AutotoolsBuildWizardHandler h = new AutotoolsBuildWizardHandler(pt, this.parent, wizard);
            IToolChain[] tcs = ManagedBuildManager.getExtensionToolChains((IProjectType)pt);
            int i = 0;
            while (i < tcs.length) {
                IToolChain t;
                IToolChain parent = t = tcs[i];
                while (parent.getSuperClass() != null) {
                    parent = parent.getSuperClass();
                }
                if (parent.getId().equals(AUTOTOOLS_TOOLCHAIN_ID) && !t.isSystemObject() && this.isValid(t, supportedOnly, wizard)) {
                    h.addTc(t);
                }
                ++i;
            }
            String pId = null;
            if (CDTPrefUtil.getBool((String)"wizard.group.others.enable")) {
                if (oldsRoot == null) {
                    oldsRoot = new EntryDescriptor(OTHERS_LABEL, null, OTHERS_LABEL, true, null, null);
                    items.add(oldsRoot);
                }
                pId = oldsRoot.getId();
            } else {
                pId = null;
            }
            if (h.getToolChainsCount() <= 0) continue;
            items.add(new EntryDescriptor(pt.getId(), pId, pt.getName(), true, (CWizardHandler)h, null));
        }
        return items.toArray(new EntryDescriptor[items.size()]);
    }
}

