/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.util;

import java.util.concurrent.Callable;

public class RunnableWithResult<V>
implements Runnable,
Callable<V> {
    protected V m_result = null;
    protected boolean m_done = false;

    public void dispose() {
        this.m_result = null;
    }

    public void setResult(V result) {
        this.m_result = result;
    }

    public V getResult() {
        return this.m_result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_done = false;
        this.setResult(this.call());
        this.m_done = true;
        RunnableWithResult runnableWithResult = this;
        synchronized (runnableWithResult) {
            this.notifyAll();
        }
    }

    @Override
    public V call() {
        return null;
    }

    public V waitForResult() {
        return this.waitForResult(0L, null);
    }

    public V waitForResult(long timeout) {
        return this.waitForResult(timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V waitForResult(long timeout, V defaultValue) {
        V result = defaultValue;
        try {
            if (timeout == 0L) {
                while (!this.m_done) {
                    RunnableWithResult runnableWithResult = this;
                    synchronized (runnableWithResult) {
                        this.wait(0L);
                    }
                }
            } else {
                long then = RunnableWithResult.now();
                long waitstep = timeout / 10L;
                if (waitstep == 0L) {
                    waitstep = 1L;
                }
                do {
                    RunnableWithResult runnableWithResult = this;
                    synchronized (runnableWithResult) {
                        this.wait(waitstep);
                    }
                } while (!this.m_done && RunnableWithResult.now() - then < timeout);
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.m_done) {
            result = this.getResult();
        }
        return result;
    }

    protected static long now() {
        return System.currentTimeMillis();
    }
}

