/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.util;

import java.util.ArrayList;

public abstract class ListenerList {
    protected Object m_owner = null;
    protected String m_label = null;
    protected ArrayList<Object> m_listeners = null;

    public ListenerList(Object owner, String label) {
        this.m_owner = owner;
        this.m_label = label;
    }

    public void dispose() {
        this.m_owner = null;
        this.m_label = null;
        if (this.m_listeners != null) {
            this.clear();
            this.m_listeners = null;
        }
    }

    public synchronized void clear() {
        if (this.m_listeners != null) {
            this.m_listeners.clear();
        }
    }

    public synchronized int size() {
        return this.m_listeners == null ? 0 : this.m_listeners.size();
    }

    public synchronized void addListener(Object listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public synchronized void removeListener(Object listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raise(Object event) {
        ArrayList<Object> listeners = null;
        ListenerList listenerList = this;
        synchronized (listenerList) {
            if (this.m_listeners != null) {
                listeners = new ArrayList<Object>(this.m_listeners);
            }
        }
        int count = listeners == null ? 0 : listeners.size();
        int i = 0;
        while (i < count) {
            Object listener = listeners.get(i);
            try {
                this.raise(listener, event);
            }
            catch (Throwable throwable) {}
            ++i;
        }
    }

    protected abstract void raise(Object var1, Object var2);
}

