/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemorySpaceManagement;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddWatchpointDialog
extends Dialog
implements ModifyListener,
SelectionListener {
    private Combo fExpressionInput;
    private String fExpression;
    private static List<String> sExpressionHistory = new ArrayList<String>();
    private boolean fHasMemorySpaceControls;
    private Button fMemorySpaceEnableButton;
    private Combo fMemorySpaceInput;
    private String fMemorySpace;
    private boolean fRangeInitialEnable;
    private Button fRangeEnableButton;
    private Text fRangeField;
    private String fRange = "";
    private Button fChkBtnWrite;
    private Button fChkBtnRead;
    private boolean fRead;
    private boolean fWrite;
    private ICDIMemorySpaceManagement fMemManagement;

    public AddWatchpointDialog(Shell parentShell, ICDIMemorySpaceManagement memMgmt) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMemManagement = memMgmt;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        Composite composite = new Composite(parent, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        parent = composite;
        this.createExpressionControl(parent);
        boolean hasDebugContext = DebugUITools.getDebugContext() != null;
        boolean hasMemorySpaces = hasDebugContext && this.fMemManagement != null && this.fMemManagement.getMemorySpaces() != null && this.fMemManagement.getMemorySpaces().length > 0;
        boolean bl = this.fHasMemorySpaceControls = !hasDebugContext || hasMemorySpaces;
        if (this.fHasMemorySpaceControls) {
            this.createMemorySpaceControl(parent, hasMemorySpaces);
        }
        this.createCountField(parent);
        this.createAccessWidgets(parent);
        if (this.fExpression != null && this.fExpression.length() > 0) {
            this.fExpressionInput.add(this.fExpression, 0);
            this.fExpressionInput.select(0);
        }
        this.fExpressionInput.setFocus();
        if (this.fHasMemorySpaceControls) {
            this.fMemorySpaceInput.setEnabled(this.fMemorySpaceEnableButton.getEnabled());
        }
        this.fRangeField.setEnabled(this.fRangeEnableButton.getEnabled());
        this.updateUI();
        return parent;
    }

    private void createExpressionControl(Composite parent) {
        Label l = new Label(parent, 768);
        l.setText(ActionMessages.getString("AddWatchpointDialog.1"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        l.setLayoutData((Object)gridData);
        this.fExpressionInput = new Combo(parent, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fExpressionInput.setLayoutData((Object)gridData);
        this.fExpressionInput.addModifyListener((ModifyListener)this);
        for (String expression : sExpressionHistory) {
            this.fExpressionInput.add(expression);
        }
    }

    private void createMemorySpaceControl(Composite parent, boolean hasMemorySpaces) {
        this.fMemorySpaceEnableButton = new Button(parent, 32);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fMemorySpaceEnableButton.setLayoutData((Object)gridData);
        this.fMemorySpaceEnableButton.setText(ActionMessages.getString("AddWatchpointDialog.5"));
        this.fMemorySpaceEnableButton.setSelection(false);
        this.fMemorySpaceEnableButton.addSelectionListener((SelectionListener)this);
        this.fMemorySpaceInput = hasMemorySpaces ? new Combo(parent, 2056) : new Combo(parent, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fMemorySpaceInput.setLayoutData((Object)gridData);
        this.fMemorySpaceInput.addSelectionListener((SelectionListener)this);
        if (this.fMemManagement != null) {
            String[] memorySpaces = this.fMemManagement.getMemorySpaces();
            int i = 0;
            while (i < memorySpaces.length) {
                this.fMemorySpaceInput.add(memorySpaces[i]);
                ++i;
            }
        }
        if (this.fMemorySpace != null && this.fMemorySpace.length() > 0) {
            int i = this.fMemorySpaceInput.indexOf(this.fMemorySpace);
            if (i >= 0) {
                this.fMemorySpaceInput.select(i);
                this.fMemorySpaceEnableButton.setSelection(true);
            } else {
                this.fMemorySpaceInput.add(this.fMemorySpace);
            }
        }
        this.fMemorySpaceInput.addModifyListener((ModifyListener)this);
        this.fMemorySpaceInput.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ActionMessages.getString("AddWatchpointDialog.5");
            }
        });
    }

    private static boolean verifyIntegerTextAddition(String text, char c) {
        if (Character.isISOControl(c)) {
            return true;
        }
        c = Character.toLowerCase(c);
        if ((text = text.toLowerCase()).length() == 0) {
            return Character.isDigit(c);
        }
        if (text.length() == 1) {
            if (text.equals("0")) {
                return c == 'x';
            }
            return Character.isDigit(c);
        }
        return Character.isDigit(c) || text.startsWith("0x") && 'a' <= c && c <= 'f';
    }

    private static boolean verifyIntegerText(String text) {
        if (text.length() == 0) {
            return false;
        }
        if (text.length() == 1) {
            return true;
        }
        if (text.length() == 2) {
            return !text.equals("0x");
        }
        return true;
    }

    private void createCountField(Composite parent) {
        this.fRangeEnableButton = new Button(parent, 32);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fRangeEnableButton.setLayoutData((Object)gridData);
        this.fRangeEnableButton.setText(ActionMessages.getString("AddWatchpointDialog.6"));
        this.fRangeEnableButton.setSelection(this.fRangeInitialEnable && this.fRange.length() > 0);
        this.fRangeEnableButton.addSelectionListener((SelectionListener)this);
        this.fRangeField = new Text(parent, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        GC gc = new GC((Drawable)this.fRangeField);
        FontMetrics fm = gc.getFontMetrics();
        gridData.minimumWidth = 8 * fm.getAverageCharWidth();
        this.fRangeField.setLayoutData((Object)gridData);
        this.fRangeField.setText(this.fRange);
        this.fRangeField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = AddWatchpointDialog.verifyIntegerTextAddition(AddWatchpointDialog.this.fRangeField.getText(), e.character);
            }
        });
        this.fRangeField.addModifyListener((ModifyListener)this);
        this.fRangeField.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ActionMessages.getString("AddWatchpointDialog.6");
            }
        });
    }

    private void createAccessWidgets(Composite parent) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)gridData);
        group.setText(ActionMessages.getString("AddWatchpointDialog.2"));
        this.fChkBtnWrite = new Button((Composite)group, 32);
        this.fChkBtnWrite.setText(ActionMessages.getString("AddWatchpointDialog.3"));
        this.fChkBtnWrite.setSelection(true);
        this.fChkBtnWrite.addSelectionListener((SelectionListener)this);
        this.fChkBtnRead = new Button((Composite)group, 32);
        this.fChkBtnRead.setText(ActionMessages.getString("AddWatchpointDialog.4"));
        this.fChkBtnRead.setSelection(false);
        this.fChkBtnRead.addSelectionListener((SelectionListener)this);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ActionMessages.getString("AddWatchpointDialog.0"));
    }

    protected void okPressed() {
        this.fExpression = this.fExpressionInput.getText().trim();
        if (this.fExpression.length() > 0) {
            AddWatchpointDialog.addHistory(this.fExpression);
        }
        if (this.fHasMemorySpaceControls) {
            this.fMemorySpace = this.fMemorySpaceEnableButton.getSelection() ? this.fMemorySpaceInput.getText().trim() : "";
        }
        this.fRange = this.fRangeEnableButton.getSelection() ? this.fRangeField.getText().trim() : "0";
        this.fRead = this.fChkBtnRead.getSelection();
        this.fWrite = this.fChkBtnWrite.getSelection();
        super.okPressed();
    }

    public void modifyText(ModifyEvent e) {
        this.updateUI();
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    public String getExpression() {
        return this.fExpression;
    }

    public String getMemorySpace() {
        return this.fMemorySpace;
    }

    private static void addHistory(String item) {
        if (!sExpressionHistory.contains(item)) {
            sExpressionHistory.add(0, item);
            if (sExpressionHistory.size() > 5) {
                sExpressionHistory.remove(sExpressionHistory.size() - 1);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateUI();
    }

    private void updateUI() {
        if (this.fHasMemorySpaceControls) {
            this.fMemorySpaceInput.setEnabled(this.fMemorySpaceEnableButton.getSelection());
        }
        this.fRangeField.setEnabled(this.fRangeEnableButton.getSelection());
        Button b = this.getButton(0);
        if (b == null) {
            return;
        }
        b.setEnabled(this.okayEnabled());
    }

    private boolean okayEnabled() {
        if (!this.fChkBtnRead.getSelection() && !this.fChkBtnWrite.getSelection()) {
            return false;
        }
        if (this.fExpressionInput.getText().length() == 0) {
            return false;
        }
        if (this.fHasMemorySpaceControls && this.fMemorySpaceInput.getEnabled() && this.fMemorySpaceInput.getText().length() == 0) {
            return false;
        }
        return !this.fRangeField.getEnabled() || this.fRangeField.getText().length() != 0 && AddWatchpointDialog.verifyIntegerText(this.fRangeField.getText());
    }

    public boolean getWriteAccess() {
        return this.fWrite;
    }

    public boolean getReadAccess() {
        return this.fRead;
    }

    public void setExpression(String expressionString) {
        this.fExpression = expressionString;
    }

    public BigInteger getRange() {
        return BigInteger.valueOf(Long.decode(this.fRange));
    }

    public void initializeRange(boolean enable, String range) {
        this.fRangeInitialEnable = enable;
        this.fRange = range;
    }

    public void initializeMemorySpace(String memorySpace) {
        this.fMemorySpace = memorySpace;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true).setEnabled(this.okayEnabled());
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

