/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.qt.core.index.IQMethod;

public class QtASTClass {
    private final Iterator<Region> regions;
    private final Iterator<Tag> tags;
    private final Iterator<Revision> revisions;
    private Region region;
    private Tag tag;
    private Revision revision;

    public IQMethod.Kind getKindFor(int offset) {
        IQMethod.Kind kind = IQMethod.Kind.Unspecified;
        while (this.tag != null && this.tag.offset < offset) {
            kind = QtASTClass.getHigherPrecedence(kind, this.tag.kind);
            Tag tag = this.tag = this.tags.hasNext() ? this.tags.next() : null;
        }
        while (this.region != null && this.region.end < offset) {
            Region region = this.region = this.regions.hasNext() ? this.regions.next() : null;
        }
        if (this.region != null && this.region.contains(offset)) {
            kind = this.region.kind;
        }
        return kind;
    }

    public Long getRevisionFor(int offset) {
        Long rev = null;
        while (this.revision != null && this.revision.offset < offset) {
            rev = this.revision.revision;
            Revision revision = this.revision = this.revisions.hasNext() ? this.revisions.next() : null;
        }
        return rev;
    }

    private static IQMethod.Kind getHigherPrecedence(IQMethod.Kind kind1, IQMethod.Kind kind2) {
        switch (kind1) {
            case Unspecified: {
                return kind2;
            }
            case Invokable: {
                switch (kind2) {
                    case Signal: 
                    case Slot: {
                        return kind2;
                    }
                }
                return kind1;
            }
            case Signal: {
                if (kind2 == IQMethod.Kind.Slot) {
                    return kind2;
                }
                return kind2;
            }
            case Slot: {
                return kind1;
            }
        }
        return IQMethod.Kind.Unspecified;
    }

    public static QtASTClass create(ICPPASTCompositeTypeSpecifier spec) {
        Iterator iterator;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ArrayList<Revision> revisions = new ArrayList<Revision>();
        ArrayList<Region> regions = new ArrayList<Region>();
        Region currRegion = null;
        IASTNodeLocation[] iASTNodeLocationArray = spec.getNodeLocations();
        int n = iASTNodeLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Region region;
            Revision revision;
            IASTNodeLocation location = iASTNodeLocationArray[n2];
            Tag tag = Tag.create(location);
            if (tag != null) {
                tags.add(tag);
            }
            if ((revision = Revision.create(location)) != null) {
                revisions.add(revision);
            }
            if ((region = Region.create(location)) != null) {
                if (currRegion != null) {
                    currRegion.end = region.begin;
                }
                currRegion = region;
                regions.add(region);
            }
            ++n2;
        }
        if (!regions.isEmpty()) {
            iterator = regions.iterator();
            Region region = (Region)iterator.next();
            IASTDeclaration[] iASTDeclarationArray = spec.getMembers();
            int n3 = iASTDeclarationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IASTDeclaration decl = iASTDeclarationArray[n4];
                if (decl instanceof ICPPASTVisibilityLabel) {
                    int offset = decl.getFileLocation().getNodeOffset();
                    while (region != null && region.begin < offset) {
                        region.end = offset;
                        Region region2 = region = iterator.hasNext() ? (Region)iterator.next() : null;
                    }
                    if (region == null) break;
                }
                ++n4;
            }
        }
        if (!tags.isEmpty()) {
            iterator = tags.iterator();
            Tag tag = (Tag)iterator.next();
            for (Region region : regions) {
                while (tag != null && tag.offset < region.begin) {
                    Tag tag2 = tag = iterator.hasNext() ? (Tag)iterator.next() : null;
                }
                while (tag != null && region.contains(tag.offset)) {
                    iterator.remove();
                    Tag tag3 = tag = iterator.hasNext() ? (Tag)iterator.next() : null;
                }
                if (tag == null) break;
            }
        }
        return new QtASTClass(regions, tags, revisions);
    }

    private QtASTClass(List<Region> regions, List<Tag> tags, List<Revision> revisions) {
        this.regions = regions.iterator();
        this.tags = tags.iterator();
        this.revisions = revisions.iterator();
        this.region = this.regions.hasNext() ? this.regions.next() : null;
        this.tag = this.tags.hasNext() ? this.tags.next() : null;
        this.revision = this.revisions.hasNext() ? this.revisions.next() : null;
    }

    private static String getMacroName(IASTPreprocessorMacroExpansion expansion) {
        if (expansion == null) {
            return null;
        }
        IASTName name = expansion.getMacroReference();
        return name == null ? null : name.toString();
    }

    private static class Region {
        public final int begin;
        public int end = Integer.MAX_VALUE;
        public final IQMethod.Kind kind;

        public Region(int begin, IQMethod.Kind kind) {
            this.begin = begin;
            this.kind = kind;
        }

        public boolean contains(int offset) {
            return offset >= this.begin && offset < this.end;
        }

        public static Region create(IASTNodeLocation location) {
            if (!(location instanceof IASTMacroExpansionLocation)) {
                return null;
            }
            IASTMacroExpansionLocation macroLocation = (IASTMacroExpansionLocation)location;
            IASTFileLocation fileLocation = macroLocation.asFileLocation();
            if (fileLocation == null) {
                return null;
            }
            int offset = fileLocation.getNodeOffset();
            IASTPreprocessorMacroExpansion expansion = macroLocation.getExpansion();
            String macroName = QtASTClass.getMacroName(expansion);
            if ("Q_SLOTS".equals(macroName) || "slots".equals(macroName)) {
                return new Region(offset, IQMethod.Kind.Slot);
            }
            if ("Q_SIGNALS".equals(macroName) || "signals".equals(macroName)) {
                return new Region(offset, IQMethod.Kind.Signal);
            }
            return null;
        }
    }

    private static class Revision {
        private final int offset;
        private final Long revision;
        private static final Pattern QREVISION_REGEX = Pattern.compile("^Q_REVISION\\s*\\(\\s*((?:0x)?[\\da-fA-F]+)[ulUL]*\\s*\\)$");

        public Revision(int offset, Long revision) {
            this.offset = offset;
            this.revision = revision;
        }

        public static Revision create(IASTNodeLocation location) {
            if (!(location instanceof IASTMacroExpansionLocation)) {
                return null;
            }
            IASTMacroExpansionLocation macroLocation = (IASTMacroExpansionLocation)location;
            IASTFileLocation fileLocation = macroLocation.asFileLocation();
            if (fileLocation == null) {
                return null;
            }
            int offset = fileLocation.getNodeOffset();
            IASTPreprocessorMacroExpansion expansion = macroLocation.getExpansion();
            String macroName = QtASTClass.getMacroName(expansion);
            if (!"Q_REVISION".equals(macroName)) {
                return null;
            }
            String raw = expansion.getRawSignature();
            if (raw == null) {
                return null;
            }
            Matcher m = QREVISION_REGEX.matcher(raw.trim().replaceAll("\\s+", ""));
            if (m.matches()) {
                try {
                    return new Revision(offset, Long.parseLong(m.group(1)));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return null;
        }
    }

    private static class Tag {
        public final int offset;
        public IQMethod.Kind kind;

        private Tag(int begin, IQMethod.Kind kind) {
            this.offset = begin;
            this.kind = kind;
        }

        public static Tag create(IASTNodeLocation location) {
            if (!(location instanceof IASTMacroExpansionLocation)) {
                return null;
            }
            IASTMacroExpansionLocation macroLocation = (IASTMacroExpansionLocation)location;
            IASTFileLocation fileLocation = macroLocation.asFileLocation();
            if (fileLocation == null) {
                return null;
            }
            int offset = fileLocation.getNodeOffset();
            IASTPreprocessorMacroExpansion expansion = macroLocation.getExpansion();
            String macroName = QtASTClass.getMacroName(expansion);
            if ("Q_SLOT".equals(macroName)) {
                return new Tag(offset, IQMethod.Kind.Slot);
            }
            if ("Q_SIGNAL".equals(macroName)) {
                return new Tag(offset, IQMethod.Kind.Signal);
            }
            if ("Q_INVOKABLE".equals(macroName)) {
                return new Tag(offset, IQMethod.Kind.Invokable);
            }
            return null;
        }
    }
}

