/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.qt.core.index.CDTIndex;
import org.eclipse.cdt.internal.qt.core.index.QObject;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQObject;
import org.eclipse.cdt.qt.core.index.IQObject;
import org.eclipse.cdt.qt.core.index.QtIndex;
import org.eclipse.core.runtime.CoreException;

public class QtIndexImpl
extends QtIndex {
    private final CDTIndex cdtIndex;
    private static final IndexFilter QtLinkageFilter = new IndexFilter(){

        public boolean acceptLinkage(ILinkage linkage) {
            return linkage.getLinkageID() == 5;
        }

        public boolean acceptBinding(IBinding binding) throws CoreException {
            return true;
        }
    };

    public QtIndexImpl(CDTIndex cdtIndex) {
        this.cdtIndex = cdtIndex;
    }

    @Override
    public IQObject findQObject(String[] name) {
        return name == null ? null : this.cdtIndex.get(new QObjectImplAccessor(name));
    }

    private class QObjectImplAccessor
    implements CDTIndex.Accessor<IQObject> {
        private final char[][] name;

        public QObjectImplAccessor(String[] qualName) {
            this.name = new char[qualName.length][];
            int i = 0;
            while (i < this.name.length) {
                this.name[i] = qualName[i].toCharArray();
                ++i;
            }
        }

        @Override
        public IQObject access(IIndex index) throws CoreException {
            IIndexBinding[] iIndexBindingArray = index.findBindings(this.name, QtLinkageFilter, null);
            int n = iIndexBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexBinding binding = iIndexBindingArray[n2];
                if (binding instanceof QtPDOMQObject) {
                    return new QObject(QtIndexImpl.this, QtIndexImpl.this.cdtIndex, (QtPDOMQObject)binding);
                }
                ++n2;
            }
            return null;
        }
    }
}

