/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.qt.core.index.IQEnum;

public class QEnum
implements IQEnum {
    private final String name;
    private final boolean isFlag;
    private final List<IQEnum.Enumerator> enumerators;

    public QEnum(String name, boolean isFlag, List<IEnumerator> enumerators) {
        this.name = name;
        this.isFlag = isFlag;
        this.enumerators = new ArrayList<IQEnum.Enumerator>(enumerators.size());
        for (IEnumerator enumerator : enumerators) {
            this.enumerators.add(new Enumerator(enumerator));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFlag() {
        return this.isFlag;
    }

    @Override
    public Collection<IQEnum.Enumerator> getEnumerators() {
        return this.enumerators;
    }

    private static class Enumerator
    implements IQEnum.Enumerator {
        private final String name;
        private final Long ordinal;

        public Enumerator(IEnumerator enumerator) {
            this.name = enumerator.getName();
            IValue val = enumerator.getValue();
            this.ordinal = val == null ? null : val.numericalValue();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Long getOrdinal() {
            return this.ordinal;
        }
    }
}

