/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.commands;

import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MIBreakInsert
extends MICommand<MIBreakInsertInfo> {
    public MIBreakInsert(IBreakpoints.IBreakpointsTargetDMContext ctx, String func, boolean allowPending) {
        this(ctx, false, false, null, 0, func, 0, allowPending);
    }

    public MIBreakInsert(IBreakpoints.IBreakpointsTargetDMContext ctx, boolean isTemporary, boolean isHardware, String condition, int ignoreCount, String line, int tid, boolean allowPending) {
        this(ctx, isTemporary, isHardware, condition, ignoreCount, line, tid, false, false, allowPending);
    }

    public MIBreakInsert(IBreakpoints.IBreakpointsTargetDMContext ctx, boolean isTemporary, boolean isHardware, String condition, int ignoreCount, String location, int tid, boolean disabled, boolean isTracepoint, boolean allowPending) {
        super((IDMContext)ctx, "-break-insert");
        if (isTracepoint) {
            isTemporary = false;
            ignoreCount = 0;
            tid = 0;
        }
        int i = 0;
        if (isTemporary) {
            ++i;
        }
        if (isHardware) {
            ++i;
        }
        if (condition != null && condition.length() > 0) {
            i += 2;
        }
        if (ignoreCount > 0) {
            i += 2;
        }
        if (tid > 0) {
            i += 2;
        }
        if (disabled) {
            ++i;
        }
        if (isTracepoint) {
            ++i;
        }
        if (allowPending) {
            ++i;
        }
        String[] opts = new String[i];
        i = 0;
        if (isTemporary) {
            opts[i] = "-t";
            ++i;
        }
        if (isHardware) {
            opts[i] = "-h";
            ++i;
        }
        if (condition != null && condition.length() > 0) {
            opts[i] = "-c";
            opts[++i] = condition;
            ++i;
        }
        if (ignoreCount > 0) {
            opts[i] = "-i";
            opts[++i] = Integer.toString(ignoreCount);
            ++i;
        }
        if (tid > 0) {
            opts[i] = "-p";
            opts[++i] = Integer.toString(tid);
            ++i;
        }
        if (disabled) {
            opts[i] = "-d";
            ++i;
        }
        if (isTracepoint) {
            opts[i] = "-a";
            ++i;
        }
        if (allowPending) {
            opts[i] = "-f";
            ++i;
        }
        if (opts.length > 0) {
            this.setOptions(opts);
        }
        this.setParameters(new PathAdjustable(location));
    }

    @Override
    public MIBreakInsertInfo getResult(MIOutput output) {
        return new MIBreakInsertInfo(output);
    }

    private class PathAdjustable
    extends MICommand.MIStandardParameterAdjustable {
        public PathAdjustable(String path) {
            super(path);
        }

        @Override
        public String getAdjustedValue() {
            String adjustedValue = super.getAdjustedValue();
            return adjustedValue.replace("\\\\", "\\");
        }
    }
}

