/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.model.IDisassemblyInstruction;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;

public class DisassemblyInstruction
extends CDebugElement
implements IDisassemblyInstruction {
    private ICDIInstruction fCDIInstruction;
    private IAddress fAddress;

    public DisassemblyInstruction(CDebugTarget target, BigInteger baseElement, ICDIInstruction instruction) {
        super(target);
        this.fCDIInstruction = instruction;
        this.fAddress = target.getAddressFactory().createAddress(this.fCDIInstruction.getAdress());
    }

    @Override
    public IAddress getAdress() {
        return this.fAddress;
    }

    @Override
    public String getArguments() {
        return this.fCDIInstruction.getArgs();
    }

    @Override
    public String getFunctionName() {
        return this.fCDIInstruction.getFuntionName();
    }

    @Override
    public String getInstructionText() {
        return this.fCDIInstruction.getInstruction();
    }

    @Override
    public long getOffset() {
        return this.fCDIInstruction.getOffset();
    }

    @Override
    public String getOpcode() {
        return this.fCDIInstruction.getOpcode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IDisassemblyInstruction)) {
            return false;
        }
        IDisassemblyInstruction instr = (IDisassemblyInstruction)obj;
        if (!instr.getAdress().equals((Object)this.getAdress())) {
            return false;
        }
        if (instr.getOffset() != this.getOffset()) {
            return false;
        }
        if (instr.getFunctionName().compareTo(this.getFunctionName()) != 0) {
            return false;
        }
        if (instr.getOpcode().compareTo(this.getOpcode()) != 0) {
            return false;
        }
        if (instr.getArguments().compareTo(this.getArguments()) != 0) {
            return false;
        }
        return instr.getInstructionText().compareTo(this.getInstructionText()) == 0;
    }
}

