/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.ITracepointAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.TracepointActionManager;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.WhileSteppingAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions.MessagesForTracepointActions;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepointactions.TracepointActionDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TracepointGlobalActionsList
extends Composite {
    private Button attachButton;
    private Button deleteButton;
    private Button editButton;
    private Button newButton;
    private Table table;
    private boolean isSubAction;

    public TracepointGlobalActionsList(Composite parent, int style, boolean useAttachButton, boolean isSub) {
        super(parent, style);
        this.isSubAction = isSub;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        this.setLayout((Layout)gridLayout);
        this.table = new Table((Composite)this, 67586);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracepointGlobalActionsList.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TracepointGlobalActionsList.this.HandleEditButton();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 5;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn nameTableColumn = new TableColumn(this.table, 0);
        nameTableColumn.setWidth(120);
        nameTableColumn.setText(MessagesForTracepointActions.TracepointActions_Name);
        TableColumn typeTableColumn = new TableColumn(this.table, 0);
        typeTableColumn.setWidth(120);
        typeTableColumn.setText(MessagesForTracepointActions.TracepointActions_Type);
        TableColumn summaryTableColumn = new TableColumn(this.table, 0);
        summaryTableColumn.setWidth(120);
        summaryTableColumn.setText(MessagesForTracepointActions.TracepointActions_Summary);
        ArrayList actions = TracepointActionManager.getInstance().getActions();
        for (ITracepointAction element : actions) {
            if (this.isSubAction && element instanceof WhileSteppingAction) continue;
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, element.getName());
            tableItem.setText(1, element.getTypeName());
            tableItem.setText(2, element.getSummary());
            tableItem.setData((Object)element);
        }
        if (useAttachButton) {
            this.attachButton = new Button((Composite)this, 0);
            this.attachButton.setLayoutData((Object)new GridData(512));
            this.attachButton.setText(MessagesForTracepointActions.TracepointActions_Attach);
        }
        this.newButton = new Button((Composite)this, 0);
        this.newButton.setLayoutData((Object)new GridData());
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TracepointGlobalActionsList.this.HandleNewButton();
                }
                catch (CoreException coreException) {}
            }
        });
        this.newButton.setText(MessagesForTracepointActions.TracepointActions_New);
        this.newButton.setEnabled(true);
        this.editButton = new Button((Composite)this, 0);
        this.editButton.setText(MessagesForTracepointActions.TracepointActions_Edit);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracepointGlobalActionsList.this.HandleEditButton();
            }
        });
        if (!useAttachButton) {
            this.editButton.setLayoutData((Object)new GridData(640));
        }
        this.deleteButton = new Button((Composite)this, 0);
        this.deleteButton.setLayoutData((Object)new GridData(128));
        this.deleteButton.setText(MessagesForTracepointActions.TracepointActions_Delete);
        this.updateButtons();
    }

    public Button getAttachButton() {
        return this.attachButton;
    }

    public Button getDeleteButton() {
        return this.deleteButton;
    }

    public ITracepointAction[] getSelectedActions() {
        TableItem[] selectedItems = this.table.getSelection();
        ITracepointAction[] actionList = new ITracepointAction[selectedItems.length];
        int actionCount = 0;
        int i = 0;
        while (i < selectedItems.length) {
            actionList[actionCount++] = (ITracepointAction)selectedItems[i].getData();
            ++i;
        }
        return actionList;
    }

    protected void HandleDeleteButton() {
        TableItem[] selectedItems = this.table.getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            ITracepointAction action = (ITracepointAction)selectedItems[i].getData();
            TracepointActionManager.getInstance().deleteAction(action);
            ++i;
        }
        this.table.remove(this.table.getSelectionIndices());
        if (this.table.getItemCount() > 0) {
            this.table.select(this.table.getItemCount() - 1);
        }
        this.updateButtons();
    }

    protected void HandleEditButton() {
        TableItem[] selectedItems = this.table.getSelection();
        ITracepointAction action = (ITracepointAction)selectedItems[0].getData();
        TracepointActionDialog dialog = new TracepointActionDialog(this.getShell(), action, this.isSubAction);
        int result = dialog.open();
        if (result == 0) {
            action.setName(dialog.getActionName());
            selectedItems[0].setText(0, action.getName());
            selectedItems[0].setText(1, action.getTypeName());
            selectedItems[0].setText(2, action.getSummary());
        }
    }

    protected void HandleNewButton() throws CoreException {
        TracepointActionDialog dialog = new TracepointActionDialog(this.getShell(), null, this.isSubAction);
        int result = dialog.open();
        if (result == 0) {
            ITracepointAction action = (ITracepointAction)dialog.getTracepointAction();
            action.setName(dialog.getActionName());
            TracepointActionManager.getInstance().addAction(action);
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, action.getName());
            tableItem.setText(1, action.getTypeName());
            tableItem.setText(2, action.getSummary());
            tableItem.setData((Object)action);
        }
    }

    public void updateButtons() {
        TableItem[] selectedItems = this.table.getSelection();
        if (this.attachButton != null) {
            this.attachButton.setEnabled(selectedItems.length > 0);
        }
        this.deleteButton.setEnabled(selectedItems.length > 0);
        this.editButton.setEnabled(selectedItems.length == 1);
    }
}

