/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner.ASTFileLocation;
import org.eclipse.cdt.internal.core.parser.scanner.ASTInclusionNode;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtx;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxMacroExpansion;

class LocationCtxContainer
extends LocationCtx {
    private int fChildSequenceLength;
    private ArrayList<LocationCtx> fChildren;
    private final AbstractCharArray fSource;
    private int[] fLineOffsets;

    public LocationCtxContainer(LocationCtxContainer parent, AbstractCharArray source, int parentOffset, int parentEndOffset, int sequenceNumber) {
        super(parent, parentOffset, parentEndOffset, sequenceNumber);
        this.fSource = source;
    }

    @Override
    public Collection<LocationCtx> getChildren() {
        if (this.fChildren == null) {
            return Collections.emptyList();
        }
        return this.fChildren;
    }

    public void addChild(LocationCtx locationCtx) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(locationCtx);
    }

    public char[] getSource(int offset, int length) {
        if (this.fSource.isValidOffset(offset + length - 1)) {
            char[] result = new char[length];
            this.fSource.arraycopy(offset, result, 0, length);
            return result;
        }
        return CharArrayUtils.EMPTY;
    }

    @Override
    public final int getSequenceLength() {
        return this.fSource.getLength() + this.fChildSequenceLength;
    }

    @Override
    public final int getSequenceNumberForOffset(int offset, boolean checkChildren) {
        int result = this.fSequenceNumber + this.fChildSequenceLength + offset;
        if (checkChildren && this.fChildren != null) {
            int i = this.fChildren.size() - 1;
            while (i >= 0) {
                LocationCtx child = this.fChildren.get(i);
                if (child.fEndOffsetInParent > offset) {
                    result -= child.getSequenceLength();
                } else {
                    return result;
                }
                --i;
            }
        }
        return result;
    }

    @Override
    public void addChildSequenceLength(int childLength) {
        this.fChildSequenceLength += childLength;
    }

    @Override
    public final LocationCtx findSurroundingContext(int sequenceNumber, int length) {
        int testEnd = length > 1 ? sequenceNumber + length - 1 : sequenceNumber;
        LocationCtx child = this.findChildLessOrEqualThan(sequenceNumber, false);
        if (child != null && child.fSequenceNumber + child.getSequenceLength() > testEnd) {
            return child.findSurroundingContext(sequenceNumber, length);
        }
        return this;
    }

    @Override
    public final LocationCtxMacroExpansion findEnclosingMacroExpansion(int sequenceNumber, int length) {
        int testEnd = length > 1 ? sequenceNumber + length - 1 : sequenceNumber;
        LocationCtx child = this.findChildLessOrEqualThan(sequenceNumber, true);
        if (child != null && child.fSequenceNumber + child.getSequenceLength() > testEnd) {
            return child.findEnclosingMacroExpansion(sequenceNumber, length);
        }
        return null;
    }

    @Override
    public int convertToSequenceEndNumber(int sequenceNumber) {
        LocationCtx child = this.findChildLessOrEqualThan(sequenceNumber, false);
        if (child != null) {
            sequenceNumber = child.convertToSequenceEndNumber(sequenceNumber);
        }
        if (sequenceNumber == this.fSequenceNumber) {
            return sequenceNumber - this.fEndOffsetInParent + this.fOffsetInParent;
        }
        return sequenceNumber;
    }

    @Override
    public ASTFileLocation findMappedFileLocation(int sequenceNumber, int length) {
        int testEnd = length > 1 ? sequenceNumber + length - 1 : sequenceNumber;
        LocationCtx child = this.findChildLessOrEqualThan(sequenceNumber, false);
        if (child != null && child.fSequenceNumber + child.getSequenceLength() > testEnd) {
            return child.findMappedFileLocation(sequenceNumber, length);
        }
        return super.findMappedFileLocation(sequenceNumber, length);
    }

    @Override
    public void collectLocations(int sequenceNumber, int length, ArrayList<IASTNodeLocation> locations) {
        if (length < 1) {
            return;
        }
        int endSequenceNumber = sequenceNumber + length;
        if (this.fChildren != null) {
            int childIdx = Math.max(0, this.findChildIdxLessOrEqualThan(sequenceNumber, false));
            while (childIdx < this.fChildren.size()) {
                int childEndSequenceNumber;
                LocationCtx child = this.fChildren.get(childIdx);
                if (sequenceNumber < child.fSequenceNumber) {
                    int offset = child.fEndOffsetInParent - (child.fSequenceNumber - sequenceNumber);
                    if (endSequenceNumber <= child.fSequenceNumber) {
                        this.addFileLocation(offset, endSequenceNumber - sequenceNumber, locations);
                        return;
                    }
                    int gapLen = child.fOffsetInParent - offset;
                    if (gapLen > 0) {
                        this.addFileLocation(offset, child.fOffsetInParent - offset, locations);
                    }
                    sequenceNumber = child.fSequenceNumber;
                    assert (sequenceNumber < endSequenceNumber);
                }
                if (sequenceNumber < (childEndSequenceNumber = child.fSequenceNumber + child.getSequenceLength()) || sequenceNumber == childEndSequenceNumber && !locations.isEmpty()) {
                    child.collectLocations(sequenceNumber, endSequenceNumber - sequenceNumber, locations);
                    sequenceNumber = childEndSequenceNumber;
                    if (sequenceNumber >= endSequenceNumber) {
                        return;
                    }
                }
                ++childIdx;
            }
        }
        int myEndNumber = this.fSequenceNumber + this.getSequenceLength();
        int offset = this.fSource.getLength() - (myEndNumber - sequenceNumber);
        if (endSequenceNumber <= myEndNumber) {
            this.addFileLocation(offset, endSequenceNumber - sequenceNumber, locations);
        } else {
            this.addFileLocation(offset, this.fSource.getLength() - offset, locations);
        }
    }

    private ArrayList<IASTNodeLocation> addFileLocation(int offset, int length, ArrayList<IASTNodeLocation> sofar) {
        ASTFileLocation loc = this.createFileLocation(offset, length);
        if (loc != null) {
            sofar.add(loc);
        }
        return sofar;
    }

    ASTFileLocation createFileLocation(int start, int length) {
        return null;
    }

    final int findChildIdxLessOrEqualThan(int sequenceNumber, boolean beforeReplacedChars) {
        if (this.fChildren == null) {
            return -1;
        }
        int upper = this.fChildren.size();
        int lower = 0;
        while (upper > lower) {
            int middle = (upper + lower) / 2;
            LocationCtx child = this.fChildren.get(middle);
            int childSequenceNumber = child.fSequenceNumber;
            if (beforeReplacedChars) {
                childSequenceNumber -= child.fEndOffsetInParent - child.fOffsetInParent;
            }
            if (childSequenceNumber <= sequenceNumber) {
                lower = middle + 1;
                continue;
            }
            upper = middle;
        }
        return lower - 1;
    }

    final LocationCtx findChildLessOrEqualThan(int sequenceNumber, boolean beforeReplacedChars) {
        int idx = this.findChildIdxLessOrEqualThan(sequenceNumber, beforeReplacedChars);
        return idx >= 0 ? this.fChildren.get(idx) : null;
    }

    @Override
    public void getInclusions(ArrayList<IASTTranslationUnit.IDependencyTree.IASTInclusionNode> result) {
        if (this.fChildren != null) {
            for (LocationCtx ctx : this.fChildren) {
                if (ctx.getInclusionStatement() != null) {
                    result.add(new ASTInclusionNode(ctx));
                    continue;
                }
                ctx.getInclusions(result);
            }
        }
    }

    @Override
    public int getLineNumber(int offset) {
        int idx;
        if (this.fLineOffsets == null) {
            this.fLineOffsets = this.computeLineOffsets();
        }
        if ((idx = Arrays.binarySearch(this.fLineOffsets, offset)) < 0) {
            return -idx;
        }
        return idx + 1;
    }

    private int[] computeLineOffsets() {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        int len = this.fSource.getLength();
        int i = 0;
        while (i < len) {
            if (this.fSource.get(i) == '\n') {
                offsets.add(new Integer(i));
            }
            ++i;
        }
        int[] result = new int[offsets.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (Integer)offsets.get(i2);
            ++i2;
        }
        return result;
    }

    public String toString() {
        return "<synthetic>";
    }
}

