/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIArg {
    String name;
    String value;

    public MIArg(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static MIArg[] getMIArgs(MIList miList) {
        ArrayList<MIArg> aList = new ArrayList<MIArg>();
        MIValue[] values = miList.getMIValues();
        int i = 0;
        while (i < values.length) {
            MIArg arg;
            if (values[i] instanceof MITuple && (arg = MIArg.getMIArg((MITuple)values[i])) != null) {
                aList.add(arg);
            }
            ++i;
        }
        MIResult[] results = miList.getMIResults();
        int i2 = 0;
        while (i2 < results.length) {
            MIValue value = results[i2].getMIValue();
            if (value instanceof MIConst) {
                String str = ((MIConst)value).getCString();
                aList.add(new MIArg(str, ""));
            }
            ++i2;
        }
        return aList.toArray(new MIArg[aList.size()]);
    }

    public static MIArg[] getMIArgs(MITuple miTuple) {
        ArrayList<MIArg> aList = new ArrayList<MIArg>();
        MIValue[] values = miTuple.getMIValues();
        int i = 0;
        while (i < values.length) {
            MIArg arg;
            if (values[i] instanceof MITuple && (arg = MIArg.getMIArg((MITuple)values[i])) != null) {
                aList.add(arg);
            }
            ++i;
        }
        MIResult[] results = miTuple.getMIResults();
        int i2 = 0;
        while (i2 < results.length) {
            MIValue value = results[i2].getMIValue();
            if (value instanceof MIConst) {
                String str = ((MIConst)value).getCString();
                aList.add(new MIArg(str, ""));
            }
            ++i2;
        }
        return aList.toArray(new MIArg[aList.size()]);
    }

    public static MIArg getMIArg(MITuple tuple) {
        MIResult[] args = tuple.getMIResults();
        MIArg arg = null;
        if (args.length > 0) {
            String aName = "";
            MIValue value = args[0].getMIValue();
            aName = value != null && value instanceof MIConst ? ((MIConst)value).getCString() : "";
            String aValue = "";
            if (args.length == 2) {
                value = args[1].getMIValue();
                aValue = value != null && value instanceof MIConst ? ((MIConst)value).getCString() : "";
            }
            arg = new MIArg(aName, aValue);
        }
        return arg;
    }

    public String toString() {
        return String.valueOf(this.name) + "=" + this.value;
    }
}

