/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.generation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Bindings;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.TypeBinding;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.ui.actions.AddUnimplementedMethodsOperation;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.php.ui.util.CodeGenerationUtils;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class UnimplementMethodsTests {
    protected IProject project;
    protected IFile testFile;
    protected IDocument testDocument;
    protected PHPVersion phpVersion;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static final char SELECTION_CHAR = '|';

    static {
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/generation/unimplement_methods"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/generation/unimplement_methods_php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/generation/unimplement_methods_php56", "/workspace/generation/unimplement_methods_php7"});
        TESTS.put(PHPVersion.PHP8_1, new String[]{"/workspace/generation/unimplement_methods_php81"});
    }

    public UnimplementMethodsTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        TestUtils.disableColliders((TestUtils.ColliderType)TestUtils.ColliderType.ALL);
        this.project = TestUtils.createProject((String)("UnimplementMethods_" + String.valueOf(this.phpVersion)));
        TestUtils.setProjectPHPVersion((IProject)this.project, (PHPVersion)this.phpVersion);
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.php.formatter.core");
        node.put("formatterProfile", "org.eclipse.php.formatter.ui.default");
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject((IProject)this.project);
        TestUtils.enableColliders((TestUtils.ColliderType)TestUtils.ColliderType.ALL);
    }

    @After
    public void tearDown() throws Exception {
        if (this.testFile != null) {
            TestUtils.deleteFile((IFile)this.testFile);
        }
    }

    @Test
    public void generate(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        pdttFile.applyPreferences();
        IType type = this.createFile(pdttFile.getFile());
        ASTParser parser = ASTParser.newParser((PHPVersion)this.phpVersion, (boolean)false, (boolean)true, (ISourceModule)type.getSourceModule());
        Program unit = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        PHPClassType evaluatedType = PHPClassType.fromIType((IType)type);
        TypeBinding binding = new TypeBinding(unit.getAST().getBindingResolver(), (IEvaluatedType)evaluatedType, (IModelElement)type);
        ArrayList<IMethodBinding> toImplement = new ArrayList<IMethodBinding>();
        IMethodBinding[] overridable = null;
        IMethodBinding[] methods = CodeGenerationUtils.getOverridableMethods((AST)unit.getAST(), (ITypeBinding)binding, (boolean)false);
        ArrayList<IMethodBinding> list = new ArrayList<IMethodBinding>(methods.length);
        IMethodBinding[] iMethodBindingArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding cur = iMethodBindingArray[n2];
            if (Bindings.isVisibleInHierarchy((IMethodBinding)cur)) {
                list.add(cur);
            }
            ++n2;
        }
        overridable = list.toArray(new IMethodBinding[list.size()]);
        iMethodBindingArray = overridable;
        n = overridable.length;
        n2 = 0;
        while (n2 < n) {
            IMethodBinding element = iMethodBindingArray[n2];
            toImplement.add(element);
            ++n2;
        }
        IMethodBinding[] toImplementArray = toImplement.toArray(new IMethodBinding[toImplement.size()]);
        AddUnimplementedMethodsOperation operation = new AddUnimplementedMethodsOperation(unit, type, (ITypeBinding)binding, toImplementArray, -1, true, this.testDocument);
        operation.setCreateComments(true);
        operation.run((IProgressMonitor)new NullProgressMonitor());
        PDTTUtils.assertContents((String)pdttFile.getExpected(), (String)this.testDocument.get());
    }

    protected InputStream[] prepareOtherStreams(PdttFile file) {
        String[] contents = file.getOtherFiles();
        InputStream[] result = new InputStream[contents.length];
        int i = 0;
        while (i < contents.length) {
            result[i] = new ByteArrayInputStream(contents[i].getBytes());
            ++i;
        }
        return result;
    }

    protected IType createFile(String data) throws Exception {
        int left = ((String)data).indexOf(124);
        if (left == -1) {
            throw new IllegalArgumentException("Selection characters are not set");
        }
        int right = ((String)(data = ((String)data).substring(0, left) + ((String)data).substring(left + 1))).indexOf(124);
        if (right == -1) {
            throw new IllegalArgumentException("Selection is not closed");
        }
        data = ((String)data).substring(0, right) + ((String)data).substring(right + 1);
        this.testDocument = new Document();
        this.testDocument.set((String)data);
        this.testFile = TestUtils.createFile((IProject)this.project, (String)"test.php", (String)data);
        this.project.refreshLocal(2, null);
        this.project.build(6, null);
        TestUtils.waitForIndexer();
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)this.testFile);
        IModelElement element = sourceModule.getElementAt(left);
        IType type = CodeGenerationUtils.getType((IModelElement)element);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("No type found under selection");
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }
}

