/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import java.util.Collection;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.MatchLocatorParser;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.php.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.core.compiler.ast.nodes.ConstantDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.core.compiler.ast.nodes.Include;
import org.eclipse.php.core.compiler.ast.nodes.ListVariable;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;

public class PHPMatchLocatorParser
extends MatchLocatorParser {
    public PHPMatchLocatorParser(MatchLocator locator) {
        super(locator);
    }

    protected void visitTypeDeclaration(TypeDeclaration t) {
        if (t instanceof NamespaceDeclaration && ((NamespaceDeclaration)t).isGlobal()) {
            return;
        }
        super.visitTypeDeclaration(t);
    }

    protected void processStatement(ASTNode node, PatternLocator locator) {
        if (node instanceof FieldDeclaration) {
            locator.match((FieldDeclaration)node, this.getNodeSet());
        } else if (node instanceof ConstantDeclaration) {
            ConstantDeclaration constDecl = (ConstantDeclaration)node;
            ConstantReference constantName = constDecl.getConstantName();
            FieldDeclarationLocation decl = new FieldDeclarationLocation(constantName.getName(), constantName.sourceStart(), constantName.sourceEnd(), constDecl.sourceStart(), constDecl.sourceEnd());
            decl.setModifiers(2);
            locator.match((FieldDeclaration)decl, this.getNodeSet());
        } else if (node instanceof FieldAccess) {
            Expression field = ((FieldAccess)node).getField();
            if (field instanceof SimpleReference) {
                SimpleReference ref = (SimpleReference)field;
                SimpleReferenceLocation refLoc = new SimpleReferenceLocation(ref.sourceStart(), ref.sourceEnd(), "$" + ref.getName());
                locator.match((Reference)refLoc, this.getNodeSet());
            }
        } else if (node instanceof StaticFieldAccess) {
            Expression field = ((StaticFieldAccess)node).getField();
            if (field instanceof SimpleReference) {
                SimpleReference ref = (SimpleReference)field;
                SimpleReferenceLocation refLoc = new SimpleReferenceLocation(ref.sourceStart(), ref.sourceEnd(), "$" + ref.getName());
                locator.match((Reference)refLoc, this.getNodeSet());
            }
        } else if (node instanceof StaticConstantAccess) {
            ConstantReference constantRef = ((StaticConstantAccess)node).getConstant();
            locator.match((Reference)constantRef, this.getNodeSet());
        } else if (node instanceof Assignment) {
            Expression left = ((Assignment)node).getVariable();
            if (left instanceof FieldAccess) {
                Expression field;
                FieldAccess fieldAccess = (FieldAccess)left;
                Expression dispatcher = fieldAccess.getDispatcher();
                if (dispatcher instanceof VariableReference && (field = fieldAccess.getField()) instanceof SimpleReference) {
                    SimpleReference ref = (SimpleReference)field;
                    FieldDeclarationLocation decl = new FieldDeclarationLocation("$" + ref.getName(), ref.sourceStart(), ref.sourceEnd(), node.sourceStart(), node.sourceEnd());
                    locator.match((FieldDeclaration)decl, this.getNodeSet());
                }
            } else if (left instanceof VariableReference) {
                FieldDeclarationLocation decl = new FieldDeclarationLocation(((VariableReference)left).getName(), left.sourceStart(), left.sourceEnd(), node.sourceStart(), node.sourceEnd());
                locator.match((FieldDeclaration)decl, this.getNodeSet());
            }
        } else if (node instanceof ListVariable) {
            this.recursiveListMatch(node, locator);
        } else if (node instanceof TypeReference) {
            locator.match((TypeReference)node, this.getNodeSet());
        } else if (node instanceof VariableReference) {
            locator.match((Reference)((VariableReference)node), this.getNodeSet());
        } else if (node instanceof CallExpression) {
            FieldDeclaration constantDecl = ASTUtils.getConstantDeclaration((CallExpression)node);
            if (constantDecl != null) {
                locator.match(constantDecl, this.getNodeSet());
            } else {
                locator.match((CallExpression)node, this.getNodeSet());
            }
        } else if (node instanceof Include) {
            Include include = (Include)node;
            if (include.getExpr() instanceof Scalar) {
                Scalar filePath = (Scalar)include.getExpr();
                CallExpressionLocation callExpression = new CallExpressionLocation(filePath.sourceStart(), filePath.sourceEnd(), null, "include", new CallArgumentsList());
                locator.match((CallExpression)callExpression, this.getNodeSet());
            }
        } else if (node instanceof Argument) {
            SimpleReference ref = ((Argument)node).getRef();
            FieldDeclarationLocation decl = new FieldDeclarationLocation(ref.getName(), ref.sourceStart(), ref.sourceEnd(), node.sourceStart(), node.sourceEnd());
            locator.match((FieldDeclaration)decl, this.getNodeSet());
        } else if (node instanceof ForEachStatement) {
            FieldDeclarationLocation decl;
            SimpleReference ref;
            Expression key = ((ForEachStatement)node).getKey();
            Expression value = ((ForEachStatement)node).getValue();
            if (key instanceof SimpleReference) {
                ref = (SimpleReference)key;
                decl = new FieldDeclarationLocation(ref.getName(), ref.sourceStart(), ref.sourceEnd(), node.sourceStart(), node.sourceEnd());
                locator.match((FieldDeclaration)decl, this.getNodeSet());
            }
            if (value instanceof SimpleReference) {
                ref = (SimpleReference)value;
                decl = new FieldDeclarationLocation(ref.getName(), ref.sourceStart(), ref.sourceEnd(), ref.sourceStart(), ref.sourceEnd());
                locator.match((FieldDeclaration)decl, this.getNodeSet());
            }
        } else if (node instanceof CatchClause) {
            VariableReference ref = ((CatchClause)node).getVariable();
            FieldDeclarationLocation decl = new FieldDeclarationLocation(ref.getName(), ref.sourceStart(), ref.sourceEnd(), node.sourceStart(), node.sourceEnd());
            locator.match((FieldDeclaration)decl, this.getNodeSet());
        }
    }

    private void recursiveListMatch(ASTNode node, PatternLocator locator) {
        Collection<? extends Expression> variables = ((ListVariable)node).getVariables();
        for (Expression expression : variables) {
            if (expression instanceof ListVariable) {
                this.recursiveListMatch((ASTNode)expression, locator);
                continue;
            }
            if (!(expression instanceof VariableReference)) continue;
            FieldDeclarationLocation decl = new FieldDeclarationLocation(((VariableReference)expression).getName(), expression.sourceStart(), expression.sourceEnd(), expression.sourceStart(), expression.sourceEnd());
            locator.match((FieldDeclaration)decl, this.getNodeSet());
        }
    }

    public void parseBodies(ModuleDeclaration unit) {
        unit.rebuild();
        super.parseBodies(unit);
    }

    static boolean locationEquals(ASTNode node, Object obj) {
        if (obj == node) {
            return true;
        }
        if (obj instanceof ASTNode) {
            return node.locationMatches((ASTNode)obj);
        }
        return false;
    }

    class CallExpressionLocation
    extends CallExpression {
        public CallExpressionLocation(ASTNode receiver, String name, CallArgumentsList args) {
            super(receiver, name, args);
        }

        public CallExpressionLocation(int start, int end, ASTNode receiver, SimpleReference name, CallArgumentsList args) {
            super(start, end, receiver, name, args);
        }

        public CallExpressionLocation(int start, int end, ASTNode receiver, String name, CallArgumentsList args) {
            super(start, end, receiver, name, args);
        }

        public boolean equals(Object obj) {
            return PHPMatchLocatorParser.locationEquals((ASTNode)this, obj);
        }

        public int hashCode() {
            return this.sourceEnd() * 1001 + this.sourceEnd();
        }
    }

    class FieldDeclarationLocation
    extends FieldDeclaration {
        public FieldDeclarationLocation(String name, int nameStart, int nameEnd, int declStart, int declEnd) {
            super(name, nameStart, nameEnd, declStart, declEnd);
        }

        public boolean equals(Object obj) {
            return PHPMatchLocatorParser.locationEquals((ASTNode)this, obj);
        }

        public int hashCode() {
            return this.sourceEnd() * 1001 + this.sourceEnd();
        }
    }

    private static final class SimpleReferenceLocation
    extends SimpleReference {
        private SimpleReferenceLocation(int start, int end, String name) {
            super(start, end, name);
        }

        public boolean equals(Object obj) {
            return PHPMatchLocatorParser.locationEquals((ASTNode)this, obj);
        }

        public int hashCode() {
            return this.sourceEnd() * 1001 + this.sourceEnd();
        }
    }
}

