/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.locator.AbstractConciliatorTest;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.junit.Assert;
import org.junit.Test;

public class PHPElementConciliatorTest
extends AbstractConciliatorTest {
    @Test
    public void concileClassName() {
        this.setFileContent("<?php class TestRenameClass{}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 13;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 7;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileClassName1() {
        this.setFileContent("<?php class TestRenameClass{} class TestExtendedClass extends TestRenameClass{}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 63;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileClassName2() {
        this.setFileContent("<?php class A{function foo(){}} class B{function bar(){}} $a = new A();$a->foo(); A::foo(); $b = new B();$b->bar();B::bar();?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 68;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 83;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileInterface() {
        this.setFileContent("<?php interface iTemplate{public function setVariable($name, $var);}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 17;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileInterface1() {
        this.setFileContent("<?php interface iTemplate{public function setVariable($name, $var);} class Template implements iTemplate{  public function setVariable($name, $var){}}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 96;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileProgram() {
        this.setFileContent("<?php class TestRenameClass{}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        Assert.assertEquals((long)7L, (long)PHPElementConciliator.concile((ASTNode)program));
    }

    @Test
    public void concileGlobalVar() {
        this.setFileContent("<?php $a = 1;  function test(){  global $a; echo $a;} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 7;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 41;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 50;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileGlobalVar1() {
        this.setFileContent("<?php $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 48;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileGlobalVar2() {
        this.setFileContent("<?php $a = 1;  function test(){  global $a; echo $a;} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 41;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileFunc() {
        this.setFileContent("<?php $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 16;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 25;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileFunc1() {
        this.setFileContent("<?php function a($n){return ($n * $n);}echo a(5);?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 45;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod1() {
        this.setFileContent("<?class foo {public static function bar(){return 'bar in a class called';}}$strFN2 = foo::bar;echo bar();?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 91;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod2() {
        this.setFileContent("<?class foo {public function bar(){return 'bar in a class called';}}$strFN2 = new foo(); $strFN2->bar()?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 99;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod3() {
        this.setFileContent("<?class foo {public function bar(){return 'bar in a class called';} public function f(){$this->bar();}}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 96;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod4() {
        this.setFileContent("<?class foo {public function bar(){return 'bar in a class called';} public function f(){$this->bar();}}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 30;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileField1() {
        this.setFileContent("<?class foo {var $f; public function f(){$this->$f;}}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 14;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 45;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileField2() {
        this.setFileContent("<?class foo {var $f; public function f(){$this->$f;}} $cls= new foo(); $cls->f;?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 78;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileField3() {
        this.setFileContent("<?class foo {var $f; public function f(){$this->$f;}} $cls= new foo(); $cls->f;?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 18;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileStaticField1() {
        this.setFileContent("<?class foo {public static $my_static = 'foo';} echo Foo::$my_static; echo $foo->my_static?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 28;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 59;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 82;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void localVar() {
        this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 46;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)3L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 33;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)3L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void localVar1() {
        this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 33;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)3L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant() {
        this.setFileContent("<?php define(\"CONSTANT\", \"Hello world.\"); echo CONSTANT; echo Constant; ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 15;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 48;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
        start = 63;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant1() {
        this.setFileContent("<?php define (\"TEST\", 1234);");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PHPElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstantExists() {
        this.setFileContent("<?php define (\"TEST\", 1234);");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        Assert.assertTrue((boolean)PHPElementConciliator.constantAlreadyExists((Program)program, (String)"TEST"));
    }

    @Test
    public void concileClsMemberExists() {
        this.setFileContent("<?class foo {public static function bar(){return 'bar in a class called';}}$strFN2 = foo::bar;echo bar();?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 8;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertTrue((boolean)(selectedNode instanceof TypeDeclaration));
        Assert.assertTrue((boolean)PHPElementConciliator.classMemberAlreadyExists((TypeDeclaration)((TypeDeclaration)selectedNode), (String)"bar", (int)29));
    }

    @Test
    public void concileClassNameExists() {
        this.setFileContent("<?php class TestRenameClass{}?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        PHPElementConciliator.classNameAlreadyExists((Program)program, (String)"TestRenameClass");
    }

    @Test
    public void localVarExists() {
        this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 21;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        Assert.assertNotNull((Object)selectedNode);
        PHPElementConciliator.localVariableAlreadyExists((FunctionDeclaration)((FunctionDeclaration)selectedNode), (String)"x");
    }

    @Test
    public void funExists1() {
        this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        PHPElementConciliator.functionAlreadyExists((Program)program, (String)"assignx");
    }

    @Test
    public void concileGlobalExists() {
        this.setFileContent("<?php $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        Assert.assertTrue((boolean)PHPElementConciliator.globalVariableAlreadyExists((Program)program, (String)"a"));
    }
}

