/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.codeassist;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.codeassist.CodeAssistPdttFile;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.documentModel.loader.PHPDocumentLoader;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class CodeAssistTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    public static final String DEFAULT_CURSOR = "|";
    private IProject project;
    private IFile testFile;
    private List<IFile> otherFiles = null;
    private PHPVersion version;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/codeassist/php5/exclusive", "/workspace/codeassist/php5", "/workspace/codeassist/php5/classExclusive"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php5/classExclusive", "/workspace/codeassist/php53/exclusive", "/workspace/codeassist/php53/classExclusive", "/workspace/codeassist/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php5/classExclusive", "/workspace/codeassist/php53", "/workspace/codeassist/php53/classExclusive", "/workspace/codeassist/php54", "/workspace/codeassist/php54/classExclusive"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php7/classExclusive"});
        TESTS.put(PHPVersion.PHP7_1, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php7/classExclusive", "/workspace/codeassist/php71"});
        TESTS.put(PHPVersion.PHP7_2, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php7/classExclusive", "/workspace/codeassist/php71", "/workspace/codeassist/php72"});
        TESTS.put(PHPVersion.PHP7_3, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php7/classExclusive", "/workspace/codeassist/php71", "/workspace/codeassist/php72"});
        TESTS.put(PHPVersion.PHP7_4, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php71", "/workspace/codeassist/php72", "/workspace/codeassist/php74"});
        TESTS.put(PHPVersion.PHP8_0, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php71", "/workspace/codeassist/php72", "/workspace/codeassist/php74", "/workspace/codeassist/php80"});
        TESTS.put(PHPVersion.PHP8_1, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php71", "/workspace/codeassist/php72", "/workspace/codeassist/php74", "/workspace/codeassist/php80", "/workspace/codeassist/php81"});
        TESTS.put(PHPVersion.PHP8_2, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php71", "/workspace/codeassist/php72", "/workspace/codeassist/php74", "/workspace/codeassist/php80", "/workspace/codeassist/php81"});
        TESTS.put(PHPVersion.PHP8_3, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56", "/workspace/codeassist/php7", "/workspace/codeassist/php71", "/workspace/codeassist/php72", "/workspace/codeassist/php74", "/workspace/codeassist/php80", "/workspace/codeassist/php81"});
    }

    public CodeAssistTests(PHPVersion version, String[] fileNames) {
        this.version = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        TestUtils.disableColliders(TestUtils.ColliderType.WTP_VALIDATION);
        TestUtils.disableColliders(TestUtils.ColliderType.LIBRARY_AUTO_DETECTION);
        TestUtils.disableColliders(TestUtils.ColliderType.AUTO_BUILD);
        this.project = TestUtils.createProject("CodeAssistTests_" + this.version.toString());
        TestUtils.setProjectPHPVersion(this.project, this.version);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject(this.project);
        TestUtils.enableColliders(TestUtils.ColliderType.AUTO_BUILD);
        TestUtils.enableColliders(TestUtils.ColliderType.WTP_VALIDATION);
        TestUtils.enableColliders(TestUtils.ColliderType.LIBRARY_AUTO_DETECTION);
    }

    @Test
    public void assist(String fileName) throws Exception {
        CodeAssistPdttFile pdttFile = new CodeAssistPdttFile(fileName);
        int offset = this.createFiles(pdttFile);
        CompletionProposal[] proposals = this.getProposals(DLTKCore.createSourceModuleFrom((IFile)this.testFile), offset);
        this.compareProposals(proposals, pdttFile);
    }

    @After
    public void deleteFiles() throws CoreException {
        ResourcesPlugin.getWorkspace().run(m -> {
            if (this.testFile != null) {
                TestUtils.deleteFile(this.testFile);
            }
            if (this.otherFiles != null) {
                for (IFile file : this.otherFiles) {
                    if (file == null) continue;
                    TestUtils.deleteFile(file);
                }
            }
        }, null);
    }

    private int createFiles(PdttFile pdttFile) throws Exception {
        String cursor = this.getCursor(pdttFile) != null ? this.getCursor(pdttFile) : DEFAULT_CURSOR;
        String data = pdttFile.getFile();
        String[] otherFilesArr = pdttFile.getOtherFiles();
        int offset = data.lastIndexOf(cursor);
        if (offset == -1) {
            throw new IllegalArgumentException("Offset character is not set");
        }
        pdttFile.applyPreferences();
        String fileContent = data.substring(0, offset) + data.substring(offset + 1);
        String fileNameBase = Paths.get(pdttFile.getFileName(), new String[0]).getFileName().toString();
        String fileName = fileNameBase.substring(0, fileNameBase.indexOf(46));
        ResourcesPlugin.getWorkspace().run(m -> {
            this.otherFiles = new ArrayList<IFile>(otherFilesArr.length);
            this.testFile = TestUtils.createFile(this.project, fileName + ".php", fileContent);
            int i = 0;
            String[] stringArray2 = otherFilesArr;
            int n = otherFilesArr.length;
            int n2 = 0;
            while (n2 < n) {
                String otherFileContent = stringArray2[n2];
                IFile tmp = TestUtils.createFile(this.project, String.format("test%s.php", i), otherFileContent);
                this.otherFiles.add(i++, tmp);
                ++n2;
            }
        }, null);
        TestUtils.waitForIndexer();
        return offset;
    }

    private CompletionProposal[] getProposals(ISourceModule sourceModule, int offset) throws ModelException {
        IStructuredDocument document = (IStructuredDocument)new PHPDocumentLoader().createNewStructuredDocument();
        String content = new String(sourceModule.getSourceAsCharArray());
        document.set(content);
        final LinkedList proposals = new LinkedList();
        sourceModule.codeComplete(offset, (CompletionRequestor)new TestCompletionRequestor(document, offset){

            public void accept(CompletionProposal proposal) {
                proposals.add(proposal);
            }

            public void completionFailure(IProblem problem) {
                Logger.log((int)4, (String)problem.getMessage());
            }
        }, 60000L);
        return proposals.toArray(new CompletionProposal[proposals.size()]);
    }

    private void compareProposals(CompletionProposal[] proposals, CodeAssistPdttFile pdttFile) throws Exception {
        int n;
        CodeAssistPdttFile.ExpectedProposal[] expectedProposals = pdttFile.getExpectedProposals();
        boolean proposalsEqual = true;
        if (proposals.length == expectedProposals.length) {
            CodeAssistPdttFile.ExpectedProposal[] expectedProposalArray = pdttFile.getExpectedProposals();
            n = expectedProposalArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeAssistPdttFile.ExpectedProposal expectedProposal = expectedProposalArray[n2];
                boolean found = false;
                CompletionProposal[] completionProposalArray = proposals;
                int n3 = proposals.length;
                int n4 = 0;
                while (n4 < n3) {
                    CompletionProposal proposal = completionProposalArray[n4];
                    IModelElement modelElement = proposal.getModelElement();
                    if (modelElement == null) {
                        if (new String(proposal.getName()).equalsIgnoreCase(expectedProposal.name)) {
                            found = true;
                            break;
                        }
                    } else if (modelElement.getElementType() == expectedProposal.type) {
                        if (modelElement instanceof AliasType) {
                            if (((AliasType)modelElement).getAlias().equals(expectedProposal.name)) {
                                found = true;
                                break;
                            }
                        } else if (modelElement instanceof FakeConstructor && modelElement.getParent() instanceof AliasType) {
                            if (((AliasType)modelElement.getParent()).getAlias().equals(expectedProposal.name)) {
                                found = true;
                                break;
                            }
                        } else if (modelElement.getElementName().equalsIgnoreCase(expectedProposal.name)) {
                            found = true;
                            break;
                        }
                    } else if (modelElement.getElementType() == expectedProposal.type && new String(proposal.getName()).equalsIgnoreCase(expectedProposal.name)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    proposalsEqual = false;
                    break;
                }
                ++n2;
            }
        } else {
            proposalsEqual = false;
        }
        if (!proposalsEqual) {
            StringBuilder errorBuf = new StringBuilder();
            errorBuf.append("\nEXPECTED COMPLETIONS LIST:\n-----------------------------\n");
            errorBuf.append(pdttFile.getExpected());
            errorBuf.append("\nACTUAL COMPLETIONS LIST:\n-----------------------------\n");
            CompletionProposal[] completionProposalArray = proposals;
            int n5 = proposals.length;
            n = 0;
            while (n < n5) {
                CompletionProposal p = completionProposalArray[n];
                IModelElement modelElement = p.getModelElement();
                if (modelElement == null || modelElement.getElementName() == null) {
                    errorBuf.append("keyword(").append(p.getName()).append(")\n");
                } else {
                    switch (modelElement.getElementType()) {
                        case 8: {
                            errorBuf.append("field");
                            break;
                        }
                        case 9: {
                            errorBuf.append("method");
                            break;
                        }
                        case 7: {
                            errorBuf.append("type");
                        }
                    }
                    if (modelElement instanceof FakeConstructor && modelElement.getParent() instanceof AliasType) {
                        modelElement = modelElement.getParent();
                    }
                    if (modelElement instanceof AliasType) {
                        errorBuf.append('(').append(((AliasType)modelElement).getAlias()).append(")\n");
                    } else {
                        errorBuf.append('(').append(modelElement.getElementName()).append(")\n");
                    }
                }
                ++n;
            }
            Assert.fail((String)errorBuf.toString());
        }
    }

    private String getCursor(PdttFile pdttFile) {
        Map<String, String> config = pdttFile.getConfig();
        return config.get("cursor");
    }

    private static abstract class TestCompletionRequestor
    extends CompletionRequestor
    implements IPHPCompletionRequestor {
        private IStructuredDocument document;
        private int offset;

        public TestCompletionRequestor(IStructuredDocument document, int offset) {
            this.document = document;
            this.offset = offset;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public boolean isExplicit() {
            return true;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public boolean filter(int flag) {
            return false;
        }

        public void addFlag(int flag) {
        }
    }
}

