/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.semantic_highlighter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.problem.DefaultProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildState;
import org.eclipse.dltk.internal.core.builder.SourceModuleBuildContext;
import org.eclipse.jface.text.Position;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.builder.TaskTagBuildParticipantFactory;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.ClassHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.ConstantHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.DeprecatedHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.FieldHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.FunctionHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.InternalClassHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.InternalConstantHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.InternalFunctionHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.MethodHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.ParameterVariableHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.StaticFieldHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.StaticMethodHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.SuperGlobalHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.TaskTagHighlighting;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class SemanticHighlightingTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    protected IProject project;
    protected IFile testFile;
    protected List<IFile> otherFiles = null;
    protected PHPVersion phpVersion;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private static Map<String, AbstractSemanticHighlighting> highlighters;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/semantic_highlighting/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/semantic_highlighting/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/semantic_highlighting/php54"});
        TESTS.put(PHPVersion.PHP7_1, new String[]{"/workspace/semantic_highlighting/php71"});
        TESTS.put(PHPVersion.PHP8_0, new String[]{"/workspace/semantic_highlighting/php71", "/workspace/semantic_highlighting/php80"});
        TESTS.put(PHPVersion.PHP8_1, new String[]{"/workspace/semantic_highlighting/php71", "/workspace/semantic_highlighting/php80"});
        TESTS.put(PHPVersion.PHP8_2, new String[]{"/workspace/semantic_highlighting/php71", "/workspace/semantic_highlighting/php80"});
        TESTS.put(PHPVersion.PHP8_3, new String[]{"/workspace/semantic_highlighting/php71", "/workspace/semantic_highlighting/php80"});
        highlighters = new HashMap<String, AbstractSemanticHighlighting>();
        highlighters.put("class", (AbstractSemanticHighlighting)new ClassHighlighting());
        highlighters.put("constant", (AbstractSemanticHighlighting)new ConstantHighlighting());
        highlighters.put("deprecated", (AbstractSemanticHighlighting)new DeprecatedHighlighting());
        highlighters.put("field", (AbstractSemanticHighlighting)new FieldHighlighting());
        highlighters.put("function", (AbstractSemanticHighlighting)new FunctionHighlighting());
        highlighters.put("internal_class", (AbstractSemanticHighlighting)new InternalClassHighlighting());
        highlighters.put("internal_constant", (AbstractSemanticHighlighting)new InternalConstantHighlighting());
        highlighters.put("internal_function", (AbstractSemanticHighlighting)new InternalFunctionHighlighting());
        highlighters.put("method", (AbstractSemanticHighlighting)new MethodHighlighting());
        highlighters.put("parameter_variable", (AbstractSemanticHighlighting)new ParameterVariableHighlighting());
        highlighters.put("static_field", (AbstractSemanticHighlighting)new StaticFieldHighlighting());
        highlighters.put("static_method", (AbstractSemanticHighlighting)new StaticMethodHighlighting());
        highlighters.put("super_global", (AbstractSemanticHighlighting)new SuperGlobalHighlighting());
        highlighters.put("task_tags", (AbstractSemanticHighlighting)new TaskTagHighlighting());
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    public SemanticHighlightingTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        TestUtils.disableColliders((TestUtils.ColliderType)TestUtils.ColliderType.ALL);
        this.project = TestUtils.createProject((String)("SemanticHighlighting_" + String.valueOf(this.phpVersion)));
        TestUtils.setProjectPHPVersion((IProject)this.project, (PHPVersion)this.phpVersion);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TaskPatternsProvider.unregisterProject((IProject)this.project);
        this.setDefaultTaskTagPreferences();
        TestUtils.deleteProject((IProject)this.project);
        TestUtils.enableColliders((TestUtils.ColliderType)TestUtils.ColliderType.ALL);
    }

    @After
    public void tearDown() throws Exception {
        if (this.testFile != null) {
            TestUtils.deleteFile((IFile)this.testFile);
        }
        if (this.otherFiles != null) {
            for (IFile file : this.otherFiles) {
                if (file == null) continue;
                TestUtils.deleteFile((IFile)file);
            }
            this.otherFiles = null;
        }
    }

    private void setDefaultTaskTagPreferences() throws CoreException {
        Object preferences = "org.eclipse.php.core/org.eclipse.php.core.taskTags=TODO,FIXME,XXX,@todo\n";
        preferences = (String)preferences + "org.eclipse.php.core/org.eclipse.php.core.taskPriorities=NORMAL,HIGH,NORMAL,NORMAL\n";
        preferences = (String)preferences + "org.eclipse.php.core/org.eclipse.php.core.taskCaseSensitive=enabled\n";
        Platform.getPreferencesService().importPreferences((InputStream)new ByteArrayInputStream(((String)preferences).getBytes()));
    }

    private void build(ISourceModule module) throws CoreException {
        TaskTagBuildParticipantFactory factory = new TaskTagBuildParticipantFactory(){

            public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
                this.natureId = "org.eclipse.php.core.PHPNature";
            }
        };
        factory.setInitializationData(null, null, null);
        IBuildParticipant buildParticipant = factory.createBuildParticipant(module.getScriptProject());
        DefaultProblemFactory problemFactory = new DefaultProblemFactory();
        IBuildState buildState = new IBuildState(){

            public void recordStructuralChange(IPath path) {
            }

            public void recordImportProblem(IPath path) {
            }

            public void recordDependency(IPath path, IPath dependency, int flags) {
            }

            public void recordDependency(IPath path, IPath dependency) {
            }

            public Set<IPath> getStructuralChanges() {
                return null;
            }
        };
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module, null);
        if (moduleDeclaration instanceof PHPModuleDeclaration) {
            SourceModuleBuildContext context = new SourceModuleBuildContext((IProblemFactory)problemFactory, module, 1, buildState);
            context.set(IBuildContext.ATTR_MODULE_DECLARATION, (Object)moduleDeclaration);
            buildParticipant.build((IBuildContext)context);
        }
    }

    @Test
    public void highlighter(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        this.setDefaultTaskTagPreferences();
        pdttFile.applyPreferences();
        Object result = "";
        this.createFile(pdttFile);
        ISourceModule module = this.getSourceModule();
        Assert.assertNotNull((Object)module);
        String index = fileName.substring(fileName.lastIndexOf(47) + 1, fileName.indexOf(46));
        int endIndex = index.indexOf(45);
        if (endIndex != -1) {
            index = index.substring(0, endIndex);
        }
        AbstractSemanticHighlighting highlighter = highlighters.get(index);
        Assert.assertNotNull((Object)highlighter);
        this.build(module);
        Program program = this.getProgram(module);
        Position[] positions = highlighter.consumes(program);
        this.assertNoDuplicates(highlighter.getDisplayName(), positions);
        result = (String)result + highlighter.getClass().getName() + ":\n";
        Position[] positionArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Position position = positionArray[n2];
            result = (String)result + "highlight(" + pdttFile.getFile().substring(position.getOffset(), position.getOffset() + position.getLength()) + ")\n";
            ++n2;
        }
        Assert.assertEquals((Object)pdttFile.getExpected(), (Object)result);
        for (AbstractSemanticHighlighting h : highlighters.values()) {
            if (h == highlighter) continue;
            positions = h.consumes(program);
            this.assertNoDuplicates(highlighter.getDisplayName(), positions);
        }
    }

    private Program getProgram(ISourceModule module) throws ModelException, IOException {
        return SharedASTProvider.getAST((ISourceModule)module, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
    }

    protected void assertNoDuplicates(String highlighter, Position[] positions) {
        Position[] positionArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Position p1 = positionArray[n2];
            Position[] positionArray2 = positions;
            int n3 = positions.length;
            int n4 = 0;
            while (n4 < n3) {
                Position p2 = positionArray2[n4];
                if (p1 != p2 && p1.equals((Object)p2)) {
                    throw new IllegalStateException("Found duplicate position in " + highlighter + ": " + String.valueOf(p1));
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void createFile(PdttFile pdttFile) throws Exception {
        ResourcesPlugin.getWorkspace().run(m -> {
            this.testFile = TestUtils.createFile((IProject)this.project, (String)"test.php", (String)new String(pdttFile.getFile().getBytes()));
            String[] otherFiles = pdttFile.getOtherFiles();
            this.otherFiles = new ArrayList<IFile>(otherFiles.length);
            int i = 0;
            String[] stringArray = otherFiles;
            int n = otherFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String otherFileContent = stringArray[n2];
                IFile tmp = TestUtils.createFile((IProject)this.project, (String)String.format("test%s.php", i), (String)otherFileContent);
                this.otherFiles.add(i, tmp);
                ++i;
                ++n2;
            }
        }, null);
        TestUtils.waitForIndexer();
    }

    protected ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)this.testFile);
    }
}

