/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.DragEvent;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.gestures.AbstractGesture;
import org.eclipse.gef.mvc.fx.handlers.IOnDragDropHandler;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class DragDropGesture
extends AbstractGesture {
    public static final Class<IOnDragDropHandler> ON_DRAGDROP_HANDLER_KEY = IOnDragDropHandler.class;
    private IViewer activeViewer;
    private final Set<Scene> scenes = Collections.newSetFromMap(new IdentityHashMap());
    private final EventHandler<DragEvent> dragEnteredFilter = new EventHandler<DragEvent>(){

        public void handle(DragEvent event) {
            EventTarget target = event.getTarget();
            if (target instanceof Node) {
                DragDropGesture.this.dragEntered((Node)target, event);
            }
        }
    };
    private final EventHandler<DragEvent> dragExitedFilter = new EventHandler<DragEvent>(){

        public void handle(DragEvent event) {
            EventTarget target = event.getTarget();
            if (target instanceof Node) {
                DragDropGesture.this.dragExited((Node)target, event);
            }
        }
    };
    private final EventHandler<DragEvent> dragOverFilter = new EventHandler<DragEvent>(){

        public void handle(DragEvent event) {
            EventTarget target = event.getTarget();
            if (event.getGestureSource() != target && target instanceof Node) {
                Node targetNode = (Node)target;
                DragDropGesture.this.dragOver(targetNode, event);
            }
        }
    };
    private final EventHandler<DragEvent> dragDroppedFilter = new EventHandler<DragEvent>(){

        public void handle(DragEvent event) {
            DragDropGesture.this.dragDropped(event);
        }
    };
    private final ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (DragDropGesture.this.activeViewer == null) {
                return;
            }
            for (IViewer v : DragDropGesture.this.getDomain().getViewers().values()) {
                if (!v.isViewerFocused()) continue;
                return;
            }
            DragDropGesture.this.clearActiveHandlers(DragDropGesture.this.activeViewer);
            DragDropGesture.this.activeViewer = null;
        }
    };

    @Override
    protected void doActivate() {
        super.doActivate();
        ChangeListener sceneListener = (exp, oldScene, newScene) -> {
            if (oldScene != null && this.getDomain().getViewers().values().stream().noneMatch(v -> v.getCanvas().getScene() == oldScene)) {
                this.unhookScene((Scene)oldScene);
            }
            if (newScene != null) {
                this.hookScene((Scene)newScene);
            }
        };
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            viewer.viewerFocusedProperty().addListener(this.viewerFocusChangeListener);
            ReadOnlyObjectProperty sceneProperty = viewer.getCanvas().sceneProperty();
            sceneProperty.addListener(sceneListener);
            if (sceneProperty.get() == null) continue;
            sceneListener.changed((ObservableValue)sceneProperty, null, sceneProperty.get());
        }
    }

    @Override
    protected void doDeactivate() {
        for (Scene scene : new ArrayList<Scene>(this.scenes)) {
            this.unhookScene(scene);
        }
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListener);
        }
        super.doDeactivate();
    }

    protected void dragDropped(DragEvent event) {
        if (this.activeViewer == null) {
            return;
        }
        Scene scene = this.activeViewer.getRootPart().getVisual().getScene();
        if (scene == null) {
            throw new IllegalStateException("Active viewer's root part visual is not in Scene.");
        }
        List<IOnDragDropHandler> handlers = this.getActiveHandlers(this.activeViewer);
        if (handlers.isEmpty()) {
            this.activeViewer = null;
            return;
        }
        this.getDomain().openExecutionTransaction(this);
        for (IOnDragDropHandler policy : handlers) {
            policy.dragDropped(event);
        }
        this.clearActiveHandlers(this.activeViewer);
        this.activeViewer = null;
        this.getDomain().closeExecutionTransaction(this);
    }

    protected void dragEntered(Node target, DragEvent event) {
        IViewer viewer = PartUtils.retrieveViewer(this.getDomain(), target);
        List<IOnDragDropHandler> dragDropPolicies = this.getHandlerResolver().resolve(this, target, viewer, ON_DRAGDROP_HANDLER_KEY);
        if (dragDropPolicies != null && !dragDropPolicies.isEmpty()) {
            for (IOnDragDropHandler dragDropPolicy : dragDropPolicies) {
                dragDropPolicy.dragEntered(event);
            }
        }
    }

    protected void dragExited(Node target, DragEvent event) {
        IViewer viewer = PartUtils.retrieveViewer(this.getDomain(), target);
        List<IOnDragDropHandler> dragDropPolicies = this.getHandlerResolver().resolve(this, target, viewer, ON_DRAGDROP_HANDLER_KEY);
        if (dragDropPolicies != null && !dragDropPolicies.isEmpty()) {
            for (IOnDragDropHandler dragDropPolicy : dragDropPolicies) {
                dragDropPolicy.dragExited(event);
            }
        }
    }

    protected void dragOver(Node target, DragEvent event) {
        Scene scene;
        IViewer viewer = PartUtils.retrieveViewer(this.getDomain(), target);
        if (viewer == null) {
            return;
        }
        if (viewer instanceof InfiniteCanvasViewer) {
            InfiniteCanvas canvas = ((InfiniteCanvasViewer)viewer).getCanvas();
            if (event.getTarget() instanceof Node) {
                Node targetNode = (Node)event.getTarget();
                while (targetNode != null) {
                    if (targetNode == canvas.getHorizontalScrollBar() || targetNode == canvas.getVerticalScrollBar()) {
                        return;
                    }
                    targetNode = targetNode.getParent();
                }
            }
        }
        if ((scene = target.getScene()) == null) {
            return;
        }
        this.activeViewer = PartUtils.retrieveViewer(this.getDomain(), target);
        List<IOnDragDropHandler> dragDropPolicies = this.getHandlerResolver().resolve(this, target, this.activeViewer, ON_DRAGDROP_HANDLER_KEY);
        this.setActiveHandlers(this.activeViewer, dragDropPolicies);
        if (dragDropPolicies != null && !dragDropPolicies.isEmpty()) {
            for (IOnDragDropHandler dragDropPolicy : dragDropPolicies) {
                dragDropPolicy.dragOver(event);
            }
        }
    }

    public List<IOnDragDropHandler> getActiveHandlers(IViewer viewer) {
        return super.getActiveHandlers(viewer);
    }

    private void hookScene(Scene scene) {
        if (this.scenes.contains(scene)) {
            return;
        }
        scene.addEventFilter(DragEvent.DRAG_ENTERED, this.dragEnteredFilter);
        scene.addEventFilter(DragEvent.DRAG_EXITED, this.dragExitedFilter);
        scene.addEventFilter(DragEvent.DRAG_OVER, this.dragOverFilter);
        scene.addEventFilter(DragEvent.DRAG_DROPPED, this.dragDroppedFilter);
        this.scenes.add(scene);
    }

    private void unhookScene(Scene scene) {
        scene.removeEventFilter(DragEvent.DRAG_ENTERED, this.dragEnteredFilter);
        scene.removeEventFilter(DragEvent.DRAG_EXITED, this.dragExitedFilter);
        scene.removeEventFilter(DragEvent.DRAG_OVER, this.dragOverFilter);
        scene.removeEventFilter(DragEvent.DRAG_DROPPED, this.dragDroppedFilter);
    }
}

