/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.mvc.fx.parts.HoverFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public class DefaultHoverFeedbackPartFactory
implements IFeedbackPartFactory {
    public static final String HOVER_FEEDBACK_COLOR_PROVIDER = "HOVER_FEEDBACK_COLOR_PROVIDER";
    public static final String HOVER_FEEDBACK_GEOMETRY_PROVIDER = "HOVER_FEEDBACK_GEOMETRY_PROVIDER";
    public static final Color DEFAULT_HOVER_FEEDBACK_COLOR = Color.web((String)"#5a61af");
    @Inject
    private Injector injector;

    @Override
    public List<IFeedbackPart<? extends Node>> createFeedbackParts(List<? extends IVisualPart<? extends Node>> targets, Map<Object, Object> contextMap) {
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Part factory is called without targets.");
        }
        if (targets.size() > 1) {
            throw new IllegalArgumentException("Cannot create feedback for multiple targets.");
        }
        final IVisualPart<? extends Node> target = targets.iterator().next();
        ArrayList<IFeedbackPart<? extends Node>> feedbackParts = new ArrayList<IFeedbackPart<? extends Node>>();
        final Provider hoverFeedbackGeometryProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)HOVER_FEEDBACK_GEOMETRY_PROVIDER));
        if (hoverFeedbackGeometryProvider != null) {
            Provider<IGeometry> geometryInSceneProvider = new Provider<IGeometry>(){

                public IGeometry get() {
                    return NodeUtils.localToScene(target.getVisual(), (IGeometry)((IGeometry)hoverFeedbackGeometryProvider.get()));
                }
            };
            HoverFeedbackPart part = (HoverFeedbackPart)this.injector.getInstance(HoverFeedbackPart.class);
            part.setGeometryProvider((Provider<? extends IGeometry>)geometryInSceneProvider);
            feedbackParts.add(part);
        }
        return feedbackParts;
    }
}

