/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.gef.GEFColorProvider;
import org.eclipse.gef.internal.ui.palette.PaletteColorUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class PaletteColorProvider
extends GEFColorProvider {
    private static final Color HOVER_COLOR_HICONTRAST = new Color(null, 0, 128, 0);
    private static final Color SELECTED_COLOR_HICONTRAST = new Color(null, 128, 0, 128);
    private final Map<Double, Color> mixedButtonDarker = new HashMap<Double, Color>();
    private Color hotspotColor;
    public static final PaletteColorProvider INSTANCE = new PaletteColorProvider();

    protected PaletteColorProvider() {
    }

    @Override
    public Color getListSelectedBackgroundColor() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display.getHighContrast()) {
            return SELECTED_COLOR_HICONTRAST;
        }
        return ColorConstants.listSelectedBackgroundColor;
    }

    @Override
    public Color getListHoverBackgroundColor() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display.getHighContrast()) {
            return HOVER_COLOR_HICONTRAST;
        }
        return ColorConstants.listHoverBackgroundColor;
    }

    @Override
    public Color getButton() {
        return ColorConstants.button;
    }

    @Override
    public Color getButtonDarker() {
        return ColorConstants.buttonDarker;
    }

    @Override
    public Color getButtonDarkest() {
        return ColorConstants.buttonDarkest;
    }

    public final Color getButtonDarker(double weight) {
        if (weight < 0.0 || weight > 1.0) {
            throw new IllegalArgumentException("The weight %d must be within [0, 1]".formatted(weight));
        }
        return this.mixedButtonDarker.computeIfAbsent(weight, ignore -> FigureUtilities.mixColors((Color)this.getButton(), (Color)this.getButtonDarker(), (double)weight));
    }

    public final Color getHotspotColor() {
        if (this.hotspotColor == null) {
            this.hotspotColor = FigureUtilities.mixColors((Color)PaletteColorUtil.WIDGET_LIST_BACKGROUND, (Color)this.getButtonDarker(), (double)0.6);
        }
        return this.hotspotColor;
    }
}

