/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.examples.layouts;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.zest.core.widgets.DefaultSubgraph;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.core.widgets.SubgraphFactory;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpaceTreeLayoutAlgorithm;

public class SpaceTreeExample {
    static Graph g;
    static GraphNode source;
    static GraphNode target;
    static boolean changesSeries;

    static {
        changesSeries = false;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        d = new Display();
        shell = new Shell(d);
        shell.setText("GraphSnippet1");
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(400, 400);
        SpaceTreeExample.g = new Graph((Composite)shell, 0);
        SpaceTreeExample.g.setConnectionStyle(2);
        SpaceTreeExample.g.setNodeStyle(4);
        factory = new DefaultSubgraph.TriangleSubgraphFactory();
        factory.setColor(ColorConstants.green);
        SpaceTreeExample.g.setSubgraphFactory((SubgraphFactory)factory);
        spaceTreeLayoutAlgorithm = new SpaceTreeLayoutAlgorithm();
        SpaceTreeExample.g.setExpandCollapseManager(spaceTreeLayoutAlgorithm.getExpandCollapseManager());
        SpaceTreeExample.g.setLayoutAlgorithm((LayoutAlgorithm)spaceTreeLayoutAlgorithm, false);
        SpaceTreeExample.createTree(SpaceTreeExample.g, "!", 5, 5);
        SpaceTreeExample.hookMenu(SpaceTreeExample.g);
        shell.open();
        ** GOTO lbl24
        {
            d.sleep();
            do {
                if (!d.readAndDispatch()) continue block0;
lbl24:
                // 2 sources

            } while (!shell.isDisposed());
        }
    }

    private static GraphNode createTree(Graph g, String rootTitle, int depth, int breadth) {
        GraphNode root = new GraphNode((IContainer)g, 0, rootTitle);
        if (depth > 0) {
            int i = 0;
            while (i < breadth) {
                GraphNode child = SpaceTreeExample.createTree(g, rootTitle + i, depth - 1 - i, breadth - i);
                new GraphConnection(g, 0, root, child);
                ++i;
            }
        }
        return root;
    }

    private static void hookMenu(Graph g) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(SpaceTreeExample::fillContextMenu);
        g.setMenu(menuMgr.createContextMenu((Control)g));
    }

    private static void fillContextMenu(IMenuManager menuMgr) {
        List selection = g.getSelection();
        if (selection.size() == 1) {
            if (selection.get(0) instanceof GraphNode) {
                final GraphNode node = (GraphNode)selection.get(0);
                if (g.canExpand(node)) {
                    Action expandAction = new Action(){

                        public void run() {
                            g.setExpanded(node, true);
                        }
                    };
                    expandAction.setText("expand");
                    menuMgr.add((IAction)expandAction);
                }
                if (g.canCollapse(node)) {
                    Action collapseAction = new Action(){

                        public void run() {
                            g.setExpanded(node, false);
                        }
                    };
                    collapseAction.setText("collapse");
                    menuMgr.add((IAction)collapseAction);
                }
                Action disposeAction = new Action(){

                    public void run() {
                        node.dispose();
                    }
                };
                disposeAction.setText("dispose");
                menuMgr.add((IAction)disposeAction);
                Action asSourceAction = new Action(){

                    public void run() {
                        source = node;
                        SpaceTreeExample.addConnection();
                    }
                };
                asSourceAction.setText("use as source");
                menuMgr.add((IAction)asSourceAction);
                Action asTargetAction = new Action(){

                    public void run() {
                        target = node;
                        SpaceTreeExample.addConnection();
                    }
                };
                asTargetAction.setText("use as target");
                menuMgr.add((IAction)asTargetAction);
            }
            if (selection.get(0) instanceof GraphConnection) {
                final GraphConnection connection = (GraphConnection)selection.get(0);
                Action removeAction = new Action(){

                    public void run() {
                        connection.dispose();
                    }
                };
                removeAction.setText("remove");
                menuMgr.add((IAction)removeAction);
            }
        }
        if (selection.size() == 0) {
            Action addNode = new Action(){

                public void run() {
                    new GraphNode((IContainer)g, 0, "new!");
                }
            };
            addNode.setText("add node");
            menuMgr.add((IAction)addNode);
            if (!changesSeries) {
                Action startChangesSeries = new Action(){

                    public void run() {
                        g.setDynamicLayout(false);
                        changesSeries = true;
                    }
                };
                startChangesSeries.setText("start changes");
                menuMgr.add((IAction)startChangesSeries);
            } else {
                Action endChangesSeries = new Action(){

                    public void run() {
                        g.setDynamicLayout(true);
                        changesSeries = false;
                    }
                };
                endChangesSeries.setText("end changes");
                menuMgr.add((IAction)endChangesSeries);
            }
        }
    }

    private static void addConnection() {
        if (source != null && target != null) {
            new GraphConnection(g, 0, source, target);
            target = null;
            source = null;
        }
    }
}

