/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.uml;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;

public class StickyNote
extends FlowPage {
    private TextFlow text = new TextFlow();

    public StickyNote() {
        this.setBorder((Border)new DogEar());
        this.add((IFigure)this.text);
        this.text.setText("This is a sticky note.  It wraps text based on its width.");
        this.setBackgroundColor(ColorConstants.tooltipBackground);
        this.setOpaque(true);
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        PointList pl = new PointList(5);
        pl.addPoint(r.getTopLeft());
        pl.addPoint(r.getTopRight().translate(-6, 0));
        pl.addPoint(r.getTopRight().translate(0, 6));
        pl.addPoint(r.getBottomRight());
        pl.addPoint(r.getBottomLeft());
        g.fillPolygon(pl);
    }

    static class DogEar
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(3, 3, 3, 3);

        DogEar() {
        }

        public Insets getInsets(IFigure figure) {
            return INSETS;
        }

        public void paint(IFigure figure, Graphics g, Insets insets) {
            Rectangle r = DogEar.getPaintRectangle((IFigure)figure, (Insets)insets);
            r.resize(-1, -1);
            int[] nArray = new int[6];
            nArray[0] = -5;
            nArray[1] = 5;
            nArray[3] = 5;
            nArray[4] = -5;
            PointList pl = new PointList(nArray);
            pl.translate(r.getTopRight());
            g.drawPolygon(pl);
            g.drawLine(r.getTopLeft(), r.getTopRight().translate(-5, 0));
            g.drawLine(r.getTopLeft(), r.getTopLeft());
            g.drawLine(r.getBottomLeft(), r.getBottomRight());
            g.drawLine(r.getTopRight().translate(0, 5), r.getBottomRight());
            g.drawLine(r.getTopLeft(), r.getBottomLeft());
        }
    }
}

