/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.IToggleRefactoringStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleFromClassToInHeaderStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleFromImplementationToHeaderOrClassStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleFromInHeaderToClassStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleFromInHeaderToImplementationStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringContext;

public class ToggleStrategyFactory {
    private ToggleRefactoringContext context;

    public ToggleStrategyFactory(ToggleRefactoringContext context) {
        this.context = context;
    }

    public IToggleRefactoringStrategy getAppropriateStategy() {
        if (this.context.getDefinition() == null) {
            throw new NotSupportedException(Messages.ToggleStrategyFactory_NoDefinitionFound);
        }
        if (!this.context.getDefinitionAST().isHeaderUnit()) {
            return new ToggleFromImplementationToHeaderOrClassStrategy(this.context);
        }
        if (this.isInClassSituation()) {
            return new ToggleFromClassToInHeaderStrategy(this.context);
        }
        if (this.isTemplateSituation()) {
            return new ToggleFromInHeaderToClassStrategy(this.context);
        }
        if (this.isinHeaderSituation()) {
            return new ToggleFromInHeaderToImplementationStrategy(this.context);
        }
        throw new NotSupportedException(Messages.ToggleStrategyFactory_UnsupportedSituation);
    }

    private boolean isinHeaderSituation() {
        return this.context.getDefinition() != null && this.context.getDefinitionAST().isHeaderUnit();
    }

    private boolean isInClassSituation() {
        return this.context.getDeclaration() == null && ASTQueries.findAncestorWithType((IASTNode)this.context.getDefinition(), IASTCompositeTypeSpecifier.class) != null;
    }

    private boolean isTemplateSituation() {
        return ASTQueries.findAncestorWithType((IASTNode)this.context.getDefinition(), ICPPASTTemplateDeclaration.class) != null;
    }
}

