/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.parser.ConflictedParser;
import org.eclipse.jdt.internal.compiler.parser.NLSTag;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.parser.TerminalToken;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.CharDeduplication;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Scanner {
    public long sourceLevel;
    public long complianceLevel;
    public boolean useAssertAsAnIndentifier = false;
    public boolean containsAssertKeyword = false;
    public boolean previewEnabled;
    public boolean useEnumAsAnIndentifier = false;
    public boolean recordLineSeparator = false;
    public char currentCharacter;
    public int startPosition;
    public int currentPosition;
    public int initialPosition;
    public int eofPosition;
    public boolean skipComments = false;
    public boolean tokenizeComments = false;
    public boolean tokenizeWhiteSpace = false;
    public char[] source;
    public char[] withoutUnicodeBuffer;
    public int withoutUnicodePtr;
    public boolean unicodeAsBackSlash = false;
    public boolean scanningFloatLiteral = false;
    public static final int COMMENT_ARRAYS_SIZE = 30;
    public int[] commentStops = new int[30];
    public int[] commentStarts = new int[30];
    public boolean[] commentIsMarkdown = new boolean[30];
    public int[] commentTagStarts = new int[30];
    public int commentPtr = -1;
    public int lastCommentLinePosition = -1;
    public char[][] foundTaskTags = null;
    public char[][] foundTaskMessages;
    public char[][] foundTaskPriorities = null;
    public int[][] foundTaskPositions;
    public int foundTaskCount = 0;
    public char[][] taskTags = null;
    public char[][] taskPriorities = null;
    public boolean isTaskCaseSensitive = true;
    public boolean diet = false;
    public int[] lineEnds = new int[250];
    public int linePtr = -1;
    public boolean wasAcr = false;
    public boolean fakeInModule = false;
    boolean inCondition = false;
    boolean breakPreviewAllowed = false;
    protected ScanContext scanContext = null;
    protected boolean insideModuleInfo = false;
    public static final String END_OF_SOURCE = "End_Of_Source";
    public static final String INVALID_HEXA = "Invalid_Hexa_Literal";
    public static final String INVALID_OCTAL = "Invalid_Octal_Literal";
    public static final String INVALID_CHARACTER_CONSTANT = "Invalid_Character_Constant";
    public static final String INVALID_ESCAPE = "Invalid_Escape";
    public static final String INVALID_INPUT = "Invalid_Input";
    public static final String INVALID_TEXTBLOCK = "Invalid_Textblock";
    public static final String INVALID_UNICODE_ESCAPE = "Invalid_Unicode_Escape";
    public static final String INVALID_FLOAT = "Invalid_Float_Literal";
    public static final String INVALID_LOW_SURROGATE = "Invalid_Low_Surrogate";
    public static final String INVALID_HIGH_SURROGATE = "Invalid_High_Surrogate";
    public static final String NULL_SOURCE_STRING = "Null_Source_String";
    public static final String UNTERMINATED_STRING = "Unterminated_String";
    public static final String UNTERMINATED_TEXT_BLOCK = "Unterminated_Text_Block";
    public static final String UNTERMINATED_COMMENT = "Unterminated_Comment";
    public static final String INVALID_CHAR_IN_STRING = "Invalid_Char_In_String";
    public static final String INVALID_DIGIT = "Invalid_Digit";
    private static final int[] EMPTY_LINE_ENDS = Util.EMPTY_INT_ARRAY;
    public static final String INVALID_BINARY = "Invalid_Binary_Literal";
    public static final String BINARY_LITERAL_NOT_BELOW_17 = "Binary_Literal_Not_Below_17";
    public static final String ILLEGAL_HEXA_LITERAL = "Illegal_Hexa_Literal";
    public static final String INVALID_UNDERSCORE = "Invalid_Underscore";
    public static final String UNDERSCORES_IN_LITERALS_NOT_BELOW_17 = "Underscores_In_Literals_Not_Below_17";
    public static final char[] TAG_PREFIX = "//$NON-NLS-".toCharArray();
    public static final int TAG_PREFIX_LENGTH = TAG_PREFIX.length;
    public static final char TAG_POSTFIX = '$';
    public static final int TAG_POSTFIX_LENGTH = 1;
    public static final char[] IDENTITY_COMPARISON_TAG = "//$IDENTITY-COMPARISON$".toCharArray();
    public boolean[] validIdentityComparisonLines;
    public boolean checkUninternedIdentityComparison;
    private NLSTag[] nlsTags = null;
    protected int nlsTagsPtr;
    public boolean checkNonExternalizedStringLiterals;
    protected int lastPosition;
    public boolean returnOnlyGreater = false;
    public boolean insideRecovery = false;
    TerminalToken[] lookBack = new TerminalToken[2];
    protected TerminalToken nextToken = TerminalToken.TokenNameNotAToken;
    private VanguardScanner vanguardScanner;
    private VanguardParser vanguardParser;
    ConflictedParser activeParser = null;
    private boolean consumingEllipsisAnnotations = false;
    public boolean scanningSwitchLabel = false;
    public static final int RoundBracket = 0;
    public static final int SquareBracket = 1;
    public static final int CurlyBracket = 2;
    public static final int BracketKinds = 3;
    public static final int LOW_SURROGATE_MIN_VALUE = 56320;
    public static final int HIGH_SURROGATE_MIN_VALUE = 55296;
    public static final int HIGH_SURROGATE_MAX_VALUE = 56319;
    public static final int LOW_SURROGATE_MAX_VALUE = 57343;
    protected int rawStart = -1;
    private final CharDeduplication deduplication = CharDeduplication.getThreadLocalInstance();

    public Scanner() {
        this(false, false, false, 0x2F0000L, null, null, true);
    }

    public Scanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean checkNonExternalizedStringLiterals, long sourceLevel, long complianceLevel, char[][] taskTags, char[][] taskPriorities, boolean isTaskCaseSensitive, boolean isPreviewEnabled) {
        this.eofPosition = Integer.MAX_VALUE;
        this.tokenizeComments = tokenizeComments;
        this.tokenizeWhiteSpace = tokenizeWhiteSpace;
        this.sourceLevel = sourceLevel;
        this.resetLookBack();
        this.nextToken = TerminalToken.TokenNameNotAToken;
        this.consumingEllipsisAnnotations = false;
        this.complianceLevel = complianceLevel;
        this.checkNonExternalizedStringLiterals = checkNonExternalizedStringLiterals;
        this.previewEnabled = isPreviewEnabled;
        this.scanningSwitchLabel = false;
        if (taskTags != null) {
            int taskTagsLength;
            int length = taskTagsLength = ((char[][])taskTags).length;
            if (taskPriorities != null) {
                int taskPrioritiesLength = ((char[][])taskPriorities).length;
                if (taskPrioritiesLength != taskTagsLength) {
                    if (taskPrioritiesLength > taskTagsLength) {
                        char[][] cArray = taskPriorities;
                        char[][] cArrayArray = new char[taskTagsLength][];
                        taskPriorities = cArrayArray;
                        System.arraycopy(cArray, 0, cArrayArray, 0, taskTagsLength);
                    } else {
                        char[][] cArray = taskTags;
                        char[][] cArrayArray = new char[taskPrioritiesLength][];
                        taskTags = cArrayArray;
                        System.arraycopy(cArray, 0, cArrayArray, 0, taskPrioritiesLength);
                        length = taskPrioritiesLength;
                    }
                }
                int[] initialIndexes = new int[length];
                int i = 0;
                while (i < length) {
                    initialIndexes[i] = i;
                    ++i;
                }
                Util.reverseQuickSort(taskTags, 0, length - 1, initialIndexes);
                char[][] temp = new char[length][];
                int i2 = 0;
                while (i2 < length) {
                    temp[i2] = taskPriorities[initialIndexes[i2]];
                    ++i2;
                }
                this.taskPriorities = temp;
            } else {
                Util.reverseQuickSort(taskTags, 0, length - 1);
            }
            this.taskTags = taskTags;
            this.isTaskCaseSensitive = isTaskCaseSensitive;
        }
    }

    public Scanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean checkNonExternalizedStringLiterals, long sourceLevel, char[][] taskTags, char[][] taskPriorities, boolean isTaskCaseSensitive, boolean isPreviewEnabled) {
        this(tokenizeComments, tokenizeWhiteSpace, checkNonExternalizedStringLiterals, sourceLevel, sourceLevel, taskTags, taskPriorities, isTaskCaseSensitive, isPreviewEnabled);
    }

    public Scanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean checkNonExternalizedStringLiterals, long sourceLevel, char[][] taskTags, char[][] taskPriorities, boolean isTaskCaseSensitive) {
        this(tokenizeComments, tokenizeWhiteSpace, checkNonExternalizedStringLiterals, sourceLevel, sourceLevel, taskTags, taskPriorities, isTaskCaseSensitive, false);
    }

    public final boolean atEnd() {
        return this.eofPosition <= this.currentPosition;
    }

    /*
     * Unable to fully structure code
     */
    public void checkTaskTag(int commentStart, int commentEnd) throws InvalidInputException {
        src = this.source;
        if (this.foundTaskCount > 0 && this.foundTaskPositions[this.foundTaskCount - 1][0] >= commentStart) {
            return;
        }
        foundTaskIndex = this.foundTaskCount;
        previous = src[commentStart + 1];
        i = commentStart + 2;
        while (i < commentEnd && i < this.eofPosition) {
            tag = null;
            priority = null;
            if (previous != '@') {
                itag = 0;
                while (itag < this.taskTags.length) {
                    block25: {
                        tag = this.taskTags[itag];
                        tagLength = tag.length;
                        if (!(tagLength == 0 || ScannerHelper.isJavaIdentifierStart(this.complianceLevel, tag[0]) && ScannerHelper.isJavaIdentifierPart(this.complianceLevel, previous))) {
                            t = 0;
                            while (t < tagLength) {
                                x = i + t;
                                if (x < this.eofPosition && x < commentEnd && ((sc = src[i + t]) == (tc = tag[t]) || !this.isTaskCaseSensitive && ScannerHelper.toLowerCase(sc) == ScannerHelper.toLowerCase(tc))) {
                                    ++t;
                                    continue;
                                }
                                break block25;
                            }
                            if (i + tagLength >= commentEnd || !ScannerHelper.isJavaIdentifierPart(this.complianceLevel, src[i + tagLength - 1]) || !ScannerHelper.isJavaIdentifierPart(this.complianceLevel, src[i + tagLength])) {
                                if (this.foundTaskTags == null) {
                                    this.foundTaskTags = new char[5][];
                                    this.foundTaskMessages = new char[5][];
                                    this.foundTaskPriorities = new char[5][];
                                    this.foundTaskPositions = new int[5][];
                                } else if (this.foundTaskCount == this.foundTaskTags.length) {
                                    v0 = new char[this.foundTaskCount * 2][];
                                    this.foundTaskTags = v0;
                                    System.arraycopy(this.foundTaskTags, 0, v0, 0, this.foundTaskCount);
                                    v1 = new char[this.foundTaskCount * 2][];
                                    this.foundTaskMessages = v1;
                                    System.arraycopy(this.foundTaskMessages, 0, v1, 0, this.foundTaskCount);
                                    v2 = new char[this.foundTaskCount * 2][];
                                    this.foundTaskPriorities = v2;
                                    System.arraycopy(this.foundTaskPriorities, 0, v2, 0, this.foundTaskCount);
                                    v3 = new int[this.foundTaskCount * 2][];
                                    this.foundTaskPositions = v3;
                                    System.arraycopy(this.foundTaskPositions, 0, v3, 0, this.foundTaskCount);
                                }
                                priority = this.taskPriorities != null && itag < this.taskPriorities.length ? this.taskPriorities[itag] : null;
                                this.foundTaskTags[this.foundTaskCount] = tag;
                                this.foundTaskPriorities[this.foundTaskCount] = priority;
                                this.foundTaskPositions[this.foundTaskCount] = new int[]{i, i + tagLength - 1};
                                this.foundTaskMessages[this.foundTaskCount] = CharOperation.NO_CHAR;
                                ++this.foundTaskCount;
                                i += tagLength - 1;
                                break;
                            }
                        }
                    }
                    ++itag;
                }
            }
            previous = src[i];
            ++i;
        }
        containsEmptyTask = false;
        i = foundTaskIndex;
        while (i < this.foundTaskCount) {
            block26: {
                msgStart = this.foundTaskPositions[i][0] + this.foundTaskTags[i].length;
                v4 = max_value = i + 1 < this.foundTaskCount ? this.foundTaskPositions[i + 1][0] - 1 : commentEnd - 1;
                if (max_value < msgStart) {
                    max_value = msgStart;
                }
                end = -1;
                j = msgStart;
                while (j < max_value) {
                    c = src[j];
                    if (c == '\n' || c == '\r') {
                        end = j - 1;
                        break;
                    }
                    ++j;
                }
                if (end == -1) {
                    j = max_value;
                    while (j > msgStart) {
                        c = src[j];
                        if (c == '*') {
                            end = j - 1;
                            break;
                        }
                        --j;
                    }
                    if (end == -1) {
                        end = max_value;
                    }
                }
                if (msgStart != end) ** GOTO lbl88
                containsEmptyTask = true;
                break block26;
lbl-1000:
                // 1 sources

                {
                    --end;
lbl88:
                    // 2 sources

                    ** while (CharOperation.isWhitespace((char)src[end]) && msgStart <= end)
                }
lbl89:
                // 1 sources

                this.foundTaskPositions[i][1] = end;
                messageLength = end - msgStart + 1;
                message = new char[messageLength];
                System.arraycopy(src, msgStart, message, 0, messageLength);
                this.foundTaskMessages[i] = message;
            }
            ++i;
        }
        if (containsEmptyTask) {
            i = foundTaskIndex;
            max = this.foundTaskCount;
            while (i < max) {
                if (this.foundTaskMessages[i].length == 0) {
                    j = i + 1;
                    while (j < max) {
                        if (this.foundTaskMessages[j].length != 0) {
                            this.foundTaskMessages[i] = this.foundTaskMessages[j];
                            this.foundTaskPositions[i][1] = this.foundTaskPositions[j][1];
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public char[] getCurrentIdentifierSource() {
        if (this.withoutUnicodePtr != 0) {
            char[] result = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, result, 0, this.withoutUnicodePtr);
            return result;
        }
        int length = this.currentPosition - this.startPosition;
        if (length == this.eofPosition) {
            return this.source;
        }
        return this.deduplication.sharedCopyOfRange(this.source, this.startPosition, this.currentPosition);
    }

    public int getCurrentTokenEndPosition() {
        return this.currentPosition - 1;
    }

    public char[] getCurrentTokenSource() {
        char[] result;
        if (this.withoutUnicodePtr != 0) {
            result = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, result, 0, this.withoutUnicodePtr);
        } else {
            int length = this.currentPosition - this.startPosition;
            result = new char[length];
            System.arraycopy(this.source, this.startPosition, result, 0, length);
        }
        return result;
    }

    public final String getCurrentTokenString() {
        if (this.withoutUnicodePtr != 0) {
            return new String(this.withoutUnicodeBuffer, 1, this.withoutUnicodePtr);
        }
        return new String(this.source, this.startPosition, this.currentPosition - this.startPosition);
    }

    public char[] getCurrentTokenSourceString() {
        char[] result;
        if (this.withoutUnicodePtr != 0) {
            result = new char[this.withoutUnicodePtr - 2];
            System.arraycopy(this.withoutUnicodeBuffer, 2, result, 0, this.withoutUnicodePtr - 2);
        } else {
            int length = this.currentPosition - this.startPosition - 2;
            result = new char[length];
            System.arraycopy(this.source, this.startPosition + 1, result, 0, length);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean scanForTextBlockBeginning() {
        try {
            int temp = this.currentPosition;
            if (this.source[temp++] != '\"') return false;
            if (this.source[temp++] != '\"') return false;
            char c = this.source[temp++];
            while (true) {
                if (!ScannerHelper.isWhitespace(c)) {
                    return false;
                }
                switch (c) {
                    case '\n': {
                        this.currentCharacter = c;
                        this.currentPosition = temp;
                        return true;
                    }
                }
                c = this.source[temp++];
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean lineBeginsWithMarkdown() throws InvalidInputException {
        char c;
        int count;
        try {
            int temp = this.currentPosition;
            count = 0;
            if (this.currentCharacter == '\r') {
                c = this.source[temp];
                if (c == '\\') {
                    if (this.source[temp + 1] == 'u') {
                        this.getNextUnicodeChar();
                        if (this.currentCharacter == '\n') {
                            this.pushUnicodeLineSeparator();
                        }
                        temp = this.currentPosition;
                    }
                } else if (c == '\n') {
                    // empty if block
                }
            }
            block7: while (true) {
                int n = ++temp;
                ++temp;
                c = this.source[n];
                switch (c) {
                    case '/': {
                        if (++count <= 2) continue block7;
                        this.currentPosition = temp;
                        return true;
                    }
                    case '\n': {
                        return false;
                    }
                }
                break;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        {
            if (!ScannerHelper.isWhitespace(c)) return false;
            if (count != 0) continue;
            continue;
        }
    }

    protected final boolean scanForTextBlockClose() throws InvalidInputException {
        try {
            if (this.source[this.currentPosition] == '\"' && this.source[this.currentPosition + 1] == '\"') {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public char[] getCurrentTextBlock() {
        char[] all;
        if (this.withoutUnicodePtr != 0) {
            all = CharOperation.subarray(this.withoutUnicodeBuffer, this.rawStart + 1, this.withoutUnicodePtr + 1);
        } else {
            all = CharOperation.subarray(this.source, this.startPosition + this.rawStart, this.currentPosition - 3);
            if (all == null) {
                all = new char[]{};
            }
        }
        all = this.normalize(all);
        char[][] lines = CharOperation.splitOn('\n', all);
        int size = lines.length;
        ArrayList<char[]> list = new ArrayList<char[]>(lines.length);
        int i = 0;
        while (i < lines.length) {
            char[] line = lines[i];
            if (i + 1 == size && line.length == 0) {
                list.add(line);
                break;
            }
            char[][] sub = CharOperation.splitOn('\r', line);
            if (sub.length == 0) {
                list.add(line);
            } else {
                char[][] cArray = sub;
                int n = sub.length;
                int n2 = 0;
                while (n2 < n) {
                    char[] cs = cArray[n2];
                    list.add(cs);
                    ++n2;
                }
            }
            ++i;
        }
        size = list.size();
        lines = (char[][])list.toArray((T[])new char[size][]);
        int prefix = -1;
        int i2 = 0;
        while (i2 < size) {
            char[] line = lines[i2];
            boolean blank = true;
            int whitespaces = 0;
            char[] cArray = line;
            int n = line.length;
            int n3 = 0;
            while (n3 < n) {
                char c = cArray[n3];
                if (blank) {
                    if (ScannerHelper.isWhitespace(c)) {
                        ++whitespaces;
                    } else {
                        blank = false;
                    }
                }
                ++n3;
            }
            if (!(blank && i2 + 1 != size || prefix >= 0 && whitespaces >= prefix)) {
                prefix = whitespaces;
            }
            ++i2;
        }
        if (prefix == -1) {
            prefix = 0;
        }
        StringBuilder result = new StringBuilder();
        boolean newLine = false;
        int i3 = 0;
        while (i3 < lines.length) {
            int length;
            char[] l = lines[i3];
            int trail = length = l.length;
            while (trail > 0) {
                if (!ScannerHelper.isWhitespace(l[trail - 1])) break;
                --trail;
            }
            if (i3 >= size - 1) {
                if (newLine) {
                    result.append('\n');
                }
                if (trail >= prefix) {
                    newLine = this.getLineContent(result, l, prefix, trail - 1, false, true);
                }
            } else {
                if (i3 > 0 && newLine) {
                    result.append('\n');
                }
                if (trail <= prefix) {
                    newLine = true;
                } else {
                    boolean merge = length > 0 && l[length - 1] == '\\';
                    newLine = this.getLineContent(result, l, prefix, trail - 1, merge, false);
                }
            }
            ++i3;
        }
        this.rawStart = -1;
        return result.toString().toCharArray();
    }

    private char[] normalize(char[] content) {
        StringBuilder result = new StringBuilder();
        boolean isCR = false;
        char[] cArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\r': {
                    result.append(c);
                    isCR = true;
                    break;
                }
                case '\n': {
                    if (!isCR) {
                        result.append(c);
                    }
                    isCR = false;
                    break;
                }
                default: {
                    result.append(c);
                    isCR = false;
                }
            }
            ++n2;
        }
        return result.toString().toCharArray();
    }

    private boolean getLineContent(StringBuilder result, char[] line, int start, int end, boolean merge, boolean lastLine) {
        char[] chars;
        int lastPointer = 0;
        int i = start;
        block12: while (i < end) {
            char c = line[i];
            if (c != '\\') {
                ++i;
                continue;
            }
            if (i >= end) continue;
            if (lastPointer + 1 <= i) {
                result.append(CharOperation.subarray(line, lastPointer == 0 ? start : lastPointer, i));
            }
            char next = line[++i];
            switch (next) {
                case '\\': {
                    result.append('\\');
                    if (i != end) break;
                    merge = false;
                    break;
                }
                case 's': {
                    result.append(' ');
                    break;
                }
                case '\"': {
                    result.append('\"');
                    break;
                }
                case 'b': {
                    result.append('\b');
                    break;
                }
                case 'n': {
                    result.append('\n');
                    break;
                }
                case 'r': {
                    result.append('\r');
                    break;
                }
                case 't': {
                    result.append('\t');
                    break;
                }
                case 'f': {
                    result.append('\f');
                    break;
                }
                default: {
                    int pos = i + 1;
                    int number = ScannerHelper.getHexadecimalValue(next);
                    if (number >= 0 && number <= 7) {
                        boolean zeroToThreeNot = number > 3;
                        try {
                            next = line[pos];
                            if (ScannerHelper.isDigit(next)) {
                                ++pos;
                                int digit = ScannerHelper.getHexadecimalValue(next);
                                if (digit >= 0 && digit <= 7) {
                                    number = number * 8 + digit;
                                    next = line[pos];
                                    if (ScannerHelper.isDigit(next)) {
                                        ++pos;
                                        if (!zeroToThreeNot && (digit = ScannerHelper.getHexadecimalValue(next)) >= 0 && digit <= 7) {
                                            number = number * 8 + digit;
                                        }
                                    }
                                }
                            }
                        }
                        catch (InvalidInputException invalidInputException) {
                            // empty catch block
                        }
                        if (number < 255) {
                            next = (char)number;
                        }
                        result.append(next);
                        lastPointer = i = pos;
                        continue block12;
                    }
                    result.append(c);
                    lastPointer = i;
                    continue block12;
                }
            }
            lastPointer = ++i;
        }
        end = merge ? end : (end >= line.length ? end : end + 1);
        char[] cArray = chars = lastPointer == 0 ? CharOperation.subarray(line, start, end) : CharOperation.subarray(line, lastPointer, end);
        if (chars != null && chars.length > 0) {
            result.append(chars);
        }
        return !merge && !lastLine;
    }

    public final String getCurrentStringLiteral() {
        if (this.withoutUnicodePtr != 0) {
            return new String(this.withoutUnicodeBuffer, 2, this.withoutUnicodePtr - 2);
        }
        return new String(this.source, this.startPosition + 1, this.currentPosition - this.startPosition - 2);
    }

    public final char[] getRawTokenSource() {
        int length = this.currentPosition - this.startPosition;
        char[] tokenSource = new char[length];
        System.arraycopy(this.source, this.startPosition, tokenSource, 0, length);
        return tokenSource;
    }

    public final char[] getRawTokenSourceEnd() {
        int length = this.eofPosition - this.currentPosition - 1;
        char[] sourceEnd = new char[length];
        System.arraycopy(this.source, this.currentPosition, sourceEnd, 0, length);
        return sourceEnd;
    }

    public int getCurrentTokenStartPosition() {
        return this.startPosition;
    }

    public final int getLineEnd(int lineNumber) {
        if (this.lineEnds == null || this.linePtr == -1) {
            return -1;
        }
        if (lineNumber > this.lineEnds.length + 1) {
            return -1;
        }
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == this.lineEnds.length + 1) {
            return this.eofPosition;
        }
        return this.lineEnds[lineNumber - 1];
    }

    public final int[] getLineEnds() {
        if (this.linePtr == -1) {
            return EMPTY_LINE_ENDS;
        }
        int[] copy = new int[this.linePtr + 1];
        System.arraycopy(this.lineEnds, 0, copy, 0, this.linePtr + 1);
        return copy;
    }

    public final int getLineStart(int lineNumber) {
        if (this.lineEnds == null || this.linePtr == -1) {
            return -1;
        }
        if (lineNumber > this.lineEnds.length + 1) {
            return -1;
        }
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == 1) {
            return this.initialPosition;
        }
        return this.lineEnds[lineNumber - 2] + 1;
    }

    public final int getNextChar() {
        try {
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
            } else {
                this.unicodeAsBackSlash = false;
                if (this.withoutUnicodePtr != 0) {
                    this.unicodeStore();
                }
            }
            return this.currentCharacter;
        }
        catch (IndexOutOfBoundsException | InvalidInputException e) {
            return -1;
        }
    }

    public final int getNextCharWithBoundChecks() {
        if (this.currentPosition >= this.eofPosition) {
            return -1;
        }
        this.currentCharacter = this.source[this.currentPosition++];
        if (this.currentPosition >= this.eofPosition) {
            this.unicodeAsBackSlash = false;
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return this.currentCharacter;
        }
        if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
            try {
                this.getNextUnicodeChar();
            }
            catch (InvalidInputException e) {
                return -1;
            }
        } else {
            this.unicodeAsBackSlash = false;
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
        }
        return this.currentCharacter;
    }

    public final boolean getNextChar(char testedChar) {
        int temp;
        block8: {
            block7: {
                if (this.currentPosition >= this.eofPosition) {
                    this.unicodeAsBackSlash = false;
                    return false;
                }
                temp = this.currentPosition;
                this.currentCharacter = this.source[this.currentPosition++];
                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != 'u') break block7;
                this.getNextUnicodeChar();
                if (this.currentCharacter != testedChar) {
                    this.currentPosition = temp;
                    --this.withoutUnicodePtr;
                    return false;
                }
                return true;
            }
            if (this.currentCharacter == testedChar) break block8;
            this.currentPosition = temp;
            return false;
        }
        try {
            this.unicodeAsBackSlash = false;
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException e) {
            this.unicodeAsBackSlash = false;
            this.currentPosition = temp;
            return false;
        }
    }

    public final int getNextChar(char testedChar1, char testedChar2) {
        int result;
        int temp;
        block12: {
            if (this.currentPosition >= this.eofPosition) {
                return -1;
            }
            temp = this.currentPosition;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                int result2;
                this.getNextUnicodeChar();
                if (this.currentCharacter == testedChar1) {
                    result2 = 0;
                } else if (this.currentCharacter == testedChar2) {
                    result2 = 1;
                } else {
                    this.currentPosition = temp;
                    --this.withoutUnicodePtr;
                    result2 = -1;
                }
                return result2;
            }
            if (this.currentCharacter == testedChar1) {
                result = 0;
                break block12;
            }
            if (this.currentCharacter == testedChar2) {
                result = 1;
                break block12;
            }
            this.currentPosition = temp;
            return -1;
        }
        try {
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return result;
        }
        catch (IndexOutOfBoundsException | InvalidInputException e) {
            this.currentPosition = temp;
            return -1;
        }
    }

    private final void consumeDigits(int radix) throws InvalidInputException {
        this.consumeDigits(radix, false);
    }

    private final void consumeDigits(int radix, boolean expectingDigitFirst) throws InvalidInputException {
        boolean USING_UNDERSCORE = true;
        int INVALID_POSITION = 2;
        switch (this.consumeDigits0(radix, 1, 2, expectingDigitFirst)) {
            case 1: {
                if (this.sourceLevel >= 0x330000L) break;
                throw Scanner.invalidUnderscoresInLiterals();
            }
            case 2: {
                if (this.sourceLevel < 0x330000L) {
                    throw Scanner.invalidUnderscoresInLiterals();
                }
                throw Scanner.invalidUnderscore();
            }
        }
    }

    private final int consumeDigits0(int radix, int usingUnderscore, int invalidPosition, boolean expectingDigitFirst) throws InvalidInputException {
        int kind = 0;
        if (this.getNextChar('_')) {
            if (expectingDigitFirst) {
                return invalidPosition;
            }
            kind = usingUnderscore;
            while (this.getNextChar('_')) {
            }
        }
        if (this.getNextCharAsDigit(radix)) {
            while (this.getNextCharAsDigit(radix)) {
            }
            int kind2 = this.consumeDigits0(radix, usingUnderscore, invalidPosition, false);
            if (kind2 == 0) {
                return kind;
            }
            return kind2;
        }
        if (kind == usingUnderscore) {
            return invalidPosition;
        }
        return kind;
    }

    public final boolean getNextCharAsDigit() throws InvalidInputException {
        int temp;
        block8: {
            block7: {
                if (this.currentPosition >= this.eofPosition) {
                    return false;
                }
                temp = this.currentPosition;
                this.currentCharacter = this.source[this.currentPosition++];
                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != 'u') break block7;
                this.getNextUnicodeChar();
                if (!ScannerHelper.isDigit(this.currentCharacter)) {
                    this.currentPosition = temp;
                    --this.withoutUnicodePtr;
                    return false;
                }
                return true;
            }
            if (ScannerHelper.isDigit(this.currentCharacter)) break block8;
            this.currentPosition = temp;
            return false;
        }
        try {
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException e) {
            this.currentPosition = temp;
            return false;
        }
    }

    public final boolean getNextCharAsDigit(int radix) {
        int temp;
        block8: {
            block7: {
                if (this.currentPosition >= this.eofPosition) {
                    return false;
                }
                temp = this.currentPosition;
                this.currentCharacter = this.source[this.currentPosition++];
                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != 'u') break block7;
                this.getNextUnicodeChar();
                if (ScannerHelper.digit(this.currentCharacter, radix) == -1) {
                    this.currentPosition = temp;
                    --this.withoutUnicodePtr;
                    return false;
                }
                return true;
            }
            if (ScannerHelper.digit(this.currentCharacter, radix) != -1) break block8;
            this.currentPosition = temp;
            return false;
        }
        try {
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException e) {
            this.currentPosition = temp;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getNextCharAsJavaIdentifierPartWithBoundCheck() {
        int pos = this.currentPosition;
        if (pos >= this.eofPosition) {
            return false;
        }
        int temp2 = this.withoutUnicodePtr;
        try {
            boolean unicode = false;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentPosition < this.eofPosition && this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
                unicode = true;
            }
            char c = this.currentCharacter;
            boolean isJavaIdentifierPart = false;
            if (c >= '\ud800' && c <= '\udbff') {
                if (this.complianceLevel < 0x310000L) {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                char low = (char)this.getNextCharWithBoundChecks();
                if (low < '\udc00' || low > '\udfff') {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                isJavaIdentifierPart = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c, low);
            } else {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                isJavaIdentifierPart = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c);
            }
            if (unicode) {
                if (!isJavaIdentifierPart) {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                return true;
            }
            if (!isJavaIdentifierPart) {
                this.currentPosition = pos;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (InvalidInputException e) {
            this.currentPosition = pos;
            this.withoutUnicodePtr = temp2;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getNextCharAsJavaIdentifierPart() {
        int pos = this.currentPosition;
        if (pos >= this.eofPosition) {
            return false;
        }
        int temp2 = this.withoutUnicodePtr;
        try {
            boolean unicode = false;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
                unicode = true;
            }
            char c = this.currentCharacter;
            boolean isJavaIdentifierPart = false;
            if (c >= '\ud800' && c <= '\udbff') {
                if (this.complianceLevel < 0x310000L) {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                char low = (char)this.getNextChar();
                if (low < '\udc00' || low > '\udfff') {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                isJavaIdentifierPart = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c, low);
            } else {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                isJavaIdentifierPart = ScannerHelper.isJavaIdentifierPart(this.complianceLevel, c);
            }
            if (unicode) {
                if (!isJavaIdentifierPart) {
                    this.currentPosition = pos;
                    this.withoutUnicodePtr = temp2;
                    return false;
                }
                return true;
            }
            if (!isJavaIdentifierPart) {
                this.currentPosition = pos;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            return true;
        }
        catch (IndexOutOfBoundsException | InvalidInputException e) {
            this.currentPosition = pos;
            this.withoutUnicodePtr = temp2;
            return false;
        }
    }

    public TerminalToken scanIdentifier() throws InvalidInputException {
        boolean isJavaIdStart;
        char c;
        int offset;
        int unicodePtr;
        boolean isWhiteSpace;
        int whiteStart = 0;
        this.withoutUnicodePtr = 0;
        whiteStart = this.currentPosition;
        boolean hasWhiteSpaces = false;
        boolean checkIfUnicode = false;
        do {
            unicodePtr = this.withoutUnicodePtr;
            offset = this.currentPosition;
            this.startPosition = this.currentPosition;
            if (this.currentPosition >= this.eofPosition) {
                if (this.tokenizeWhiteSpace && whiteStart != this.currentPosition - 1) {
                    --this.currentPosition;
                    this.startPosition = whiteStart;
                    return TerminalToken.TokenNameWHITESPACE;
                }
                return TerminalToken.TokenNameEOF;
            }
            this.currentCharacter = this.source[this.currentPosition++];
            checkIfUnicode = this.currentPosition < this.eofPosition && this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
            if (checkIfUnicode) {
                isWhiteSpace = this.jumpOverUnicodeWhiteSpace();
                offset = this.currentPosition - offset;
            } else {
                offset = this.currentPosition - offset;
                switch (this.currentCharacter) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        isWhiteSpace = true;
                        break;
                    }
                    default: {
                        isWhiteSpace = false;
                    }
                }
            }
            if (!isWhiteSpace) continue;
            hasWhiteSpaces = true;
        } while (isWhiteSpace);
        if (hasWhiteSpaces) {
            if (this.tokenizeWhiteSpace) {
                this.currentPosition -= offset;
                this.startPosition = whiteStart;
                if (checkIfUnicode) {
                    this.withoutUnicodePtr = unicodePtr;
                }
                return TerminalToken.TokenNameWHITESPACE;
            }
            if (checkIfUnicode) {
                this.withoutUnicodePtr = 0;
                this.unicodeStore();
            } else {
                this.withoutUnicodePtr = 0;
            }
        }
        if ((c = this.currentCharacter) < '\u0080') {
            if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x40) != 0) {
                return this.scanIdentifierOrKeywordWithBoundCheck();
            }
            return TerminalToken.TokenNameERROR;
        }
        if (c >= '\ud800' && c <= '\udbff') {
            if (this.complianceLevel < 0x310000L) {
                throw Scanner.invalidUnicodeEscape();
            }
            char low = (char)this.getNextCharWithBoundChecks();
            if (low < '\udc00' || low > '\udfff') {
                throw Scanner.invalidLowSurrogate();
            }
            isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c, low);
        } else {
            if (c >= '\udc00' && c <= '\udfff') {
                if (this.complianceLevel < 0x310000L) {
                    throw Scanner.invalidUnicodeEscape();
                }
                throw Scanner.invalidHighSurrogate();
            }
            isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c);
        }
        if (isJavaIdStart) {
            return this.scanIdentifierOrKeywordWithBoundCheck();
        }
        return TerminalToken.TokenNameERROR;
    }

    public void ungetToken(TerminalToken unambiguousToken) {
        if (this.nextToken != TerminalToken.TokenNameNotAToken) {
            throw new ArrayIndexOutOfBoundsException("Single cell array overflow");
        }
        this.nextToken = unambiguousToken;
    }

    public TerminalToken getNextToken() throws InvalidInputException {
        if (this.nextToken != TerminalToken.TokenNameNotAToken) {
            TerminalToken token = this.nextToken;
            this.nextToken = TerminalToken.TokenNameNotAToken;
            return token;
        }
        if (this.scanContext == null) {
            this.scanContext = this.isInModuleDeclaration() ? ScanContext.EXPECTING_KEYWORD : ScanContext.INACTIVE;
        }
        TerminalToken token = this.getNextToken0();
        if (this.areRestrictedModuleKeywordsActive()) {
            if (Scanner.isRestrictedKeyword(token)) {
                token = this.disambiguatedRestrictedKeyword(token);
            }
            this.updateScanContext(token);
        }
        if (this.activeParser == null) {
            if (token != TerminalToken.TokenNameWHITESPACE) {
                this.addTokenToLookBack(token);
            }
            return token;
        }
        if (token == TerminalToken.TokenNameLPAREN || token == TerminalToken.TokenNameLESS || token == TerminalToken.TokenNameAT || token == TerminalToken.TokenNameARROW) {
            token = this.disambiguatedToken(token, this);
        } else if (token == TerminalToken.TokenNameELLIPSIS) {
            this.consumingEllipsisAnnotations = false;
        } else if (this.mayBeAtCasePattern(token)) {
            token = this.disambiguateCasePattern(token);
        }
        this.addTokenToLookBack(token);
        return token;
    }

    protected int findCommentType() {
        int test = this.getNextChar('/', '*');
        if (test == 0 && JavaFeature.MARKDOWN_COMMENTS.isSupported(this.complianceLevel, this.previewEnabled) && this.getNextChar('/')) {
            return 2;
        }
        return test;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TerminalToken getNextToken0() throws InvalidInputException {
        this.wasAcr = false;
        if (this.diet) {
            this.jumpOverMethodBody();
            this.diet = false;
            return this.currentPosition > this.eofPosition ? TerminalToken.TokenNameEOF : TerminalToken.TokenNameRBRACE;
        }
        int whiteStart = 0;
        try {
            boolean isJavaIdStart;
            block49: while (true) {
                int offset;
                int unicodePtr;
                boolean isWhiteSpace;
                this.withoutUnicodePtr = 0;
                whiteStart = ++this.currentPosition;
                boolean hasWhiteSpaces = false;
                boolean checkIfUnicode = false;
                do {
                    unicodePtr = this.withoutUnicodePtr;
                    offset = this.currentPosition;
                    this.startPosition = this.currentPosition;
                    boolean repositionNeeded = false;
                    if (this.currentPosition < this.source.length) {
                        this.currentCharacter = this.source[this.currentPosition];
                        ++this.currentPosition;
                        if (this.currentCharacter == '\\') {
                            if (this.currentPosition < this.source.length) {
                                checkIfUnicode = this.source[this.currentPosition] == 'u';
                            } else {
                                repositionNeeded = true;
                            }
                        } else {
                            checkIfUnicode = false;
                        }
                    } else {
                        ++this.currentPosition;
                        repositionNeeded = true;
                    }
                    if (repositionNeeded) {
                        if (this.tokenizeWhiteSpace && whiteStart != this.currentPosition - 1) {
                            --this.currentPosition;
                            this.startPosition = whiteStart;
                            return TerminalToken.TokenNameWHITESPACE;
                        }
                        if (this.currentPosition > this.eofPosition) {
                            return TerminalToken.TokenNameEOF;
                        }
                    }
                    if (this.currentPosition > this.eofPosition) {
                        if (!this.tokenizeWhiteSpace || whiteStart == this.currentPosition - 1) return TerminalToken.TokenNameEOF;
                        --this.currentPosition;
                        this.startPosition = whiteStart;
                        return TerminalToken.TokenNameWHITESPACE;
                    }
                    if (checkIfUnicode) {
                        isWhiteSpace = this.jumpOverUnicodeWhiteSpace();
                        offset = this.currentPosition - offset;
                    } else {
                        offset = this.currentPosition - offset;
                        if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                            this.pushLineSeparator();
                        }
                        switch (this.currentCharacter) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                isWhiteSpace = true;
                                break;
                            }
                            default: {
                                isWhiteSpace = false;
                            }
                        }
                    }
                    if (!isWhiteSpace) continue;
                    hasWhiteSpaces = true;
                } while (isWhiteSpace);
                if (hasWhiteSpaces) {
                    if (this.tokenizeWhiteSpace) {
                        this.currentPosition -= offset;
                        this.startPosition = whiteStart;
                        if (!checkIfUnicode) return TerminalToken.TokenNameWHITESPACE;
                        this.withoutUnicodePtr = unicodePtr;
                        return TerminalToken.TokenNameWHITESPACE;
                    }
                    if (checkIfUnicode) {
                        this.withoutUnicodePtr = 0;
                        this.unicodeStore();
                    } else {
                        this.withoutUnicodePtr = 0;
                    }
                }
                switch (this.currentCharacter) {
                    case '@': {
                        return TerminalToken.TokenNameAT;
                    }
                    case '(': {
                        return TerminalToken.TokenNameLPAREN;
                    }
                    case ')': {
                        return TerminalToken.TokenNameRPAREN;
                    }
                    case '{': {
                        return TerminalToken.TokenNameLBRACE;
                    }
                    case '}': {
                        return TerminalToken.TokenNameRBRACE;
                    }
                    case '[': {
                        return TerminalToken.TokenNameLBRACKET;
                    }
                    case ']': {
                        return TerminalToken.TokenNameRBRACKET;
                    }
                    case ';': {
                        return TerminalToken.TokenNameSEMICOLON;
                    }
                    case ',': {
                        return TerminalToken.TokenNameCOMMA;
                    }
                    case '.': {
                        if (this.getNextCharAsDigit()) {
                            return this.scanNumber(true);
                        }
                        int temp = this.currentPosition;
                        if (this.getNextChar('.')) {
                            if (this.getNextChar('.')) {
                                return TerminalToken.TokenNameELLIPSIS;
                            }
                            this.currentPosition = temp;
                            return TerminalToken.TokenNameDOT;
                        }
                        this.currentPosition = temp;
                        return TerminalToken.TokenNameDOT;
                    }
                    case '+': {
                        int test = this.getNextChar('+', '=');
                        if (test == 0) {
                            return TerminalToken.TokenNamePLUS_PLUS;
                        }
                        if (test <= 0) return TerminalToken.TokenNamePLUS;
                        return TerminalToken.TokenNamePLUS_EQUAL;
                    }
                    case '-': {
                        int test = this.getNextChar('-', '=');
                        if (test == 0) {
                            return TerminalToken.TokenNameMINUS_MINUS;
                        }
                        if (test > 0) {
                            return TerminalToken.TokenNameMINUS_EQUAL;
                        }
                        if (!this.getNextChar('>')) return TerminalToken.TokenNameMINUS;
                        return TerminalToken.TokenNameARROW;
                    }
                    case '~': {
                        return TerminalToken.TokenNameTWIDDLE;
                    }
                    case '!': {
                        if (!this.getNextChar('=')) return TerminalToken.TokenNameNOT;
                        return TerminalToken.TokenNameNOT_EQUAL;
                    }
                    case '*': {
                        if (!this.getNextChar('=')) return TerminalToken.TokenNameMULTIPLY;
                        return TerminalToken.TokenNameMULTIPLY_EQUAL;
                    }
                    case '%': {
                        if (!this.getNextChar('=')) return TerminalToken.TokenNameREMAINDER;
                        return TerminalToken.TokenNameREMAINDER_EQUAL;
                    }
                    case '<': {
                        int test = this.getNextChar('=', '<');
                        if (test == 0) {
                            return TerminalToken.TokenNameLESS_EQUAL;
                        }
                        if (test <= 0) return TerminalToken.TokenNameLESS;
                        if (!this.getNextChar('=')) return TerminalToken.TokenNameLEFT_SHIFT;
                        return TerminalToken.TokenNameLEFT_SHIFT_EQUAL;
                    }
                    case '>': {
                        if (this.returnOnlyGreater) {
                            return TerminalToken.TokenNameGREATER;
                        }
                        int test = this.getNextChar('=', '>');
                        if (test == 0) {
                            return TerminalToken.TokenNameGREATER_EQUAL;
                        }
                        if (test <= 0) return TerminalToken.TokenNameGREATER;
                        test = this.getNextChar('=', '>');
                        if (test == 0) {
                            return TerminalToken.TokenNameRIGHT_SHIFT_EQUAL;
                        }
                        if (test <= 0) return TerminalToken.TokenNameRIGHT_SHIFT;
                        if (!this.getNextChar('=')) return TerminalToken.TokenNameUNSIGNED_RIGHT_SHIFT;
                        return TerminalToken.TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL;
                    }
                    case '=': {
                        if (!this.getNextChar('=')) return TerminalToken.TokenNameEQUAL;
                        return TerminalToken.TokenNameEQUAL_EQUAL;
                    }
                    case '&': {
                        int test = this.getNextChar('&', '=');
                        if (test == 0) {
                            return TerminalToken.TokenNameAND_AND;
                        }
                        if (test <= 0) return TerminalToken.TokenNameAND;
                        return TerminalToken.TokenNameAND_EQUAL;
                    }
                    case '|': {
                        int test = this.getNextChar('|', '=');
                        if (test == 0) {
                            return TerminalToken.TokenNameOR_OR;
                        }
                        if (test <= 0) return TerminalToken.TokenNameOR;
                        return TerminalToken.TokenNameOR_EQUAL;
                    }
                    case '^': {
                        if (!this.getNextChar('=')) return TerminalToken.TokenNameXOR;
                        return TerminalToken.TokenNameXOR_EQUAL;
                    }
                    case '?': {
                        return TerminalToken.TokenNameQUESTION;
                    }
                    case ':': {
                        if (!this.getNextChar(':')) return TerminalToken.TokenNameCOLON;
                        return TerminalToken.TokenNameCOLON_COLON;
                    }
                    case '\'': {
                        return this.processSingleQuotes(checkIfUnicode);
                    }
                    case '\"': {
                        return this.scanForStringLiteral();
                    }
                    case '/': {
                        int test;
                        if (!this.skipComments) {
                            test = this.findCommentType();
                            if (test == 0) {
                                this.lastCommentLinePosition = this.currentPosition--;
                                try {
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                    }
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                        ++this.currentPosition;
                                    }
                                    boolean isUnicode = false;
                                    while (this.currentCharacter != '\r' && this.currentCharacter != '\n') {
                                        if (this.currentPosition >= this.eofPosition) {
                                            this.lastCommentLinePosition = this.currentPosition++;
                                            throw new IndexOutOfBoundsException();
                                        }
                                        this.lastCommentLinePosition = this.currentPosition;
                                        isUnicode = false;
                                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                            this.getNextUnicodeChar();
                                            isUnicode = true;
                                        }
                                        if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                        ++this.currentPosition;
                                    }
                                    if (this.currentCharacter == '\r' && this.eofPosition > this.currentPosition) {
                                        if (this.source[this.currentPosition] == '\n') {
                                            ++this.currentPosition;
                                            this.currentCharacter = (char)10;
                                        } else if (this.source[this.currentPosition] == '\\' && this.source[this.currentPosition + 1] == 'u') {
                                            this.getNextUnicodeChar();
                                            isUnicode = true;
                                        }
                                    }
                                    this.recordComment(TerminalToken.TokenNameCOMMENT_LINE);
                                    if (this.taskTags != null) {
                                        this.checkTaskTag(this.startPosition, this.currentPosition);
                                    }
                                    if (this.currentCharacter == '\r' || this.currentCharacter == '\n') {
                                        if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                            this.parseTags();
                                        }
                                        if (this.recordLineSeparator) {
                                            if (isUnicode) {
                                                this.pushUnicodeLineSeparator();
                                            } else {
                                                this.pushLineSeparator();
                                            }
                                        }
                                    }
                                    if (!this.tokenizeComments) continue block49;
                                    return TerminalToken.TokenNameCOMMENT_LINE;
                                }
                                catch (IndexOutOfBoundsException e) {
                                    this.recordComment(TerminalToken.TokenNameCOMMENT_LINE);
                                    if (this.taskTags != null) {
                                        this.checkTaskTag(this.startPosition, this.currentPosition);
                                    }
                                    if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                        this.parseTags();
                                    }
                                    if (!this.tokenizeComments) continue block49;
                                    return TerminalToken.TokenNameCOMMENT_LINE;
                                }
                            }
                            if (test == 1) {
                                try {
                                    boolean isJavadoc = false;
                                    boolean star = false;
                                    boolean isUnicode = false;
                                    this.unicodeAsBackSlash = false;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        isUnicode = true;
                                    } else {
                                        isUnicode = false;
                                        if (this.withoutUnicodePtr != 0) {
                                            this.unicodeStore();
                                        }
                                    }
                                    if (this.currentCharacter == '*') {
                                        isJavadoc = true;
                                        star = true;
                                    }
                                    if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                        if (isUnicode) {
                                            this.pushUnicodeLineSeparator();
                                        } else {
                                            this.pushLineSeparator();
                                        }
                                    }
                                    isUnicode = false;
                                    int previous = this.currentPosition;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        isUnicode = true;
                                    } else {
                                        isUnicode = false;
                                    }
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                        ++this.currentPosition;
                                    }
                                    if (this.currentCharacter == '/') {
                                        isJavadoc = false;
                                    }
                                    int firstTag = 0;
                                    while (this.currentCharacter != '/' || !star) {
                                        if (this.currentPosition >= this.eofPosition) {
                                            throw Scanner.unterminatedComment();
                                        }
                                        if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                            if (isUnicode) {
                                                this.pushUnicodeLineSeparator();
                                            } else {
                                                this.pushLineSeparator();
                                            }
                                        }
                                        switch (this.currentCharacter) {
                                            case '*': {
                                                star = true;
                                                break;
                                            }
                                            case '@': {
                                                if (firstTag == 0 && this.isFirstTag()) {
                                                    firstTag = previous;
                                                }
                                            }
                                            default: {
                                                star = false;
                                            }
                                        }
                                        previous = this.currentPosition;
                                        this.currentCharacter = this.source[this.currentPosition++];
                                        if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                            this.getNextUnicodeChar();
                                            isUnicode = true;
                                        } else {
                                            isUnicode = false;
                                        }
                                        if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                        ++this.currentPosition;
                                    }
                                    TerminalToken token = isJavadoc ? TerminalToken.TokenNameCOMMENT_JAVADOC : TerminalToken.TokenNameCOMMENT_BLOCK;
                                    this.recordComment(token);
                                    this.commentTagStarts[this.commentPtr] = firstTag;
                                    if (this.taskTags != null) {
                                        this.checkTaskTag(this.startPosition, this.currentPosition);
                                    }
                                    if (!this.tokenizeComments) continue block49;
                                    return token;
                                }
                                catch (IndexOutOfBoundsException e) {
                                    --this.currentPosition;
                                    throw Scanner.unterminatedComment();
                                }
                            }
                            if (test == 2) {
                                try {
                                    boolean isUnicode = false;
                                    this.unicodeAsBackSlash = false;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        isUnicode = true;
                                    } else {
                                        isUnicode = false;
                                        if (this.withoutUnicodePtr != 0) {
                                            this.unicodeStore();
                                        }
                                    }
                                    if (this.currentCharacter == '\r' || this.currentCharacter == '\n') {
                                        if (this.recordLineSeparator) {
                                            if (isUnicode) {
                                                this.pushUnicodeLineSeparator();
                                            } else {
                                                this.pushLineSeparator();
                                            }
                                        }
                                        if (!this.lineBeginsWithMarkdown()) {
                                            --this.currentPosition;
                                            continue block49;
                                        }
                                    }
                                    isUnicode = false;
                                    int previous = this.currentPosition;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        isUnicode = true;
                                    } else {
                                        isUnicode = false;
                                    }
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                        ++this.currentPosition;
                                    }
                                    int firstTag = 0;
                                    while (true) {
                                        if (this.currentPosition > this.eofPosition) {
                                            throw Scanner.unterminatedComment();
                                        }
                                        if (this.currentCharacter == '\r' || this.currentCharacter == '\n') {
                                            if (this.recordLineSeparator) {
                                                if (isUnicode) {
                                                    this.pushUnicodeLineSeparator();
                                                } else {
                                                    this.pushLineSeparator();
                                                }
                                            }
                                            if (!this.lineBeginsWithMarkdown()) break;
                                        }
                                        switch (this.currentCharacter) {
                                            case '*': {
                                                break;
                                            }
                                            case '@': 
                                            case '[': {
                                                if (firstTag != 0 || !this.isFirstTag()) break;
                                                firstTag = previous;
                                            }
                                        }
                                        previous = this.currentPosition;
                                        this.currentCharacter = this.source[this.currentPosition++];
                                        if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                            this.getNextUnicodeChar();
                                            isUnicode = true;
                                        } else {
                                            isUnicode = false;
                                        }
                                        if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                        ++this.currentPosition;
                                    }
                                    TerminalToken token = TerminalToken.TokenNameCOMMENT_MARKDOWN;
                                    this.recordComment(token);
                                    this.commentTagStarts[this.commentPtr] = firstTag;
                                    if (this.taskTags != null) {
                                        this.checkTaskTag(this.startPosition, this.currentPosition);
                                    }
                                    if (this.tokenizeComments) return token;
                                    continue block49;
                                }
                                catch (IndexOutOfBoundsException e) {
                                    --this.currentPosition;
                                    throw Scanner.unterminatedComment();
                                }
                            }
                        }
                        if (!this.getNextChar('=')) return TerminalToken.TokenNameDIVIDE;
                        return TerminalToken.TokenNameDIVIDE_EQUAL;
                    }
                    case '\u001a': {
                        if (!this.atEnd()) throw Scanner.invalidEof();
                        return TerminalToken.TokenNameEOF;
                    }
                }
                break;
            }
            char c = this.currentCharacter;
            if (c < '\u0080') {
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x40) != 0) {
                    return this.scanIdentifierOrKeyword();
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 4) == 0) return TerminalToken.TokenNameERROR;
                return this.scanNumber(false);
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (this.complianceLevel < 0x310000L) {
                    throw Scanner.invalidUnicodeEscape();
                }
                char low = (char)this.getNextChar();
                if (low < '\udc00' || low > '\udfff') {
                    throw Scanner.invalidLowSurrogate();
                }
                isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c, low);
            } else {
                if (c >= '\udc00' && c <= '\udfff') {
                    if (this.complianceLevel >= 0x310000L) throw Scanner.invalidHighSurrogate();
                    throw Scanner.invalidUnicodeEscape();
                }
                isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c);
            }
            if (isJavaIdStart) {
                return this.scanIdentifierOrKeyword();
            }
            if (!ScannerHelper.isDigit(this.currentCharacter)) return TerminalToken.TokenNameERROR;
            return this.scanNumber(false);
        }
        catch (IndexOutOfBoundsException e) {
            if (!this.tokenizeWhiteSpace || whiteStart == this.currentPosition - 1) return TerminalToken.TokenNameEOF;
            --this.currentPosition;
            this.startPosition = whiteStart;
            return TerminalToken.TokenNameWHITESPACE;
        }
    }

    protected TerminalToken processSingleQuotes(boolean checkIfUnicode) throws InvalidInputException {
        int lookAhead;
        int test = this.getNextChar('\n', '\r');
        if (test == 0) {
            throw Scanner.invalidCharacter();
        }
        if (test > 0) {
            int lookAhead2 = 0;
            while (lookAhead2 < 3) {
                if (this.currentPosition + lookAhead2 == this.eofPosition || this.source[this.currentPosition + lookAhead2] == '\n') break;
                if (this.source[this.currentPosition + lookAhead2] == '\'') {
                    this.currentPosition += lookAhead2 + 1;
                    break;
                }
                ++lookAhead2;
            }
            throw Scanner.invalidCharacter();
        }
        if (this.getNextChar('\'')) {
            lookAhead = 0;
            while (lookAhead < 3) {
                if (this.currentPosition + lookAhead == this.eofPosition || this.source[this.currentPosition + lookAhead] == '\n') break;
                if (this.source[this.currentPosition + lookAhead] == '\'') {
                    this.currentPosition += lookAhead + 1;
                    break;
                }
                ++lookAhead;
            }
            throw Scanner.invalidCharacter();
        }
        if (this.getNextChar('\\')) {
            if (this.unicodeAsBackSlash) {
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                } else if (this.withoutUnicodePtr != 0) {
                    this.unicodeStore();
                }
            } else {
                this.currentCharacter = this.source[this.currentPosition++];
            }
            this.scanEscapeCharacter();
        } else {
            this.unicodeAsBackSlash = false;
            checkIfUnicode = false;
            try {
                this.currentCharacter = this.source[this.currentPosition++];
                checkIfUnicode = this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
            }
            catch (IndexOutOfBoundsException e) {
                --this.currentPosition;
                throw Scanner.invalidCharacter();
            }
            if (checkIfUnicode) {
                this.getNextUnicodeChar();
            } else if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
        }
        if (this.getNextChar('\'')) {
            return TerminalToken.TokenNameCharacterLiteral;
        }
        lookAhead = 0;
        while (lookAhead < 20) {
            if (this.currentPosition + lookAhead == this.eofPosition || this.source[this.currentPosition + lookAhead] == '\n') break;
            if (this.source[this.currentPosition + lookAhead] == '\'') {
                this.currentPosition += lookAhead + 1;
                break;
            }
            ++lookAhead;
        }
        throw Scanner.invalidCharacter();
    }

    /*
     * Unable to fully structure code
     */
    protected TerminalToken scanForStringLiteral() throws InvalidInputException {
        block29: {
            block30: {
                isTextBlock = false;
                this.unicodeAsBackSlash = false;
                isUnicode = false;
                isTextBlock = this.scanForTextBlockBeginning();
                if (isTextBlock) {
                    return this.scanForTextBlock();
                }
                try {
                    this.unicodeAsBackSlash = false;
                    isUnicode = false;
                    this.currentCharacter = this.source[this.currentPosition++];
                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                        this.getNextUnicodeChar();
                        isUnicode = true;
                    } else if (this.withoutUnicodePtr != 0) {
                        this.unicodeStore();
                    }
                    while (this.currentCharacter != '\"') {
                        if (this.currentPosition >= this.eofPosition) {
                            throw Scanner.unterminatedString();
                        }
                        if (this.currentCharacter == '\n' || this.currentCharacter == '\r') {
                            if (isUnicode) {
                                start = this.currentPosition;
                                lookAhead = 0;
                                while (lookAhead < 50) {
                                    if (this.currentPosition >= this.eofPosition) {
                                        this.currentPosition = start;
                                        break;
                                    }
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        isUnicode = true;
                                        this.getNextUnicodeChar();
                                    } else {
                                        isUnicode = false;
                                    }
                                    if (!isUnicode && this.currentCharacter == '\n') {
                                        --this.currentPosition;
                                        break;
                                    }
                                    if (this.currentCharacter == '\"') {
                                        throw Scanner.invalidCharInString();
                                    }
                                    ++lookAhead;
                                }
                            } else {
                                --this.currentPosition;
                            }
                            throw Scanner.invalidCharInString();
                        }
                        if (this.currentCharacter == '\\') {
                            if (this.unicodeAsBackSlash) {
                                --this.withoutUnicodePtr;
                                this.unicodeAsBackSlash = false;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                    --this.withoutUnicodePtr;
                                } else {
                                    isUnicode = false;
                                }
                            } else {
                                if (this.withoutUnicodePtr == 0) {
                                    this.unicodeInitializeBuffer(this.currentPosition - this.startPosition);
                                }
                                --this.withoutUnicodePtr;
                                this.currentCharacter = this.source[this.currentPosition++];
                            }
                            this.scanEscapeCharacter();
                            if (this.withoutUnicodePtr != 0) {
                                this.unicodeStore();
                            }
                        }
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                            isUnicode = true;
                            continue;
                        }
                        isUnicode = false;
                        if (this.withoutUnicodePtr == 0) continue;
                        this.unicodeStore();
                    }
                    break block29;
                }
                catch (IndexOutOfBoundsException e) {
                    --this.currentPosition;
                    throw Scanner.unterminatedString();
                }
                catch (InvalidInputException e) {
                    if (!e.getMessage().equals("Invalid_Escape")) break block30;
                    lookAhead = 0;
                    ** while (lookAhead < 50)
                }
lbl-1000:
                // 1 sources

                {
                    if (this.currentPosition + lookAhead == this.eofPosition || this.source[this.currentPosition + lookAhead] == '\n') break;
                    if (this.source[this.currentPosition + lookAhead] == '\"') {
                        this.currentPosition += lookAhead + 1;
                        break;
                    }
                    ++lookAhead;
                    continue;
                }
            }
            throw e;
        }
        return TerminalToken.TokenNameStringLiteral;
    }

    protected TerminalToken scanForTextBlock() throws InvalidInputException {
        int lastQuotePos = 0;
        try {
            this.rawStart = this.currentPosition - this.startPosition;
            block8: while (this.currentPosition <= this.eofPosition) {
                block23: {
                    if (this.currentCharacter == '\"') {
                        lastQuotePos = this.currentPosition;
                        if (this.scanForTextBlockClose()) {
                            this.currentPosition += 2;
                            return TerminalToken.TokenNameTextBlock;
                        }
                        if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    } else if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                        this.pushLineSeparator();
                    }
                    if (this.currentCharacter == '\\') {
                        switch (this.source[this.currentPosition]) {
                            case 'f': 
                            case 'n': 
                            case 'r': 
                            case 's': 
                            case 't': {
                                break block23;
                            }
                            case '\n': 
                            case '\r': {
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (!this.recordLineSeparator) break;
                                this.pushLineSeparator();
                                break;
                            }
                            case '\"': {
                                ++this.currentPosition;
                                this.currentCharacter = this.source[this.currentPosition++];
                                continue block8;
                            }
                            case '\\': {
                                ++this.currentPosition;
                                break;
                            }
                            default: {
                                if (this.unicodeAsBackSlash) {
                                    --this.withoutUnicodePtr;
                                    if (this.currentPosition >= this.eofPosition) break;
                                    this.unicodeAsBackSlash = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        --this.withoutUnicodePtr;
                                    }
                                } else {
                                    if (this.withoutUnicodePtr == 0) {
                                        this.unicodeInitializeBuffer(this.currentPosition - this.startPosition);
                                    }
                                    --this.withoutUnicodePtr;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                }
                                int oldPos = this.currentPosition - 1;
                                this.scanEscapeCharacter();
                                if (!ScannerHelper.isWhitespace(this.currentCharacter)) break;
                                if (this.withoutUnicodePtr == 0) {
                                    this.unicodeInitializeBuffer(this.currentPosition - this.startPosition);
                                }
                                this.unicodeStore('\\');
                                this.currentPosition = oldPos;
                                this.currentCharacter = this.source[this.currentPosition];
                                break block23;
                            }
                        }
                        if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    }
                }
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                    continue;
                }
                if (this.currentCharacter == '\"' || this.withoutUnicodePtr == 0) continue;
                this.unicodeStore();
            }
            if (lastQuotePos > 0) {
                this.currentPosition = lastQuotePos;
            }
            this.currentPosition = lastQuotePos > 0 ? lastQuotePos : this.startPosition + this.rawStart;
            throw Scanner.unterminatedTextBlock();
        }
        catch (IndexOutOfBoundsException e) {
            this.currentPosition = lastQuotePos > 0 ? lastQuotePos : this.startPosition + this.rawStart;
            throw Scanner.unterminatedTextBlock();
        }
    }

    public void getNextUnicodeChar() throws InvalidInputException {
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int c4 = 0;
        int unicodeSize = 6;
        ++this.currentPosition;
        if (this.currentPosition < this.eofPosition) {
            while (this.source[this.currentPosition] == 'u') {
                ++this.currentPosition;
                if (this.currentPosition >= this.eofPosition) {
                    --this.currentPosition;
                    throw Scanner.invalidUnicodeEscape();
                }
                ++unicodeSize;
            }
        } else {
            --this.currentPosition;
            throw Scanner.invalidUnicodeEscape();
        }
        if (this.currentPosition + 4 > this.eofPosition) {
            this.currentPosition += this.eofPosition - this.currentPosition;
            throw Scanner.invalidUnicodeEscape();
        }
        if ((c1 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = ScannerHelper.getHexadecimalValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
            throw Scanner.invalidUnicodeEscape();
        }
        this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
        if (this.withoutUnicodePtr == 0) {
            this.unicodeInitializeBuffer(this.currentPosition - unicodeSize - this.startPosition);
        }
        this.unicodeStore();
        this.unicodeAsBackSlash = this.currentCharacter == '\\';
    }

    public NLSTag[] getNLSTags() {
        int length = this.nlsTagsPtr;
        if (length != 0) {
            NLSTag[] result = new NLSTag[length];
            System.arraycopy(this.nlsTags, 0, result, 0, length);
            this.nlsTagsPtr = 0;
            return result;
        }
        return null;
    }

    public boolean[] getIdentityComparisonLines() {
        boolean[] retVal = this.validIdentityComparisonLines;
        this.validIdentityComparisonLines = null;
        return retVal;
    }

    public char[] getSource() {
        return this.source;
    }

    protected boolean isFirstTag() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public final void jumpOverMethodBody() {
        this.wasAcr = false;
        found = 1;
        block43: while (true) {
            block44: while (true) {
                this.withoutUnicodePtr = 0;
                do {
                    this.startPosition = ++this.currentPosition;
                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                        isWhiteSpace = this.jumpOverUnicodeWhiteSpace();
                        continue;
                    }
                    if (this.recordLineSeparator && (this.currentCharacter == '\r' || this.currentCharacter == '\n')) {
                        this.pushLineSeparator();
                    }
                    isWhiteSpace = CharOperation.isWhitespace(this.currentCharacter);
                } while (isWhiteSpace);
                switch (this.currentCharacter) {
                    case '{': {
                        ++found;
                        continue block44;
                    }
                    case '}': {
                        if (--found != 0) continue block44;
                        return;
                    }
                    case '\'': {
                        test = this.getNextChar('\\');
                        if (test) {
                            try {
                                if (this.unicodeAsBackSlash) {
                                    this.unicodeAsBackSlash = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                    } else if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                } else {
                                    this.currentCharacter = this.source[this.currentPosition++];
                                }
                                this.scanEscapeCharacter();
                            }
                            catch (InvalidInputException var4_5) {}
                        } else {
                            try {
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                } else if (this.withoutUnicodePtr != 0) {
                                    this.unicodeStore();
                                }
                            }
                            catch (InvalidInputException var4_6) {
                                // empty catch block
                            }
                        }
                        this.getNextChar('\'');
                        continue block44;
                    }
                    case '\"': {
                        isTextBlock = false;
                        firstClosingBrace = 0;
                        try {
                            try {
                                isTextBlock = this.scanForTextBlockBeginning();
                                if (!isTextBlock) {
                                    this.unicodeAsBackSlash = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                    } else if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                }
                            }
                            catch (InvalidInputException var5_8) {}
                            while (true) {
                                if (this.currentPosition > this.eofPosition) continue block43;
                                if (!isTextBlock) ** GOTO lbl96
                                switch (this.currentCharacter) {
                                    case '\"': {
                                        if (this.scanForTextBlockClose()) {
                                            this.currentPosition += 2;
                                            this.currentCharacter = this.source[this.currentPosition];
                                            isTextBlock = false;
                                            continue block44;
                                        }
                                        ** GOTO lbl97
                                    }
                                    case '}': {
                                        if (firstClosingBrace == 0) {
                                            firstClosingBrace = this.currentPosition;
                                        }
                                        ** GOTO lbl97
                                    }
                                    case '\r': {
                                        if (this.source[this.currentPosition] == '\n') {
                                            ++this.currentPosition;
                                        }
                                    }
                                    case '\n': {
                                        this.pushLineSeparator();
                                    }
                                    default: {
                                        if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\"') {
                                            ++this.currentPosition;
                                        }
                                        this.currentCharacter = this.source[this.currentPosition++];
                                        break;
                                    }
                                }
                                continue;
lbl96:
                                // 1 sources

                                if (this.currentCharacter == '\"') continue block44;
lbl97:
                                // 3 sources

                                if (this.currentCharacter == '\r') {
                                    if (this.source[this.currentPosition] != '\n') continue block44;
                                    continue block44;
                                }
                                if (this.currentCharacter == '\n') continue block44;
                                if (this.currentCharacter == '\\') {
                                    try {
                                        if (this.unicodeAsBackSlash) {
                                            this.unicodeAsBackSlash = false;
                                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                                this.getNextUnicodeChar();
                                            } else if (this.withoutUnicodePtr != 0) {
                                                this.unicodeStore();
                                            }
                                        } else {
                                            this.currentCharacter = this.source[this.currentPosition++];
                                        }
                                        this.scanEscapeCharacter();
                                    }
                                    catch (InvalidInputException var5_9) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    this.unicodeAsBackSlash = false;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        continue;
                                    }
                                    if (this.withoutUnicodePtr == 0) continue;
                                    this.unicodeStore();
                                }
                                catch (InvalidInputException var5_10) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            if (!isTextBlock || firstClosingBrace <= 0) continue block44;
                            this.currentPosition = firstClosingBrace - 1;
                        }
                        continue block44;
                    }
                    case '/': {
                        test = this.findCommentType();
                        if (test == 0) {
                            try {
                                this.lastCommentLinePosition = this.currentPosition;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                }
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                    ++this.currentPosition;
                                }
                                isUnicode = false;
                                while (this.currentCharacter != '\r' && this.currentCharacter != '\n') {
                                    if (this.currentPosition >= this.eofPosition) {
                                        this.lastCommentLinePosition = this.currentPosition++;
                                        throw new IndexOutOfBoundsException();
                                    }
                                    this.lastCommentLinePosition = this.currentPosition;
                                    isUnicode = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        isUnicode = true;
                                        this.getNextUnicodeChar();
                                    }
                                    if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                    ++this.currentPosition;
                                }
                                if (this.currentCharacter == '\r' && this.eofPosition > this.currentPosition) {
                                    if (this.source[this.currentPosition] == '\n') {
                                        ++this.currentPosition;
                                        this.currentCharacter = (char)10;
                                    } else if (this.source[this.currentPosition] == '\\' && this.source[this.currentPosition + 1] == 'u') {
                                        isUnicode = true;
                                        this.getNextUnicodeChar();
                                    }
                                }
                                this.recordComment(TerminalToken.TokenNameCOMMENT_LINE);
                                if (!this.recordLineSeparator || this.currentCharacter != '\r' && this.currentCharacter != '\n') continue block44;
                                if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                    this.parseTags();
                                }
                                if (!this.recordLineSeparator) continue block44;
                                if (isUnicode) {
                                    this.pushUnicodeLineSeparator();
                                    continue block44;
                                }
                                this.pushLineSeparator();
                            }
                            catch (IndexOutOfBoundsException e) {
                                --this.currentPosition;
                                this.recordComment(TerminalToken.TokenNameCOMMENT_LINE);
                                if ((this.checkNonExternalizedStringLiterals || this.checkUninternedIdentityComparison) && this.lastPosition < this.currentPosition) {
                                    this.parseTags();
                                }
                                if (this.tokenizeComments) continue block44;
                                ++this.currentPosition;
                            }
                            continue block44;
                        }
                        if (test == 1) {
                            isJavadoc = false;
                            try {
                                star = false;
                                isUnicode = false;
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                    if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                }
                                if (this.currentCharacter == '*') {
                                    isJavadoc = true;
                                    star = true;
                                }
                                if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                    if (isUnicode) {
                                        this.pushUnicodeLineSeparator();
                                    } else {
                                        this.pushLineSeparator();
                                    }
                                }
                                isUnicode = false;
                                previous = this.currentPosition;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                }
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                    ++this.currentPosition;
                                }
                                if (this.currentCharacter == '/') {
                                    isJavadoc = false;
                                }
                                firstTag = 0;
                                while (this.currentCharacter != '/' || !star) {
                                    if (this.currentPosition >= this.eofPosition) {
                                        return;
                                    }
                                    if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                        if (isUnicode) {
                                            this.pushUnicodeLineSeparator();
                                        } else {
                                            this.pushLineSeparator();
                                        }
                                    }
                                    switch (this.currentCharacter) {
                                        case '*': {
                                            star = true;
                                            break;
                                        }
                                        case '@': {
                                            if (firstTag == 0 && this.isFirstTag()) {
                                                firstTag = previous;
                                            }
                                        }
                                        default: {
                                            star = false;
                                        }
                                    }
                                    previous = this.currentPosition;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        isUnicode = true;
                                    } else {
                                        isUnicode = false;
                                    }
                                    if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                    ++this.currentPosition;
                                }
                                this.recordComment(isJavadoc != false ? TerminalToken.TokenNameCOMMENT_JAVADOC : TerminalToken.TokenNameCOMMENT_BLOCK);
                                this.commentTagStarts[this.commentPtr] = firstTag;
                                continue block44;
                            }
                            catch (IndexOutOfBoundsException e) {
                                return;
                            }
                        }
                        if (test != 2) continue block44;
                        try {
                            isUnicode = false;
                            this.unicodeAsBackSlash = false;
                            this.currentCharacter = this.source[this.currentPosition++];
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                                isUnicode = true;
                            } else {
                                isUnicode = false;
                                if (this.withoutUnicodePtr != 0) {
                                    this.unicodeStore();
                                }
                            }
                            if (this.currentCharacter == '\r' || this.currentCharacter == '\n') {
                                if (this.recordLineSeparator) {
                                    if (isUnicode) {
                                        this.pushUnicodeLineSeparator();
                                    } else {
                                        this.pushLineSeparator();
                                    }
                                }
                                if (!this.lineBeginsWithMarkdown()) {
                                    --this.currentPosition;
                                    continue block44;
                                }
                            }
                            isUnicode = false;
                            previous = this.currentPosition;
                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                                isUnicode = true;
                            } else {
                                isUnicode = false;
                            }
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                ++this.currentPosition;
                            }
                            firstTag = 0;
                            while (true) {
                                if (this.currentPosition > this.eofPosition) {
                                    throw Scanner.unterminatedComment();
                                }
                                if (this.currentCharacter == '\r' || this.currentCharacter == '\n') {
                                    if (this.recordLineSeparator) {
                                        if (isUnicode) {
                                            this.pushUnicodeLineSeparator();
                                        } else {
                                            this.pushLineSeparator();
                                        }
                                    }
                                    if (!this.lineBeginsWithMarkdown()) {
                                        --this.currentPosition;
                                        break;
                                    }
                                }
                                switch (this.currentCharacter) {
                                    case '*': {
                                        break;
                                    }
                                    case '@': 
                                    case '[': {
                                        if (firstTag != 0 || !this.isFirstTag()) break;
                                        firstTag = previous;
                                    }
                                }
                                previous = this.currentPosition;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                }
                                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                ++this.currentPosition;
                            }
                            this.recordComment(TerminalToken.TokenNameCOMMENT_MARKDOWN);
                            this.commentTagStarts[this.commentPtr] = firstTag;
                            continue block44;
                        }
                        catch (IndexOutOfBoundsException e) {
                            return;
                        }
                    }
                }
                try {
                    c = this.currentCharacter;
                    if (c < '\u0080') {
                        if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 64) != 0) {
                            this.scanIdentifierOrKeyword();
                            continue;
                        }
                        if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 4) == 0) continue;
                        this.scanNumber(false);
                        continue;
                    }
                    if (c >= '\ud800' && c <= '\udbff') {
                        if (this.complianceLevel < 0x310000L) {
                            throw Scanner.invalidUnicodeEscape();
                        }
                        low = (char)this.getNextChar();
                        if (low < '\udc00' || low > '\udfff') continue;
                        isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c, low);
                    } else {
                        if (c >= '\udc00' && c <= '\udfff') continue;
                        isJavaIdStart = ScannerHelper.isJavaIdentifierStart(this.complianceLevel, c);
                    }
                    if (!isJavaIdStart) continue;
                    this.scanIdentifierOrKeyword();
                }
                catch (InvalidInputException var5_14) {}
            }
            break;
        }
        catch (IndexOutOfBoundsException | InvalidInputException var2_3) {
            return;
        }
    }

    public final boolean jumpOverUnicodeWhiteSpace() throws InvalidInputException {
        this.wasAcr = false;
        this.getNextUnicodeChar();
        return CharOperation.isWhitespace(this.currentCharacter);
    }

    public boolean isInModuleDeclaration() {
        return this.fakeInModule || this.insideModuleInfo;
    }

    protected boolean areRestrictedModuleKeywordsActive() {
        return this.scanContext != null && this.scanContext != ScanContext.INACTIVE;
    }

    void updateScanContext(TerminalToken token) {
        if (this.scanContext == ScanContext.AFTER_IMPORT && !this.isInModuleDeclaration()) {
            this.scanContext = ScanContext.INACTIVE;
            return;
        }
        switch (token) {
            case TokenNameRPAREN: 
            case TokenNameRBRACE: 
            case TokenNameSEMICOLON: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
            case TokenNameopen: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
            case TokenNamerequires: {
                this.scanContext = ScanContext.AFTER_REQUIRES;
                break;
            }
            case TokenNamemodule: 
            case TokenNametransitive: 
            case TokenNameexports: 
            case TokenNameopens: 
            case TokenNameto: 
            case TokenNameuses: 
            case TokenNameprovides: 
            case TokenNamewith: 
            case TokenNameCOMMA: 
            case TokenNameDOT: 
            case TokenNameAT: 
            case TokenNameAT308: {
                this.scanContext = ScanContext.EXPECTING_IDENTIFIER;
                break;
            }
            case TokenNameimport: {
                this.scanContext = ScanContext.AFTER_IMPORT;
                break;
            }
            case TokenNameIdentifier: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
            case TokenNameLBRACE: {
                this.scanContext = ScanContext.EXPECTING_KEYWORD;
                break;
            }
        }
    }

    private void parseTags() {
        int pos;
        int position = 0;
        int currentStartPosition = this.startPosition;
        int currentLinePtr = this.linePtr;
        if (currentLinePtr >= 0) {
            position = this.lineEnds[currentLinePtr] + 1;
        }
        while (ScannerHelper.isWhitespace(this.source[position])) {
            ++position;
        }
        if (currentStartPosition == position) {
            return;
        }
        char[] s = null;
        int sourceEnd = this.currentPosition;
        int sourceStart = currentStartPosition;
        int sourceDelta = 0;
        if (this.withoutUnicodePtr != 0) {
            s = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, s, 0, this.withoutUnicodePtr);
            sourceEnd = this.withoutUnicodePtr;
            sourceStart = 1;
            sourceDelta = currentStartPosition;
        } else {
            s = this.source;
        }
        if (this.checkNonExternalizedStringLiterals && (pos = CharOperation.indexOf(TAG_PREFIX, s, true, sourceStart, sourceEnd)) != -1) {
            if (this.nlsTags == null) {
                this.nlsTags = new NLSTag[10];
                this.nlsTagsPtr = 0;
            }
            while (pos != -1) {
                int start = pos + TAG_PREFIX_LENGTH;
                int end = CharOperation.indexOf('$', s, start, sourceEnd);
                if (end != -1) {
                    NLSTag currentTag = null;
                    int currentLine = currentLinePtr + 1;
                    try {
                        currentTag = new NLSTag(pos + sourceDelta, end + sourceDelta, currentLine, this.extractInt(s, start, end));
                    }
                    catch (NumberFormatException e) {
                        currentTag = new NLSTag(pos + sourceDelta, end + sourceDelta, currentLine, -1);
                    }
                    if (this.nlsTagsPtr == this.nlsTags.length) {
                        this.nlsTags = new NLSTag[this.nlsTagsPtr + 10];
                        System.arraycopy(this.nlsTags, 0, this.nlsTags, 0, this.nlsTagsPtr);
                    }
                    this.nlsTags[this.nlsTagsPtr++] = currentTag;
                } else {
                    end = start;
                }
                pos = CharOperation.indexOf(TAG_PREFIX, s, true, end, sourceEnd);
            }
        }
        if (this.checkUninternedIdentityComparison && (pos = CharOperation.indexOf(IDENTITY_COMPARISON_TAG, s, true, sourceStart, sourceEnd)) != -1) {
            if (this.validIdentityComparisonLines == null) {
                this.validIdentityComparisonLines = new boolean[0];
            }
            int currentLine = currentLinePtr + 1;
            int length = this.validIdentityComparisonLines.length;
            this.validIdentityComparisonLines = new boolean[currentLine + 1];
            System.arraycopy(this.validIdentityComparisonLines, 0, this.validIdentityComparisonLines, 0, length);
            this.validIdentityComparisonLines[currentLine] = true;
        }
    }

    private int extractInt(char[] array, int start, int end) {
        int value = 0;
        int i = start;
        while (i < end) {
            char currentChar = array[i];
            int digit = 0;
            switch (currentChar) {
                case '0': {
                    digit = 0;
                    break;
                }
                case '1': {
                    digit = 1;
                    break;
                }
                case '2': {
                    digit = 2;
                    break;
                }
                case '3': {
                    digit = 3;
                    break;
                }
                case '4': {
                    digit = 4;
                    break;
                }
                case '5': {
                    digit = 5;
                    break;
                }
                case '6': {
                    digit = 6;
                    break;
                }
                case '7': {
                    digit = 7;
                    break;
                }
                case '8': {
                    digit = 8;
                    break;
                }
                case '9': {
                    digit = 9;
                    break;
                }
                default: {
                    throw new NumberFormatException();
                }
            }
            value *= 10;
            if (digit < 0) {
                throw new NumberFormatException();
            }
            value += digit;
            ++i;
        }
        return value;
    }

    public final void pushLineSeparator() {
        block12: {
            int INCREMENT = 250;
            if (this.currentCharacter == '\r') {
                int separatorPos = this.currentPosition - 1;
                if (this.linePtr >= 0 && this.lineEnds[this.linePtr] >= separatorPos) {
                    return;
                }
                int length = this.lineEnds.length;
                if (++this.linePtr >= length) {
                    this.lineEnds = new int[2 * length + 250];
                    System.arraycopy(this.lineEnds, 0, this.lineEnds, 0, length);
                }
                this.lineEnds[this.linePtr] = separatorPos;
                try {
                    if (this.source[this.currentPosition] == '\n') {
                        this.lineEnds[this.linePtr] = this.currentPosition++;
                        this.wasAcr = false;
                        break block12;
                    }
                    this.wasAcr = true;
                }
                catch (IndexOutOfBoundsException e) {
                    this.wasAcr = true;
                }
            } else if (this.currentCharacter == '\n') {
                if (this.wasAcr && this.lineEnds[this.linePtr] == this.currentPosition - 2) {
                    this.lineEnds[this.linePtr] = this.currentPosition - 1;
                } else {
                    int separatorPos = this.currentPosition - 1;
                    if (this.linePtr >= 0 && this.lineEnds[this.linePtr] >= separatorPos) {
                        return;
                    }
                    int length = this.lineEnds.length;
                    if (++this.linePtr >= length) {
                        this.lineEnds = new int[2 * length + 250];
                        System.arraycopy(this.lineEnds, 0, this.lineEnds, 0, length);
                    }
                    this.lineEnds[this.linePtr] = separatorPos;
                }
                this.wasAcr = false;
            }
        }
    }

    public final void pushUnicodeLineSeparator() {
        if (this.currentCharacter == '\r') {
            this.wasAcr = this.source[this.currentPosition] != '\n';
        } else if (this.currentCharacter == '\n') {
            this.wasAcr = false;
        }
    }

    public void recordComment(TerminalToken token) {
        int commentStart = this.startPosition;
        int stopPosition = this.currentPosition;
        boolean isMarkdown = false;
        switch (token) {
            case TokenNameCOMMENT_LINE: {
                commentStart = -this.startPosition;
                stopPosition = -this.lastCommentLinePosition;
                break;
            }
            case TokenNameCOMMENT_BLOCK: {
                stopPosition = -this.currentPosition;
                break;
            }
            case TokenNameCOMMENT_MARKDOWN: {
                isMarkdown = true;
                break;
            }
        }
        int length = this.commentStops.length;
        if (++this.commentPtr >= length) {
            int newLength = length + 300;
            this.growCommentInfoArrays(length, newLength);
        }
        this.commentStops[this.commentPtr] = stopPosition;
        this.commentStarts[this.commentPtr] = commentStart;
        this.commentIsMarkdown[this.commentPtr] = isMarkdown;
    }

    public void resetTo(int begin, int end) {
        this.resetTo(begin, end, this.isInModuleDeclaration());
    }

    public void resetTo(int begin, int end, boolean isModuleInfo) {
        this.resetTo(begin, end, isModuleInfo, null);
    }

    public void resetTo(int begin, int end, boolean isModuleInfo, ScanContext context) {
        this.diet = false;
        this.startPosition = this.currentPosition = begin;
        this.initialPosition = this.currentPosition;
        this.eofPosition = this.source != null && this.source.length < end ? this.source.length : (end < Integer.MAX_VALUE ? end + 1 : end);
        this.commentPtr = -1;
        this.foundTaskCount = 0;
        this.resetLookBack();
        this.nextToken = TerminalToken.TokenNameNotAToken;
        this.consumingEllipsisAnnotations = false;
        this.insideModuleInfo = isModuleInfo;
        this.scanContext = context == null ? this.getScanContext(begin) : context;
        this.scanningSwitchLabel = false;
    }

    final void resetLookBack() {
        this.lookBack[0] = this.lookBack[1] = TerminalToken.TokenNameNotAToken;
    }

    final void addTokenToLookBack(TerminalToken newToken) {
        switch (newToken) {
            case TokenNameWHITESPACE: 
            case TokenNameCOMMENT_LINE: 
            case TokenNameCOMMENT_BLOCK: 
            case TokenNameCOMMENT_JAVADOC: {
                return;
            }
        }
        if (newToken == TerminalToken.TokenNamecase) {
            this.scanningSwitchLabel = true;
        } else if (newToken == TerminalToken.TokenNameCaseArrow) {
            this.scanningSwitchLabel = false;
        } else if (this.scanningSwitchLabel && this.lookBack[1] == TerminalToken.TokenNameCOLON && (this.activeParser == null || this.activeParser.automatonWillShift(TerminalToken.TokenNamecase))) {
            this.scanningSwitchLabel = false;
        }
        this.lookBack[0] = this.lookBack[1];
        this.lookBack[1] = newToken;
    }

    private ScanContext getScanContext(int begin) {
        if (!this.isInModuleDeclaration()) {
            return ScanContext.INACTIVE;
        }
        if (begin == 0) {
            return ScanContext.EXPECTING_KEYWORD;
        }
        CompilerOptions options = new CompilerOptions();
        options.complianceLevel = this.complianceLevel;
        options.sourceLevel = this.sourceLevel;
        ModuleScanContextDetector parser = new ModuleScanContextDetector(options);
        return parser.getScanContext(this.source, begin - 1);
    }

    protected final void scanEscapeCharacter() throws InvalidInputException {
        switch (this.currentCharacter) {
            case 'b': {
                this.currentCharacter = (char)8;
                break;
            }
            case 't': {
                this.currentCharacter = (char)9;
                break;
            }
            case 'n': {
                this.currentCharacter = (char)10;
                break;
            }
            case 'f': {
                this.currentCharacter = (char)12;
                break;
            }
            case 'r': {
                this.currentCharacter = (char)13;
                break;
            }
            case '\"': {
                this.currentCharacter = (char)34;
                break;
            }
            case '\'': {
                this.currentCharacter = (char)39;
                break;
            }
            case 's': {
                if (this.sourceLevel < 0x3B0000L) {
                    throw Scanner.invalidEscape();
                }
                this.currentCharacter = (char)32;
                break;
            }
            case '\\': {
                this.currentCharacter = (char)92;
                break;
            }
            default: {
                int number = ScannerHelper.getHexadecimalValue(this.currentCharacter);
                if (number >= 0 && number <= 7) {
                    boolean zeroToThreeNot = number > 3;
                    if (ScannerHelper.isDigit(this.currentCharacter = this.source[this.currentPosition++])) {
                        int digit = ScannerHelper.getHexadecimalValue(this.currentCharacter);
                        if (digit >= 0 && digit <= 7) {
                            number = number * 8 + digit;
                            if (ScannerHelper.isDigit(this.currentCharacter = this.source[this.currentPosition++])) {
                                if (zeroToThreeNot) {
                                    --this.currentPosition;
                                } else {
                                    digit = ScannerHelper.getHexadecimalValue(this.currentCharacter);
                                    if (digit >= 0 && digit <= 7) {
                                        number = number * 8 + digit;
                                    } else {
                                        --this.currentPosition;
                                    }
                                }
                            } else {
                                --this.currentPosition;
                            }
                        } else {
                            --this.currentPosition;
                        }
                    } else {
                        --this.currentPosition;
                    }
                    if (number > 255) {
                        throw Scanner.invalidEscape();
                    }
                    this.currentCharacter = (char)number;
                    break;
                }
                throw Scanner.invalidEscape();
            }
        }
    }

    public TerminalToken scanIdentifierOrKeywordWithBoundCheck() {
        int index;
        char[] data;
        int length;
        int pos;
        this.useAssertAsAnIndentifier = false;
        this.useEnumAsAnIndentifier = false;
        char[] src = this.source;
        int srcLength = this.eofPosition;
        while ((pos = ++this.currentPosition) < srcLength) {
            char c = src[pos];
            if (c < '\u0080') {
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x3C) != 0) {
                    if (this.withoutUnicodePtr != 0) {
                        this.currentCharacter = c;
                        this.unicodeStore();
                    }
                    continue;
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x102) != 0) {
                    this.currentCharacter = c;
                    break;
                }
                while (this.getNextCharAsJavaIdentifierPartWithBoundCheck()) {
                }
                break;
            }
            while (this.getNextCharAsJavaIdentifierPartWithBoundCheck()) {
            }
            break block0;
        }
        if (this.withoutUnicodePtr == 0) {
            length = this.currentPosition - this.startPosition;
            if (length == 1) {
                return TerminalToken.TokenNameIdentifier;
            }
            data = this.source;
            index = this.startPosition;
        } else {
            length = this.withoutUnicodePtr;
            if (length == 1) {
                return TerminalToken.TokenNameIdentifier;
            }
            data = this.withoutUnicodeBuffer;
            index = 1;
        }
        return this.internalScanIdentifierOrKeyword(index, length, data);
    }

    public TerminalToken scanIdentifierOrKeyword() {
        int index;
        char[] data;
        int length;
        int pos;
        this.useAssertAsAnIndentifier = false;
        this.useEnumAsAnIndentifier = false;
        char[] src = this.source;
        int srcLength = this.eofPosition;
        while ((pos = ++this.currentPosition) < srcLength) {
            char c = src[pos];
            if (c < '\u0080') {
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x3C) != 0) {
                    if (this.withoutUnicodePtr != 0) {
                        this.currentCharacter = c;
                        this.unicodeStore();
                    }
                    continue;
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x102) != 0) {
                    this.currentCharacter = c;
                    break;
                }
                while (this.getNextCharAsJavaIdentifierPart()) {
                }
                break;
            }
            while (this.getNextCharAsJavaIdentifierPart()) {
            }
            break block0;
        }
        if (this.withoutUnicodePtr == 0) {
            length = this.currentPosition - this.startPosition;
            if (length == 1) {
                if (this.source[this.startPosition] == '_') {
                    return JavaFeature.UNNAMMED_PATTERNS_AND_VARS.isSupported(this.sourceLevel, this.previewEnabled) ? TerminalToken.TokenNameUNDERSCORE : TerminalToken.TokenNameIdentifier;
                }
                return TerminalToken.TokenNameIdentifier;
            }
            data = this.source;
            index = this.startPosition;
        } else {
            length = this.withoutUnicodePtr;
            if (length == 1) {
                if (this.withoutUnicodeBuffer[0] == '_') {
                    return JavaFeature.UNNAMMED_PATTERNS_AND_VARS.isSupported(this.sourceLevel, this.previewEnabled) ? TerminalToken.TokenNameUNDERSCORE : TerminalToken.TokenNameIdentifier;
                }
                return TerminalToken.TokenNameIdentifier;
            }
            data = this.withoutUnicodeBuffer;
            index = 1;
        }
        return this.internalScanIdentifierOrKeyword(index, length, data);
    }

    private TerminalToken internalScanIdentifierOrKeyword(int index, int length, char[] data) {
        switch (data[index]) {
            case 'a': {
                switch (length) {
                    case 8: {
                        if (data[++index] == 'b' && data[++index] == 's' && data[++index] == 't' && data[++index] == 'r' && data[++index] == 'a' && data[++index] == 'c' && data[++index] == 't') {
                            return TerminalToken.TokenNameabstract;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 6: {
                        if (data[++index] == 's' && data[++index] == 's' && data[++index] == 'e' && data[++index] == 'r' && data[++index] == 't') {
                            if (this.sourceLevel >= 0x300000L) {
                                this.containsAssertKeyword = true;
                                return TerminalToken.TokenNameassert;
                            }
                            this.useAssertAsAnIndentifier = true;
                            return TerminalToken.TokenNameIdentifier;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'b': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'y' && data[++index] == 't' && data[++index] == 'e') {
                            return TerminalToken.TokenNamebyte;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 5: {
                        if (data[++index] == 'r' && data[++index] == 'e' && data[++index] == 'a' && data[++index] == 'k') {
                            return TerminalToken.TokenNamebreak;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 7: {
                        if (data[++index] == 'o' && data[++index] == 'o' && data[++index] == 'l' && data[++index] == 'e' && data[++index] == 'a' && data[++index] == 'n') {
                            return TerminalToken.TokenNameboolean;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'c': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'a') {
                            if (data[++index] == 's' && data[++index] == 'e') {
                                return TerminalToken.TokenNamecase;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'h' && data[++index] == 'a' && data[++index] == 'r') {
                            return TerminalToken.TokenNamechar;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 5: {
                        if (data[++index] == 'a') {
                            if (data[++index] == 't' && data[++index] == 'c' && data[++index] == 'h') {
                                return TerminalToken.TokenNamecatch;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'l') {
                            if (data[++index] == 'a' && data[++index] == 's' && data[++index] == 's') {
                                return TerminalToken.TokenNameclass;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'o' && data[++index] == 'n' && data[++index] == 's' && data[++index] == 't') {
                            return TerminalToken.TokenNameconst;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 8: {
                        if (data[++index] == 'o' && data[++index] == 'n' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'n' && data[++index] == 'u' && data[++index] == 'e') {
                            return TerminalToken.TokenNamecontinue;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'd': {
                switch (length) {
                    case 2: {
                        if (data[++index] == 'o') {
                            return TerminalToken.TokenNamedo;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 6: {
                        if (data[++index] == 'o' && data[++index] == 'u' && data[++index] == 'b' && data[++index] == 'l' && data[++index] == 'e') {
                            return TerminalToken.TokenNamedouble;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 7: {
                        if (data[++index] == 'e' && data[++index] == 'f' && data[++index] == 'a' && data[++index] == 'u' && data[++index] == 'l' && data[++index] == 't') {
                            return TerminalToken.TokenNamedefault;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'e': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'l') {
                            if (data[++index] == 's' && data[++index] == 'e') {
                                return TerminalToken.TokenNameelse;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'n' && data[++index] == 'u' && data[++index] == 'm') {
                            if (this.sourceLevel >= 0x310000L) {
                                return TerminalToken.TokenNameenum;
                            }
                            this.useEnumAsAnIndentifier = true;
                            return TerminalToken.TokenNameIdentifier;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 7: {
                        if (data[++index] == 'x') {
                            if (data[++index] == 't' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 'd' && data[++index] == 's') {
                                return TerminalToken.TokenNameextends;
                            }
                            if (this.areRestrictedModuleKeywordsActive() && data[index] == 'p' && data[++index] == 'o' && data[++index] == 'r' && data[++index] == 't' && data[++index] == 's') {
                                return TerminalToken.TokenNameexports;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'f': {
                switch (length) {
                    case 3: {
                        if (data[++index] == 'o' && data[++index] == 'r') {
                            return TerminalToken.TokenNamefor;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 5: {
                        if (data[++index] == 'i') {
                            if (data[++index] == 'n' && data[++index] == 'a' && data[++index] == 'l') {
                                return TerminalToken.TokenNamefinal;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'l') {
                            if (data[++index] == 'o' && data[++index] == 'a' && data[++index] == 't') {
                                return TerminalToken.TokenNamefloat;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'a' && data[++index] == 'l' && data[++index] == 's' && data[++index] == 'e') {
                            return TerminalToken.TokenNamefalse;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 7: {
                        if (data[++index] == 'i' && data[++index] == 'n' && data[++index] == 'a' && data[++index] == 'l' && data[++index] == 'l' && data[++index] == 'y') {
                            return TerminalToken.TokenNamefinally;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'g': {
                if (length == 4 && data[++index] == 'o' && data[++index] == 't' && data[++index] == 'o') {
                    return TerminalToken.TokenNamegoto;
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'i': {
                switch (length) {
                    case 2: {
                        if (data[++index] == 'f') {
                            return TerminalToken.TokenNameif;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 3: {
                        if (data[++index] == 'n' && data[++index] == 't') {
                            return TerminalToken.TokenNameint;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 6: {
                        if (data[++index] == 'm' && data[++index] == 'p' && data[++index] == 'o' && data[++index] == 'r' && data[++index] == 't') {
                            if (this.scanContext == null || this.scanContext == ScanContext.INACTIVE) {
                                this.scanContext = ScanContext.EXPECTING_IDENTIFIER;
                            }
                            return TerminalToken.TokenNameimport;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 9: {
                        if (data[++index] == 'n' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'r' && data[++index] == 'f' && data[++index] == 'a' && data[++index] == 'c' && data[++index] == 'e') {
                            return TerminalToken.TokenNameinterface;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 10: {
                        if (data[++index] == 'm') {
                            if (data[++index] == 'p' && data[++index] == 'l' && data[++index] == 'e' && data[++index] == 'm' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 't' && data[++index] == 's') {
                                return TerminalToken.TokenNameimplements;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'n' && data[++index] == 's' && data[++index] == 't' && data[++index] == 'a' && data[++index] == 'n' && data[++index] == 'c' && data[++index] == 'e' && data[++index] == 'o' && data[++index] == 'f') {
                            return TerminalToken.TokenNameinstanceof;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'l': {
                if (length == 4 && data[++index] == 'o' && data[++index] == 'n' && data[++index] == 'g') {
                    return TerminalToken.TokenNamelong;
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'm': {
                switch (length) {
                    case 6: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'o' && data[++index] == 'd' && data[++index] == 'u' && data[++index] == 'l' && data[++index] == 'e') {
                            return TerminalToken.TokenNamemodule;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'n': {
                switch (length) {
                    case 3: {
                        if (data[++index] == 'e' && data[++index] == 'w') {
                            return TerminalToken.TokenNamenew;
                        }
                        if (data == this.source && data.length >= index + 10 && data[index] == 'o' && data[++index] == 'n' && data[++index] == '-' && data[++index] == 's' && data[++index] == 'e' && data[++index] == 'a' && data[++index] == 'l' && data[++index] == 'e' && data[++index] == 'd' && !ScannerHelper.isJavaIdentifierPart(data[++index])) {
                            this.currentPosition += 7;
                            TerminalToken t = this.disambiguatesRestrictedIdentifierWithLookAhead(TerminalToken.TokenNamenon_sealed);
                            if (t == TerminalToken.TokenNamenon_sealed) {
                                return TerminalToken.TokenNamenon_sealed;
                            }
                            this.currentPosition -= 7;
                            return TerminalToken.TokenNameIdentifier;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 4: {
                        if (data[++index] == 'u' && data[++index] == 'l' && data[++index] == 'l') {
                            return TerminalToken.TokenNamenull;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 6: {
                        if (data[++index] == 'a' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'v' && data[++index] == 'e') {
                            return TerminalToken.TokenNamenative;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'o': {
                switch (length) {
                    case 4: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'p' && data[++index] == 'e' && data[++index] == 'n') {
                            return TerminalToken.TokenNameopen;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 5: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'p' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 's') {
                            return TerminalToken.TokenNameopens;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'p': {
                switch (length) {
                    case 6: {
                        if (data[++index] == 'u' && data[++index] == 'b' && data[++index] == 'l' && data[++index] == 'i' && data[++index] == 'c') {
                            return TerminalToken.TokenNamepublic;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 7: {
                        if (data[++index] == 'a') {
                            if (data[++index] == 'c' && data[++index] == 'k' && data[++index] == 'a' && data[++index] == 'g' && data[++index] == 'e') {
                                return TerminalToken.TokenNamepackage;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'r' && data[++index] == 'i' && data[++index] == 'v' && data[++index] == 'a' && data[++index] == 't' && data[++index] == 'e') {
                            return TerminalToken.TokenNameprivate;
                        }
                        if (data[index] == 'e' && data[++index] == 'r' && data[++index] == 'm' && data[++index] == 'i' && data[++index] == 't' && data[++index] == 's') {
                            return this.disambiguatesRestrictedIdentifierWithLookAhead(TerminalToken.TokenNameRestrictedIdentifierpermits);
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 8: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'v' && data[++index] == 'i' && data[++index] == 'd' && data[++index] == 'e' && data[++index] == 's') {
                            return TerminalToken.TokenNameprovides;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 9: {
                        if (data[++index] == 'r' && data[++index] == 'o' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'c' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'd') {
                            return TerminalToken.TokenNameprotected;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'r': {
                switch (length) {
                    case 6: {
                        if (data[++index] == 'e') {
                            if (data[++index] == 't' && data[++index] == 'u' && data[++index] == 'r' && data[++index] == 'n') {
                                return TerminalToken.TokenNamereturn;
                            }
                            if (data[index] == 'c' && data[++index] == 'o' && data[++index] == 'r' && data[++index] == 'd') {
                                return this.disambiguateRecord();
                            }
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 8: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'e' && data[++index] == 'q' && data[++index] == 'u' && data[++index] == 'i' && data[++index] == 'r' && data[++index] == 'e' && data[++index] == 's') {
                            return TerminalToken.TokenNamerequires;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 's': {
                switch (length) {
                    case 5: {
                        if (data[++index] == 'h') {
                            if (data[++index] == 'o' && data[++index] == 'r' && data[++index] == 't') {
                                return TerminalToken.TokenNameshort;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'u' && data[++index] == 'p' && data[++index] == 'e' && data[++index] == 'r') {
                            return TerminalToken.TokenNamesuper;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 6: {
                        if (data[++index] == 't') {
                            if (data[++index] == 'a' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'c') {
                                return TerminalToken.TokenNamestatic;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'w' && data[++index] == 'i' && data[++index] == 't' && data[++index] == 'c' && data[++index] == 'h') {
                            return TerminalToken.TokenNameswitch;
                        }
                        if (data[index] == 'e' && data[++index] == 'a' && data[++index] == 'l' && data[++index] == 'e' && data[++index] == 'd') {
                            return this.disambiguatesRestrictedIdentifierWithLookAhead(TerminalToken.TokenNameRestrictedIdentifiersealed);
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 8: {
                        if (data[++index] == 't' && data[++index] == 'r' && data[++index] == 'i' && data[++index] == 'c' && data[++index] == 't' && data[++index] == 'f' && data[++index] == 'p') {
                            return TerminalToken.TokenNamestrictfp;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 12: {
                        if (data[++index] == 'y' && data[++index] == 'n' && data[++index] == 'c' && data[++index] == 'h' && data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'n' && data[++index] == 'i' && data[++index] == 'z' && data[++index] == 'e' && data[++index] == 'd') {
                            return TerminalToken.TokenNamesynchronized;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 't': {
                switch (length) {
                    case 2: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'o') {
                            return TerminalToken.TokenNameto;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 3: {
                        if (data[++index] == 'r' && data[++index] == 'y') {
                            return TerminalToken.TokenNametry;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 4: {
                        if (data[++index] == 'h') {
                            if (data[++index] == 'i' && data[++index] == 's') {
                                return TerminalToken.TokenNamethis;
                            }
                            return TerminalToken.TokenNameIdentifier;
                        }
                        if (data[index] == 'r' && data[++index] == 'u' && data[++index] == 'e') {
                            return TerminalToken.TokenNametrue;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 5: {
                        if (data[++index] == 'h' && data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'w') {
                            return TerminalToken.TokenNamethrow;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 6: {
                        if (data[++index] == 'h' && data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'w' && data[++index] == 's') {
                            return TerminalToken.TokenNamethrows;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 9: {
                        if (data[++index] == 'r' && data[++index] == 'a' && data[++index] == 'n' && data[++index] == 's' && data[++index] == 'i' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 't') {
                            return TerminalToken.TokenNametransient;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 10: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'r' && data[++index] == 'a' && data[++index] == 'n' && data[++index] == 's' && data[++index] == 'i' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'v' && data[++index] == 'e') {
                            return TerminalToken.TokenNametransitive;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'u': {
                switch (length) {
                    case 4: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 's' && data[++index] == 'e' && data[++index] == 's') {
                            return TerminalToken.TokenNameuses;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'v': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'o' && data[++index] == 'i' && data[++index] == 'd') {
                            return TerminalToken.TokenNamevoid;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 8: {
                        if (data[++index] == 'o' && data[++index] == 'l' && data[++index] == 'a' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'l' && data[++index] == 'e') {
                            return TerminalToken.TokenNamevolatile;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'w': {
                switch (length) {
                    case 4: {
                        if (this.areRestrictedModuleKeywordsActive() && data[++index] == 'i' && data[++index] == 't' && data[++index] == 'h') {
                            return TerminalToken.TokenNamewith;
                        }
                        if (data[++index] == 'h' && data[++index] == 'e' && data[++index] == 'n') {
                            return this.disambiguateWhen();
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                    case 5: {
                        if (data[++index] == 'h' && data[++index] == 'i' && data[++index] == 'l' && data[++index] == 'e') {
                            return TerminalToken.TokenNamewhile;
                        }
                        return TerminalToken.TokenNameIdentifier;
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
            case 'y': {
                switch (length) {
                    case 5: {
                        if (data[++index] != 'i' || data[++index] != 'e' || data[++index] != 'l' || data[++index] != 'd') break;
                        return this.disambiguateYield();
                    }
                }
                return TerminalToken.TokenNameIdentifier;
            }
        }
        return TerminalToken.TokenNameIdentifier;
    }

    public TerminalToken scanNumber(boolean dotPrefix) throws InvalidInputException {
        boolean floating = dotPrefix;
        if (!dotPrefix && this.currentCharacter == '0') {
            if (this.getNextChar('x', 'X') >= 0) {
                int start = this.currentPosition;
                this.consumeDigits(16, true);
                int end = this.currentPosition;
                if (this.getNextChar('l', 'L') >= 0) {
                    if (end == start) {
                        throw Scanner.invalidHexa();
                    }
                    return TerminalToken.TokenNameLongLiteral;
                }
                if (this.getNextChar('.')) {
                    boolean hasNoDigitsBeforeDot = end == start;
                    start = this.currentPosition;
                    this.consumeDigits(16, true);
                    end = this.currentPosition;
                    if (hasNoDigitsBeforeDot && end == start) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        throw Scanner.invalidHexa();
                    }
                    if (this.getNextChar('p', 'P') >= 0) {
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                        } else if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                        if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                            this.unicodeAsBackSlash = false;
                            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                            } else if (this.withoutUnicodePtr != 0) {
                                this.unicodeStore();
                            }
                        }
                        if (!ScannerHelper.isDigit(this.currentCharacter)) {
                            if (this.sourceLevel < 0x310000L) {
                                throw Scanner.illegalHexaLiteral();
                            }
                            if (this.currentCharacter == '_') {
                                this.consumeDigits(10);
                                throw Scanner.invalidUnderscore();
                            }
                            throw Scanner.invalidHexa();
                        }
                        this.consumeDigits(10);
                        if (this.getNextChar('f', 'F') >= 0) {
                            if (this.sourceLevel < 0x310000L) {
                                throw Scanner.illegalHexaLiteral();
                            }
                            return TerminalToken.TokenNameFloatingPointLiteral;
                        }
                        if (this.getNextChar('d', 'D') >= 0) {
                            if (this.sourceLevel < 0x310000L) {
                                throw Scanner.illegalHexaLiteral();
                            }
                            return TerminalToken.TokenNameDoubleLiteral;
                        }
                        if (this.getNextChar('l', 'L') >= 0) {
                            if (this.sourceLevel < 0x310000L) {
                                throw Scanner.illegalHexaLiteral();
                            }
                            throw Scanner.invalidHexa();
                        }
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        return TerminalToken.TokenNameDoubleLiteral;
                    }
                    if (this.sourceLevel < 0x310000L) {
                        throw Scanner.illegalHexaLiteral();
                    }
                    throw Scanner.invalidHexa();
                }
                if (this.getNextChar('p', 'P') >= 0) {
                    if (end == start) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        throw Scanner.invalidHexa();
                    }
                    this.unicodeAsBackSlash = false;
                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                        this.getNextUnicodeChar();
                    } else if (this.withoutUnicodePtr != 0) {
                        this.unicodeStore();
                    }
                    if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                        } else if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    }
                    if (!ScannerHelper.isDigit(this.currentCharacter)) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        if (this.currentCharacter == '_') {
                            this.consumeDigits(10);
                            throw Scanner.invalidUnderscore();
                        }
                        throw Scanner.invalidFloat();
                    }
                    this.consumeDigits(10);
                    if (this.getNextChar('f', 'F') >= 0) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        return TerminalToken.TokenNameFloatingPointLiteral;
                    }
                    if (this.getNextChar('d', 'D') >= 0) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        return TerminalToken.TokenNameDoubleLiteral;
                    }
                    if (this.getNextChar('l', 'L') >= 0) {
                        if (this.sourceLevel < 0x310000L) {
                            throw Scanner.illegalHexaLiteral();
                        }
                        throw Scanner.invalidHexa();
                    }
                    if (this.sourceLevel < 0x310000L) {
                        throw Scanner.illegalHexaLiteral();
                    }
                    return TerminalToken.TokenNameDoubleLiteral;
                }
                if (end == start) {
                    throw Scanner.invalidHexa();
                }
                return TerminalToken.TokenNameIntegerLiteral;
            }
            if (this.getNextChar('b', 'B') >= 0) {
                int start = this.currentPosition;
                this.consumeDigits(2, true);
                int end = this.currentPosition;
                if (end == start) {
                    if (this.sourceLevel < 0x330000L) {
                        throw Scanner.invalidBinaryLiteral();
                    }
                    throw Scanner.invalidBinary();
                }
                if (this.getNextChar('l', 'L') >= 0) {
                    if (this.sourceLevel < 0x330000L) {
                        throw Scanner.invalidBinaryLiteral();
                    }
                    return TerminalToken.TokenNameLongLiteral;
                }
                if (this.sourceLevel < 0x330000L) {
                    throw Scanner.invalidBinaryLiteral();
                }
                return TerminalToken.TokenNameIntegerLiteral;
            }
            if (this.getNextCharAsDigit()) {
                this.consumeDigits(10);
                if (this.getNextChar('l', 'L') >= 0) {
                    return TerminalToken.TokenNameLongLiteral;
                }
                if (this.getNextChar('f', 'F') >= 0) {
                    return TerminalToken.TokenNameFloatingPointLiteral;
                }
                if (this.getNextChar('d', 'D') >= 0) {
                    return TerminalToken.TokenNameDoubleLiteral;
                }
                boolean isInteger = true;
                if (this.getNextChar('.')) {
                    isInteger = false;
                    this.consumeDigits(10);
                }
                if (this.getNextChar('e', 'E') >= 0) {
                    isInteger = false;
                    this.unicodeAsBackSlash = false;
                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                        this.getNextUnicodeChar();
                    } else if (this.withoutUnicodePtr != 0) {
                        this.unicodeStore();
                    }
                    if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                        } else if (this.withoutUnicodePtr != 0) {
                            this.unicodeStore();
                        }
                    }
                    if (!ScannerHelper.isDigit(this.currentCharacter)) {
                        if (this.currentCharacter == '_') {
                            this.consumeDigits(10);
                            throw Scanner.invalidUnderscore();
                        }
                        throw Scanner.invalidFloat();
                    }
                    this.consumeDigits(10);
                }
                if (this.getNextChar('f', 'F') >= 0) {
                    return TerminalToken.TokenNameFloatingPointLiteral;
                }
                if (this.getNextChar('d', 'D') >= 0 || !isInteger) {
                    return TerminalToken.TokenNameDoubleLiteral;
                }
                return TerminalToken.TokenNameIntegerLiteral;
            }
        }
        this.consumeDigits(10);
        if (!dotPrefix && this.getNextChar('l', 'L') >= 0) {
            return TerminalToken.TokenNameLongLiteral;
        }
        if (!dotPrefix && this.getNextChar('.')) {
            this.consumeDigits(10, true);
            floating = true;
        }
        if (this.getNextChar('e', 'E') >= 0) {
            floating = true;
            this.unicodeAsBackSlash = false;
            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
            } else if (this.withoutUnicodePtr != 0) {
                this.unicodeStore();
            }
            if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                } else if (this.withoutUnicodePtr != 0) {
                    this.unicodeStore();
                }
            }
            if (!ScannerHelper.isDigit(this.currentCharacter)) {
                if (this.currentCharacter == '_') {
                    this.consumeDigits(10);
                    throw Scanner.invalidUnderscore();
                }
                throw Scanner.invalidFloat();
            }
            this.consumeDigits(10);
        }
        if (this.getNextChar('d', 'D') >= 0) {
            return TerminalToken.TokenNameDoubleLiteral;
        }
        if (this.getNextChar('f', 'F') >= 0) {
            return TerminalToken.TokenNameFloatingPointLiteral;
        }
        return floating ? TerminalToken.TokenNameDoubleLiteral : TerminalToken.TokenNameIntegerLiteral;
    }

    public final int getLineNumber(int position) {
        return Util.getLineNumber(position, this.lineEnds, 0, this.linePtr);
    }

    public final void setSource(char[] sourceString) {
        int sourceLength;
        if (sourceString == null) {
            this.source = CharOperation.NO_CHAR;
            sourceLength = 0;
        } else {
            this.source = sourceString;
            sourceLength = sourceString.length;
        }
        this.startPosition = -1;
        this.eofPosition = sourceLength;
        this.currentPosition = 0;
        this.initialPosition = 0;
        this.containsAssertKeyword = false;
        this.linePtr = -1;
        this.scanContext = null;
        this.insideModuleInfo = false;
    }

    public final void setSource(char[] contents, CompilationResult compilationResult) {
        if (contents == null) {
            char[] cuContents = compilationResult.compilationUnit.getContents();
            this.setSource(cuContents);
        } else {
            this.setSource(contents);
        }
        int[] lineSeparatorPositions = compilationResult.lineSeparatorPositions;
        if (lineSeparatorPositions != null) {
            this.lineEnds = lineSeparatorPositions;
            this.linePtr = lineSeparatorPositions.length - 1;
        }
    }

    public final void setSource(CompilationResult compilationResult) {
        this.setSource(null, compilationResult);
    }

    public String toString() {
        if (this.startPosition == this.eofPosition) {
            return "EOF\n\n" + new String(this.source);
        }
        if (this.currentPosition > this.eofPosition) {
            return "behind the EOF\n\n" + new String(this.source);
        }
        if (this.currentPosition <= 0) {
            return "NOT started!\n\n" + (this.source != null ? new String(this.source) : "");
        }
        StringBuilder buffer = new StringBuilder();
        if (this.startPosition < 1000) {
            buffer.append(this.source, 0, this.startPosition);
        } else {
            buffer.append("<source beginning>\n...\n");
            int line = Util.getLineNumber(this.startPosition - 1000, this.lineEnds, 0, this.linePtr);
            int lineStart = this.getLineStart(line);
            buffer.append(this.source, lineStart, this.startPosition - lineStart);
        }
        buffer.append("\n===============================\nStarts here -->");
        int middleLength = this.currentPosition - 1 - this.startPosition + 1;
        if (middleLength > -1) {
            buffer.append(this.source, this.startPosition, middleLength);
        }
        if (this.nextToken != TerminalToken.TokenNameNotAToken) {
            buffer.append("<-- Ends here [in pipeline " + this.toStringAction(this.nextToken) + "]\n===============================\n");
        } else {
            buffer.append("<-- Ends here\n===============================\n");
        }
        buffer.append(this.source, this.currentPosition - 1 + 1, this.eofPosition - (this.currentPosition - 1) - 1);
        return buffer.toString();
    }

    public String toStringAction(TerminalToken act) {
        switch (act) {
            case TokenNameIdentifier: {
                return "Identifier(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case TokenNameRestrictedIdentifierWhen: {
                return "when";
            }
            case TokenNameRestrictedIdentifierYield: {
                return "yield";
            }
            case TokenNameRestrictedIdentifierrecord: {
                return "record";
            }
            case TokenNameabstract: {
                return "abstract";
            }
            case TokenNameboolean: {
                return "boolean";
            }
            case TokenNamebreak: {
                return "break";
            }
            case TokenNamebyte: {
                return "byte";
            }
            case TokenNamecase: {
                return "case";
            }
            case TokenNamecatch: {
                return "catch";
            }
            case TokenNamechar: {
                return "char";
            }
            case TokenNameclass: {
                return "class";
            }
            case TokenNamecontinue: {
                return "continue";
            }
            case TokenNamedefault: {
                return "default";
            }
            case TokenNamedo: {
                return "do";
            }
            case TokenNamedouble: {
                return "double";
            }
            case TokenNameelse: {
                return "else";
            }
            case TokenNameextends: {
                return "extends";
            }
            case TokenNamefalse: {
                return "false";
            }
            case TokenNamefinal: {
                return "final";
            }
            case TokenNamefinally: {
                return "finally";
            }
            case TokenNamefloat: {
                return "float";
            }
            case TokenNamefor: {
                return "for";
            }
            case TokenNameif: {
                return "if";
            }
            case TokenNameimplements: {
                return "implements";
            }
            case TokenNameimport: {
                return "import";
            }
            case TokenNameinstanceof: {
                return "instanceof";
            }
            case TokenNameint: {
                return "int";
            }
            case TokenNameinterface: {
                return "interface";
            }
            case TokenNamelong: {
                return "long";
            }
            case TokenNamenative: {
                return "native";
            }
            case TokenNamenew: {
                return "new";
            }
            case TokenNamenon_sealed: {
                return "non-sealed";
            }
            case TokenNamenull: {
                return "null";
            }
            case TokenNamepackage: {
                return "package";
            }
            case TokenNameRestrictedIdentifierpermits: {
                return "permits";
            }
            case TokenNameprivate: {
                return "private";
            }
            case TokenNameprotected: {
                return "protected";
            }
            case TokenNamepublic: {
                return "public";
            }
            case TokenNamereturn: {
                return "return";
            }
            case TokenNameRestrictedIdentifiersealed: {
                return "sealed";
            }
            case TokenNameshort: {
                return "short";
            }
            case TokenNamestatic: {
                return "static";
            }
            case TokenNamesuper: {
                return "super";
            }
            case TokenNameswitch: {
                return "switch";
            }
            case TokenNamesynchronized: {
                return "synchronized";
            }
            case TokenNamethis: {
                return "this";
            }
            case TokenNamethrow: {
                return "throw";
            }
            case TokenNamethrows: {
                return "throws";
            }
            case TokenNametransient: {
                return "transient";
            }
            case TokenNametrue: {
                return "true";
            }
            case TokenNametry: {
                return "try";
            }
            case TokenNamevoid: {
                return "void";
            }
            case TokenNamevolatile: {
                return "volatile";
            }
            case TokenNamewhile: {
                return "while";
            }
            case TokenNamemodule: {
                return "module";
            }
            case TokenNamerequires: {
                return "requires";
            }
            case TokenNameexports: {
                return "exports";
            }
            case TokenNameIntegerLiteral: {
                return "Integer(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case TokenNameLongLiteral: {
                return "Long(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case TokenNameFloatingPointLiteral: {
                return "Float(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case TokenNameDoubleLiteral: {
                return "Double(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case TokenNameCharacterLiteral: {
                return "Char(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case TokenNameStringLiteral: {
                return "String(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case TokenNameTextBlock: {
                return "String(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case TokenNamePLUS_PLUS: {
                return "++";
            }
            case TokenNameMINUS_MINUS: {
                return "--";
            }
            case TokenNameEQUAL_EQUAL: {
                return "==";
            }
            case TokenNameLESS_EQUAL: {
                return "<=";
            }
            case TokenNameGREATER_EQUAL: {
                return ">=";
            }
            case TokenNameNOT_EQUAL: {
                return "!=";
            }
            case TokenNameLEFT_SHIFT: {
                return "<<";
            }
            case TokenNameRIGHT_SHIFT: {
                return ">>";
            }
            case TokenNameUNSIGNED_RIGHT_SHIFT: {
                return ">>>";
            }
            case TokenNamePLUS_EQUAL: {
                return "+=";
            }
            case TokenNameMINUS_EQUAL: {
                return "-=";
            }
            case TokenNameARROW: {
                return "->";
            }
            case TokenNameMULTIPLY_EQUAL: {
                return "*=";
            }
            case TokenNameDIVIDE_EQUAL: {
                return "/=";
            }
            case TokenNameAND_EQUAL: {
                return "&=";
            }
            case TokenNameOR_EQUAL: {
                return "|=";
            }
            case TokenNameXOR_EQUAL: {
                return "^=";
            }
            case TokenNameREMAINDER_EQUAL: {
                return "%=";
            }
            case TokenNameLEFT_SHIFT_EQUAL: {
                return "<<=";
            }
            case TokenNameRIGHT_SHIFT_EQUAL: {
                return ">>=";
            }
            case TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL: {
                return ">>>=";
            }
            case TokenNameOR_OR: {
                return "||";
            }
            case TokenNameAND_AND: {
                return "&&";
            }
            case TokenNamePLUS: {
                return "+";
            }
            case TokenNameMINUS: {
                return "-";
            }
            case TokenNameNOT: {
                return "!";
            }
            case TokenNameREMAINDER: {
                return "%";
            }
            case TokenNameXOR: {
                return "^";
            }
            case TokenNameAND: {
                return "&";
            }
            case TokenNameMULTIPLY: {
                return "*";
            }
            case TokenNameOR: {
                return "|";
            }
            case TokenNameTWIDDLE: {
                return "~";
            }
            case TokenNameDIVIDE: {
                return "/";
            }
            case TokenNameGREATER: {
                return ">";
            }
            case TokenNameLESS: {
                return "<";
            }
            case TokenNameLPAREN: {
                return "(";
            }
            case TokenNameRPAREN: {
                return ")";
            }
            case TokenNameLBRACE: {
                return "{";
            }
            case TokenNameRBRACE: {
                return "}";
            }
            case TokenNameLBRACKET: {
                return "[";
            }
            case TokenNameRBRACKET: {
                return "]";
            }
            case TokenNameSEMICOLON: {
                return ";";
            }
            case TokenNameQUESTION: {
                return "?";
            }
            case TokenNameCOLON: {
                return ":";
            }
            case TokenNameCOLON_COLON: {
                return "::";
            }
            case TokenNameCOMMA: {
                return ",";
            }
            case TokenNameDOT: {
                return ".";
            }
            case TokenNameEQUAL: {
                return "=";
            }
            case TokenNameEOF: {
                return "EOF";
            }
            case TokenNameWHITESPACE: {
                return "white_space(" + new String(this.getCurrentTokenSource()) + ")";
            }
        }
        return "not-a-token";
    }

    public void unicodeInitializeBuffer(int length) {
        int bLength;
        this.withoutUnicodePtr = length;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[length + 11];
        }
        if (1 + length >= (bLength = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[length + 11];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, bLength);
        }
        System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, length);
    }

    public void unicodeStore() {
        int length;
        int pos = ++this.withoutUnicodePtr;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[10];
        }
        if (pos == (length = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[length * 2];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, length);
        }
        this.withoutUnicodeBuffer[pos] = this.currentCharacter;
    }

    public void unicodeStore(char character) {
        int length;
        int pos = ++this.withoutUnicodePtr;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[10];
        }
        if (pos == (length = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[length * 2];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, length);
        }
        this.withoutUnicodeBuffer[pos] = character;
    }

    public static boolean isIdentifier(TerminalToken token) {
        return token == TerminalToken.TokenNameIdentifier;
    }

    public static boolean isLiteral(TerminalToken token) {
        switch (token) {
            case TokenNameIntegerLiteral: 
            case TokenNameLongLiteral: 
            case TokenNameFloatingPointLiteral: 
            case TokenNameDoubleLiteral: 
            case TokenNameCharacterLiteral: 
            case TokenNameStringLiteral: 
            case TokenNameTextBlock: {
                return true;
            }
        }
        return false;
    }

    public static boolean isKeyword(TerminalToken token) {
        switch (token) {
            case TokenNameabstract: 
            case TokenNameassert: 
            case TokenNameboolean: 
            case TokenNamebreak: 
            case TokenNamebyte: 
            case TokenNamecase: 
            case TokenNamecatch: 
            case TokenNamechar: 
            case TokenNameclass: 
            case TokenNamecontinue: 
            case TokenNamedefault: 
            case TokenNamedo: 
            case TokenNamedouble: 
            case TokenNameelse: 
            case TokenNameextends: 
            case TokenNamefalse: 
            case TokenNamefinal: 
            case TokenNamefinally: 
            case TokenNamefloat: 
            case TokenNamefor: 
            case TokenNameif: 
            case TokenNameimplements: 
            case TokenNameimport: 
            case TokenNameinstanceof: 
            case TokenNameint: 
            case TokenNameinterface: 
            case TokenNamelong: 
            case TokenNamenative: 
            case TokenNamenew: 
            case TokenNamenull: 
            case TokenNamepackage: 
            case TokenNameprivate: 
            case TokenNameprotected: 
            case TokenNamepublic: 
            case TokenNamereturn: 
            case TokenNameshort: 
            case TokenNamestatic: 
            case TokenNamestrictfp: 
            case TokenNamesuper: 
            case TokenNameswitch: 
            case TokenNamesynchronized: 
            case TokenNamethis: 
            case TokenNamethrow: 
            case TokenNamethrows: 
            case TokenNametransient: 
            case TokenNametrue: 
            case TokenNametry: 
            case TokenNamevoid: 
            case TokenNamevolatile: 
            case TokenNamewhile: {
                return true;
            }
        }
        return false;
    }

    private VanguardParser getVanguardParser() {
        if (this.vanguardParser == null) {
            this.vanguardScanner = new VanguardScanner(this.sourceLevel, this.complianceLevel, this.previewEnabled);
            this.vanguardParser = new VanguardParser(this.vanguardScanner);
            this.vanguardScanner.setActiveParser(this.vanguardParser);
        }
        this.vanguardScanner.setSource(this.source);
        this.vanguardScanner.resetTo(this.startPosition, this.eofPosition - 1, this.isInModuleDeclaration(), this.scanContext);
        return this.vanguardParser;
    }

    private VanguardParser getNewVanguardParser() {
        VanguardScanner vs = this.getNewVanguardScanner();
        VanguardParser vp = new VanguardParser(vs);
        vs.setActiveParser(vp);
        return vp;
    }

    private VanguardScanner getNewVanguardScanner() {
        VanguardScanner vs = new VanguardScanner(this.sourceLevel, this.complianceLevel, this.previewEnabled);
        vs.setSource(this.source);
        vs.resetTo(this.startPosition, this.eofPosition - 1, this.isInModuleDeclaration(), this.scanContext);
        return vs;
    }

    protected final boolean maybeAtLambdaOrCast() {
        if (this.isInModuleDeclaration()) {
            return false;
        }
        switch (this.lookBack[1]) {
            case TokenNameIdentifier: 
            case TokenNamecase: 
            case TokenNamecatch: 
            case TokenNamefor: 
            case TokenNameif: 
            case TokenNamesuper: 
            case TokenNameswitch: 
            case TokenNamesynchronized: 
            case TokenNamethis: 
            case TokenNametry: 
            case TokenNamewhile: {
                return false;
            }
        }
        return this.activeParser.atConflictScenario(TerminalToken.TokenNameLPAREN);
    }

    protected final boolean maybeAtReferenceExpression() {
        if (this.isInModuleDeclaration()) {
            return false;
        }
        switch (this.lookBack[1]) {
            case TokenNameIdentifier: {
                switch (this.lookBack[0]) {
                    case TokenNameabstract: 
                    case TokenNameclass: 
                    case TokenNamedefault: 
                    case TokenNameenum: 
                    case TokenNameextends: 
                    case TokenNamefinal: 
                    case TokenNameimplements: 
                    case TokenNameinstanceof: 
                    case TokenNameinterface: 
                    case TokenNamenew: 
                    case TokenNamenon_sealed: 
                    case TokenNameprivate: 
                    case TokenNameprotected: 
                    case TokenNamepublic: 
                    case TokenNamestatic: 
                    case TokenNamesuper: 
                    case TokenNamethrows: 
                    case TokenNameRIGHT_SHIFT: 
                    case TokenNameAND: 
                    case TokenNameGREATER: 
                    case TokenNameLESS: 
                    case TokenNameRBRACE: 
                    case TokenNameSEMICOLON: 
                    case TokenNameAT: 
                    case TokenNameRestrictedIdentifiersealed: 
                    case TokenNameRestrictedIdentifierpermits: {
                        return false;
                    }
                }
                break;
            }
            case TokenNameNotAToken: {
                break;
            }
            default: {
                return false;
            }
        }
        return this.activeParser.atConflictScenario(TerminalToken.TokenNameLESS);
    }

    private final boolean maybeAtEllipsisAnnotationsStart() {
        if (this.consumingEllipsisAnnotations) {
            return false;
        }
        switch (this.lookBack[1]) {
            case TokenNameextends: 
            case TokenNameimplements: 
            case TokenNameinstanceof: 
            case TokenNamenew: 
            case TokenNamesuper: 
            case TokenNamethrows: 
            case TokenNameAND: 
            case TokenNameLESS: 
            case TokenNameLBRACE: 
            case TokenNameCOMMA: 
            case TokenNameDOT: 
            case TokenNameRestrictedIdentifierpermits: {
                return false;
            }
        }
        return true;
    }

    protected final boolean atTypeAnnotation() {
        return !this.activeParser.atConflictScenario(TerminalToken.TokenNameAT);
    }

    public void setActiveParser(ConflictedParser parser) {
        this.activeParser = parser;
        this.resetLookBack();
        if (parser != null) {
            this.insideModuleInfo = parser.isParsingModuleDeclaration();
        }
        this.scanningSwitchLabel = false;
    }

    public static boolean isRestrictedKeyword(TerminalToken token) {
        switch (token) {
            case TokenNamemodule: 
            case TokenNameopen: 
            case TokenNamerequires: 
            case TokenNametransitive: 
            case TokenNameexports: 
            case TokenNameopens: 
            case TokenNameto: 
            case TokenNameuses: 
            case TokenNameprovides: 
            case TokenNamewith: {
                return true;
            }
        }
        return false;
    }

    private boolean mayBeAtAnYieldStatement() {
        if (this.isInModuleDeclaration()) {
            return false;
        }
        switch (this.lookBack[1]) {
            case TokenNamedo: 
            case TokenNameelse: 
            case TokenNameRPAREN: 
            case TokenNameLBRACE: 
            case TokenNameRBRACE: 
            case TokenNameSEMICOLON: {
                return true;
            }
            case TokenNameCOLON: {
                return this.lookBack[0] == TerminalToken.TokenNamedefault || this.scanningSwitchLabel && (this.activeParser == null || this.activeParser.automatonWillShift(TerminalToken.TokenNamecase));
            }
        }
        return false;
    }

    TerminalToken disambiguateRecord() {
        if (JavaFeature.RECORDS.isSupported(this.complianceLevel, this.previewEnabled) && this.disambiguateRecordWithLookAhead()) {
            return TerminalToken.TokenNameRestrictedIdentifierrecord;
        }
        return TerminalToken.TokenNameIdentifier;
    }

    private TerminalToken getNextTokenAfterTypeParameterHeader() {
        block8: {
            int count = 1;
            try {
                TerminalToken token;
                while ((token = this.vanguardScanner.getNextToken()) != TerminalToken.TokenNameNotAToken) {
                    if (token != TerminalToken.TokenNameEOF) {
                        if (token == TerminalToken.TokenNameLESS) {
                            ++count;
                        }
                        if (token == TerminalToken.TokenNameGREATER) {
                            --count;
                        }
                        if (token == TerminalToken.TokenNameRIGHT_SHIFT) {
                            count -= 2;
                        }
                        if (token == TerminalToken.TokenNameUNSIGNED_RIGHT_SHIFT) {
                            count -= 3;
                        }
                        if (count > 0) continue;
                        return this.vanguardScanner.getNextToken();
                    }
                    break;
                }
            }
            catch (InvalidInputException e) {
                if (e.getMessage().equals(INVALID_CHAR_IN_STRING)) break block8;
                e.printStackTrace();
            }
        }
        return TerminalToken.TokenNameEOF;
    }

    private boolean disambiguateRecordWithLookAhead() {
        block4: {
            TerminalToken lookAhead2;
            block5: {
                if (this.isInModuleDeclaration()) {
                    return false;
                }
                this.getVanguardParser();
                this.vanguardScanner.resetTo(this.currentPosition, this.eofPosition - 1);
                TerminalToken lookAhead1 = this.vanguardScanner.getNextToken();
                if (lookAhead1 != TerminalToken.TokenNameIdentifier) break block4;
                lookAhead2 = this.vanguardScanner.getNextToken();
                TerminalToken terminalToken = lookAhead2 = lookAhead2 == TerminalToken.TokenNameLESS ? this.getNextTokenAfterTypeParameterHeader() : lookAhead2;
                if (lookAhead2 != TerminalToken.TokenNameLBRACE) break block5;
                return true;
            }
            try {
                return lookAhead2 == TerminalToken.TokenNameLPAREN;
            }
            catch (InvalidInputException e) {
                if (e.getMessage().equals(INVALID_CHAR_IN_STRING)) break block4;
                e.printStackTrace();
            }
        }
        return false;
    }

    TerminalToken disambiguateWhen() {
        return this.activeParser == null || !this.activeParser.automatonWillShift(TerminalToken.TokenNameRestrictedIdentifierWhen) ? TerminalToken.TokenNameIdentifier : TerminalToken.TokenNameRestrictedIdentifierWhen;
    }

    TerminalToken disambiguateYield() {
        if (this.sourceLevel < 0x3A0000L || !this.mayBeAtAnYieldStatement()) {
            return TerminalToken.TokenNameIdentifier;
        }
        this.getVanguardParser();
        this.vanguardScanner.resetTo(this.currentPosition, this.eofPosition - 1);
        try {
            switch (this.vanguardScanner.getNextToken()) {
                case TokenNameEQUAL_EQUAL: 
                case TokenNameLESS_EQUAL: 
                case TokenNameGREATER_EQUAL: 
                case TokenNameNOT_EQUAL: 
                case TokenNameLEFT_SHIFT: 
                case TokenNameRIGHT_SHIFT: 
                case TokenNameUNSIGNED_RIGHT_SHIFT: 
                case TokenNamePLUS_EQUAL: 
                case TokenNameMINUS_EQUAL: 
                case TokenNameMULTIPLY_EQUAL: 
                case TokenNameDIVIDE_EQUAL: 
                case TokenNameAND_EQUAL: 
                case TokenNameOR_EQUAL: 
                case TokenNameXOR_EQUAL: 
                case TokenNameREMAINDER_EQUAL: 
                case TokenNameLEFT_SHIFT_EQUAL: 
                case TokenNameRIGHT_SHIFT_EQUAL: 
                case TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL: 
                case TokenNameOR_OR: 
                case TokenNameAND_AND: 
                case TokenNameREMAINDER: 
                case TokenNameXOR: 
                case TokenNameAND: 
                case TokenNameMULTIPLY: 
                case TokenNameOR: 
                case TokenNameDIVIDE: 
                case TokenNameGREATER: 
                case TokenNameLESS: 
                case TokenNameLBRACE: 
                case TokenNameRBRACE: 
                case TokenNameLBRACKET: 
                case TokenNameRBRACKET: 
                case TokenNameSEMICOLON: 
                case TokenNameQUESTION: 
                case TokenNameCOLON: 
                case TokenNameCOMMA: 
                case TokenNameDOT: 
                case TokenNameEQUAL: 
                case TokenNameAT: 
                case TokenNameELLIPSIS: 
                case TokenNameARROW: 
                case TokenNameCOLON_COLON: {
                    return TerminalToken.TokenNameIdentifier;
                }
                case TokenNamePLUS_PLUS: 
                case TokenNameMINUS_MINUS: {
                    return this.vanguardScanner.getNextToken() == TerminalToken.TokenNameIdentifier ? TerminalToken.TokenNameRestrictedIdentifierYield : TerminalToken.TokenNameIdentifier;
                }
            }
            return TerminalToken.TokenNameRestrictedIdentifierYield;
        }
        catch (InvalidInputException e) {
            if (!e.getMessage().equals(INVALID_CHAR_IN_STRING)) {
                e.printStackTrace();
            }
            return TerminalToken.TokenNameIdentifier;
        }
    }

    TerminalToken disambiguatedRestrictedKeyword(TerminalToken restrictedKeywordToken) {
        TerminalToken token = restrictedKeywordToken;
        if (this.scanContext == ScanContext.EXPECTING_IDENTIFIER) {
            return TerminalToken.TokenNameIdentifier;
        }
        block0 : switch (restrictedKeywordToken) {
            case TokenNametransitive: {
                if (this.scanContext != ScanContext.AFTER_REQUIRES) {
                    token = TerminalToken.TokenNameIdentifier;
                    break;
                }
                if (this.lookAhead(true, ScanContext.EXPECTING_IDENTIFIER) != TerminalToken.TokenNameSEMICOLON) break;
                token = TerminalToken.TokenNameIdentifier;
                break;
            }
            case TokenNamemodule: {
                switch (this.scanContext) {
                    case EXPECTING_KEYWORD: {
                        break block0;
                    }
                    case AFTER_IMPORT: {
                        if (this.lookAhead(true, ScanContext.EXPECTING_IDENTIFIER) != TerminalToken.TokenNameDOT) break block0;
                        token = TerminalToken.TokenNameIdentifier;
                        break block0;
                    }
                }
                token = TerminalToken.TokenNameIdentifier;
                break;
            }
            case TokenNameopen: 
            case TokenNamerequires: 
            case TokenNameexports: 
            case TokenNameopens: 
            case TokenNameto: 
            case TokenNameuses: 
            case TokenNameprovides: 
            case TokenNamewith: {
                if (this.scanContext == ScanContext.EXPECTING_KEYWORD) break;
                token = TerminalToken.TokenNameIdentifier;
                break;
            }
        }
        return token;
    }

    TerminalToken lookAhead(boolean isModuleInfo, ScanContext context) {
        this.getVanguardParser();
        this.vanguardScanner.resetTo(this.currentPosition, this.eofPosition - 1, isModuleInfo, context);
        try {
            return this.vanguardScanner.getNextToken();
        }
        catch (InvalidInputException e) {
            return TerminalToken.TokenNameNotAToken;
        }
    }

    TerminalToken disambiguatesRestrictedIdentifierWithLookAhead(TerminalToken restrictedIdentifierToken) {
        Goal goal;
        if (this.isInModuleDeclaration()) {
            return TerminalToken.TokenNameIdentifier;
        }
        switch (restrictedIdentifierToken) {
            case TokenNamenon_sealed: 
            case TokenNameRestrictedIdentifiersealed: {
                if (this.sourceLevel < 0x3D0000L) {
                    return TerminalToken.TokenNameIdentifier;
                }
                goal = Goal.SealedModifierGoal;
                break;
            }
            case TokenNameRestrictedIdentifierpermits: {
                if (this.sourceLevel < 0x3D0000L) {
                    return TerminalToken.TokenNameIdentifier;
                }
                goal = Goal.PermittedTypesGoal;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled contextual keyword");
            }
        }
        VanguardParser vp = this.getNewVanguardParser();
        VanguardScanner vs = (VanguardScanner)vp.scanner;
        vs.resetTo(this.currentPosition, this.eofPosition - 1);
        if (vp.parse(goal)) {
            return restrictedIdentifierToken;
        }
        return TerminalToken.TokenNameIdentifier;
    }

    TerminalToken disambiguatedToken(TerminalToken token, Scanner scanner) {
        VanguardParser parser = this.getVanguardParser();
        if (token == TerminalToken.TokenNameARROW) {
            if (this.lookBack[1] == TerminalToken.TokenNamedefault) {
                return TerminalToken.TokenNameCaseArrow;
            }
            if (this.activeParser == null || !this.activeParser.automatonWillShift(TerminalToken.TokenNameCaseArrow)) {
                return TerminalToken.TokenNameARROW;
            }
            return TerminalToken.TokenNameCaseArrow;
        }
        if (token == TerminalToken.TokenNameLPAREN && this.maybeAtLambdaOrCast()) {
            if (parser.parse(Goal.LambdaParameterListGoal)) {
                scanner.nextToken = TerminalToken.TokenNameLPAREN;
                return TerminalToken.TokenNameBeginLambda;
            }
            scanner.vanguardScanner.resetTo(scanner.startPosition, scanner.eofPosition - 1);
            if (parser.parse(Goal.IntersectionCastGoal)) {
                scanner.nextToken = TerminalToken.TokenNameLPAREN;
                return TerminalToken.TokenNameBeginIntersectionCast;
            }
        } else if (token == TerminalToken.TokenNameLESS && this.maybeAtReferenceExpression()) {
            if (parser.parse(Goal.ReferenceExpressionGoal)) {
                scanner.nextToken = TerminalToken.TokenNameLESS;
                return TerminalToken.TokenNameBeginTypeArguments;
            }
        } else if (token == TerminalToken.TokenNameAT && this.atTypeAnnotation()) {
            token = TerminalToken.TokenNameAT308;
            if (this.maybeAtEllipsisAnnotationsStart() && parser.parse(Goal.VarargTypeAnnotationGoal)) {
                scanner.consumingEllipsisAnnotations = true;
                scanner.nextToken = TerminalToken.TokenNameAT308;
                return TerminalToken.TokenNameAT308DOTDOTDOT;
            }
        }
        return token;
    }

    public boolean atMultiCaseComma() {
        return this.scanningSwitchLabel && this.lookBack[1] == TerminalToken.TokenNameCOMMA && (this.activeParser == null || this.activeParser.automatonWillShift(TerminalToken.TokenNameBeginCasePattern));
    }

    protected final boolean mayBeAtCasePattern(TerminalToken token) {
        return token == TerminalToken.TokenNamecase || this.atMultiCaseComma();
    }

    TerminalToken disambiguateCasePattern(TerminalToken token) {
        int delta = token == TerminalToken.TokenNamecase ? 4 : 0;
        VanguardParser parser = this.getNewVanguardParser();
        parser.scanner.resetTo(parser.scanner.currentPosition + delta, parser.scanner.eofPosition);
        if (parser.parse(Goal.PatternGoal)) {
            if (token == TerminalToken.TokenNamecase) {
                this.nextToken = TerminalToken.TokenNameBeginCasePattern;
            } else {
                this.nextToken = token;
                token = TerminalToken.TokenNameBeginCasePattern;
            }
        }
        return token;
    }

    protected boolean isAtAssistIdentifier() {
        return false;
    }

    public TerminalToken fastForward(Statement unused) {
        block8: while (true) {
            TerminalToken token;
            try {
                token = this.getNextToken();
            }
            catch (InvalidInputException e) {
                return TerminalToken.TokenNameEOF;
            }
            switch (token) {
                case TokenNameIdentifier: {
                    if (this.isAtAssistIdentifier()) {
                        return token;
                    }
                }
                case TokenNameabstract: 
                case TokenNameassert: 
                case TokenNameboolean: 
                case TokenNamebreak: 
                case TokenNamebyte: 
                case TokenNamecase: 
                case TokenNamechar: 
                case TokenNameclass: 
                case TokenNamecontinue: 
                case TokenNamedefault: 
                case TokenNamedo: 
                case TokenNamedouble: 
                case TokenNameenum: 
                case TokenNamefalse: 
                case TokenNamefinal: 
                case TokenNamefloat: 
                case TokenNamefor: 
                case TokenNameif: 
                case TokenNameint: 
                case TokenNameinterface: 
                case TokenNamelong: 
                case TokenNamenative: 
                case TokenNamenew: 
                case TokenNamenon_sealed: 
                case TokenNamenull: 
                case TokenNameprivate: 
                case TokenNameprotected: 
                case TokenNamepublic: 
                case TokenNamereturn: 
                case TokenNameshort: 
                case TokenNamestatic: 
                case TokenNamestrictfp: 
                case TokenNamesuper: 
                case TokenNameswitch: 
                case TokenNamesynchronized: 
                case TokenNamethis: 
                case TokenNamethrow: 
                case TokenNametransient: 
                case TokenNametrue: 
                case TokenNametry: 
                case TokenNamevoid: 
                case TokenNamevolatile: 
                case TokenNamewhile: 
                case TokenNameIntegerLiteral: 
                case TokenNameLongLiteral: 
                case TokenNameFloatingPointLiteral: 
                case TokenNameDoubleLiteral: 
                case TokenNameCharacterLiteral: 
                case TokenNameStringLiteral: 
                case TokenNameTextBlock: 
                case TokenNamePLUS_PLUS: 
                case TokenNameMINUS_MINUS: 
                case TokenNameLESS: 
                case TokenNameLPAREN: 
                case TokenNameLBRACE: 
                case TokenNameAT: 
                case TokenNameBeginLambda: 
                case TokenNameAT308: 
                case TokenNameCaseArrow: 
                case TokenNameRestrictedIdentifierYield: 
                case TokenNameRestrictedIdentifiersealed: {
                    if (!this.getVanguardParser().parse(Goal.BlockStatementoptGoal)) continue block8;
                    return token;
                }
                case TokenNameSEMICOLON: 
                case TokenNameEOF: {
                    return token;
                }
                case TokenNameRBRACE: {
                    this.ungetToken(token);
                    return TerminalToken.TokenNameSEMICOLON;
                }
            }
        }
    }

    protected TerminalToken getNextNotFakedToken() throws InvalidInputException {
        return this.getNextToken();
    }

    protected static InvalidInputException invalidCharacter() {
        return new InvalidInputException(INVALID_CHARACTER_CONSTANT);
    }

    protected static InvalidInputException invalidCharInString() {
        return new InvalidInputException(INVALID_CHAR_IN_STRING);
    }

    protected static InvalidInputException unterminatedString() {
        return new InvalidInputException(UNTERMINATED_STRING);
    }

    protected static InvalidInputException invalidUnicodeEscape() {
        return new InvalidInputException(INVALID_UNICODE_ESCAPE);
    }

    protected static InvalidInputException invalidLowSurrogate() {
        return new InvalidInputException(INVALID_LOW_SURROGATE);
    }

    protected static InvalidInputException invalidHighSurrogate() {
        return new InvalidInputException(INVALID_HIGH_SURROGATE);
    }

    protected static InvalidInputException unterminatedComment() {
        return new InvalidInputException(UNTERMINATED_COMMENT);
    }

    protected static InvalidInputException unterminatedTextBlock() {
        return new InvalidInputException(UNTERMINATED_TEXT_BLOCK);
    }

    protected static InvalidInputException invalidEof() {
        return new InvalidInputException("Ctrl-Z");
    }

    protected static InvalidInputException invalidUnderscore() {
        return new InvalidInputException(INVALID_UNDERSCORE);
    }

    protected static InvalidInputException invalidUnderscoresInLiterals() {
        return new InvalidInputException(UNDERSCORES_IN_LITERALS_NOT_BELOW_17);
    }

    protected static InvalidInputException invalidEscape() {
        return new InvalidInputException(INVALID_ESCAPE);
    }

    protected static InvalidInputException invalidHexa() {
        return new InvalidInputException(INVALID_HEXA);
    }

    protected static InvalidInputException illegalHexaLiteral() {
        return new InvalidInputException(ILLEGAL_HEXA_LITERAL);
    }

    protected static InvalidInputException invalidFloat() {
        return new InvalidInputException(INVALID_FLOAT);
    }

    protected static InvalidInputException invalidBinaryLiteral() {
        return new InvalidInputException(BINARY_LITERAL_NOT_BELOW_17);
    }

    protected static InvalidInputException invalidBinary() {
        return new InvalidInputException(INVALID_BINARY);
    }

    public static InvalidInputException invalidToken(TerminalToken token) {
        return new InvalidInputException("Unknown token (check Scanner/TerminalToken): " + String.valueOf((Object)token));
    }

    public static InvalidInputException invalidInput() {
        return new InvalidInputException();
    }

    public void copyCommentInfo(int to, int from) {
        this.commentStarts[to] = this.commentStarts[from];
        this.commentStops[to] = this.commentStops[from];
        this.commentTagStarts[to] = this.commentTagStarts[from];
        this.commentIsMarkdown[to] = this.commentIsMarkdown[from];
    }

    public void copyAllCommentInfo(int from, int to, int length) {
        System.arraycopy(this.commentStarts, from, this.commentStarts, to, length);
        System.arraycopy(this.commentStops, from, this.commentStops, to, length);
        System.arraycopy(this.commentTagStarts, from, this.commentTagStarts, to, length);
        System.arraycopy(this.commentIsMarkdown, from, this.commentIsMarkdown, 0, length);
    }

    protected void growCommentInfoArrays(int length, int newLength) {
        this.commentStops = new int[newLength];
        System.arraycopy(this.commentStops, 0, this.commentStops, 0, length);
        this.commentStarts = new int[newLength];
        System.arraycopy(this.commentStarts, 0, this.commentStarts, 0, length);
        this.commentIsMarkdown = new boolean[newLength];
        System.arraycopy(this.commentIsMarkdown, 0, this.commentIsMarkdown, 0, length);
        this.commentTagStarts = new int[newLength];
        System.arraycopy(this.commentTagStarts, 0, this.commentTagStarts, 0, length);
    }

    private static class Goal {
        final TerminalToken first;
        final TerminalToken[] follow;
        final int[] rules;
        static int LambdaParameterListRule = 0;
        static int IntersectionCastRule = 0;
        static int ReferenceExpressionRule = 0;
        static int VarargTypeAnnotationsRule = 0;
        static int BlockStatementoptRule = 0;
        static int[] ModifiersoptRules;
        static int PermittedTypesRule;
        static int[] PatternRules;
        static Goal LambdaParameterListGoal;
        static Goal IntersectionCastGoal;
        static Goal VarargTypeAnnotationGoal;
        static Goal ReferenceExpressionGoal;
        static Goal BlockStatementoptGoal;
        static Goal SealedModifierGoal;
        static Goal PermittedTypesGoal;
        static Goal PatternGoal;
        static TerminalToken[] SealedModifierFollow;
        static TerminalToken[] PermittedTypesFollow;
        static TerminalToken[] PatternCaseLabelFollow;

        static {
            SealedModifierFollow = new TerminalToken[]{TerminalToken.TokenNameclass, TerminalToken.TokenNameinterface, TerminalToken.TokenNameenum, TerminalToken.TokenNameRestrictedIdentifierrecord};
            PermittedTypesFollow = new TerminalToken[]{TerminalToken.TokenNameLBRACE};
            PatternCaseLabelFollow = new TerminalToken[]{TerminalToken.TokenNameCOLON, TerminalToken.TokenNameARROW, TerminalToken.TokenNameCOMMA, TerminalToken.TokenNameCaseArrow, TerminalToken.TokenNameRestrictedIdentifierWhen};
            ArrayList<Integer> modifiersOptStates = new ArrayList<Integer>(2);
            ArrayList<Integer> patternStates = new ArrayList<Integer>();
            int i = 1;
            while (i <= 926) {
                if ("ParenthesizedLambdaParameterList".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    LambdaParameterListRule = i;
                } else if ("ParenthesizedCastNameAndBounds".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    IntersectionCastRule = i;
                } else if ("ReferenceExpressionTypeArgumentsAndTrunk".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    ReferenceExpressionRule = i;
                } else if ("TypeAnnotations".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    VarargTypeAnnotationsRule = i;
                } else if ("BlockStatementopt".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    BlockStatementoptRule = i;
                } else if ("Modifiersopt".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    modifiersOptStates.add(i);
                } else if ("PermittedTypes".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    PermittedTypesRule = i;
                } else if ("TypePattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    patternStates.add(i);
                } else if ("Pattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    patternStates.add(i);
                } else if ("RecordPattern".equals(Parser.name[Parser.non_terminal_index[Parser.lhs[i]]])) {
                    patternStates.add(i);
                }
                ++i;
            }
            ModifiersoptRules = modifiersOptStates.stream().mapToInt(Integer::intValue).toArray();
            PatternRules = patternStates.stream().mapToInt(Integer::intValue).toArray();
            LambdaParameterListGoal = new Goal(TerminalToken.TokenNameARROW, new TerminalToken[]{TerminalToken.TokenNameARROW}, LambdaParameterListRule);
            IntersectionCastGoal = new Goal(TerminalToken.TokenNameLPAREN, Goal.followSetOfCast(), IntersectionCastRule);
            VarargTypeAnnotationGoal = new Goal(TerminalToken.TokenNameAT, new TerminalToken[]{TerminalToken.TokenNameELLIPSIS}, VarargTypeAnnotationsRule);
            ReferenceExpressionGoal = new Goal(TerminalToken.TokenNameLESS, new TerminalToken[]{TerminalToken.TokenNameCOLON_COLON}, ReferenceExpressionRule);
            BlockStatementoptGoal = new Goal(TerminalToken.TokenNameLBRACE, new TerminalToken[0], BlockStatementoptRule);
            SealedModifierGoal = new Goal(TerminalToken.TokenNameRestrictedIdentifiersealed, SealedModifierFollow, ModifiersoptRules);
            PermittedTypesGoal = new Goal(TerminalToken.TokenNameRestrictedIdentifierpermits, PermittedTypesFollow, PermittedTypesRule);
            PatternGoal = new Goal(TerminalToken.TokenNameBeginCasePattern, PatternCaseLabelFollow, PatternRules);
        }

        Goal(TerminalToken first, TerminalToken[] follow, int rule) {
            this.first = first;
            this.follow = follow;
            this.rules = new int[]{rule};
        }

        Goal(TerminalToken first, TerminalToken[] follow, int[] rules) {
            this.first = first;
            this.follow = follow;
            this.rules = rules;
        }

        boolean hasBeenReached(int act, TerminalToken token) {
            boolean foundRule = false;
            int[] nArray = this.rules;
            int n = this.rules.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (act == i) {
                    foundRule = true;
                    break;
                }
                ++n2;
            }
            if (foundRule) {
                int length = this.follow.length;
                if (length == 0) {
                    return true;
                }
                int i = 0;
                while (i < length) {
                    if (this.follow[i] == token) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        private static TerminalToken[] followSetOfCast() {
            return new TerminalToken[]{TerminalToken.TokenNameIdentifier, TerminalToken.TokenNamenew, TerminalToken.TokenNamesuper, TerminalToken.TokenNamethis, TerminalToken.TokenNamefalse, TerminalToken.TokenNametrue, TerminalToken.TokenNamenull, TerminalToken.TokenNameIntegerLiteral, TerminalToken.TokenNameLongLiteral, TerminalToken.TokenNameFloatingPointLiteral, TerminalToken.TokenNameDoubleLiteral, TerminalToken.TokenNameCharacterLiteral, TerminalToken.TokenNameStringLiteral, TerminalToken.TokenNameTextBlock, TerminalToken.TokenNameNOT, TerminalToken.TokenNameTWIDDLE, TerminalToken.TokenNameLPAREN};
        }
    }

    private class ModuleScanContextDetector
    extends VanguardParser {
        ModuleScanContextDetector(CompilerOptions options) {
            super(new ProblemReporter(DefaultErrorHandlingPolicies.ignoreAllProblems(), options, new DefaultProblemFactory()));
            this.problemReporter.options.performStatementsRecovery = false;
            this.reportSyntaxErrorIsRequired = false;
            this.reportOnlyOneSyntaxError = false;
        }

        @Override
        public void initializeScanner() {
            this.scanner = new Scanner(false, false, false, this.options.sourceLevel, this.options.complianceLevel, this.options.taskTags, this.options.taskPriorities, this.options.isTaskCaseSensitive, this.options.enablePreviewFeatures){

                @Override
                void updateScanContext(TerminalToken token) {
                    if (token != TerminalToken.TokenNameEOF) {
                        super.updateScanContext(token);
                    }
                }
            };
            this.scanner.recordLineSeparator = false;
            this.scanner.setActiveParser(this);
            this.scanner.previewEnabled = this.options.enablePreviewFeatures;
        }

        @Override
        public boolean isParsingModuleDeclaration() {
            return true;
        }

        public ScanContext getScanContext(char[] src, int begin) {
            this.scanner.setSource(src);
            this.scanner.resetTo(0, begin, true);
            this.goForCompilationUnit();
            Goal goal = new Goal(TerminalToken.TokenNamePLUS_PLUS, null, 0){

                @Override
                boolean hasBeenReached(int act, TerminalToken token) {
                    return token == TerminalToken.TokenNameEOF;
                }
            };
            this.parse(goal);
            return this.scanner.scanContext;
        }
    }

    static enum ScanContext {
        EXPECTING_KEYWORD,
        EXPECTING_IDENTIFIER,
        AFTER_REQUIRES,
        AFTER_IMPORT,
        INACTIVE;

    }

    private static class VanguardParser
    extends Parser {
        public static final boolean SUCCESS = true;
        public static final boolean FAILURE = false;
        Goal currentGoal;

        public VanguardParser(VanguardScanner scanner) {
            this.scanner = scanner;
        }

        public VanguardParser(ProblemReporter reporter) {
            super(reporter, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean parse(Goal goal) {
            this.currentGoal = goal;
            try {
                int act = 1015;
                this.stateStackTop = -1;
                this.currentToken = goal.first;
                while (true) {
                    int stackLength;
                    if (++this.stateStackTop >= (stackLength = this.stack.length)) {
                        this.stack = new int[stackLength + 255];
                        System.arraycopy(this.stack, 0, this.stack, 0, stackLength);
                    }
                    this.stack[this.stateStackTop] = act;
                    if ((act = Parser.tAction(act, this.currentToken.tokenNumber())) == 17648) {
                        return false;
                    }
                    if (act <= 926) {
                        --this.stateStackTop;
                    } else if (act > 17648) {
                        this.unstackedAct = act;
                        try {
                            this.currentToken = this.scanner.getNextToken();
                        }
                        finally {
                            this.unstackedAct = 17648;
                        }
                        act -= 17648;
                    } else {
                        if (act >= 17647) {
                            return false;
                        }
                        this.unstackedAct = act;
                        try {
                            this.currentToken = this.scanner.getNextToken();
                        }
                        finally {
                            this.unstackedAct = 17648;
                        }
                        continue;
                    }
                    do {
                        TerminalToken reskw;
                        if (goal.hasBeenReached(act, this.currentToken)) {
                            return true;
                        }
                        if (this.currentToken == TerminalToken.TokenNameIdentifier && (reskw = TerminalToken.getRestrictedKeyword(this.scanner.getCurrentIdentifierSource())) != TerminalToken.TokenNameNotAToken && goal.hasBeenReached(act, reskw)) {
                            return true;
                        }
                        this.stateStackTop -= Parser.rhs[act] - 1;
                    } while ((act = Parser.ntAction(this.stack[this.stateStackTop], Parser.lhs[act])) <= 926);
                }
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public String toString() {
            return "\n\n\n----------------Scanner--------------\n" + this.scanner.toString();
        }
    }

    private static final class VanguardScanner
    extends Scanner {
        public VanguardScanner(long sourceLevel, long complianceLevel, boolean previewEnabled) {
            super(false, false, false, sourceLevel, complianceLevel, null, null, false, previewEnabled);
        }

        @Override
        public TerminalToken getNextToken() throws InvalidInputException {
            if (this.nextToken != TerminalToken.TokenNameNotAToken) {
                TerminalToken token = this.nextToken;
                this.nextToken = TerminalToken.TokenNameNotAToken;
                return token;
            }
            if (this.scanContext == null) {
                this.scanContext = this.isInModuleDeclaration() ? ScanContext.EXPECTING_KEYWORD : ScanContext.INACTIVE;
            }
            TerminalToken token = this.getNextToken0();
            if (this.areRestrictedModuleKeywordsActive()) {
                if (VanguardScanner.isRestrictedKeyword(token)) {
                    token = this.disambiguatedRestrictedKeyword(token);
                }
                this.updateScanContext(token);
            } else if (this.mayBeAtCasePattern(token)) {
                token = this.disambiguateCasePattern(token);
            } else if (token == TerminalToken.TokenNameARROW) {
                token = this.disambiguatedToken(token, this);
            } else if (token == TerminalToken.TokenNameAT && this.atTypeAnnotation()) {
                token = ((VanguardParser)this.activeParser).currentGoal == Goal.LambdaParameterListGoal ? this.disambiguatedToken(token, this) : TerminalToken.TokenNameAT308;
            }
            this.addTokenToLookBack(token);
            return token == TerminalToken.TokenNameEOF ? TerminalToken.TokenNameNotAToken : token;
        }
    }
}

