/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.internal.event.Event;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.WorkbenchShutdownEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.GradlePreferenceChangeListener;
import org.eclipse.jdt.ls.core.internal.managers.GradleProjectImporter;
import org.eclipse.jdt.ls.core.internal.managers.GradleUtils;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.JavaApplicationLaunchConfiguration;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class GradleBuildSupport
implements IBuildSupport {
    private static final String GRADLE = "Gradle";
    private static final String GROOVY = "Groovy";
    private static final String GROOVY_EXTENSION = ".groovy";
    private static final String COMPILE_TEST_GROOVY = "compileTestGroovy";
    private static final String COMPILE_GROOVY = "compileGroovy";
    private static Pattern GROOVY_PATTERN = Pattern.compile("(?m)^(?<file>.*\\.groovy):\\s*(?<line>\\d+):\\s*(?<message>.*)\\s+@\\s+line\\s+\\d+,\\s+column\\s+(?<col>\\d+)\\.");
    private static final String KOTLIN = "Kotlin";
    private static final String KOTLIN_EXTENSION = ".kt";
    private static final String COMPILE_TEST_KOTLIN = "compileTestKotlin";
    private static final String COMPILE_KOTLIN = "compileKotlin";
    private static Pattern KOTLIN_PATTERN = Pattern.compile("(?m)^(?:(?<type>[ew]): )?(?:file:///)?(?<file>.*\\.(?:kt|kts|aj)):(?<line>\\d+):(?<col>\\d+)?\\s*(?<message>.*)$");
    private static final String ASPECTJ = "AspectJ";
    private static final String ASPECTJ_EXTENSION = ".aj";
    private static final String COMPILE_TEST_ASPECTJ = "compileTestAspectj";
    private static final String COMPILE_ASPECTJ = "compileAspectj";
    private static Pattern ASPECTJ_PATTERN = Pattern.compile("(?m)^(?<file>.*\\.aj):(?<line>\\d+)\\s+\\[(?<type>error|warning)\\]\\s+(?<message>.*)\\R(?<source>.*)\\R(?<indent>\\s*)\\^");
    private static final String UNKNOWN = "Unknown";
    private static final List<String> includeTasks = Arrays.asList("compileKotlin", "compileTestKotlin", "compileGroovy", "compileTestGroovy", "compileAspectj", "compileTestAspectj");
    public static final Pattern GRADLE_FILE_EXT = Pattern.compile("^.*\\.gradle(\\.kts)?$");
    public static final String GRADLE_PROPERTIES = "gradle.properties";
    public static final List<String> WATCH_FILE_PATTERNS = Arrays.asList("**/*.gradle", "**/*.gradle.kts", "**/gradle.properties");
    public static final String UNSUPPORTED_ON_GRADLE = "Unsupported operation. Please use build.gradle file to manage the source directories of gradle project.";
    private static IPreferencesChangeListener listener = new GradlePreferenceChangeListener();
    private static final String GENERATED_SOURCES_PATH = "bin/generated-sources/annotations";
    private static final String GENERATED_TEST_SOURCES_PATH = "bin/generated-test-sources/annotations";

    @Override
    public boolean applies(IProject project) {
        return ProjectUtils.isGradleProject(project);
    }

    @Override
    public void update(IProject project, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!this.applies(project)) {
            return;
        }
        JavaLanguageServerPlugin.debugTrace("Starting Gradle update for " + project.getName());
        Optional build = GradleCore.getWorkspace().getBuild(project);
        if (build.isPresent()) {
            DefaultGradleBuild defaultGradleBuild;
            org.eclipse.buildship.core.internal.configuration.BuildConfiguration gradleConfig;
            boolean shouldUpdate;
            GradleBuild gradleBuild = (GradleBuild)build.get();
            boolean isRoot = this.isRoot(project, gradleBuild, monitor);
            if (force && isRoot) {
                String projectPath = project.getLocation().toFile().getAbsolutePath();
                BuildConfiguration buildConfiguration = GradleProjectImporter.getBuildConfiguration(Paths.get(projectPath, new String[0]));
                gradleBuild = GradleCore.getWorkspace().createBuild(buildConfiguration);
            }
            File buildFile = project.getFile("build.gradle").getLocation().toFile();
            File settingsFile = project.getFile("settings.gradle").getLocation().toFile();
            File buildKtsFile = project.getFile("build.gradle.kts").getLocation().toFile();
            File settingsKtsFile = project.getFile("settings.gradle.kts").getLocation().toFile();
            boolean bl = shouldUpdate = buildFile.exists() && JavaLanguageServerPlugin.getDigestStore().updateDigest(buildFile.toPath()) || settingsFile.exists() && JavaLanguageServerPlugin.getDigestStore().updateDigest(settingsFile.toPath()) || buildKtsFile.exists() && JavaLanguageServerPlugin.getDigestStore().updateDigest(buildKtsFile.toPath()) || settingsKtsFile.exists() && JavaLanguageServerPlugin.getDigestStore().updateDigest(settingsKtsFile.toPath());
            if (!(shouldUpdate |= isRoot) && force && gradleBuild instanceof DefaultGradleBuild && !(gradleConfig = (defaultGradleBuild = (DefaultGradleBuild)gradleBuild).getBuildConfig()).isAutoSync()) {
                shouldUpdate = true;
            }
            if (shouldUpdate) {
                gradleBuild.synchronize(monitor);
                GradleBuildSupport.syncAnnotationProcessingConfiguration(gradleBuild, monitor);
            }
        }
    }

    public static void syncAnnotationProcessingConfiguration(IProject project, IProgressMonitor monitor) {
        Optional build = GradleCore.getWorkspace().getBuild(project);
        if (build.isPresent()) {
            GradleBuildSupport.syncAnnotationProcessingConfiguration((GradleBuild)build.get(), monitor);
        }
    }

    public static void syncAnnotationProcessingConfiguration(GradleBuild gradleBuild, IProgressMonitor monitor) {
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null) {
            return;
        }
        if (!preferencesManager.getPreferences().isGradleAnnotationProcessingEnabled()) {
            return;
        }
        File initScript = GradleUtils.getGradleInitScript("/gradle/apt/init.gradle");
        if (initScript == null) {
            return;
        }
        Map model = null;
        try {
            model = (Map)gradleBuild.withConnection(connection -> (Map)((ModelBuilder)connection.model(Map.class).withArguments(new String[]{"--init-script", initScript.getAbsolutePath()})).get(), monitor);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        if (model == null) {
            return;
        }
        for (IProject project : ProjectUtils.getGradleProjects()) {
            Map apConfigurations;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null || (apConfigurations = (Map)model.get(project.getLocation().toFile())) == null) continue;
            if (apConfigurations.isEmpty()) {
                GradleBuildSupport.disableApt(javaProject);
                continue;
            }
            Set<File> processors = GradleBuildSupport.getProcessors(apConfigurations);
            if (processors.isEmpty()) continue;
            AptConfig.setGenSrcDir((IJavaProject)javaProject, (String)GENERATED_SOURCES_PATH);
            AptConfig.setGenTestSrcDir((IJavaProject)javaProject, (String)GENERATED_TEST_SOURCES_PATH);
            if (!AptConfig.isEnabled((IJavaProject)javaProject)) {
                AptConfig.setEnabled((IJavaProject)javaProject, (boolean)true);
            }
            IFactoryPath factoryPath = AptConfig.getDefaultFactoryPath((IJavaProject)javaProject);
            for (File processor : processors) {
                factoryPath.addExternalJar(processor);
            }
            try {
                AptConfig.setFactoryPath((IJavaProject)javaProject, (IFactoryPath)factoryPath);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
            }
            List<Object> compilerArgs = GradleBuildSupport.getCompilerArgs(apConfigurations);
            Map<String, String> newOptions = GradleUtils.parseProcessorOptions(compilerArgs);
            Map currentOptions = AptConfig.getRawProcessorOptions((IJavaProject)javaProject);
            if (currentOptions.equals(newOptions)) continue;
            AptConfig.setProcessorOptions(newOptions, (IJavaProject)javaProject);
        }
    }

    private boolean isRoot(IProject project, GradleBuild gradleBuild, IProgressMonitor monitor) {
        if (gradleBuild instanceof InternalGradleBuild) {
            InternalGradleBuild internalGradleBuild = (InternalGradleBuild)gradleBuild;
            CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();
            Map eclipseProjects = internalGradleBuild.getModelProvider().fetchModels(EclipseProject.class, FetchStrategy.LOAD_IF_NOT_CACHED, tokenSource, monitor);
            File projectDirectory = project.getLocation().toFile();
            for (EclipseProject eclipseProject : eclipseProjects.values()) {
                File eclipseProjectDirectory = eclipseProject.getProjectDirectory();
                if (!eclipseProjectDirectory.equals(projectDirectory)) continue;
                return eclipseProject.getParent() == null;
            }
        }
        return false;
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        if (resource != null && resource.getType() == 1 && this.isBuildLikeFileName(resource.getName()) && ProjectUtils.isGradleProject(resource.getProject())) {
            block4: {
                if (ProjectUtils.isJavaProject(resource.getProject())) break block4;
                return true;
            }
            try {
                IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
                IPath outputLocation = javaProject.getOutputLocation();
                return outputLocation == null || !outputLocation.isPrefixOf(resource.getFullPath());
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return false;
    }

    @Override
    public boolean isBuildLikeFileName(String fileName) {
        return GRADLE_FILE_EXT.matcher(fileName).matches() || fileName.equals(GRADLE_PROPERTIES);
    }

    public static void cleanGradleModels(IProgressMonitor monitor) {
        File projectPreferences = CorePlugin.getInstance().getStateLocation().append("project-preferences").toFile();
        if (projectPreferences.isDirectory()) {
            File[] projectFiles;
            File[] fileArray = projectFiles = projectPreferences.listFiles();
            int n = projectFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File projectFile = fileArray[n2];
                String projectName = projectFile.getName();
                if (!ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
                    FileUtils.deleteRecursively((File)projectFile);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null || !this.applies(resource.getProject())) {
            return false;
        }
        return IBuildSupport.super.fileChanged(resource, changeType, monitor) || this.isBuildFile(resource);
    }

    @Override
    public boolean useDefaultVM(IProject project, IVMInstall defaultVM) {
        return GradleProjectImporter.useDefaultVM();
    }

    public static void saveModels() {
        CorePlugin.listenerRegistry().dispatch((Event)new WorkbenchShutdownEvent());
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration(IJavaProject javaProject, String scope) throws CoreException {
        return new JavaApplicationLaunchConfiguration(javaProject.getProject(), scope, "org.eclipse.buildship.core.classpathprovider");
    }

    @Override
    public List<String> getWatchPatterns() {
        return WATCH_FILE_PATTERNS;
    }

    @Override
    public void registerPreferencesChangeListener(PreferenceManager preferenceManager) throws CoreException {
        preferenceManager.addPreferencesChangeListener(listener);
    }

    @Override
    public void unregisterPreferencesChangeListener(PreferenceManager preferenceManager) throws CoreException {
        preferenceManager.removePreferencesChangeListener(listener);
    }

    @Override
    public String buildToolName() {
        return GRADLE;
    }

    @Override
    public String unsupportedOperationMessage() {
        return UNSUPPORTED_ON_GRADLE;
    }

    @Override
    public boolean hasSpecificDeleteProjectLogic() {
        return true;
    }

    @Override
    public void deleteInvalidProjects(Collection<IPath> rootPaths, ArrayList<IProject> deleteProjectCandates, IProgressMonitor monitor) {
        ArrayList<IProject> validGradleProjects = new ArrayList<IProject>();
        ArrayList<IProject> suspiciousGradleProjects = new ArrayList<IProject>();
        for (IProject project2 : deleteProjectCandates) {
            if (!this.applies(project2)) continue;
            if (ResourceUtils.isContainedIn(project2.getLocation(), rootPaths)) {
                validGradleProjects.add(project2);
                continue;
            }
            suspiciousGradleProjects.add(project2);
        }
        List<IProject> unrelatedProjects = this.findUnrelatedGradleProjects(suspiciousGradleProjects, validGradleProjects);
        unrelatedProjects.forEach(project -> {
            try {
                project.delete(false, true, monitor);
            }
            catch (CoreException e1) {
                JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
            }
        });
    }

    private List<IProject> findUnrelatedGradleProjects(List<IProject> suspiciousProjects, List<IProject> validProjects) {
        suspiciousProjects.sort((p1, p2) -> p1.getLocation().toOSString().length() - p2.getLocation().toOSString().length());
        ArrayList<IProject> unrelatedCandidates = new ArrayList<IProject>();
        ArrayList validSubPaths = new ArrayList();
        for (IProject suspiciousProject : suspiciousProjects) {
            if (validSubPaths.contains(suspiciousProject.getFullPath().makeRelative())) continue;
            boolean isParentProject = false;
            Collection subpaths = null;
            PersistentModel model = CorePlugin.modelPersistence().loadModel(suspiciousProject);
            if (model.isPresent() && !(subpaths = model.getSubprojectPaths()).isEmpty()) {
                for (IProject validProject : validProjects) {
                    if (!subpaths.contains(validProject.getFullPath().makeRelative())) continue;
                    isParentProject = true;
                    break;
                }
            }
            if (isParentProject) {
                validSubPaths.addAll(subpaths);
                continue;
            }
            unrelatedCandidates.add(suspiciousProject);
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IProject candidate : unrelatedCandidates) {
            if (validSubPaths.contains(candidate.getFullPath().makeRelative())) continue;
            result.add(candidate);
        }
        return result;
    }

    private static List<Object> getCompilerArgs(Map<String, Object> apConfigurations) {
        List l;
        Object object = apConfigurations.get("compilerArgs");
        return object instanceof List ? (l = (List)object) : List.of();
    }

    private static Set<File> getProcessors(Map<String, Object> apConfigurations) {
        Set set;
        Object object = apConfigurations.get("processors");
        return object instanceof Set ? (set = (Set)object) : Set.of();
    }

    private static void disableApt(IJavaProject javaProject) {
        if (AptConfig.isEnabled((IJavaProject)javaProject)) {
            AptConfig.setEnabled((IJavaProject)javaProject, (boolean)false);
        }
    }

    @Override
    public void compile(IResource resource, IProgressMonitor monitor) {
        boolean shouldCompile;
        PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferenceManager == null || !preferenceManager.getPreferences().isAutobuildEnabled()) {
            return;
        }
        boolean bl = shouldCompile = preferenceManager.getPreferences().isAspectjSupportEnabled() && (resource == null || resource.getName().endsWith(ASPECTJ_EXTENSION)) || preferenceManager.getPreferences().isKotlinSupportEnabled() && (resource == null || resource.getName().endsWith(KOTLIN_EXTENSION)) || preferenceManager.getPreferences().isGroovySupportEnabled() && (resource == null || resource.getName().endsWith(GROOVY_EXTENSION));
        if (!shouldCompile) {
            return;
        }
        if (resource != null && this.applies(resource.getProject())) {
            block31: {
                String projectLocation;
                String uriString = JDTUtils.getFileURI(resource);
                PublishDiagnosticsParams $ = new PublishDiagnosticsParams(ResourceUtils.toClientUri(uriString), Collections.emptyList());
                JavaClientConnection conn = JavaLanguageServerPlugin.getInstance().getProtocol().getClientConnection();
                conn.publishDiagnostics($);
                File projectDir = resource.getProject().getLocation().toFile();
                try {
                    projectLocation = projectDir.getCanonicalPath();
                }
                catch (IOException e) {
                    JavaLanguageServerPlugin.logException(e);
                    return;
                }
                try {
                    Throwable e = null;
                    Object var11_21 = null;
                    try (ProjectConnection connection = GradleConnector.newConnector().forProjectDirectory(projectDir).connect();){
                        GradleProject rootProject = (GradleProject)connection.model(GradleProject.class).get();
                        GradleProject gradleProject = this.getProject(rootProject, projectLocation);
                        if (gradleProject == null) {
                            gradleProject = rootProject;
                        }
                        List<String> taskNames = gradleProject.getTasks().stream().map(t -> t.getName()).filter(name -> includeTasks.contains(name)).collect(Collectors.toList());
                        this.compile(gradleProject, taskNames, monitor);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (Exception e) {
                    if (!Boolean.getBoolean("jdt.ls.debug")) break block31;
                    JavaLanguageServerPlugin.logException(e);
                }
            }
            return;
        }
        if (resource == null) {
            Object igb;
            HashSet<IProject> projects = new HashSet<IProject>();
            for (IProject project : ProjectUtils.getGradleProjects()) {
                File rootDir;
                GradleBuild gb;
                Optional gradleBuild;
                if (!project.isOpen() || !(gradleBuild = GradleCore.getWorkspace().getBuild(project)).isPresent() || !((gb = (GradleBuild)gradleBuild.get()) instanceof InternalGradleBuild) || (rootDir = (igb = (InternalGradleBuild)gb).getBuildConfig().getProperties().getRootProjectDirectory()) == null || !rootDir.equals(project.getRawLocation().toFile())) continue;
                projects.add(project);
            }
            HashMap<String, GradleProject> roots = new HashMap<String, GradleProject>();
            for (IProject project : projects) {
                File projectDir = project.getLocation().toFile();
                igb = null;
                Iterator<String> iterator = null;
                try (ProjectConnection connection = GradleConnector.newConnector().forProjectDirectory(projectDir).connect();){
                    GradleProject gradleProject = (GradleProject)connection.getModel(GradleProject.class);
                    roots.put(gradleProject.getPath(), gradleProject);
                }
                catch (Throwable throwable) {
                    if (igb == null) {
                        igb = throwable;
                    } else if (igb != throwable) {
                        ((Throwable)igb).addSuppressed(throwable);
                    }
                    throw igb;
                }
            }
            for (GradleProject gradleProject : roots.values()) {
                ArrayList<String> taskNames = new ArrayList<String>();
                for (String taskName : includeTasks) {
                    if (!this.hasTask(gradleProject, taskName)) continue;
                    taskNames.add(taskName);
                }
                this.compile(gradleProject, taskNames, monitor);
            }
        }
    }

    private void compile(GradleProject gradleProject, List<String> taskNames, IProgressMonitor monitor) {
        block35: {
            if (gradleProject == null || taskNames.isEmpty()) break block35;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100).checkCanceled();
            long start = System.currentTimeMillis();
            try {
                Job.getJobManager().join((Object)"org.eclipse.buildship.core.jobs", monitor);
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                // empty catch block
            }
            File projectDir = gradleProject.getProjectDirectory();
            Throwable throwable = null;
            Object var9_10 = null;
            try (ProjectConnection connection = GradleConnector.newConnector().forProjectDirectory(projectDir).connect();){
                block36: {
                    block34: {
                        String error;
                        ByteArrayOutputStream errorStream;
                        ByteArrayOutputStream outputStream;
                        block31: {
                            Throwable throwable22;
                            block33: {
                                block32: {
                                    progress.beginTask("Run gradle tasks: " + String.valueOf(taskNames) + " for project '" + gradleProject.getPath() + "'", 100);
                                    outputStream = new ByteArrayOutputStream();
                                    errorStream = new ByteArrayOutputStream();
                                    try {
                                        try {
                                            ((BuildLauncher)((BuildLauncher)((BuildLauncher)connection.newBuild().setStandardError((OutputStream)errorStream)).setStandardOutput((OutputStream)outputStream)).forTasks(taskNames.toArray(new String[0])).withArguments(new String[]{"-q", "-Dorg.gradle.configureondemand=true", "-Dorg.gradle.caching=true", "--continue", "--console=plain"})).run();
                                            break block31;
                                        }
                                        catch (Exception e) {
                                            String error2;
                                            String log;
                                            if (Boolean.getBoolean("jdt.ls.debug")) {
                                                JavaLanguageServerPlugin.logException(e);
                                            }
                                            if (!(log = outputStream.toString()).isBlank()) {
                                                JavaLanguageServerPlugin.debugTrace("Gradle log: " + log);
                                            }
                                            if (!(error2 = errorStream.toString()).isBlank()) {
                                                boolean parseKotlin = taskNames.contains(COMPILE_KOTLIN) || taskNames.contains(COMPILE_TEST_KOTLIN);
                                                boolean parseGroovy = taskNames.contains(COMPILE_GROOVY) || taskNames.contains(COMPILE_TEST_GROOVY);
                                                boolean parseAspectj = taskNames.contains(COMPILE_ASPECTJ) || taskNames.contains(COMPILE_TEST_ASPECTJ);
                                                this.publishDiagnostics(error2, parseKotlin, parseGroovy, parseAspectj);
                                            }
                                            JavaModelManager.getJavaModelManager().resetExternalFilesCache();
                                            try {
                                                IProject[] projects;
                                                IPath path = Path.fromOSString((String)projectDir.getAbsolutePath());
                                                IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(path.toFile().toURI());
                                                IProject[] iProjectArray = projects = (IProject[])Arrays.stream(containers).filter(container -> container instanceof IProject).map(container -> (IProject)container).toArray(IProject[]::new);
                                                int n = projects.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    IProject project = iProjectArray[n2];
                                                    project.refreshLocal(2, monitor);
                                                    ++n2;
                                                }
                                            }
                                            catch (CoreException e2) {
                                                if (!Boolean.getBoolean("jdt.ls.debug")) break block32;
                                                JavaLanguageServerPlugin.logException(e2);
                                            }
                                        }
                                    }
                                    catch (Throwable throwable22) {
                                        String error3;
                                        String log = outputStream.toString();
                                        if (!log.isBlank()) {
                                            JavaLanguageServerPlugin.debugTrace("Gradle log: " + log);
                                        }
                                        if (!(error3 = errorStream.toString()).isBlank()) {
                                            boolean parseKotlin = taskNames.contains(COMPILE_KOTLIN) || taskNames.contains(COMPILE_TEST_KOTLIN);
                                            boolean parseGroovy = taskNames.contains(COMPILE_GROOVY) || taskNames.contains(COMPILE_TEST_GROOVY);
                                            boolean parseAspectj = taskNames.contains(COMPILE_ASPECTJ) || taskNames.contains(COMPILE_TEST_ASPECTJ);
                                            this.publishDiagnostics(error3, parseKotlin, parseGroovy, parseAspectj);
                                        }
                                        JavaModelManager.getJavaModelManager().resetExternalFilesCache();
                                        try {
                                            IProject[] projects;
                                            IPath path = Path.fromOSString((String)projectDir.getAbsolutePath());
                                            IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(path.toFile().toURI());
                                            IProject[] iProjectArray = projects = (IProject[])Arrays.stream(containers).filter(container -> container instanceof IProject).map(container -> (IProject)container).toArray(IProject[]::new);
                                            int n = projects.length;
                                            int n3 = 0;
                                            while (n3 < n) {
                                                IProject project = iProjectArray[n3];
                                                project.refreshLocal(2, monitor);
                                                ++n3;
                                            }
                                        }
                                        catch (CoreException e) {
                                            if (!Boolean.getBoolean("jdt.ls.debug")) break block33;
                                            JavaLanguageServerPlugin.logException(e);
                                        }
                                    }
                                }
                                progress.done();
                                break block36;
                            }
                            progress.done();
                            throw throwable22;
                        }
                        String log = outputStream.toString();
                        if (!log.isBlank()) {
                            JavaLanguageServerPlugin.debugTrace("Gradle log: " + log);
                        }
                        if (!(error = errorStream.toString()).isBlank()) {
                            boolean parseKotlin = taskNames.contains(COMPILE_KOTLIN) || taskNames.contains(COMPILE_TEST_KOTLIN);
                            boolean parseGroovy = taskNames.contains(COMPILE_GROOVY) || taskNames.contains(COMPILE_TEST_GROOVY);
                            boolean parseAspectj = taskNames.contains(COMPILE_ASPECTJ) || taskNames.contains(COMPILE_TEST_ASPECTJ);
                            this.publishDiagnostics(error, parseKotlin, parseGroovy, parseAspectj);
                        }
                        JavaModelManager.getJavaModelManager().resetExternalFilesCache();
                        try {
                            IProject[] projects;
                            IPath path = Path.fromOSString((String)projectDir.getAbsolutePath());
                            IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(path.toFile().toURI());
                            IProject[] iProjectArray = projects = (IProject[])Arrays.stream(containers).filter(container -> container instanceof IProject).map(container -> (IProject)container).toArray(IProject[]::new);
                            int n = projects.length;
                            int n4 = 0;
                            while (n4 < n) {
                                IProject project = iProjectArray[n4];
                                project.refreshLocal(2, monitor);
                                ++n4;
                            }
                        }
                        catch (CoreException e) {
                            if (!Boolean.getBoolean("jdt.ls.debug")) break block34;
                            JavaLanguageServerPlugin.logException(e);
                        }
                    }
                    progress.done();
                }
                long elapsed = System.currentTimeMillis() - start;
                JavaLanguageServerPlugin.debugTrace("Compiling gradle project " + gradleProject.getName() + " took " + elapsed + " ms");
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private boolean hasTask(GradleProject project, String taskName) {
        for (GradleTask task : project.getTasks()) {
            if (!task.getName().equals(taskName)) continue;
            return true;
        }
        for (GradleProject childProject : project.getChildren()) {
            if (!this.hasTask(childProject, taskName)) continue;
            return true;
        }
        return false;
    }

    private void publishDiagnostics(String error, boolean parseKotlin, boolean parseGroovy, boolean parseAspectj) {
        JavaLanguageServerPlugin.logError("Gradle Error log: " + error);
        HashMap<String, List<Diagnostic>> diagnosticMap = new HashMap<String, List<Diagnostic>>();
        if (parseKotlin) {
            this.getDiagnostics(KOTLIN_PATTERN, error, diagnosticMap);
        }
        if (parseGroovy) {
            this.getDiagnostics(GROOVY_PATTERN, error, diagnosticMap);
        }
        if (parseAspectj) {
            this.getDiagnostics(ASPECTJ_PATTERN, error, diagnosticMap);
        }
        diagnosticMap.forEach((uri, diagnostics) -> {
            PublishDiagnosticsParams $ = new PublishDiagnosticsParams(ResourceUtils.toClientUri(uri), diagnostics);
            JavaClientConnection conn = JavaLanguageServerPlugin.getInstance().getProtocol().getClientConnection();
            conn.publishDiagnostics($);
        });
    }

    private void getDiagnostics(Pattern pattern, String error, Map<String, List<Diagnostic>> diagnosticMap) {
        Matcher matcher = pattern.matcher(error);
        while (matcher.find()) {
            List<Diagnostic> diagnostics;
            int line;
            String uri = this.getGroup(matcher, "file", null);
            if (uri == null) continue;
            Diagnostic diag = new Diagnostic();
            String message = this.getGroup(matcher, "message", UNKNOWN);
            diag.setMessage(message);
            String ID = Integer.toString(-1);
            diag.setCode(ID);
            String type = this.getGroup(matcher, "message", "e");
            DiagnosticSeverity severity = "w".equalsIgnoreCase(type) || "warning".equalsIgnoreCase(type) ? DiagnosticSeverity.Warning : DiagnosticSeverity.Error;
            diag.setSeverity(severity);
            try {
                line = Integer.valueOf(matcher.group("line"));
                --line;
            }
            catch (Exception e) {
                line = 0;
            }
            int startChar = 0;
            int endChar = -1;
            if (uri.endsWith(ASPECTJ_EXTENSION)) {
                startChar = 0;
                endChar = 500;
            } else {
                try {
                    startChar = Integer.valueOf(matcher.group("col"));
                    if (uri.endsWith(KOTLIN_EXTENSION)) {
                        --startChar;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (startChar < 0) {
                startChar = 0;
            }
            if (line < 0) {
                line = 0;
            }
            if (endChar < 0) {
                endChar = startChar;
            }
            Position startPosition = new Position(line, startChar);
            Position endPosition = new Position(line, endChar);
            Range range = new Range(startPosition, endPosition);
            diag.setRange(range);
            diag.setSource(GRADLE);
            if (uri != null) {
                if (uri.endsWith(KOTLIN_EXTENSION)) {
                    diag.setSource(KOTLIN);
                } else if (uri.endsWith(GROOVY_EXTENSION)) {
                    diag.setSource(GROOVY);
                } else if (uri.endsWith(ASPECTJ_EXTENSION)) {
                    diag.setSource(ASPECTJ);
                }
            }
            if ((diagnostics = diagnosticMap.get(uri)) == null) {
                diagnostics = new ArrayList<Diagnostic>();
                diagnosticMap.put(uri, diagnostics);
            }
            diagnostics.add(diag);
            if (!Boolean.getBoolean("jdt.ls.debug")) continue;
            StringBuilder builder = new StringBuilder();
            builder.append("--- Diagnostic ---");
            builder.append("\nResource: " + matcher.group("file"));
            builder.append("\nType: " + type);
            builder.append("\nPosition: Line: " + line + " Character:" + startChar);
            builder.append("\nmessage: " + matcher.group("message").trim());
            JavaLanguageServerPlugin.debugTrace(builder.toString());
        }
    }

    private String getGroup(Matcher matcher, String group, String defaultValue) {
        try {
            return Optional.ofNullable(matcher.group(group)).map(String::trim).orElse(defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private GradleProject getProject(GradleProject rootProject, String projectLocation) {
        try {
            if (rootProject.getProjectDirectory().getCanonicalPath().equals(projectLocation)) {
                return rootProject;
            }
        }
        catch (IOException e) {
            JavaLanguageServerPlugin.logException(e);
        }
        for (GradleProject child : rootProject.getChildren().getAll()) {
            GradleProject gradleProject = this.getProject(child, projectLocation);
            if (gradleProject == null) continue;
            return gradleProject;
        }
        return null;
    }
}

