/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class CreateNewObjectProposalCore
extends LinkedCorrectionProposalCore {
    private ITypeBinding fTypeNode;
    private IVariableBinding fVariableBinding;
    private Statement fSelectedNode;
    private VariableDeclarationFragment fVariableDeclarationFragment;
    private AST fAST;
    private CompilationUnit fCu;

    public CreateNewObjectProposalCore(ICompilationUnit cu, Statement selectedNode, ITypeBinding typeNode, int relevance) {
        super("", cu, (ASTRewrite)null, relevance);
        this.fSelectedNode = Objects.requireNonNull(selectedNode);
        this.fTypeNode = Objects.requireNonNull(typeNode);
        this.fAST = this.fSelectedNode.getAST();
        this.fCu = (CompilationUnit)this.fSelectedNode.getRoot();
    }

    public CreateNewObjectProposalCore(ICompilationUnit cu, VariableDeclarationFragment variableDeclarationFragment, ITypeBinding typeNode, int relevance) {
        super("", cu, (ASTRewrite)null, relevance);
        this.fVariableDeclarationFragment = Objects.requireNonNull(variableDeclarationFragment);
        this.fTypeNode = Objects.requireNonNull(typeNode);
        this.fAST = this.fVariableDeclarationFragment.getAST();
        this.fCu = (CompilationUnit)this.fVariableDeclarationFragment.getRoot();
    }

    public CreateNewObjectProposalCore(ICompilationUnit cu, VariableDeclarationFragment variableDeclarationFragment, IVariableBinding variableBinding, int relevance) {
        super("", cu, (ASTRewrite)null, relevance);
        this.fVariableDeclarationFragment = Objects.requireNonNull(variableDeclarationFragment);
        this.fVariableBinding = Objects.requireNonNull(variableBinding);
        this.fTypeNode = variableBinding.getDeclaringClass();
        this.fAST = this.fVariableDeclarationFragment.getAST();
        this.fCu = (CompilationUnit)this.fVariableDeclarationFragment.getRoot();
    }

    public boolean hasProposal() {
        return this.fTypeNode.isClass();
    }

    @Override
    public String getName() {
        return Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createnew_instance_of_object, this.fTypeNode.getName());
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ASTRewrite rewrite = ASTRewrite.create((AST)this.fAST);
        ImportRewrite importRewrite = this.createImportRewrite(this.fCu);
        IMethodBinding constructorMethod = this.getConstructorMethod();
        List<Expression> typeArguments = CreateNewObjectProposalCore.getConstructorArguments(rewrite, constructorMethod.getParameterTypes());
        Type newSimpleType = importRewrite.addImport(this.fTypeNode, this.fAST);
        if (this.fVariableBinding != null && this.fVariableDeclarationFragment != null) {
            BodyDeclaration findParentBodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)this.fVariableDeclarationFragment);
            String newVariableName = StubUtility.getVariableNameSuggestions(5, this.getCompilationUnit().getJavaProject(), newSimpleType, null, Arrays.asList(ASTResolving.getUsedVariableNames((ASTNode)findParentBodyDeclaration)))[0];
            VariableDeclarationFragment newVariableDeclarationFragment = this.fAST.newVariableDeclarationFragment();
            newVariableDeclarationFragment.setName(this.fAST.newSimpleName(newVariableName));
            VariableDeclarationStatement newVariableDeclarationStatement = this.fAST.newVariableDeclarationStatement(newVariableDeclarationFragment);
            newVariableDeclarationStatement.setType(newSimpleType);
            ClassInstanceCreation classInstanceCreation = this.fAST.newClassInstanceCreation();
            classInstanceCreation.setType(importRewrite.addImport(this.fTypeNode, this.fAST));
            classInstanceCreation.arguments().addAll(typeArguments);
            newVariableDeclarationFragment.setInitializer((Expression)classInstanceCreation);
            ASTNode parentBlock = ASTNodes.getParent((ASTNode)this.fVariableDeclarationFragment, 8);
            ListRewrite listRewrite = rewrite.getListRewrite(parentBlock, Block.STATEMENTS_PROPERTY);
            listRewrite.insertBefore((ASTNode)newVariableDeclarationStatement, this.fVariableDeclarationFragment.getParent(), null);
            QualifiedName qualifiedName = (QualifiedName)this.fVariableDeclarationFragment.getInitializer();
            QualifiedName newQualifiedName = this.fAST.newQualifiedName(this.fAST.newName(newVariableName), (SimpleName)rewrite.createCopyTarget((ASTNode)qualifiedName.getName()));
            rewrite.replace((ASTNode)this.fVariableDeclarationFragment.getInitializer(), (ASTNode)newQualifiedName, null);
            this.addLinkedRanges(rewrite, classInstanceCreation);
        } else if (this.fSelectedNode instanceof ExpressionStatement) {
            ExpressionStatement selectedNode = (ExpressionStatement)this.fSelectedNode;
            String newVariableName = StubUtility.getVariableNameSuggestions(5, this.getCompilationUnit().getJavaProject(), newSimpleType, null, Arrays.asList(ASTResolving.getUsedVariableNames((ASTNode)ASTResolving.findParentBodyDeclaration((ASTNode)selectedNode))))[0];
            VariableDeclarationFragment newVariableDeclarationFragment = this.fAST.newVariableDeclarationFragment();
            newVariableDeclarationFragment.setName(this.fAST.newSimpleName(newVariableName));
            VariableDeclarationStatement newVariableDeclarationStatement = this.fAST.newVariableDeclarationStatement(newVariableDeclarationFragment);
            newVariableDeclarationStatement.setType(newSimpleType);
            ClassInstanceCreation classInstanceCreation = this.fAST.newClassInstanceCreation();
            classInstanceCreation.setType(importRewrite.addImport(this.fTypeNode, this.fAST));
            classInstanceCreation.arguments().addAll(typeArguments);
            newVariableDeclarationFragment.setInitializer((Expression)classInstanceCreation);
            ASTNode parentBlock = ASTNodes.getParent((ASTNode)selectedNode, 8);
            ListRewrite listRewrite = rewrite.getListRewrite(parentBlock, Block.STATEMENTS_PROPERTY);
            listRewrite.insertBefore((ASTNode)newVariableDeclarationStatement, (ASTNode)selectedNode, null);
            MethodInvocation oldMethodInvocation = (MethodInvocation)selectedNode.getExpression();
            String methodName = oldMethodInvocation.getName().getIdentifier();
            MethodInvocation newMethodInvocation = this.fAST.newMethodInvocation();
            newMethodInvocation.setName(this.fAST.newSimpleName(methodName));
            newMethodInvocation.setExpression((Expression)this.fAST.newName(newVariableName));
            List arguments = oldMethodInvocation.arguments();
            for (Expression argument : arguments) {
                newMethodInvocation.arguments().add(rewrite.createCopyTarget((ASTNode)argument));
            }
            rewrite.replace((ASTNode)selectedNode.getExpression(), (ASTNode)newMethodInvocation, null);
            this.addLinkedRanges(rewrite, classInstanceCreation);
        } else if (this.fVariableDeclarationFragment != null) {
            VariableDeclarationFragment newVariableDeclarationFragment = this.fAST.newVariableDeclarationFragment();
            newVariableDeclarationFragment.setName(this.fAST.newSimpleName(this.fVariableDeclarationFragment.getName().getIdentifier()));
            ClassInstanceCreation classInstanceCreation = this.fAST.newClassInstanceCreation();
            classInstanceCreation.setType(importRewrite.addImport(this.fTypeNode, this.fAST));
            classInstanceCreation.arguments().addAll(typeArguments);
            newVariableDeclarationFragment.setInitializer((Expression)classInstanceCreation);
            rewrite.replace((ASTNode)this.fVariableDeclarationFragment, (ASTNode)newVariableDeclarationFragment, null);
        }
        return rewrite;
    }

    private IMethodBinding getConstructorMethod() {
        IMethodBinding[] iMethodBindingArray = this.fTypeNode.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding iMethodBinding = iMethodBindingArray[n2];
            if (iMethodBinding.isDefaultConstructor() || iMethodBinding.isConstructor()) {
                return iMethodBinding;
            }
            ++n2;
        }
        return null;
    }

    private static List<Expression> getConstructorArguments(ASTRewrite rewrite, ITypeBinding[] typeBindings) {
        ArrayList<Expression> constructorArgs = new ArrayList<Expression>();
        AST ast = rewrite.getAST();
        ITypeBinding[] iTypeBindingArray = typeBindings;
        int n = typeBindings.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeBinding = iTypeBindingArray[n2];
            constructorArgs.add(ASTNodeFactory.newDefaultExpression(ast, typeBinding));
            ++n2;
        }
        return constructorArgs;
    }

    private void addLinkedRanges(ASTRewrite rewrite, ClassInstanceCreation newStub) {
        List parameters = newStub.arguments();
        int index = 0;
        for (Expression curr : parameters) {
            this.addLinkedPosition(rewrite.track((ASTNode)curr), false, "arg_" + index++);
        }
    }
}

