/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.SnippetUtils;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.ResponseStore;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionResolveHandler {
    public static final String DATA_FIELD_REQUEST_ID = "rid";
    public static final String DATA_FIELD_PROPOSAL_ID = "pid";

    public CodeAction resolve(CodeAction params, IProgressMonitor monitor) {
        Map data = JSONUtility.toModel(params.getData(), Map.class);
        params.setData(null);
        if (CodeActionHandler.codeActionStore.isEmpty()) {
            return params;
        }
        int proposalId = Integer.parseInt((String)data.get(DATA_FIELD_PROPOSAL_ID));
        long requestId = Long.parseLong((String)data.get(DATA_FIELD_REQUEST_ID));
        ResponseStore.ResponseItem<Either<ChangeCorrectionProposalCore, CodeActionProposal>> response = CodeActionHandler.codeActionStore.get(requestId);
        if (response == null || response.getProposals().size() <= proposalId) {
            throw new IllegalStateException("Invalid codeAction proposal");
        }
        try {
            WorkspaceEdit edit;
            Either<ChangeCorrectionProposalCore, CodeActionProposal> proposal = response.getProposals().get(proposalId);
            WorkspaceEdit workspaceEdit = edit = proposal.isLeft() ? ChangeUtil.convertToWorkspaceEdit(((ChangeCorrectionProposalCore)proposal.getLeft()).getChange()) : ((CodeActionProposal)proposal.getRight()).resolveEdit(monitor);
            if (ChangeUtil.hasChanges(edit)) {
                if (JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isWorkspaceSnippetEditSupported() && edit.getDocumentChanges() != null && proposal.isLeft() && proposal.getLeft() instanceof LinkedCorrectionProposalCore) {
                    SnippetUtils.addSnippetsIfApplicable((LinkedCorrectionProposalCore)proposal.getLeft(), edit);
                }
                params.setEdit(edit);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem converting code action proposal to workspace edit", e);
        }
        return params;
    }
}

