/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.problem;

import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.problem.ProblemHandler;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class JavacProblemReporter
extends ProblemHandler {
    public ReferenceContext referenceContext;
    private ProblemReporter severityUtility;

    public JavacProblemReporter(IErrorHandlingPolicy policy, CompilerOptions options, IProblemFactory problemFactory, ReferenceContext referenceContext) {
        super(policy, options, problemFactory);
        this.referenceContext = referenceContext;
        this.severityUtility = new ProblemReporter(policy, options, problemFactory);
    }

    public void redundantSpecificationOfTypeArguments(Type location, ITypeBinding[] argumentTypes) {
        int severity = this.severityUtility.computeSeverity(16778100);
        if (severity != 256) {
            int sourceStart = location.getStartPosition();
            int sourceEnd = sourceStart + location.getLength() - 1;
            this.handle(16778100, new String[]{this.typesAsString(argumentTypes, false)}, new String[]{this.typesAsString(argumentTypes, true)}, severity, sourceStart, sourceEnd);
        }
    }

    public void missingOverrideAnnotation(MethodDeclaration method) {
        int severity = this.severityUtility.computeSeverity(67109491);
        if (severity == 256) {
            return;
        }
        IMethodBinding binding = method.resolveBinding();
        this.handle(67109491, new String[]{binding.getName(), this.typesAsString(binding, false), binding.getDeclaringClass().getName()}, 0, new String[]{binding.getName(), this.typesAsString(binding, true), binding.getDeclaringClass().getName()}, severity, method.getName().getStartPosition(), method.getStartPosition() + method.getLength() - 1);
    }

    public void missingOverrideAnnotationForInterfaceMethodImplementation(MethodDeclaration method) {
        int severity = this.severityUtility.computeSeverity(67109500);
        if (severity == 256) {
            return;
        }
        IMethodBinding binding = method.resolveBinding();
        this.handle(67109500, new String[]{binding.getName(), this.typesAsString(binding, false), binding.getDeclaringClass().getName()}, new String[]{binding.getName(), this.typesAsString(binding, true), binding.getDeclaringClass().getName()}, severity, method.getName().getStartPosition(), method.getStartPosition() + method.getLength() - 1);
    }

    private String typesAsString(IMethodBinding imb, boolean makeShort) {
        return this.typesAsString(imb, imb.getParameterTypes(), makeShort);
    }

    private String typesAsString(IMethodBinding imb, ITypeBinding[] parameters, boolean makeShort) {
        return this.typesAsString(imb, parameters, makeShort, false);
    }

    private String typesAsString(IMethodBinding imb, boolean makeShort, boolean showNullAnnotations) {
        return this.typesAsString(imb, imb.getParameterTypes(), makeShort, showNullAnnotations);
    }

    private String typesAsString(IMethodBinding imb, ITypeBinding[] parameters, boolean makeShort, boolean showNullAnnotations) {
        StringBuilder buffer = new StringBuilder(10);
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            boolean isVarargType;
            if (i != 0) {
                buffer.append(", ");
            }
            ITypeBinding type = parameters[i];
            boolean bl = isVarargType = imb.isVarargs() && i == length - 1;
            if (isVarargType && type.isArray()) {
                type = type.getElementType();
            }
            buffer.append(new String(makeShort ? type.getName() : type.getQualifiedName()));
            if (!isVarargType) continue;
            buffer.append("...");
        }
        return buffer.toString();
    }

    private String typesAsString(ITypeBinding[] types, boolean makeShort) {
        return this.typesAsString(types, makeShort, false);
    }

    private String typesAsString(ITypeBinding[] types, boolean makeShort, boolean showNullAnnotations) {
        StringBuilder buffer = new StringBuilder(10);
        int length = types.length;
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            ITypeBinding type = types[i];
            buffer.append(new String(makeShort ? type.getName() : type.getQualifiedName()));
        }
        return buffer.toString();
    }

    private void handle(int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition) {
        this.handle(problemId, problemArguments, elaborationId, messageArguments, severity, problemStartPosition, problemEndPosition, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
    }

    private void handle(int problemId, String[] problemArguments, String[] messageArguments, int problemStartPosition, int problemEndPosition) {
        this.handle(problemId, problemArguments, messageArguments, problemStartPosition, problemEndPosition, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
    }

    private void handle(int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition) {
        this.handle(problemId, problemArguments, 0, messageArguments, severity, problemStartPosition, problemEndPosition);
    }
}

