/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import jdk.javadoc.internal.doclint.DocLint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.JdtCoreDomPackagePrivateUtility;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.javac.AccessRestrictionTreeScanner;
import org.eclipse.jdt.internal.javac.DelegatingTreeScanner;
import org.eclipse.jdt.internal.javac.UnusedTreeScanner;
import org.eclipse.jdt.internal.javac.problem.JavacDiagnosticProblemConverter;
import org.eclipse.jdt.internal.javac.problem.UnusedProblemFactory;

public class JavacResolverTaskListener
implements TaskListener {
    private final Context context;
    private final JavacDiagnosticProblemConverter problemConverter;
    private final Map<String, String> compilerOptions;
    private final IJavaProject javaProject;
    private final UnusedProblemFactory unusedProblemFactory;
    private final JavacTask task;
    private final int focalPoint;
    private final Map<JavaFileObject, CompilationUnit> filesToUnits;
    private final int flags;

    public JavacResolverTaskListener(Context context, JavacDiagnosticProblemConverter problemConverter, Map<String, String> compilerOptions, IJavaProject javaProject, UnusedProblemFactory unusedProblemFactory, JavacTask task, int focalPoint, Map<JavaFileObject, CompilationUnit> filesToUnits, int flags) {
        this.context = context;
        this.problemConverter = problemConverter;
        this.compilerOptions = compilerOptions;
        this.javaProject = javaProject;
        this.unusedProblemFactory = unusedProblemFactory;
        this.task = task;
        this.focalPoint = focalPoint;
        this.filesToUnits = filesToUnits;
        this.flags = flags;
    }

    @Override
    public void finished(TaskEvent e) {
        JCTree.JCCompilationUnit u;
        CompilationUnitTree compilationUnitTree = e.getCompilationUnit();
        if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
            u = (JCTree.JCCompilationUnit)compilationUnitTree;
            this.problemConverter.registerUnit(e.getSourceFile(), u);
        }
        if (e.getKind() == TaskEvent.Kind.PARSE && (compilationUnitTree = e.getCompilationUnit()) instanceof JCTree.JCCompilationUnit) {
            u = (JCTree.JCCompilationUnit)compilationUnitTree;
            this.finishedParse(u);
            return;
        }
        if (e.getKind() == TaskEvent.Kind.ANALYZE && (compilationUnitTree = e.getCompilationUnit()) instanceof JCTree.JCCompilationUnit) {
            u = (JCTree.JCCompilationUnit)compilationUnitTree;
            this.finishedAnalyze(e, u);
            return;
        }
    }

    private void finishedParse(JCTree.JCCompilationUnit u) {
        ArrayList<TreeScanner> list = new ArrayList<TreeScanner>();
        if ((this.flags & 8) != 0) {
            list.add(new IgnoreMethodBodiesScanner());
        }
        if (this.focalPoint >= 0) {
            list.add(new TrimNonFocussedContentTreeScanner(u, this.focalPoint));
        }
        if (this.filesToUnits.size() == 1 && this.focalPoint >= 0) {
            list.add(new TrimUnvisibleContentScanner(u, this.focalPoint, this.context));
        }
        DelegatingTreeScanner scanner = new DelegatingTreeScanner(list);
        u.accept(scanner);
    }

    private void finishedAnalyze(TaskEvent e, JCTree.JCCompilationUnit u) {
        JavaFileObject file;
        CompilationUnit dom;
        List<String> doclintOpts = Arguments.instance(this.context).getDocLintOpts();
        if (doclintOpts == null && JavacResolverTaskListener.isInJavadoc(u, this.focalPoint)) {
            DocLint doclint = (DocLint)DocLint.newDocLint();
            doclint.init(this.task, doclintOpts.toArray(new String[doclintOpts.size()]));
            doclint.scan(TreePath.getPath(u, (Tree)u));
        }
        if ((dom = this.filesToUnits.get(file = e.getSourceFile())) == null) {
            return;
        }
        if (Stream.of(dom.getProblems()).anyMatch(problem -> problem.isError())) {
            return;
        }
        CompilerOptions objectCompilerOptions = new CompilerOptions(this.compilerOptions);
        boolean unusedImportIgnored = objectCompilerOptions.getSeverityString(1024).equals("ignore");
        boolean unusedPrivateMemberIgnored = objectCompilerOptions.getSeverityString(32768).equals("ignore");
        boolean unusedLocalVariableIgnored = objectCompilerOptions.getSeverityString(16).equals("ignore");
        boolean unnecessaryTypeCheckIgnored = objectCompilerOptions.getSeverityString(0x4000000).equals("ignore");
        boolean noEffectAssignmentIgnored = objectCompilerOptions.getSeverityString(8192).equals("ignore");
        if (!Options.instance(this.context).get(Option.XLINT_CUSTOM).contains("all") && unusedImportIgnored && unusedPrivateMemberIgnored && unusedLocalVariableIgnored && unnecessaryTypeCheckIgnored && noEffectAssignmentIgnored) {
            return;
        }
        java.util.List<IProblem> allUnused = this.getUnusedElementProblems(e, dom);
        java.util.List<IProblem> accessRestrictions = this.getAccessRestrictionProblems(e, dom);
        ArrayList<IProblem> combined = new ArrayList<IProblem>();
        combined.addAll(allUnused);
        combined.addAll(accessRestrictions);
        JavacResolverTaskListener.addProblemsToDOM(dom, combined);
    }

    private java.util.List<IProblem> getAccessRestrictionProblems(TaskEvent e, CompilationUnit dom) {
        if (Options.instance(this.context).get(Option.XLINT_CUSTOM).contains("all")) {
            AccessRestrictionTreeScanner accessScanner = null;
            IJavaProject iJavaProject = this.javaProject;
            if (iJavaProject instanceof JavaProject) {
                JavaProject internalJavaProject = (JavaProject)iJavaProject;
                try {
                    SearchableEnvironment environment = new SearchableEnvironment(internalJavaProject, (WorkingCopyOwner)null, false, -1);
                    accessScanner = new AccessRestrictionTreeScanner((INameEnvironment)environment, (IProblemFactory)new DefaultProblemFactory(), new CompilerOptions(this.compilerOptions));
                    accessScanner.scan((Tree)e.getCompilationUnit(), null);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            return new ArrayList<CategorizedProblem>(accessScanner.getAccessRestrictionProblems());
        }
        return new ArrayList<IProblem>();
    }

    private java.util.List<IProblem> getUnusedElementProblems(TaskEvent e, CompilationUnit dom) {
        java.util.List<CategorizedProblem> noEffectAssignments;
        Tree tree;
        final TypeElement currentTopLevelType = e.getTypeElement();
        UnusedTreeScanner<Void, Void> scanner = new UnusedTreeScanner<Void, Void>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Void visitClass(ClassTree node, Void p) {
                if (node instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)node;
                    if (Objects.equals(currentTopLevelType, classDecl.sym) || !(classDecl.sym.owner instanceof Symbol.PackageSymbol)) {
                        return (Void)super.visitClass(node, p);
                    }
                    return null;
                }
                return (Void)super.visitClass(node, p);
            }
        };
        CompilationUnitTree unit = e.getCompilationUnit();
        try {
            scanner.scan(unit, null);
        }
        catch (Exception ex) {
            ILog.get().error("Internal error when visiting the AST Tree. " + ex.getMessage(), (Throwable)ex);
        }
        ArrayList<IProblem> allUnusedProblems = new ArrayList<IProblem>();
        java.util.List<CategorizedProblem> unusedProblems = scanner.getUnusedPrivateMembers(this.unusedProblemFactory);
        if (unusedProblems != null && !unusedProblems.isEmpty()) {
            allUnusedProblems.addAll(unusedProblems);
        }
        java.util.List<CategorizedProblem> unusedImports = scanner.getUnusedImports(this.unusedProblemFactory);
        java.util.List<? extends Tree> topTypes = unit.getTypeDecls();
        int typeCount = topTypes.size();
        if (typeCount <= 1 && unusedImports != null) {
            allUnusedProblems.addAll(unusedImports);
        } else if (typeCount > 1 && (tree = topTypes.get(typeCount - 1)) instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl lastType = (JCTree.JCClassDecl)tree;
            if (Objects.equals(currentTopLevelType, lastType.sym)) {
                allUnusedProblems.addAll(unusedImports);
            }
        }
        java.util.List<CategorizedProblem> unnecessaryCasts = scanner.getUnnecessaryCasts(this.unusedProblemFactory);
        if (!unnecessaryCasts.isEmpty()) {
            allUnusedProblems.addAll(unnecessaryCasts);
        }
        if (!(noEffectAssignments = scanner.getNoEffectAssignments(this.unusedProblemFactory)).isEmpty()) {
            allUnusedProblems.addAll(noEffectAssignments);
        }
        return allUnusedProblems;
    }

    private static void addProblemsToDOM(CompilationUnit dom, java.util.List<IProblem> accessRestrictionProblems) {
        JdtCoreDomPackagePrivateUtility.addProblemsToDOM(dom, new ArrayList<IProblem>(accessRestrictionProblems));
    }

    private static boolean isInJavadoc(final JCTree.JCCompilationUnit u, final int focalPoint) {
        final boolean[] res = new boolean[]{false};
        u.accept(new TreeScanner(){

            @Override
            public void scan(JCTree tree) {
                if (res[0]) {
                    return;
                }
                Tokens.Comment comment = u.docComments.getComment(tree);
                if (comment != null && comment.getPos().getStartPosition() < focalPoint && focalPoint < comment.getPos().getEndPosition(u.endPositions) && (comment.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_BLOCK || comment.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE)) {
                    res[0] = true;
                    return;
                }
                super.scan(tree);
            }
        });
        return res[0];
    }

    private static class IgnoreMethodBodiesScanner
    extends TreeScanner {
        private IgnoreMethodBodiesScanner() {
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl method) {
            if (method.body != null) {
                method.body.stats = List.nil();
            }
        }
    }

    private static class TrimNonFocussedContentTreeScanner
    extends TreeScanner {
        private JCTree.JCCompilationUnit compilationUnit;
        private int focalPoint;

        public TrimNonFocussedContentTreeScanner(JCTree.JCCompilationUnit compilationUnit, int focalPoint) {
            this.compilationUnit = compilationUnit;
            this.focalPoint = focalPoint;
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl method) {
            if (method.body != null && (this.focalPoint < method.getStartPosition() || method.getEndPosition(this.compilationUnit.endPositions) < this.focalPoint)) {
                method.body.stats = List.nil();
            }
        }

        @Override
        public void scan(JCTree tree) {
            final Tokens.Comment comment = this.compilationUnit.docComments.getComment(tree);
            if (comment != null && (this.focalPoint < comment.getPos().getStartPosition() || comment.getPos().getEndPosition(this.compilationUnit.endPositions) < this.focalPoint)) {
                this.compilationUnit.docComments.putComment(tree, new Tokens.Comment(){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    @Override
                    public boolean isDeprecated() {
                        return comment.isDeprecated();
                    }

                    @Override
                    public Tokens.Comment.CommentStyle getStyle() {
                        return comment.getStyle();
                    }

                    @Override
                    public int getSourcePos(int index) {
                        return comment.getSourcePos(index);
                    }

                    public JCDiagnostic.DiagnosticPosition getPos() {
                        return comment.getPos();
                    }

                    public Tokens.Comment stripIndent() {
                        return comment.stripIndent();
                    }

                    @Override
                    public String getText() {
                        return "";
                    }
                });
            }
            super.scan(tree);
        }
    }

    private static class TrimUnvisibleContentScanner
    extends TreeScanner {
        private TreeMaker treeMaker;
        private Context context;
        private int focus;
        private JCTree.JCCompilationUnit u;

        public TrimUnvisibleContentScanner(JCTree.JCCompilationUnit u, int focalPoint, Context context) {
            this.u = u;
            this.focus = focalPoint;
            this.context = context;
            this.treeMaker = TreeMaker.instance(context);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl decl) {
            if (!(decl.getBody() == null || ((List)decl.getBody().getStatements()).isEmpty() || decl.getStartPosition() <= this.focus && decl.getStartPosition() + TreeInfo.getEndPos(decl, this.u.endPositions) >= this.focus)) {
                JCTree.JCThrow throwNewRuntimeExceptionOutOfFocalPositionScope = this.treeMaker.Throw(this.treeMaker.NewClass(null, null, this.treeMaker.Ident(Names.instance(this.context).fromString(RuntimeException.class.getSimpleName())), List.of(this.treeMaker.Literal("Out of focalPosition scope")), null));
                decl.body.stats = List.of(throwNewRuntimeExceptionOutOfFocalPositionScope);
            }
        }
    }
}

