/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;

public class JdtCoreDomPackagePrivateUtility {
    public static BindingResolver getBindingResolver(AST ast) {
        return ast.getBindingResolver();
    }

    public static BindingResolver getBindingResolver(ASTNode node) {
        return node.getAST().getBindingResolver();
    }

    public static JavacBindingResolver getJavacBindingResolverOrNull(ASTNode node) {
        return JdtCoreDomPackagePrivateUtility.getJavacBindingResolverOrNull(node.getAST());
    }

    public static JavacBindingResolver getJavacBindingResolverOrNull(AST ast) {
        BindingResolver br = JdtCoreDomPackagePrivateUtility.getBindingResolver(ast);
        if (br != null && br instanceof JavacBindingResolver) {
            JavacBindingResolver br2 = (JavacBindingResolver)br;
            return br2;
        }
        return null;
    }

    public static IBinding findBindingForType(ASTNode node, String signature) {
        return JdtCoreDomPackagePrivateUtility.findBindingForType(node.getAST(), signature);
    }

    public static IBinding findBindingForType(AST ast, String signature) {
        JavacBindingResolver jcbr = JdtCoreDomPackagePrivateUtility.getJavacBindingResolverOrNull(ast);
        IBinding ret1 = jcbr.findBinding(signature);
        if (ret1 == null) {
            String sig2 = signature.replaceAll("\\.", "/");
            ret1 = jcbr.findBinding(sig2);
        }
        return ret1;
    }

    public static IBinding findUnresolvedBindingForType(ASTNode node, String signature) {
        return JdtCoreDomPackagePrivateUtility.findUnresolvedBindingForType(node.getAST(), signature);
    }

    public static IBinding findUnresolvedBindingForType(AST ast, String signature) {
        IBinding ret1;
        JavacBindingResolver br2;
        JavacBindingResolver jcbr = JdtCoreDomPackagePrivateUtility.getJavacBindingResolverOrNull(ast);
        if (jcbr instanceof JavacBindingResolver) {
            br2 = jcbr;
            v0 = br2.findBinding(signature);
        } else {
            v0 = ret1 = null;
        }
        if (ret1 == null) {
            IBinding iBinding;
            if (jcbr instanceof JavacBindingResolver) {
                br2 = jcbr;
                iBinding = br2.findUnresolvedBinding(signature);
            } else {
                iBinding = null;
            }
            ret1 = iBinding;
        }
        return ret1;
    }

    public static void addProblemsToDOM(CompilationUnit dom, Collection<IProblem> problems) {
        if (problems == null) {
            return;
        }
        IProblem[] previous = dom.getProblems();
        IProblem[] newProblems = Arrays.copyOf(previous, previous.length + problems.size());
        int start = previous.length;
        Iterator<IProblem> iterator = problems.iterator();
        while (iterator.hasNext()) {
            IProblem problem;
            newProblems[start] = problem = iterator.next();
            ++start;
        }
        Arrays.sort(newProblems, (o1, o2) -> o1.getID() - o2.getID());
        dom.setProblems(newProblems);
    }
}

